/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : main.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include <stdio.h>

#define TAG  "main"
#include "trace.h"

#include "board.h"
#include "uart.h"
#include "spi.h"
#include "hs6220.h"

#define CONFIG_LOG_OUTPUT   1
uint8_t  rf_buf[32];	
int main(void)
{
	uint8_t white_list[5];
	uint8_t rf_mode;
	uint8_t rcvd_len,i=0;	

   delay_init();
	port_init_flash();
	
#if defined(CONFIG_LOG_OUTPUT)
    uart_init(115200);
#endif
	

	TIM14_Configure();
	
    spi_int();
    HS6220_Init();
#if 0
    hs6220_set_tx_continuous_wave();
#endif

	IWDG_Configure(1000);
	
	log_debug("running\r\n", NULL, 0);
    
//   HS6220_ModeSwitch(Rf_Carrier_Mode); //زģʽ	
	rf_mode =2;  //ģʽѡ
    while(1)
    {

		if(rf_mode == 1)			//RFģʽ
		{
			HS6220_CE_Low();
			HS6220_delay_ms(1);
			HS6220_Clear_All_Irq();
			HS6220_Flush_Rx();	
			HS6220_ModeSwitch(Rf_PRX_Mode);
		  log_debug("************************RF entry Rx Mode*******************\r\n", NULL, 0);			
			while(1)
			{
				rcvd_len = hs6220_rx_check();//HS6220_RecivePack(rx_buf);
				if(rcvd_len)		
				{
					log_debug("rcv",rf_buf,rcvd_len);
				}
		/* Feed The Dog */
				WRITE_REG(IWDG->KR, 0xAAAA);				
			}
		}			
		else if(rf_mode == 2)		//RF ģʽ
		{
//			memset(rf_buf,0x00,sizeof(rf_buf));
			log_debug("************************RF entry Tx Mode*******************\r\n", NULL, 0);	
			HS6220_ModeSwitch(Rf_PTX_Mode);	
			while(1)
			{
		/* Feed The Dog */
				WRITE_REG(IWDG->KR, 0xAAAA);					
				i++;
				rf_buf[0] = 0x55;
				rf_buf[1] = 0xaa;
				rf_buf[2] = 0x01;
				rf_buf[3] = 0x02;
				rf_buf[4] = i;
				rf_buf[5] = i;			
				rf_buf[31] =0xaa;

				HS6220_delay_ms(10);
				HS6220_CE_Low();
				HS6220_Clear_All_Irq();
				HS6220_Flush_Tx();					
				hs6220_send(rf_buf,32);
				
				HS6220_CE_High();				
			//	LogBuf("tx",rx_buf,32);
			}
		}	
		
		
    }
}




