/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : uart.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include <stdio.h>
#include "mm32_device.h"

void uart_init(uint32_t baudrate)
{

    /* Enable GPIOA Clock */
    SET_BIT(RCC->AHBENR, RCC_AHBENR_GPIOA);

    /* Config PA12 AF1 */
    MODIFY_REG(GPIOA->AFRH, GPIO_AFRH_AFR12, 0x01U << GPIO_AFRH_AFR12_Pos);

    /* Config PA10 Alternate Function Output Push-Pull */
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_MODE12, 0x01U << GPIO_CRH_MODE12_Pos);
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_CNF12,  0x02U << GPIO_CRH_CNF12_Pos);

    /* Enable USART1 Clock */
    SET_BIT(RCC->APB1ENR, RCC_APB1ENR_USART1);

    /* Parity : None */
    CLEAR_BIT(USART1->CR1, USART_CR1_PCE);
    CLEAR_BIT(USART1->CR1, USART_CR1_PS);

    /* Data Length : 8-bit */
    CLEAR_BIT(USART1->CR1, USART_CR1_DL);

    /* Stop Bit : 1-bit */
    MODIFY_REG(USART1->CR2, USART_CR2_STOP, 0x00U << USART_CR2_STOP_Pos);

    /* Baudrate */
    MODIFY_REG(USART1->BRR, USART_BRR_MFD, ((48000000 / baudrate) / 16) << USART_BRR_MFD_Pos);
    MODIFY_REG(USART1->BRR, USART_BRR_FFD, ((48000000 / baudrate) % 16) << USART_BRR_FFD_Pos);

    /* Enable Transmit */
    SET_BIT(USART1->CR1, USART_CR1_TE);

    /* Enable USART1 */
    SET_BIT(USART1->CR1, USART_CR1_UE);
}


int fputc(int ch, FILE *f)
{
    USART1->DR = (uint8_t)ch;

    while (0 == READ_BIT(USART1->SR, USART_SR_TC))
    {
    }

    return (ch);
}

void debug_printf(uint8_t *buffer, uint8_t length, uint8_t format)
{
	//连续发送所有数据
	uint8_t i,tmp;

	for(i=0; i<length; i++)
	{
		if(format)
		{
			tmp = ' ';
            USART1->DR = (uint8_t)tmp;
            while (0 == READ_BIT(USART1->SR, USART_SR_TC));
                
			tmp = buffer[i] >> 4;
			USART1->DR = tmp + (tmp>9 ? 0x37:0x30);
			while (0 == READ_BIT(USART1->SR, USART_SR_TC));
			tmp = buffer[i] & 0x0f;
			USART1->DR = tmp + (tmp>9 ? 0x37:0x30);
		}
		else
		{
			USART1->DR = buffer[i];
		}
		while (0 == READ_BIT(USART1->SR, USART_SR_TC));
	}
}

#if defined(CONFIG_LOG_OUTPUT)
void  log_printf(const char *comment ,unsigned char *buf, unsigned char len)
{ 

	unsigned char slen=0;
    debug_printf((uint8_t *)"\r\n",2,0);
	if(len)
	{
	    debug_printf((uint8_t *)"L",  1, 0);
	    debug_printf(&len, 1, 1);
	    debug_printf((uint8_t *)">",  1, 0);
	}
	while(comment[slen++]);
	debug_printf((uint8_t *)comment,slen-1,0);
	if(len)
	{		
        debug_printf(buf,len, 1);
	}	
}
#endif











