/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : utilities.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-03-18
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */
 
#include <stdint.h>
#include <stdbool.h>
#include "utilities.h"



/*********************** 随机数 *******************************/
// Standard random functions redefinition start
#define RAND_LOCAL_MAX 0x7FFF

static unsigned short next = 1;

short rand1( void )
{
    next = next * 16807 + 123L;
    return (short)( ( next ) % RAND_LOCAL_MAX );
}

void srand1( short seed )
{
    next = seed;
}
// Standard random functions redefinition end

short randr( short min, short max )
{
    return ( short )rand1( ) % ( max - min + 1 ) + min;
}
/**************************************************************/

/**
 * @brief ll_crc24_generate()
 *
 * @param[in] seed
 * @param[in] pdata
 * @param[in] len
 *
 * @return
 *
 * @example:
 * ADV: {0x00,0x0d,0x08,0xac,0xd9,0xc9,0x84,0xf0,0x02,0x01,0x02,0x03,0x09,0x68,0x79}
 * seed: 0x555555
 * crc24: 0x53f51b
 **/
uint32_t ll_crc24_generate( unsigned char *ppdata, unsigned char len)
{
    unsigned i, j;
    uint32_t seed = 0x555555;
    for(i=0; i<len; ++i)
    {
        for(j=0; j<8; ++j)
        {
            uint8_t factor = ((ppdata[i] >> j) ^ (seed >> 23)) & 0x01;

            seed <<= 1;
            seed = (seed & ~(1<<10)) | ((seed ^ (factor<<10)) & (1<<10));
            seed = (seed & ~(1<<9 )) | ((seed ^ (factor<<9 )) & (1<<9 ));
            seed = (seed & ~(1<<6 )) | ((seed ^ (factor<<6 )) & (1<<6 ));
            seed = (seed & ~(1<<4 )) | ((seed ^ (factor<<4 )) & (1<<4 ));
            seed = (seed & ~(1<<3 )) | ((seed ^ (factor<<3 )) & (1<<3 ));
            seed = (seed & ~(1<<1 )) | ((seed ^ (factor<<1 )) & (1<<1 ));
            seed = (seed & ~(1<<0 )) | factor;
        }
    }
    return seed & 0x00FFFFFF;
}














