/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : board.h
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#ifndef __BOARD_H_
#define __BOARD_H_

#include <stdint.h>
#include "mm32_device.h"
#include "spi.h"
#include "adc.h"

#define BOARD_CRITICAL_BEGIN()                     \
    do {                                        \
        /*lint -save -e578 */                   \
        uint32_t _primask = __get_PRIMASK();    \
        /*lint?¨Crestore */                      \
        __disable_irq();

#define BOARD_CRITICAL_END()                       \
        if (!_primask) {                        \
            __enable_irq();                     \
        }                                       \
    } while(0)

	



////地址划分
////最大用户代码空间 0-12扇区 13*1024=0x3400=13312
//	第13扇区为记录当前备份扇区所备份的数据是哪个扇区的，防止擦写过程中意外掉电导致丢失数据，暂时用户不可使用 
//		在擦写Flash过程中，13扇区在扇区前两个字节(u16变量)记录当前备份扇区的数据来源扇区编号
//	第14扇区为备份扇区
//  第15扇区为0-511字节为YW场景信息存储32*16=512
//  第15扇区为512-639字节为对码信息存储8*16=128
//  第15扇区为640-671字节为已对码设备数量及存储地址映射表(取决于slot_heap_t结构体大小，32Bytes)
//  第15扇区为672-767字节为LED或其他设备状态信息存储 96Bytes
//  第15扇区为768-895字节为设备配置数据存储 预留128Bytes
//	第15扇区896-1023以后地址规划 NC


#define FLASH_SECTOR_SIZE           1024
#define FLASH_BASE_ADDR             ((uint32_t)0x8000000U)
#define FLASH_END_ADDR              ((uint32_t)0x0800FFFFU)

#define FLASH_DATA_BASE_SECTOR      15	//用户数据区起始扇区
#define FLASH_DATA_SECTOR_SIZE      1	//用户数据区占用扇区总数


#define FLASH_BACKUP_FLAG_ADDR      ((uint32_t)(FLASH_SECTOR_SIZE * 13))//备份扇区数据来源标记
#define FLASH_BACKUP_ADDR           ((uint32_t)(FLASH_SECTOR_SIZE * 14))//备份扇区
#define FLASH_DATA_BASE_ADDR        ((uint32_t)(FLASH_SECTOR_SIZE * 15))//用户数据区基地址


#define FLASH_LED_SCENE_ADDRESS    	    ((uint32_t)FLASH_DATA_BASE_ADDR + 0)//YW场景信息存储(32*16=512Bytes)

#define FLASH_SlotLink_BA_ADDRESS		((uint32_t)FLASH_DATA_BASE_ADDR + 512 + 128*0)//对码地址信息存储(8*16=128Bytes)

#define FLASH_SlotHeap_ADDRESS		    ((uint32_t)FLASH_DATA_BASE_ADDR + 512 + 128*1)//已对码设备数量及存储地址映射表(20Bytes)

#define FLASH_LED_STAUS_ADDRESS         ((uint32_t)FLASH_DATA_BASE_ADDR + 512 + 128*1 + 32)//LED灯状态存储(8Bytes)

#define USER_CONFIG_ADDRESS             ((uint32_t)FLASH_DATA_BASE_ADDR + 512 + 128*2) //不可擦除







typedef union
{
    uint8_t value;
    struct
    {
        uint8_t b0 :1;
        uint8_t b1 :1;
        uint8_t b2 :1;
        uint8_t b3 :1;
        uint8_t b4 :1;
        uint8_t b5 :1;
        uint8_t b6 :1;
        uint8_t b7 :1;
    }bit;
}byte_flag_t;


#define Blinky_Duty           12    //闪灯时长12*100ms
typedef enum {
    END_WITH_START = 0u,  //闪灯结束时保持起始状态一致
    END_WITH_ON,		  //闪灯结束时保持开灯状态
    END_WITH_OFF, 		  //闪灯结束时保持关灯状态
} LED_BLINK_END_STA;
typedef struct {
    unsigned char  time;
    unsigned char  tick;
    unsigned char  enable;
} BLINK;
extern BLINK blink;

extern volatile unsigned char Tim14_Tick;




void delay_init(void);
void delay_us(uint32_t nus);
void delay_ms(uint32_t nms);


uint32_t hal_get_tick(void);
uint32_t hal_get_elapsed_time( uint32_t past );

void IWDG_Configure(uint32_t Timeout);

void port_init_flash(void);
void port_read_flash(unsigned int addr,unsigned char *buf,unsigned int size);
void port_write_flash(uint32_t addr, void *buf, uint16_t size);
void port_modify_flash(unsigned int addr, unsigned char *buf,unsigned int size);
void port_fill_flash(unsigned int fill_addr, unsigned char fill_data, unsigned int data_size);
void port_erase_flash(unsigned int addr);

extern volatile uint32_t TIM14_UpdateFlag;
void TIM14_Configure(void);

void FLASH_MainFlash_Erase_Program_Sample(void);


u32 devinfo_get_net_address(unsigned char* addr);

void  LED_Blinky(void);
void led_blink_set(unsigned char btime,unsigned char end_sta);

extern void led_init(void);

#endif


 

