/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : hs6220.h
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#ifndef __HS6220_H_
#define __HS6220_H_

#include "board.h"

#define HS6220_CSN_HIGH	     SPI_CSN_HIGH()
#define HS6220_CSN_LOW       SPI_CSN_LOW()

typedef enum {
	HS6220_BANK0 = 0,
	HS6220_BANK1 = 1
}hs6220_bank_t;

#define HS6220_REQ_CNT   6


#define chn_37					2
#define chn_38					26
#define chn_39					80

typedef enum {
	Rf_PRX_Mode = 0,
	Rf_PTX_Mode,
	Rf_Carrier_Mode
}HS6220_ModeTypeDef,RF_ModeTypeDef;


void HS6220_delay_ms(uint32_t ms);
void HS6220_Init(void);
void hs6220_set_rx(void);
uint8_t hs6220_rx_check(void);
void hs6220_send(uint8_t *buff, uint16_t size);
void hs6220_set_tx_continuous_wave( uint8_t chl, int8_t power);
extern uint8_t rf_fifo_data[16];
void HS6220_ModeSwitch(HS6220_ModeTypeDef mod);

void HS6220_BLE_Init(void);
void ble_mode_send_data_set(unsigned char chl, unsigned char *Tbuf,unsigned char len);
void hs6220_ble_send(uint8_t *buff, uint16_t size);
void HS6220_BLE_ADV_Test(void);

void HS6220_CE_Low(void);
void HS6220_CE_High(void);
void HS6220_Clear_All_Irq(void);
void HS6220_Flush_Rx(void);
void HS6220_Flush_Tx(void);

uint8_t hs6220_rx_check(void);


#endif


 

