/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : board.h
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-06-27
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#ifndef __BOARD_H_
#define __BOARD_H_

#include "hal_conf.h"
#include "adc.h"
#include "spi.h"
#include "hs6220.h"
#include "flash.h"
#include "pwm.h"
#include "tim.h"
#include "utilities.h"


#define BOARD_CRITICAL_BEGIN()                     \
    do {                                        \
        /*lint -save -e578 */                   \
        uint32_t _primask = __get_PRIMASK();    \
        /*lint?Crestore */                      \
        __disable_irq();

#define BOARD_CRITICAL_END()                       \
        if (!_primask) {                        \
            __enable_irq();                     \
        }                                       \
    } while(0)

    
void board_init(void);
void board_get_unique_id(uint8_t * id);
void delay_ms(uint32_t delay);
uint32_t hal_get_tick(void);
uint32_t hal_get_elapsed_time( uint32_t past );
    
    
void uart_send(uint8_t *buff, uint16_t size);
#endif


 

