////////////////////////////////////////////////////////////////////////////////
/// @file     hal_conf.h
/// @author   AE TEAM
/// @brief    THIS FILE CONTAINS ALL THE FUNCTIONS PROTOTYPES FOR THE GENERIC MICROCONTROLLER
///           FIRMWARE LIBRARY.
////////////////////////////////////////////////////////////////////////////////
/// @attention
///
/// THE EXISTING FIRMWARE IS ONLY FOR REFERENCE, WHICH IS DESIGNED TO PROVIDE
/// CUSTOMERS WITH CODING INFORMATION ABOUT THEIR PRODUCTS SO THEY CAN SAVE
/// TIME. THEREFORE, BOLING SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT OR
/// CONSEQUENTIAL DAMAGES ABOUT ANY CLAIMS ARISING OUT OF THE CONTENT OF SUCH
/// HARDWARE AND/OR THE USE OF THE CODING INFORMATION CONTAINED HEREIN IN
/// CONNECTION WITH PRODUCTS MADE BY CUSTOMERS.
///
/// <H2><CENTER>&COPY; COPYRIGHT BOLING </CENTER></H2>
////////////////////////////////////////////////////////////////////////////////

// Define to prevent recursive inclusion
#ifndef __HAL_CONF_H
#define __HAL_CONF_H
// Files includes
#include "bl32_device.h"

#include "hal_adc.h"
#include "hal_comp.h"
#include "hal_crc.h"
#include "hal_dbg.h"
#include "hal_div.h"
#include "hal_dma.h"
#include "hal_exti.h"
#include "hal_flash.h"
#include "hal_flexcan.h"
#include "hal_gpio.h"
#include "hal_i2c.h"
#include "hal_iwdg.h"
#include "hal_misc.h"
#include "hal_pwr.h"
#include "hal_rcc.h"
#include "hal_spi.h"
#include "hal_syscfg.h"
#include "hal_tim.h"
#include "hal_uart.h"
#include "hal_uid.h"
#include "hal_wwdg.h"
#include "hal_redefine.h"
#include "hal_ver.h"

/// @}

/// @}

/// @}

////////////////////////////////////////////////////////////////////////////////
#endif //__HAL_CONF_H
////////////////////////////////////////////////////////////////////////////////
