#include "bsp.h"

uint32_t flag_pmu_timer_int0 = 0, flag_pmu_timer_int1 = 0;

uint32_t pmu_timer_cnt_val = 0;

static void pmu_timer_val0_test_callback(void *om_reg, drv_event_t drv_event, void *param0, void *param1)
{
	flag_pmu_timer_int0 = 1;
}


static void pmu_timer_val1_test_callback(void *om_reg, drv_event_t drv_event, void *param0, void *param1)
{
	flag_pmu_timer_int1 = 1;   
}


void bsp_pmu_tim_init(void)
{
	drv_pmu_timer_register_isr_callback(PMU_TIMER_TRIG_VAL0, pmu_timer_val0_test_callback);
	
    drv_pmu_timer_register_isr_callback(PMU_TIMER_TRIG_VAL1, pmu_timer_val1_test_callback);
	
    drv_pmu_timer_control(PMU_TIMER_TRIG_VAL0, PMU_TIMER_CONTROL_ENABLE, NULL);
	
    drv_pmu_timer_control(PMU_TIMER_TRIG_VAL1, PMU_TIMER_CONTROL_ENABLE, NULL);
	
    drv_pmu_timer_init();	

	pmu_timer_cnt_val = drv_pmu_timer_cnt_get();
	
    om_printf("pmu_timer_cnt_val:%ld\r\n", pmu_timer_cnt_val);
	
    drv_pmu_timer_control(PMU_TIMER_TRIG_VAL0, PMU_TIMER_CONTROL_SET_TIMER_VAL, (void *)(pmu_timer_cnt_val + 20 * 1000));
	
    drv_pmu_timer_control(PMU_TIMER_TRIG_VAL1, PMU_TIMER_CONTROL_SET_TIMER_VAL, (void *)(pmu_timer_cnt_val + 50 * 1000));
}


void bsp_pmu_tim_demo(void)
{
	if(flag_pmu_timer_int0 == 1)
	{
		flag_pmu_timer_int0 = 0;
		
		pmu_timer_cnt_val = drv_pmu_timer_cnt_get();
	
		om_printf("int0 cnt_val:%ld\r\n", pmu_timer_cnt_val);
		
		drv_pmu_timer_control(PMU_TIMER_TRIG_VAL0, PMU_TIMER_CONTROL_SET_TIMER_VAL, (void *)(pmu_timer_cnt_val + 20 * 1000));
	}
	
	if(flag_pmu_timer_int1 == 1)
	{
		flag_pmu_timer_int1 = 0;
		
		pmu_timer_cnt_val = drv_pmu_timer_cnt_get();
	
		om_printf("int1 cnt_val:%ld\r\n", pmu_timer_cnt_val);
		
		drv_pmu_timer_control(PMU_TIMER_TRIG_VAL1, PMU_TIMER_CONTROL_SET_TIMER_VAL, (void *)(pmu_timer_cnt_val + 50 * 1000));
	}
}



