#include "bsp.h"

rtc_tm_t set_tm;

rtc_tm_t alarm_tm;

rtc_tm_t get_tm; 

uint8_t flag_rtc_second = 0;

uint8_t flag_rtc_alarm_0 = 0;

uint8_t flag_rtc_alarm_1 = 0;

uint8_t flag_rtc_alarm_2 = 0;


static void rtc_second_cb(const rtc_tm_t *tm)
{
//    om_printf("second cb\r\n");
    
    flag_rtc_second = 1;
}


static void rtc_alarm_cb(rtc_alarm_event_t event, const rtc_tm_t *tm)
{
    if (event == RTC_ALARM_EVENT0) 
    {
        flag_rtc_alarm_0 = 1;
    } 
    else if (event == RTC_ALARM_EVENT1) 
    {
        flag_rtc_alarm_1 = 1;
    } 
    else if (event == RTC_ALARM_EVENT2) 
    {
        flag_rtc_alarm_2 = 1;
    }
}


void bsp_rtc_init(void)
{
    set_tm.tm_year = 2024 - 1900;   // years from 1900
    set_tm.tm_mon  = 4 - 1;         // months [0, 11]
    set_tm.tm_mday = 28;            // day [1, 31]
    set_tm.tm_hour = 23;            // hours [0, 23]
    set_tm.tm_min  = 59;            // min [0, 59]
    set_tm.tm_sec  = 10;            // sec [0, 59]
    set_tm.tm_wday = 3;             // wday [0, 6]

    memcpy(&alarm_tm, &set_tm, sizeof(rtc_tm_t));

    drv_rtc_init(OM_RTC);

    drv_rtc_register_second_isr_callback(OM_RTC, rtc_second_cb);
    
    drv_rtc_register_alarm_isr_callback(OM_RTC, rtc_alarm_cb);
    
    alarm_tm.tm_sec += 2;
    drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT0, &alarm_tm);
    
    alarm_tm.tm_sec += 3;
    drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT1, &alarm_tm);
    
    alarm_tm.tm_sec += 4;
    drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT2, &alarm_tm);
    
    // start signal
    drv_rtc_timer_set(OM_RTC, &set_tm);
}


void bsp_rtc_demo(void)
{
    if(flag_rtc_second == 1)
    {
        flag_rtc_second = 0;
        
        drv_rtc_timer_get(OM_RTC,&get_tm);
        
        om_printf("time is %d - %d - %d  %d : %d : %d\r\n",get_tm.tm_year+1900,get_tm.tm_mon + 1,get_tm.tm_mday,get_tm.tm_hour,get_tm.tm_min,get_tm.tm_sec);
    }
    
    if(flag_rtc_alarm_0 == 1)
    {
        flag_rtc_alarm_0 = 0;
        
        om_printf("alarm  event0\r\n");
        
        alarm_tm.tm_sec += 2;
        
        drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT0, &alarm_tm);
    }
    
    if(flag_rtc_alarm_1 == 1)
    {
        flag_rtc_alarm_1 = 0;
        
        om_printf("alarm  event1\r\n");
        
        alarm_tm.tm_sec += 3;
        
        drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT1, &alarm_tm);
    }
    
    if(flag_rtc_alarm_2 == 1)
    {
        flag_rtc_alarm_2 = 0;
        
        om_printf("alarm  event2\r\n");
        
        alarm_tm.tm_sec += 4;
        
        drv_rtc_alarm_set(OM_RTC, RTC_ALARM_EVENT2, &alarm_tm);
    }
}


