#ifndef __BSP_SPI_H
#define __BSP_SPI_H

#include "common.h"


#define W25QXX_SPI                      OM_SPI1

#define PAD_W25QXX_CS					22
#define MUX_W25QXX_CS					PINMUX_PAD22_SPI1_CS_CFG	//CS

#define PAD_W25QXX_CLK				    7
#define MUX_W25QXX_CLK				    PINMUX_PAD7_SPI1_SCK_CFG	//CLK

#define PAD_W25QXX_DI					20
#define MUX_W25QXX_DI					PINMUX_PAD20_SPI1_DI_CFG	//MISO

#define PAD_W25QXX_DO					21
#define MUX_W25QXX_DO					PINMUX_PAD21_SPI1_DO_CFG    //MOSI


#define W25QXX_TIME_OUT                 10


#define W25Q80 	0XEF13 	
#define W25Q16 	0XEF14
#define W25Q32 	0XEF15
#define W25Q64 	0XEF16
#define W25Q128	0XEF17



#define W25QXX_SECTOR_SIZE   0x1000
#define W25QXX_PAGE_SIZE     0x100


#define W25X_WriteEnable		0x06 
#define W25X_WriteDisable		0x04 
#define W25X_ReadStatusReg1		0x05 
#define W25X_ReadStatusReg2		0x35 
#define W25X_ReadStatusReg3		0x15 
#define W25X_WriteStatusReg1    0x01 
#define W25X_WriteStatusReg2    0x31 
#define W25X_WriteStatusReg3    0x11 
#define W25X_ReadData			0x03 
#define W25X_FastReadData		0x0B 
#define W25X_FastReadDual		0x3B 
#define W25X_PageProgram		0x02 
#define W25X_BlockErase			0xD8 
#define W25X_SectorErase		0x20 
#define W25X_ChipErase			0xC7 
#define W25X_PowerDown			0xB9 
#define W25X_ReleasePowerDown	0xAB 
#define W25X_DeviceID			0xAB 
#define W25X_ManufactDeviceID	0x90 
#define W25X_JedecDeviceID		0x9F 
#define W25X_Enable4ByteAddr    0xB7
#define W25X_Exit4ByteAddr      0xE9









extern void bsp_spi_w25qxx_init(void);

extern void bsp_spi_w25qxx_demo(void);






#endif
