#include "bsp.h"



/// uart flag defination
#define SEND_INT_IS_DONE            (1 << 0)
#define SEND_DMA_IS_DONE            (1 << 1)
#define READ_INT_IS_DONE            (1 << 2)
#define READ_DMA_IS_DONE            (1 << 3)



static const pin_config_t uart1_pin_config[] = 
{
    {PAD_UART1_TXD, {PINMUX_UART1_TX},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_UART1_RXD, {PINMUX_UART1_RX},  PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
};

static const pin_config_t uart_pin_config[] = 
{
    {PAD_UART1_TXD, {PINMUX_UART1_TX},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_UART1_RXD, {PINMUX_UART1_RX},  PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_UART1_RTS, {PINMUX_UART1_RTS}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_UART1_CTS, {PINMUX_UART1_CTS}, PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
};



usart_config_t usart_cfg = 
{
	.baudrate       = USART_BAUDRATE,
	.flow_control   = USART_FLOW_CONTROL_NONE,
	.data_bit       = USART_DATA_BIT_8,
	.stop_bit       = USART_STOP_BIT_1,
	.parity         = USART_PARITY_NONE,
};

typedef struct 
{
    volatile uint8_t st;
} usart_flag_t;


static usart_flag_t usart_flag;

static uint8_t rec_data[20];

static uint8_t send_data[20];




void bsp_uart1_gpio_init(void)
{
    drv_pin_init(uart1_pin_config, sizeof(uart1_pin_config) / sizeof(uart1_pin_config[0]));
}


void bsp_uart_block_init(void)
{
    drv_pin_init(uart_pin_config, sizeof(uart_pin_config) / sizeof(uart_pin_config[0]));

    drv_usart_init(TEST_USART, &usart_cfg);
}


void bsp_uart_block_demo(void)
{
    om_error_t error;
    
    memcpy(send_data, "hello\r\n", 7);
    
    drv_usart_write(TEST_USART, (uint8_t *)send_data, 7, 10);

    error = drv_usart_read(TEST_USART, (uint8_t *)rec_data, 10, 3000);
    
    if (error == OM_ERROR_TIMEOUT) 
    {
        drv_usart_write(TEST_USART, (uint8_t *)"Read Timeout\r\n", 14, 10);
    }
    else
    {
        drv_usart_write(TEST_USART, (uint8_t *)rec_data, 10, 10);
    }
}



static void test_usart_cb(void *om_usart, drv_event_t event, void *rxbuf, void *rx_cnt)
{ 
    if (event == DRV_EVENT_COMMON_READ_COMPLETED) 
	{
        drv_usart_write(TEST_USART, (uint8_t *)rxbuf, (uint32_t)rx_cnt, 10);   // Send what you receive
		
        usart_flag.st |= READ_INT_IS_DONE;
		
        usart_flag.st |= READ_DMA_IS_DONE;
    } 
	else if (event == DRV_EVENT_COMMON_WRITE_COMPLETED) 
	{
        usart_flag.st |= SEND_INT_IS_DONE;
    } 
	else if (event == DRV_EVENT_COMMON_DMA2PERIPH_COMPLETED) 
	{
        usart_flag.st |= SEND_DMA_IS_DONE;
    }
}


void bsp_uart_int_init(void)
{
    drv_pin_init(uart_pin_config, sizeof(uart_pin_config) / sizeof(uart_pin_config[0]));

    drv_usart_init(TEST_USART, &usart_cfg);
	
	drv_usart_register_isr_callback(TEST_USART, test_usart_cb);
}


void bsp_uart_int_demo(void)
{
	memcpy(send_data, "hello\r\n", 7);
	
    drv_usart_write_int(TEST_USART, (uint8_t *)send_data, 7);
	
    while (!(usart_flag.st & SEND_INT_IS_DONE));
	
    usart_flag.st &= ~SEND_INT_IS_DONE;

    drv_usart_read_int(TEST_USART, NULL, 0);

	while (!(usart_flag.st & READ_INT_IS_DONE));
	
	usart_flag.st &= ~READ_INT_IS_DONE;
}


void bsp_uart_dma_init(void)
{
    drv_pin_init(uart_pin_config, sizeof(uart_pin_config) / sizeof(uart_pin_config[0]));

    drv_usart_init(TEST_USART, &usart_cfg);
	
	drv_usart_register_isr_callback(TEST_USART, test_usart_cb);
	
	drv_usart_dma_channel_allocate(TEST_USART, USART_DMA_CHAN_ALL);	
}


void bsp_uart_dma_demo(void)
{
	memcpy(send_data, "hello\r\n", 7);
	
    drv_usart_write_dma(TEST_USART, (uint8_t *)send_data, 7);
	
    while (!(usart_flag.st & SEND_DMA_IS_DONE));
	
    usart_flag.st &= ~SEND_DMA_IS_DONE;

    drv_usart_read_dma(TEST_USART, (uint8_t *)rec_data, 10);

	while (!(usart_flag.st & READ_DMA_IS_DONE));
	
	usart_flag.st &= ~READ_DMA_IS_DONE;
}



void bsp_uart_flow_init(void)
{
	drv_pin_init(uart_pin_config, sizeof(uart_pin_config) / sizeof(uart_pin_config[0]));

	usart_cfg.flow_control = USART_FLOW_CONTROL_RTS_CTS;
	
    drv_usart_init(TEST_USART, &usart_cfg);
	
	drv_usart_register_isr_callback(TEST_USART, test_usart_cb);
}


void bsp_uart_flow_demo(void)
{
	memcpy(send_data, "hello\r\n", 7);
	
    drv_usart_write_int(TEST_USART, (uint8_t *)send_data, 7);
	
    while (!(usart_flag.st & SEND_INT_IS_DONE));
	
    usart_flag.st &= ~SEND_INT_IS_DONE;

    drv_usart_read_int(TEST_USART, NULL, 0);

	while (!(usart_flag.st & READ_INT_IS_DONE));
	
	usart_flag.st &= ~READ_INT_IS_DONE;
}




