#include "bsp.h"

static const pin_config_t uart0_pin_config[] = 
{
    {PAD_UART0_TXD, {PINMUX_UART0_TX},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_UART0_RXD, {PINMUX_UART0_RX},  PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
};


static uint8_t uart_ex_send_data[20];
static uint8_t uart_ex_rec_data[20];
static uint8_t uart_ex_rec_cnt = 0;


void bsp_uart0_gpio_init(void)
{
    drv_pin_init(uart0_pin_config, sizeof(uart0_pin_config) / sizeof(uart0_pin_config[0]));
}


static void test_usart_ex_cb(void *om_usart, drv_event_t event, void *rx_buf, void *rx_cnt)
{
	uint8_t *data = (uint8_t *)rx_buf; 
	
	uart_ex_rec_data[uart_ex_rec_cnt++] = data[0];
}



void bsp_uart_ex_int_init(void)
{
    usart_ex_config_t usart_cfg = 
	{
        .baudrate = USART_BAUDRATE,
    };
	
	bsp_uart0_gpio_init();
	
	drv_usart_ex_init(OM_USART0, &usart_cfg);
	
    drv_usart_ex_register_isr_callback(OM_USART0, test_usart_ex_cb);
	
	memcpy(uart_ex_send_data, "hello\r\n", 7);
	
    drv_usart_ex_write(OM_USART0, (uint8_t *)uart_ex_send_data, 7, 10);
}


void bsp_uart_ex_int_demo(void)
{
	if(uart_ex_rec_cnt >= 10)
	{
		drv_usart_ex_write(OM_USART0, (uint8_t *)uart_ex_rec_data, uart_ex_rec_cnt, 10);
		
		uart_ex_rec_cnt = 0;
	}		
}
















