#include "bsp.h"

uint8_t wdt_flag = 0;

static void bsp_wdt_cb(void *om_wdt, drv_event_t event, void *buff, void *num)
{
    if (event == DRV_EVENT_COMMON_GENERAL) 
    {
        wdt_flag = 1;
    }
}


void bsp_wdt_intdis_feed_init(void)
{
    uint8_t i = 0;
    
    drv_wdt_init(5000);
    
    for(i = 0;i < 5;i++)
    {
        DRV_DELAY_MS(200);
    
        led1_off();
        led2_off();
        
        DRV_DELAY_MS(200);
    
        led1_on();
        led2_off();
    }
}

void bsp_wdt_intdis_rst_init(void)
{
    uint8_t i = 0;
    
    drv_wdt_init(5000);
    
    for(i = 0;i < 5;i++)
    {
        DRV_DELAY_MS(200);
    
        led1_off();
        led2_off();
        
        DRV_DELAY_MS(200);
    
        led1_off();
        led2_on();
    }
}

void bsp_wdt_inten_feed_init(void)
{
    uint8_t i = 0;
    
    drv_wdt_init(5000);
    
    drv_wdt_register_isr_callback(bsp_wdt_cb);
    
    for(i = 0;i < 5;i++)
    {
        DRV_DELAY_MS(200);
    
        led1_off();
        led2_on();
        
        DRV_DELAY_MS(200);
    
        led1_on();
        led2_off();
    }
}

void bsp_wdt_inten_rst_init(void)
{
    uint8_t i = 0;
    
    drv_wdt_init(5000);
    
    drv_wdt_register_isr_callback(bsp_wdt_cb);
    
    for(i = 0;i < 5;i++)
    {
        DRV_DELAY_MS(200);
    
        led1_on();
        led2_off();
        
        DRV_DELAY_MS(200);
    
        led1_off();
        led2_on();
    }
}


void bsp_wdt_intdis_feed_demo(void)
{
    static uint8_t index = 0;
    
    DRV_DELAY_MS(500);
    
    drv_wdt_keep_alive();
    
    if(index == 0)
    {
        led1_off();
        led2_off();
        
        index = 1;
    }
    else
    {
        led1_on();
        led2_on();
        
        index = 0;
    }  
}


void bsp_wdt_intdis_rst_demo(void)
{
    static uint8_t index = 0;
    
    DRV_DELAY_MS(500);
    
    if(index == 0)
    {
        led1_off();
        led2_off();
        
        index = 1;
    }
    else
    {
        led1_on();
        led2_on();
        
        index = 0;
    }  
}


void bsp_wdt_inten_feed_demo(void)
{
    static uint8_t index = 0;
    
    if(wdt_flag == 1)
    {
        wdt_flag = 0;
        
        drv_wdt_keep_alive();
        
        if(index == 0)
        {
            led1_off();
            led2_off();
            
            index = 1;
        }
        else
        {
            led1_on();
            led2_on();
            
            index = 0;
        } 
    }
}


void bsp_wdt_inten_rst_demo(void)
{
    static uint8_t index = 0;
    
    if(wdt_flag == 1)
    {
        wdt_flag = 0;
        
        if(index == 0)
        {
            led1_off();
            led2_off();
            
            index = 1;
        }
        else
        {
            led1_on();
            led2_on();
            
            index = 0;
        } 
    }
}






