/* ----------------------------------------------------------------------------
 * Copyright (c) 2020-2030 Boling Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of Boling nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------------------------- */

/**
 * @file     omble_error.h
 * @date     27. May 2021
 * @author   Boling SW Team
 *
 * @version
 * Version 1.0
 *  - Initial release
 *
 * @addtogroup OMBLE_ERROR
 * @brief 错误代码
 */
/// @{

#ifndef __OMBLE_ERR_H__
#define __OMBLE_ERR_H__

/// 错误定义
typedef enum ob_error {
    OB_ERROR_NO_ERR                  = 0x00, ///< 执行成功
    OB_ERROR_NO_CONNECTION,                  ///< 无连接错误
    OB_ERROR_INVALID_STATE,                  ///< 状态错误
    OB_ERROR_INSUFFICIENT_RESOURCES,         ///< 无可用资源错误
    OB_ERROR_NOT_SUPPORT,                    ///< 操作或请求不支持
    OB_ERROR_INVALID_PARAM,                  ///< 参数错误
} ob_error_t;

/// GATT 错误定义
typedef enum ob_gatt_error {
    OB_GATT_ERR_NO_ERROR                       = 0x0000,
    OB_GATT_ERR_INVALID_HANDLE                 = 0x0401,
    OB_GATT_ERR_READ_NOT_PERMITTED             = 0x0402,
    OB_GATT_ERR_WRITE_NOT_PERMITTED            = 0x0403,
    OB_GATT_ERR_INVALID_PDU                    = 0x0404,
    OB_GATT_ERR_INSUFFICIENT_AUTHENTICATION    = 0x0405,
    OB_GATT_ERR_REQUEST_NOT_SUPPORTED          = 0x0406,
    OB_GATT_ERR_INVALID_OFFSET                 = 0x0407,
    OB_GATT_ERR_INSUFFICIENT_AUTHORIZATION     = 0x0408,
    OB_GATT_ERR_PREPARE_QUEUE_FULL             = 0x0409,
    OB_GATT_ERR_ATTRIBUTE_NOT_FOUND            = 0x040A,
    OB_GATT_ERR_ATTRIBUTE_NOT_LONG             = 0x040B,
    OB_GATT_ERR_ENCRYPTION_KEY_SIZE_TOO_SHORT  = 0x040C,
    OB_GATT_ERR_INVALID_ATTRIBUTE_VALUE_LENGTH = 0x040D,
    OB_GATT_ERR_UNLIKELY_ERROR                 = 0x040E,
    OB_GATT_ERR_INSUFFICIENT_ENCRYPTION        = 0x040F,
    OB_GATT_ERR_UNSUPPORTED_GROUP_TYPE         = 0x0410,
    OB_GATT_ERR_INSUFFICIENT_RESOURCES         = 0x0411,
    OB_GATT_ERR_DATABASE_OUT_OF_SYNC           = 0x0412,
    OB_GATT_ERR_VALUE_NOT_ALLOWED              = 0x0413,
} ob_gatt_error_t;

/// SMP 错误定义
typedef enum ob_smp_error {
    OB_SMP_ERR_NO_ERR                                 = 0x0000,
    OB_SMP_LOCAL_ERR_PASSKEY_ENTRY_FAILED             = 0x0601,
    OB_SMP_LOCAL_ERR_OOB_NOT_AVAILABLE                = 0x0602,
    OB_SMP_LOCAL_ERR_AUTHENTICATION_REQUIREMENTS      = 0x0603,
    OB_SMP_LOCAL_ERR_CONFIRM_VALUE_FAILED             = 0x0604,
    OB_SMP_LOCAL_ERR_PAIRING_NOT_SUPPORTED            = 0x0605,
    OB_SMP_LOCAL_ERR_ENCRYPTION_KEY_SIZE              = 0x0606,
    OB_SMP_LOCAL_ERR_COMMAND_NOT_SUPPORTED            = 0x0607,
    OB_SMP_LOCAL_ERR_UNSPECIFIED_REASON               = 0x0608,
    OB_SMP_LOCAL_ERR_REPEATED_ATTEMPTS                = 0x0609,
    OB_SMP_LOCAL_ERR_INVALID_PARAMETERS               = 0x060A,
    OB_SMP_LOCAL_ERR_DHKEY_CHECK_FAILED               = 0x060B,
    OB_SMP_LOCAL_ERR_NUMERIC_COMPARISON_FAILED        = 0x060C,
    OB_SMP_LOCAL_ERR_BR_EDR_PAIRING_IN_PROGRESS       = 0x060D,
    OB_SMP_LOCAL_ERR_CROSS_TRANSPORT_KEY_NOT_ALLOWED  = 0x060E,
    OB_SMP_LOCAL_ERR_KEY_REJECTED                     = 0x060F,
    OB_SMP_REMOTE_ERR_PASSKEY_ENTRY_FAILED            = 0x0701,
    OB_SMP_REMOTE_ERR_OOB_NOT_AVAILABLE               = 0x0702,
    OB_SMP_REMOTE_ERR_AUTHENTICATION_REQUIREMENTS     = 0x0703,
    OB_SMP_REMOTE_ERR_CONFIRM_VALUE_FAILED            = 0x0704,
    OB_SMP_REMOTE_ERR_PAIRING_NOT_SUPPORTED           = 0x0705,
    OB_SMP_REMOTE_ERR_ENCRYPTION_KEY_SIZE             = 0x0706,
    OB_SMP_REMOTE_ERR_COMMAND_NOT_SUPPORTED           = 0x0707,
    OB_SMP_REMOTE_ERR_UNSPECIFIED_REASON              = 0x0708,
    OB_SMP_REMOTE_ERR_REPEATED_ATTEMPTS               = 0x0709,
    OB_SMP_REMOTE_ERR_INVALID_PARAMETERS              = 0x070A,
    OB_SMP_REMOTE_ERR_DHKEY_CHECK_FAILED              = 0x070B,
    OB_SMP_REMOTE_ERR_NUMERIC_COMPARISON_FAILED       = 0x070C,
    OB_SMP_REMOTE_ERR_BR_EDR_PAIRING_IN_PROGRESS      = 0x070D,
    OB_SMP_REMOTE_ERR_CROSS_TRANSPORT_KEY_NOT_ALLOWED = 0x070E,
    OB_SMP_REMOTE_ERR_KEY_REJECTED                    = 0x070F,
} ob_smp_error_t;

#endif /* __OMBLE_ERR_H__ */

/// @}
