/* ----------------------------------------------------------------------------
 * Copyright (c) 2020-2030 Boling Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of Boling nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------------------------- */

/**
 * @file     omsh_app_firms.c
 * @brief    omesh app firms source file
 * @date     01. OCT. 2023
 * @author   Boling SW Team
 *
 * @version
 * Version 1.0
 *  - Initial release
 *
 * @{
 */


/*******************************************************************************
 * INCLUDES
 */
#include "omsh_app.h"

#ifdef APP_MESH_FIRMS
/*******************************************************************************
 * STATIC VARIABLE
 */
static omesh_node_id_t node_info = {
    .uuid           = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff},
    .company_id     = 0x01BF,
    .product_id     = 0x0001,
    .version_id     = 0x0001
};

static uint8_t bt_addr[6] = {0xDD, 0xDD, 0x66, 0x21, 0xDD, 0xDD};


/*******************************************************************************
 * EXPORTED FUNCTION DEFINITIONS
 */
void omesh_app_firms_init(void)
{
    // Set local bluetooth address
    ob_gap_addr_set(OB_ADV_ADDR_TYPE_PUBLIC, &bt_addr[0]);

    // Set mesh node identify
    omesh_set_uuid(node_info.uuid);
    omesh_set_cid(node_info.company_id);
    omesh_set_pid(node_info.product_id);
    omesh_set_vid(node_info.version_id);
}

void omesh_app_firms_start(uint8_t prov_state)
{
    // Check proved
    if(true == prov_state) {

    } else {
        /* TODO: Test API of omesh_auto_prov_handle
        omesh_auto_prov_t auto_prov = {
            .dev_key        = {0x37,0xB5,0xAD,0x9D,0xD7,0xBD,0x7C,0xA1,0xA1,0xAB,0x32,0x4C,0xED,0x0C,0xB8,0x0C},
            .net_key        = {0xC6,0x98,0x82,0x7C,0x34,0x23,0x79,0xCE,0xBE,0x10,0x1D,0x57,0x2B,0xBB,0x14,0x86},
            .net_key_id     = 0,
            .flags          = 0,
            .iv             = 0x0a,
            .unicast_addr   = 0x02
        };

        omesh_auto_prov_handle(&auto_prov);
        */
    }
}

#endif /* APP_MESH_FIRMS */

/** @} */