/* ----------------------------------------------------------------------------
 * Copyright (c) 2020-2030 Boling Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of Boling nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------------------------- */

/**
 * @file     omsh_app.h
 * @brief    omesh app header file
 * @date     01. OCT. 2023
 * @author   Boling SW Team
 *
 * @defgroup APP APP
 * @ingroup  APP
 * @brief    omesh app header file
 * @details  omesh app header file

 * @version
 * Version 1.0
 *  - Initial release
 *
 *
 * @{
 */

#ifndef __OMSH_APP_H__
#define __OMSH_APP_H__

#ifdef __cplusplus
extern "C"
{
#endif


/*******************************************************************************
 * INCLUDES
 */
#include "omsh_app_config.h"

/// Board and Driver
#include "board.h"
#include "om_driver.h"

/// Event and Event timer
#include "evt.h"
#include "evt_timer.h"

/// Power manager
#include "pm.h"

/// Shell and Log
#include "shell.h"
#include "om_log.h"

/// Algorithm
#include "uECC.h"
#include "sha256.h"

/// NVDS
#include "nvds.h"

/// BLE config
#include "ob_config.h"
#include "omble.h"

/// Mesh stack to app apis
#include "omsh_apis.h"

#if APP_MESH_PTS
#include "omsh_app_sig.h"
#endif

#if APP_MESH_TMALL
#include "omsh_app_tmall.h"
#endif

#if APP_MESH_FIRMS
#include "omsh_app_firms.h"
#endif


/*******************************************************************************
 * FUNTIONS
 */

/**
 ****************************************************************************************
 * @brief Mesh app init
 ****************************************************************************************
 */
void omesh_app_init(void);

/**
 ****************************************************************************************
 * @brief Mesh app start
 ****************************************************************************************
 */
void omesh_app_start(uint8_t prov_state);


#ifdef __cplusplus
}
#endif

#endif /* __OMSH_APP_H__ */

/** @} */
