#include "evt.h"

#include "decoder.h"

#include "LCM_DMA_SPI.h"

char m_pBuffer[m_Buffer_len];

char decode_pBuffer[m_Buffer_len];

char Line_ReadBuff[LCD_Show_Width];

char iBuf[240 * 2 * 2 + 16];

pencolor_t pencolor;
bmpHead_t bmpHeadInfo;

void Set_pen_color(uint16_t F_color, uint16_t B_color)
{
	pencolor.F_color = F_color;
	pencolor.B_color = B_color;
}

void sf_read_bmp(uint32_t address, char *pDataBuffer, uint32_t nByteToRead)
{
	//sf_read_fast_dual_dma(HS_SF, 0, address, (uint8_t *)pDataBuffer, nByteToRead);
	int iByteToRead = (nByteToRead + 15) & (~0xf);
	drv_sf_read(OM_SF, 0, address, iBuf, iByteToRead);
	memcpy(pDataBuffer, iBuf, nByteToRead);
}

int bmp_decode_show(int x0, int y0, uint32_t bmpAddres)
{
	char *pBuffer;
	uint16_t Half_lenOf_Buffer;
	char x1, y1; // window x1,y1;
	char bmpWidth, bmpHight;
	char bmp_nBit = 0;
	uint32_t pixDataOffset;
	int nByte_PerLine;
	int MaxLine_PerRead;
	int nBytes_PerRead;
	int nBytes_PerWrite;
	char left_line;
	uint32_t bmp_length;
	//CO_ALIGN(16)
	bmpHead_t bmp_HeadInfo;
	uint32_t MaxByte_To_Write;
	uint32_t bmp_pix_addr;
	char *pBuffer_flash2Sram;
	char *pReadBuff;
	char *pDecodeBuff;
	char *pDecodeSource;
	int ii;
	int dma_read_write_count;
	char *pColorIndex;
	char *pPix_Color;
	char first_trans = 1;

	pix_index_t *pPix_4b_index;

	pBuffer = (char *)m_pBuffer;
	Half_lenOf_Buffer = m_Buffer_len / 2;
	
	// read header
	memset(m_pBuffer, 0x00, m_Buffer_len);
	sf_read_bmp((bmpAddres), (char *)&bmp_HeadInfo, sizeof(bmpHead_t)); // get image info
	
	bmpWidth = bmp_HeadInfo.bmp_info.biWidth;
	bmpHight = bmp_HeadInfo.bmp_info.biHeight;
	bmp_length = bmpWidth * bmpHight;
	bmp_pix_addr = bmpAddres + bmp_HeadInfo.file_info.bfOffBits;
	bmp_nBit = bmp_HeadInfo.bmp_info.biBitCount;
	if ((bmp_HeadInfo.file_info.bfType != 0x4d42) || (bmp_length = 0))
	{
		return 0;
	}
	// Set dispay window
	if (x0 + bmpWidth > LCD_Width)
	{
		x1 = LCD_Width - 1;
	}
	else
	{
		x1 = x0 + bmpWidth - 1;
	}
	if (y0 + bmpHight > LCD_Hight)
	{
		y1 = LCD_Hight - 1;
	}
	else
	{
		y1 = y0 + bmpHight - 1;
	}
	lcm_screen_address_set(x0, y0, x1, y1);
	int mbyte = 0;
	MaxLine_PerRead = 0;
	
	switch (bmp_nBit)
	{
		case 1:
			while (1)
			{
				mbyte += bmpWidth;
				if (mbyte > Half_lenOf_Buffer)
				{
					break;
				}
				MaxLine_PerRead ++;
			}
			left_line = bmpHight;
			nByte_PerLine = ((bmpWidth + 7) / 8);
			pReadBuff = &pBuffer[Half_lenOf_Buffer * 2 - nByte_PerLine * MaxLine_PerRead];
			uint16_t *pDecodeBuff_1bit = (uint16_t *)pBuffer;
			
			while (1)
			{
				if (left_line == 0)
				{
					break;
				}
				if (left_line < MaxLine_PerRead)
				{
					MaxLine_PerRead = left_line;
				}
				left_line -= MaxLine_PerRead;
				//read flash
				dma_read_write_count = MaxLine_PerRead * nByte_PerLine;
				sf_read_bmp((bmp_pix_addr), pReadBuff, dma_read_write_count);
				bmp_pix_addr += dma_read_write_count;
				
				//decode
				char n, m, k, pix_cnt, mask, var;
				uint16_t pixer_total = 0;
				uint16_t pix_index;
				pDecodeSource = pReadBuff;
				pDecodeBuff_1bit = (uint16_t *)pBuffer;
				
				for (n = 0; n < MaxLine_PerRead; n++)
				{
					for (m = 0, pix_cnt = 0; m < nByte_PerLine; m++)
					{
						var = *pDecodeSource++;
						for (k = 0, mask = 0x80; k < 8; k++)
						{
							if (var & mask)
							{
								*pDecodeBuff_1bit = pencolor.F_color;
							}
							else
							{
								*pDecodeBuff_1bit = pencolor.B_color;
							}
							mask >>= 0x01;
							pDecodeBuff_1bit++;
							pixer_total += 2;
							if (++pix_cnt >= bmpWidth)
							{
								break;
							}
						}
					}
				}
//				// write lcd
//				if ((left_line == 0) && (first_trans == 1))
//					lcd_write_mem_ex(HS_SF1, 0, SFB_CS_NOKEEP, 0x2c, pBuffer, pixer_total);
//				else if (first_trans == 1)
//					lcd_write_mem_ex(HS_SF1, 0, SFB_CS_BEGIN, 0x2c, pBuffer, pixer_total);
//				else if (left_line == 0)
//					lcd_write_mem_ex(HS_SF1, 0, SFB_CS_END, 0x2c, pBuffer, pixer_total);
//				else
//					lcd_write_mem_ex(HS_SF1, 0, SFB_CS_KEEP, 0x2c, pBuffer, pixer_total);
//				OM_LOG_DEBUG("\r\n %d,%d,%d", first_trans, left_line, pixer_total);
//				first_trans = 0;
			}
		break;
			
		case 4:
			//1.calc Line need to read
			while (1)
			{
				mbyte += bmpWidth;
				if (mbyte > Half_lenOf_Buffer)
				{
					break;
				}
				MaxLine_PerRead ++;
			}
			left_line = bmpHight;
			nByte_PerLine = ((bmpWidth + 1) / 2);
			//2.setting read buff
			pReadBuff = Line_ReadBuff;
			//3.setting lcd buff
			uint16_t *pDecodeBuff_4bit = (uint16_t *)pBuffer;
			while (1)
			{
				if (left_line == 0)
				{
					break;
				}
				if (left_line < MaxLine_PerRead)
				{
					MaxLine_PerRead = left_line;
				}
				left_line -= MaxLine_PerRead;
				//read flash
				dma_read_write_count = MaxLine_PerRead * nByte_PerLine;
				sf_read_bmp((bmp_pix_addr), pReadBuff, dma_read_write_count);
				bmp_pix_addr += dma_read_write_count;
				pPix_4b_index = (pix_index_t *)pReadBuff;
				pPix_Color = pBuffer;
				uint16_t pixer_total = 0;
				pix_index_t pix_index;
#ifdef Normal_SPI_LCD_Enable
				for (ii = 0; ii < dma_read_write_count; ii++)
				{
					pix_index = *pPix_4b_index;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_1].rgbRed;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_1].rgbGreen;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_0].rgbRed;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_0].rgbGreen;
					pPix_Color++;
					pPix_4b_index++;
					pixer_total += 4;
				}
				// write lcd
				if (first_trans == 1)
				{
					lcd_pixer_trans(1);
				}
				spi_normal_lcd_write_mem_ex(HS_SF1, 0, pBuffer, pixer_total);
				if (left_line == 0)
				{
					lcd_pixer_trans(0);
				}
#else
				for (ii = 0; ii < dma_read_write_count; ii++)
				{
					pix_index = *pPix_4b_index;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_0].rgbGreen;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_0].rgbRed;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_1].rgbGreen;
					pPix_Color++;
					*pPix_Color = bmp_HeadInfo.color_table[pix_index.pix_index_1].rgbRed;
					pPix_Color++;
					pPix_4b_index++;
					pixer_total += 4;
				}
//					if ((left_line == 0) && (first_trans == 1))
//						lcd_write_mem_ex(HS_SF1, 0, SFB_CS_NOKEEP, 0x2c, pBuffer, pixer_total);
//					else if (first_trans == 1)
//						lcd_write_mem_ex(HS_SF1, 0, SFB_CS_BEGIN, 0x2c, pBuffer, pixer_total);
//					else if (left_line == 0)
//						lcd_write_mem_ex(HS_SF1, 0, SFB_CS_END, 0x2c, pBuffer, pixer_total);
//					else
//						lcd_write_mem_ex(HS_SF1, 0, SFB_CS_KEEP, 0x2c, pBuffer, pixer_total);
#endif
//					first_trans = 0;
			}
		break;
			
		case 8:
			while (1)
			{
				mbyte += bmpWidth;
				if (mbyte > Half_lenOf_Buffer)
				{
					break;
				}
				MaxLine_PerRead++;
			}
			left_line = bmpHight;
			pBuffer_flash2Sram = pBuffer;
			nByte_PerLine = bmpWidth;
			while (1)
			{
				if (left_line == 0)
				{
					break;
				}
				if (left_line < MaxLine_PerRead)
				{
					MaxLine_PerRead = left_line;
				}
				left_line -= MaxLine_PerRead;
				// read flash
				dma_read_write_count = MaxLine_PerRead * nByte_PerLine;
#ifdef OM_LCD_TEST_PING
				gpio_write(BITMASK(TEST_PIN), GPIO_LOW); // test pin
#endif
				sf_read_bmp((bmp_pix_addr), pBuffer_flash2Sram, dma_read_write_count);
#ifdef OM_LCD_TEST_PING
				gpio_write(BITMASK(TEST_PIN), GPIO_HIGH); // test pin
				gpio_write(BITMASK(TEST_PIN), GPIO_LOW);  // test pin
				gpio_write(BITMASK(TEST_PIN), GPIO_HIGH); // test pin
				gpio_write(BITMASK(TEST_PIN), GPIO_LOW);  // test pin
#endif
				uint16_t pixer_total = 0;
				bmp_pix_addr += dma_read_write_count;
				//decode
				pColorIndex = &pBuffer_flash2Sram[dma_read_write_count - 1];
				pPix_Color = &pBuffer_flash2Sram[dma_read_write_count * 2 - 1];
				for (ii = dma_read_write_count; ii > 0; ii--)
				{
					*pPix_Color = bmp_HeadInfo.color_table[*pColorIndex].rgbRed;
					pPix_Color--;
					*pPix_Color = bmp_HeadInfo.color_table[*pColorIndex].rgbGreen;
					pPix_Color--;
					pColorIndex--;
					pixer_total = pixer_total + 1;
				}
				// write lcd
				if (first_trans == 1)
				{
					lcd_pixer_trans(1);
				}
				// spi_normal_lcd_write_mem_ex(HS_SF1, 0, pBuffer, pixer_total);
				spi_normal_lcd_write_mem_ex(OM_SPI0, 0, (uint8_t *)pBuffer, pixer_total);
				if (left_line == 0)
				{
					lcd_pixer_trans(0);
				}
				// write lcd
//						if ((left_line == 0) && (first_trans == 1))
//							lcd_write_mem_ex(HS_SF1, 0, SFB_CS_NOKEEP, 0x2c, pBuffer_flash2Sram, dma_read_write_count << 1);
//						else if (first_trans == 1)
//							lcd_write_mem_ex(HS_SF1, 0, SFB_CS_BEGIN, 0x2c, pBuffer_flash2Sram, dma_read_write_count << 1);
//						else if (left_line == 0)
//							lcd_write_mem_ex(HS_SF1, 0, SFB_CS_END, 0x2c, pBuffer_flash2Sram, dma_read_write_count << 1);
//						else
//							lcd_write_mem_ex(HS_SF1, 0, SFB_CS_KEEP, 0x2c, pBuffer_flash2Sram, dma_read_write_count << 1);
//						first_trans = 0;
			}
		break;
			
		case 16:
			while (1)
			{
				mbyte += bmpWidth;
				if (mbyte > Half_lenOf_Buffer)
				{
					break;
				}
				MaxLine_PerRead ++;  //一次性可以读出最大的行，
			}
			//OM_LOG_DEBUG("\r\n MaxLine_PerRead=%d ",MaxLine_PerRead);
			left_line = bmpHight;
			pBuffer_flash2Sram = pBuffer;
			nByte_PerLine = bmpWidth * 2;//一行需要的字节数
			//OM_LOG_DEBUG("\r\n left_line=%d ",left_line);
			while (1)
			{
				if (left_line == 0)
				{
					break;
				}
				if (left_line < MaxLine_PerRead)
				{
					MaxLine_PerRead = left_line;
				}
				left_line -= MaxLine_PerRead;//按最大的行数减少
				//read flash
				dma_read_write_count = MaxLine_PerRead * nByte_PerLine;//把最大行数的字节读出来
				//OM_LOG_DEBUG("\r\n dma_read_write_count=%d ",dma_read_write_count);
				sf_read_bmp((bmp_pix_addr), pBuffer_flash2Sram, dma_read_write_count);
				bmp_pix_addr += dma_read_write_count;
				//decode none
				// write lcd
				if (first_trans == 1)
				{
					lcd_pixer_trans(1);
				}
				//spi_normal_lcd_write_mem_ex(HS_SF1, 0, pBuffer_flash2Sram, dma_read_write_count);
				spi_normal_lcd_write_mem_ex(OM_SPI0, 0, (uint8_t *)pBuffer_flash2Sram, dma_read_write_count);
				if (left_line == 0)
				{
					lcd_pixer_trans(0);
				}
				first_trans = 0;
			}
		break;
	}
	
	return bmpWidth;
}

int dial_decode_icon(int x0, int y0, uint32_t bmpAddres, uint32_t bgAddres)
{
	uint16_t x1, y1;
	int nByte_PerLine;
	char left_line;
	char *pBuffer_flash2Sram;
	int dma_read_write_count;
	char first_trans = 1;
	char *pBuffer = (char *)m_pBuffer;
	char *dBuffer = (char *)decode_pBuffer;
	uint16_t Half_lenOf_Buffer = m_Buffer_len / 2;
	//read header
	memset(m_pBuffer,   0x00, m_Buffer_len);
	memset(decode_pBuffer,  0x00, m_Buffer_len);
	//  CO_ALIGN(16)
	bmpHead_t bmp_HeadInfo;
	sf_read_bmp((bmpAddres), (char *)&bmp_HeadInfo, sizeof(bmpHead_t)); // get image info
	uint16_t bmpWidth = bmp_HeadInfo.bmp_info.biWidth;
	uint16_t bmpHight = bmp_HeadInfo.bmp_info.biHeight;
	uint32_t bmp_length = bmpWidth * bmpHight;
	uint32_t bmp_pix_addr = bmpAddres + bmp_HeadInfo.file_info.bfOffBits;
	OM_LOG_DEBUG("\r\n bmp_pix_addr=%d ", bmp_HeadInfo.file_info.bfOffBits);
	char bmp_nBit = bmp_HeadInfo.bmp_info.biBitCount;
	if ((bmp_HeadInfo.file_info.bfType != 0x4d42) || (bmp_length = 0) || bmp_nBit != 16) //notice!!!
	{
			return 0;
	}
	sf_read_bmp((bgAddres), (char *)&bmp_HeadInfo, sizeof(bmpHead_t)); // get image info
	OM_LOG_DEBUG("\r\n bg_pix_addr=%d,%d,%d", bmp_HeadInfo.file_info.bfOffBits, bmp_HeadInfo.bmp_info.biWidth,
						bmp_HeadInfo.bmp_info.biHeight);
	uint32_t bg_pix_addr = bgAddres + bmp_HeadInfo.file_info.bfOffBits + y0 * LCD_Show_Width * 2 + 2 * x0;
	// Set dispay window
	if (x0 + bmpWidth > LCD_Width)
	{
			x1 = LCD_Width - 1;
	}
	else
	{
			x1 = x0 + bmpWidth - 1;
	}
	if (y0 + bmpHight > LCD_Hight)
	{
			y1 = LCD_Hight - 1;
	}
	else
	{
			y1 = y0 + bmpHight - 1;
	}
	lcm_screen_address_set(x0, y0, x1, y1);
	//calc
	int mbyte = 0;
	int MaxLine_PerRead = 0;
	while (1)
	{
			mbyte += bmpWidth;
			if (mbyte > Half_lenOf_Buffer)
			{
					break;
			}
			MaxLine_PerRead++;
	}
	//OM_LOG_DEBUG("\r\n MaxLine_PerRead=%d ",MaxLine_PerRead);
	left_line = bmpHight;
	pBuffer_flash2Sram = pBuffer;
	nByte_PerLine = bmpWidth * 2;
	//OM_LOG_DEBUG("\r\n left_line=%d ",left_line);
	while (1)
	{
		if (left_line == 0)
		{
			break;
		}
		if (left_line < MaxLine_PerRead)
		{
			MaxLine_PerRead = left_line;
		}
		left_line -= MaxLine_PerRead;
		//read flash
		dma_read_write_count = MaxLine_PerRead * nByte_PerLine;
		//OM_LOG_DEBUG("\r\n dma_read_write_count=%d ",dma_read_write_count);
		sf_read_bmp((bmp_pix_addr), pBuffer_flash2Sram, dma_read_write_count);
		bmp_pix_addr += dma_read_write_count;
		//decode none
		for (uint16_t ii = 0; ii < MaxLine_PerRead; ii++)
		{
			sf_read_bmp(bg_pix_addr, &dBuffer[ii * nByte_PerLine], nByte_PerLine);
			bg_pix_addr += (LCD_Show_Width * 2);
		}
		//decode
		uint16_t *pdes = (uint16_t *)dBuffer;
		uint16_t *pdsrc = (uint16_t *)pBuffer_flash2Sram;
		for (int kk = 0; kk < dma_read_write_count / 2; kk++)
		{
			//skip black pix
			if (*pdsrc)
			{
				*pdes = *pdsrc;
			}
			pdes++;
			pdsrc++;
		}
		// write lcd
		if (first_trans == 1)
		{
			lcd_pixer_trans(1);
		}
		//spi_normal_lcd_write_mem_ex(HS_SF1, 0, dBuffer, dma_read_write_count);
		if (left_line == 0)
		{
			lcd_pixer_trans(0);
		}
		first_trans = 0;
	}
	return 1;
}

void decompres_bmp_evt_cb(void)
{
	int ii;
	char *pColorIndex;
	char *pPix_Color;
	
	evt_clear(DECOMPRES_BMP_EVT); // 清除解压图片数据事件
	
	if(flush_bmp_info.buf_num == 1)
	{
		pColorIndex = &FrameBuffer[flush_bmp_info.bulk_read_len - 1];
		pPix_Color = &FrameBuffer[flush_bmp_info.bulk_read_len * 2 - 1];
		for (ii = flush_bmp_info.bulk_read_len; ii > 0; ii --)
		{
//				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbRed;
//				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbGreen;
			*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbGreen;
			*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbRed;
		}
		
		while(!spi0_int_transfer_is_done_test);
		spi0_int_transfer_is_done_test = 0;
		
		SPI_3wire_8bit_serial_data_buf(FrameBuffer, flush_bmp_info.bulk_read_len * 2);
		
		flush_bmp_info.left_len -= flush_bmp_info.bulk_read_len;
		flush_bmp_info.bmp_pix_addr += flush_bmp_info.bulk_read_len;
		if (flush_bmp_info.left_len < flush_bmp_info.bulk_read_len)
			flush_bmp_info.bulk_read_len = flush_bmp_info.left_len;
		if (flush_bmp_info.left_len <= 0)
		{
			return;
		}
		
		flush_bmp_info.buf_num = 2;
		sf_read(flush_bmp_info.bmp_pix_addr, &FrameBuffer_B[0], flush_bmp_info.bulk_read_len, false);
	}
	else if(flush_bmp_info.buf_num == 2)
	{
		pColorIndex = &FrameBuffer_B[flush_bmp_info.bulk_read_len - 1];
		pPix_Color = &FrameBuffer_B[flush_bmp_info.bulk_read_len * 2 - 1];
		for (ii = flush_bmp_info.bulk_read_len; ii > 0; ii --)
		{
//				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbRed;
//				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbGreen;
			*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbGreen;
			*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbRed;
		}
		
		while(!spi0_int_transfer_is_done_test);
		spi0_int_transfer_is_done_test = 0;
		
		SPI_3wire_8bit_serial_data_buf(FrameBuffer_B, flush_bmp_info.bulk_read_len * 2);
		
		flush_bmp_info.left_len -= flush_bmp_info.bulk_read_len;
		flush_bmp_info.bmp_pix_addr += flush_bmp_info.bulk_read_len;
		if (flush_bmp_info.left_len < flush_bmp_info.bulk_read_len)
			flush_bmp_info.bulk_read_len = flush_bmp_info.left_len;
		if (flush_bmp_info.left_len <= 0)
		{
			return;
		}
		
		flush_bmp_info.buf_num = 1;
		sf_read(flush_bmp_info.bmp_pix_addr, &FrameBuffer[0], flush_bmp_info.bulk_read_len, false);
	}
}

__RAM_CODE
void fast_show_bmp_image(uint32_t image_flash_address)
{
	flush_bmp_info.buf_num = 0;

	flush_bmp_info.bmp_Flash_addr = (uint32_t *)image_flash_address; // 读取图片信息头的地址

	sf_read(flush_bmp_info.bmp_Flash_addr, &bmpHeadInfo, sizeof(bmpHead_t), true); // get image info

	if (bmpHeadInfo.file_info.bfType != 0x4d42) // bmp header
	{
//		OM_LOG_DEBUG("-->   *Fail*\r\n");
		return;
	}
	
	flush_bmp_info.bmp_length = bmpHeadInfo.bmp_info.biHeight * bmpHeadInfo.bmp_info.biWidth;
	flush_bmp_info.bmp_pix_addr = flush_bmp_info.bmp_Flash_addr + bmpHeadInfo.file_info.bfOffBits;
	lcm_screen_address_set(0, 0, bmpHeadInfo.bmp_info.biWidth - 1, bmpHeadInfo.bmp_info.biHeight - 1); // 设置刷屏区域
	flush_bmp_info.left_len = flush_bmp_info.bmp_length;

	if (flush_bmp_info.bmp_length < (DISPLAY_BUFFER_LEN / 2))
		flush_bmp_info.bulk_read_len = flush_bmp_info.bmp_length;
	else
		flush_bmp_info.bulk_read_len = DISPLAY_BUFFER_LEN / 2;

	if (bmpHeadInfo.bmp_info.biBitCount <= 8) // 16bit,24bit
	{
		lcd_pixer_trans(1);
	
		spi0_int_transfer_is_done_test = 1; // 先将SPI0的中断标志清零
		
		flush_bmp_info.buf_num = 1;
		
		// 开始读取图片信息，只需要启动，不需要等待读取完成，在产生中断之后去处理后续的事情。
		sf_read(flush_bmp_info.bmp_pix_addr, &FrameBuffer[0], flush_bmp_info.bulk_read_len, false);
		
#if 0	
		while (1)
		{
			/* 第一步：先读取图片数据，这个接口函数是等待读取完数据才出来，保证出来之后有数据解压 */
			read_flash_resut = sf_read((void *)(bmp_pix_addr), &FrameBuffer[0], bulk_read_len);
			if(read_flash_resut != 0)
			{
				// LCM上显示读取flash的错误信息
			}
			
			/* 第二步：解压数据，以便下面刷图到LCM */
			pColorIndex = &FrameBuffer[bulk_read_len - 1];
			pPix_Color = &FrameBuffer[bulk_read_len * 2 - 1];
			for (ii = bulk_read_len; ii > 0; ii --)
			{
//				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbRed;
//				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbGreen;
				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbGreen;
				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbRed;
			}
			
			/* 第三步：由于刷屏的SPI函数接收我们是不等待刷完的，只是启动DMA之后就走了，
			目的是为了读flash和刷屏同时进行，所以这里要等待上一次刷屏完成 */			
			while(!spi0_int_transfer_is_done_test);
			spi0_int_transfer_is_done_test = 0;

			/* 第四步：启动刷屏DMA，不用等待他刷完 */
			SPI_3wire_8bit_serial_data_buf(FrameBuffer, bulk_read_len * 2);

			left_len -= bulk_read_len;
			bmp_pix_addr += bulk_read_len;
			if (left_len < bulk_read_len)
				bulk_read_len = left_len;
			if (left_len <= 0)
				break;
			
			/* 第五步：再刷屏期间，准备下一个缓冲的数据，然后解压。B-Buffer, 双缓冲 */
			read_flash_resut = sf_read((void *)(bmp_pix_addr), &FrameBuffer_B[0], bulk_read_len);
			if(read_flash_resut != 0)
			{
				// LCM上显示读取flash的错误信息
			}
			
			/* 第六步：解压数据 */
			pColorIndex = &FrameBuffer_B[bulk_read_len - 1];
			pPix_Color = &FrameBuffer_B[bulk_read_len * 2 - 1];
			for (ii = bulk_read_len; ii > 0; ii --)
			{
//				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbRed;
//				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbGreen;
				*(pPix_Color --) = bmpHeadInfo.color_table[*pColorIndex].rgbGreen;
				*(pPix_Color --) = bmpHeadInfo.color_table[*(pColorIndex --)].rgbRed;
			}
			
			/* 第七步：等待刷屏DMA完成 */			
			while(!spi0_int_transfer_is_done_test);
			spi0_int_transfer_is_done_test = 0;

			/* 第八步：紧跟着刷下一组数据。由于读flash数据和解压缩数据的时间都比刷屏的时间长，所以中间几乎是没有空闲时间的。 */	
			SPI_3wire_8bit_serial_data_buf(FrameBuffer_B, bulk_read_len * 2);

			left_len -= bulk_read_len;
			bmp_pix_addr += bulk_read_len;
			if (left_len < bulk_read_len)
				bulk_read_len = left_len;
			if (left_len <= 0)
				break;
		}
		lcd_pixer_trans(0);
#endif
	}
}
