#ifndef __DECODER_H__
#define __DECODER_H__

#include "om_driver.h"

#define BMP_4BIT						0

#define LCD_Width						(LCD_FULLSCREEN_COLUMN)
#define LCD_Hight						(LCD_FULLSCREEN_ROW)

#ifdef I2T_PROJECT
	#define LCD_Show_Width		(160)
	#define LCD_Show_Hight		(80)
#else
	#define LCD_Show_Width		(128)
	#define LCD_Show_Hight		(128)
#endif

#define LCD_nLine						(1)
#define LCD_PixBytes				(2)
#define m_Buffer_len				(LCD_Show_Width * LCD_nLine * LCD_PixBytes)

typedef struct
{
	uint8_t Index; // may not used
	uint8_t Z_Layer; // may not used
	uint8_t x0_postion;
	uint8_t y0_postion;
	uint32_t pic_Address; // the picture position in flash
}ui_scene_info_t;

typedef enum
{
	scroll_Off = 0,
	scroll_off = 0,
	scroll_up = 1,
	up = 1,
	scroll_Down = 2,
	dow = 2,
}scroll_direction_t;

typedef struct
{
	uint16_t F_color; // 前景色
	uint16_t B_color; // 背景色
}pencolor_t;

typedef struct
{
	uint16_t bfType; // 2
	uint32_t bfSize; // 4
	uint16_t bfReserved1; // 2
	uint16_t bfReserved2; // 2
	uint32_t bfOffBits; // 4
}__attribute__((packed)) BitMapFileHeader_t;

// 2.位图信息 
// 位图信息包含两部分内容(1)位图信息头, (2)另一个是调色板         
// (1)文图信息头  占用40个字节 
typedef struct
{
	uint32_t biSize;          //信息头大小
	uint32_t biWidth;         //图像宽度,以像素为单位
	uint32_t biHeight;        //图像高度,以像素为单位
	uint16_t biPlanes;        //位平面数,为1;
	uint16_t biBitCount;      //每像素位数,1,4,8,24
	uint32_t biCompression;   //压缩类型,0为非压缩
	uint32_t biSizeImage;     //压缩图像大小
	uint32_t biXpelspermeter; //水平分辨率
	uint32_t biYpelspermeter; //垂直分辨率
	uint32_t biClrUsed;       //使用的色彩数
	uint32_t biClrImportant;  //重要色彩数
}__attribute__((packed)) BitMapInforHeader_t;

// (2)是调色板了, 占用了的字节数是不确定的.2位灰度图占用8个字节, 4为灰度图占用64个字节, 8位灰度图占用1024个字节.算法如下:
// 调色板
typedef struct
{
	unsigned char rgbBlue;     //该颜色的蓝色分量
	unsigned char rgbGreen;    //该颜色的绿色分量
	unsigned char rgbRed;      //该颜色的红色分量
	unsigned char rgbReserved; //保留值
}__attribute__((packed)) RGBQuad_t;

// 其他数据
typedef struct OtherData
{
	unsigned char extradata;
	struct OtherData *next;
} OtherData;

typedef struct
{
	BitMapFileHeader_t file_info; // 14
	BitMapInforHeader_t bmp_info; // 44
#if BMP_4BIT
	RGBQuad_t color_table[16]; // 64
#else
	RGBQuad_t color_table[256]; // 1024	
#endif
	char dump[6];
}__attribute__((packed)) bmpHead_t;

typedef struct
{
	unsigned char pix_index_0:4;
	unsigned char pix_index_1:4;
} pix_index_t;

extern pencolor_t pencolor;

int bmp_decode_show(int x0, int y0, uint32_t bmpAddres);

void Set_pen_color(uint16_t F_color, uint16_t B_color);

void sf_read_bmp(uint32_t address, char *pDataBuffer, uint32_t nByteToRead);

void fast_show_bmp_image(uint32_t image_flash_address);

#endif