 #include "HS6220.H"
#include "user.H"


extern word point;
byte rf_data_buf[32];


byte no_rf_delay;
//byte tx_id[2];
byte rf_buf,rf_write_data_cnt;
byte rf_reg,rf_data;
byte DelayCnt;
byte rf_sleep_cnt;

#define io_led 		Pa.0
/*
void rf_table(void)
{
	_pcadd
	{
	ret  0xdd; // //ce low
	ret  0xaa; 

	ret  0x20;    ret  0x0e;//0x03;   //HS6200_BANK0_CONFIG
	ret  0xaa;
	ret  0x25;    ret  0x46;//0x32;   //HS6200_BANK0_RF_CH
	ret  0xaa;
	ret  0x26;    ret  0x47;//0x40;   //HS6200_BANK0_RF_SETUP
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;


	ret  0x21;    ret  0x40;ret  0x00;ret  0x10;ret  0xe5;  //HS6200_BANK1_PLL_CTL0  
    ret  0xaa;
	ret  0x23;    ret  0x20;ret  0x08;ret  0x50;//ret  0x40;ret  0x50;  //HS6200_BANK1_CAL_CTL 
    ret  0xaa;
	ret  0x2a;    ret  0x00;ret  0x00;ret  0x1f;//HS6200_BANK1_IF_FREQ
    ret  0xaa;
	ret  0x2c;    ret  0x25;//0x20;   //HS6200_BANK1_FDEV
    ret  0xaa;
	ret  0x38;    ret  0x7f;   //HS6200_BANK1_DAC_CAL_HI
 //   ret  0xaa;

//	ret  0x3e;    ret  0x1f;ret  0x64;ret  0x00;ret  0x81;//HS6200_BANK1_RF_IVGEN
    ret  0xee;  //delay >=40ms
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
    ret  0xcc;  //ce high
    ret  0xbb;  //delay >=2ms
    ret  0xdd;  //ce low
    ret  0xee;  //delay >=40ms
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
	ret  0x21;    ret  0x40;ret  0x01;ret  0x30;ret  0xe1;  //HS6200_BANK1_PLL_CTL0
    ret  0xaa;
	ret  0x22;    ret  0x00;ret  0x42;//ret  0x10;ret  0x01;  //HS6200_BANK1_PLL_CTL1
    ret  0xaa;
	ret  0x23;    ret  0x29;ret  0x89;ret  0x65;ret  0x28;//ret  0x50;  //HS6200_BANK1_CAL_CTL
    ret  0xaa;
	ret  0x31;    ret  0x52;//ret  0xc2;ret  0x09;ret  0xac;  //HS6200_BANK1_RX_CTRL
    ret  0xaa;
	ret  0x33;    ret  0x80;ret  0x14;//ret  0x08;ret  0x29;  //HS6200_BANK1_FAGC_CTRL_1
    ret  0xaa;
	ret  0x3e;    ret  0x1f;ret  0x64;ret  0x00;ret  0x11;//0x01;  //HS6200_BANK1_RF_IVGEN
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
	ret  0x20;    ret  0x0e;   //HS6200_BANK0_CONFIG  bit0  tx rx
    ret  0xaa;
	ret  0x31;    ret  0x10;   //HS6200_BANK0_RX_PW_P0
    ret  0xaa;
//	ret  0x3c;    ret  0x3f;   //HS6200_BANK0_DYNPD
//    ret  0xaa;
//	ret  0x3d;    ret  0x00;   //HS6200_BANK0_FEATURE
//    ret  0xaa;
//	ret  0x3e;    ret  0x40;ret  0x5a;ret  0x80;ret  0x06;ret  0x00;  //HS6200_BANK0_SETUP_VALUE
//    ret  0xaa;
	ret  0x3f;    ret  0x77;   //HS6200_BANK0_PRE_GURD
    ret  0xaa;
//	ret  0x21;    ret  0x00;   //HS6200_BANK0_EN_AA
//    ret  0xaa;
//	ret  0x22;    ret  0x00;   //HS6200_BANK0_EN_RXADDR
//    ret  0xaa;
//	ret  0x23;    ret  0x03;   //HS6200_BANK0_SETUP_AW
//    ret  0xaa;
//	ret  0x24;    ret  0x0f;   //HS6200_BANK0_SETUP_RETR
//    ret  0xaa;
	ret  0x25;    ret  0x02;   //HS6200_BANK0_RF_CH
    ret  0xaa;
	ret  0x26;    ret  0x47;   //HS6200_BANK0_RF_SETUP
    ret  0xaa;
	ret  0x2a;    ret  0x55;ret  0x6e;ret  0x54;ret  0x9c;ret  0x52;//HS6200_BANK0_RX_ADDR_P0
    ret  0xaa;
	ret  0x30;    ret  0x55;ret  0x6e;ret  0x54;ret  0x9c;ret  0x52;//HS6200_BANK0_TX_ADDR
    ret  0xaa;
    ret  0xcc;  //ce high
    ret  0xff;
    ret  0xff;
	}
}
*/

void rf_table(void)
{
	_pcadd
	{
	ret  0xdd; // //ce low
	ret  0xaa; 
	ret  0x20;    ret  0x03;   //HS6200_BANK0_CONFIG
	ret  0xaa;
	ret  0x25;    ret  0x32;   //HS6200_BANK0_RF_CH
	ret  0xaa;
	ret  0x26;    ret  0x40;   //HS6200_BANK0_RF_SETUP
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
	ret  0x21;    ret  0x40;ret  0x00;ret  0x10;ret  0xe5;  //HS6200_BANK1_PLL_CTL0  
    ret  0xaa;
	ret  0x23;    ret  0x20;ret  0x08;ret  0x50;ret  0x40;ret  0x50;  //HS6200_BANK1_CAL_CTL 
    ret  0xaa;
	ret  0x2a;    ret  0x00;ret  0x00;ret  0x1f;//HS6200_BANK1_IF_FREQ
    ret  0xaa;
	ret  0x2c;    ret  0x20;   //HS6200_BANK1_FDEV
    ret  0xaa;
	ret  0x38;    ret  0x7f;   //HS6200_BANK1_DAC_CAL_HI
    ret  0xaa;
	ret  0x3e;    ret  0x1f;ret  0x64;ret  0x00;ret  0x81;//HS6200_BANK1_RF_IVGEN
    ret  0xbb;  //delay >=2ms
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
    ret  0xcc;  //ce high
    ret  0xbb;  //delay >=2ms
    ret  0xdd;  //ce low
    ret  0xee;  //delay >=40ms
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
	ret  0x21;    ret  0x40;ret  0x01;ret  0x30;ret  0xe1;  //HS6200_BANK1_PLL_CTL0
    ret  0xaa;
	ret  0x22;    ret  0x00;ret  0x42;ret  0x10;ret  0x01;  //HS6200_BANK1_PLL_CTL1
    ret  0xaa;
	ret  0x23;    ret  0x29;ret  0x89;ret  0x65;ret  0x28;ret  0x50;  //HS6200_BANK1_CAL_CTL
    ret  0xaa;
	ret  0x31;    ret  0x52;ret  0xc2;ret  0x09;ret  0xac;  //HS6200_BANK1_RX_CTRL
    ret  0xaa;
	ret  0x33;    ret  0x80;ret  0x14;ret  0x08;ret  0x29;  //HS6200_BANK1_FAGC_CTRL_1
    ret  0xaa;
	ret  0x3e;    ret  0x1f;ret  0x64;ret  0x00;ret  0x01;  //HS6200_BANK1_RF_IVGEN
    ret  0xaa;
	ret  0x50;    ret  0x53;   //лbank
    ret  0xaa;
	ret  0x20;    ret  0x0e;   //HS6200_BANK0_CONFIG  bit0  tx rx
    ret  0xaa;
	ret  0x31;    ret  0x10;   //HS6200_BANK0_RX_PW_P0
    ret  0xaa;
	ret  0x3c;    ret  0x3f;   //HS6200_BANK0_DYNPD
    ret  0xaa;
	ret  0x3d;    ret  0x00;   //HS6200_BANK0_FEATURE
    ret  0xaa;
	ret  0x3e;    ret  0x40;ret  0x5a;ret  0x80;ret  0x06;ret  0x00;  //HS6200_BANK0_SETUP_VALUE
    ret  0xaa;
	ret  0x3f;    ret  0x77;   //HS6200_BANK0_PRE_GURD
    ret  0xaa;
	ret  0x21;    ret  0x00;   //HS6200_BANK0_EN_AA
    ret  0xaa;
	ret  0x22;    ret  0x00;   //HS6200_BANK0_EN_RXADDR
    ret  0xaa;
	ret  0x23;    ret  0x03;   //HS6200_BANK0_SETUP_AW
    ret  0xaa;
	ret  0x24;    ret  0x0f;   //HS6200_BANK0_SETUP_RETR
    ret  0xaa;
	ret  0x25;    ret  0x02;   //HS6200_BANK0_RF_CH
    ret  0xaa;
	ret  0x26;    ret  0x47;   //HS6200_BANK0_RF_SETUP
    ret  0xaa;
	ret  0x2a;    ret  0x55;ret  0x6e;ret  0x54;ret  0x9c;ret  0x52;//HS6200_BANK0_RX_ADDR_P0
    ret  0xaa;
	ret  0x30;    ret  0x55;ret  0x6e;ret  0x54;ret  0x9c;ret  0x52;//HS6200_BANK0_TX_ADDR
    ret  0xaa;
    ret  0xcc;  //ce high
    ret  0xff;
    ret  0xff;
	}
}

/*******************************************************************************
* : Delayus
* : ӳ
* β:       
* : 
* ˵: 
*******************************************************************************/
void Delay100US(void)
{
	byte cnt;
	do
	{
		cnt = 70;
		do
		{
//		wdreset;
		}while(--cnt$0);
	}while(--DelayCnt$0);
}

//===============================================
//===============================================
void spi_Writeabyte(void)
{
//-------- SPI----------------------
/*
   byte k=8;
 //  PBC.2=1;
   .delay 10
   while(k)
   {     
	   spi_sck=0;               // _|~
	   if(rf_buf.7)
	     spi_mosi=1;
 	   else 
	     spi_mosi=0;
	  nop;
	   spi_sck=1;               // ~|_
 	   rf_buf<<=1;  	   
	   k--;
   }
   spi_sck=0;
   spi_mosi=0;
*/
//-------- SPI----------------------

   byte k=8;
   spi_mosi_c=1;

   .delay 10
   while(k)
   {     
	   spi_sck=0;               // _|~
	   if(rf_buf.7)
	     spi_mosi=1;
 	   else 
	     spi_mosi=0;
	   spi_sck=1;    
	   nop;
 	   rf_buf<<=1;  	   
	   k--;
   }
   spi_sck=0;
   spi_mosi=0;
   .delay 10
} 
//===============================================
//===============================================
void  spi_Readabyte(void)
{
//-------- SPI----------------------
/*
  byte k=8;
  // PAC.0=0;
 // paph.0 =1;
   .delay 10

  while(k)
  {
  	 rf_buf<<=1;
     spi_sck=1;
     if(spi_miso)
	    rf_buf.0=1; //   rf_buf |=0x01;
     else
	    rf_buf.0=0; // rf_buf &=0xfe;
     spi_sck=0;
	 k--;
  }
*/
//-------- SPI----------------------
  byte k=8;
   spi_mosi_c=0;
   spi_mosi_h=0;
   .delay 10

  while(k)
  {
  	 rf_buf<<=1;
     spi_sck=1;
     if(spi_mosi)
	    rf_buf.0=1; //   rf_buf |=0x01;
     else
	    rf_buf.0=0; // rf_buf &=0xfe;
     spi_sck=0;
	 k--;
  }

}
//===============================================
//write reg
//===============================================
void rf_write_onebyte(void)
{
	spi_csn=0;
	rf_buf=rf_reg;
	spi_Writeabyte();
	rf_buf=rf_data;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//write reg
//===============================================
void rf_read_onebyte(void)
{
	spi_csn=0;
	rf_buf=rf_reg;
	spi_Writeabyte();
	rf_buf=rf_data;
	spi_Readabyte();
    spi_csn=1;
		.delay 20	
}

//===============================================
//flush fifo
//===============================================
void flush_tx_fifo(void)
{
	spi_csn=0;
	rf_buf=HS6220_FLUSH_TX;
	spi_Writeabyte();
//	rf_buf=0;
//	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//flush fifo
//===============================================
void flush_rx_fifo(void)
{
	spi_csn=0;
	rf_buf=HS6220_FLUSH_RX;
	spi_Writeabyte();
//	rf_buf=0;
//	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//clear rf status flag
//===============================================
void clear_rf_status(void)
{
    spi_csn=0;
	rf_buf=0x27;  //HS6220_BANK0_STATUS
	spi_Writeabyte();
	rf_buf=0x70;
	spi_Writeabyte();
    spi_csn=1;

}
//===============================================
//get rf status flag
//===============================================
void get_rf_status_flag(void)
{
    spi_csn=0;
    rf_buf=0x07;
    spi_Writeabyte();
    spi_Readabyte();       //read rf status
    spi_csn=1;
}

//===============================================
//set_tx
//===============================================
void rf_tx_set(void)
{
    spi_csn=0;
	rf_buf=0x20;
	spi_Writeabyte();
	rf_buf=0xfa;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//set_rx
//===============================================
void rf_rx_set(void)
{
    spi_csn=0;
	rf_buf=0x20;
	spi_Writeabyte();
	rf_buf=0xfb;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//rf power up
//===============================================
void rf_power_up(void)
{
	rf_reg = HS6220_BANK0_CONFIG | HS6220_W_REGISTER;   rf_data =0Xfa;rf_read_onebyte();
	DelayCnt = 10;Delay100US();// 1msʱǱģȴRFоƬһϵж

	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	rf_buf&=0xfc;
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xa8;rf_read_onebyte();

}
//===============================================
//rf power down
//===============================================
void rf_power_down(void)
{
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	rf_buf&=0xfc;
	rf_buf|=0x01;
//	rf_buf=0xaa;
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =rf_buf;rf_read_onebyte();
	DelayCnt = 10;Delay100US();// 1msʱǱҪģҪȴRFһϵж

	rf_reg = HS6220_BANK0_CONFIG | HS6220_W_REGISTER;   rf_data =0Xf8;rf_read_onebyte();
}

//===============================================
//ce low
//===============================================
void rf_ce_low(void)
{

    spi_csn=0;
	rf_buf=HS6220_CMD_CE_LOW;
	spi_Writeabyte();
    spi_csn=1;

}
//===============================================
//ce high
//===============================================
void rf_ce_high(void)
{
    spi_csn=0;
	rf_buf=HS6220_CMD_CE_HIGH;
	spi_Writeabyte();
    spi_csn=1;
}
//==============================================
//write rf_buf
//==============================================
void write_rf_data_buf(void)
{
     byte temp01_buf;

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	     rf_buf=*point;  
         spi_Writeabyte();
	     point++;
	     temp01_buf++;
	 }
}
//==============================================
//write rf_buf
//==============================================
void read_rf_data_buf(void)
{
     byte temp01_buf;

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	   //  rf_buf=;  
         spi_Readabyte();
		 *point=rf_buf;
	     point++;
	     temp01_buf++;
	 }
}

//==============================================
//write tx0_address
//==============================================
void write_tx0_address(void)
{
	 spi_csn=0;
	 rf_buf=0x30;       //write TX0 address
     spi_Writeabyte();
	 rf_write_data_cnt=5;
	 write_rf_data_buf();
     spi_csn=1;
}
//==============================================
//write rx0_address
//==============================================
void write_rx0_address(void)
{
	 spi_csn=0;
	 rf_buf=0x2a;     //write  rx address
     spi_Writeabyte();
	 rf_write_data_cnt=5;
	 write_rf_data_buf();
     spi_csn=1;
}

/*******************************************************************************
* : HS6200_Bank_Select
* : 
* β:       
* : 
* ˵: 
*******************************************************************************/
void rf_bank_Switch(void)
{
	byte bank = rf_buf;//ѡblank

	get_rf_status_flag();
	
	if(bank == Rf_Bank1)//ѡbank1
	{
		if(!(rf_buf.7)){
			rf_reg=HS6220_ACTIVATE; rf_data=HS6220_ACTIVATE_DATA; rf_write_onebyte();
		}
	}
	else
	{
		if(rf_buf.7){
			rf_reg=HS6220_ACTIVATE; rf_data=HS6220_ACTIVATE_DATA; rf_write_onebyte();
		}
	}
}

void hs6200_get_chip_ID(void)
{
	 rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1
	while(1)
	{
	 spi_csn=0;
	 rf_buf=0x20;       //write TX0 address
     spi_Writeabyte();
	 rf_buf=0;
 	 spi_Readabyte();
	 rf_buf=0;
 	 spi_Readabyte();
     spi_csn=1;
	 if(rf_buf==1)
		 break;
	 .delay 100
	}

}

/*
	ȡ HS6220 CHIP ID Ͱλ 0x250x26
	ж6220Ϊ˫˻ǵˣ˫ʱ3msʱ20ms
*/
void hs6220_identify_delay(void)
{
	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1

	rf_reg = HS6220_BANK1_CHIP_ID;	
	rf_data = 0;
	rf_read_onebyte();	//CHIP ID
	if(0x25 == rf_buf){
		DelayCnt = 30;Delay100US();// ˫˰汾wait 3 ms
	}
	else{
		DelayCnt = 200;Delay100US();// ˰汾wait 20 ms
	}

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0
}
//===============================================
//ʼRF
//===============================================
void init_rf(void)
{   
	byte temp00,tmp_data;

reset_rf_int:
	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=SOFT_RST;rf_write_onebyte();// soft_reset

	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();//ͨ
//	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x08;rf_write_onebyte();//ͨ

	rf_ce_low();
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8b;rf_write_onebyte();// power up
	hs6220_identify_delay();//˫ʱ3msʱ20ms
	rf_reg=HS6220_BANK0_PMU_CTL+HS6220_W_REGISTER; rf_data=0xac;rf_write_onebyte();// HS6220_PWRDWN = 00
	DelayCnt = 20;Delay100US();// wait 2 ms
	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x10;rf_write_onebyte();// VCO_AMP_TX_MUX = b'0, A2 don't need config this bit

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1

	rf_reg=HS6220_BANK1_TEST_PKDET+HS6220_W_REGISTER; rf_data=0x20;rf_write_onebyte();// pll_vdiv2_sel = 01, A2 don't need config this bit

	spi_csn=0;
	rf_buf=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x01;//
	rf_write_data_cnt=1;
	write_rf_data_buf();
    spi_csn=1;
//************ʱ HS6220_BANK1_FAGC_CTRL_1**********ҪCEлBank1ȥ*****	
//*********** 6220Ϊ߿,  VCO, , Ҳǿ й¶, ֲ֤ù. 
//**********һеĽ취:  С תʱVCO, תʱָԭֵ
 /*
	spi_csn=0;
	rf_buf=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x0c;//
	rf_write_data_cnt=1;
	write_rf_data_buf();
    spi_csn=1;
*/	
//************ʱ HS6220_BANK1_FAGC_CTRL_1***************	

    spi_csn=0;
	rf_buf=HS6220_BANK1_AGC_CTRL+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[1]=0xb2;
	rf_data_buf[0]=0xcf;
	rf_write_data_cnt=2;
	write_rf_data_buf();
    spi_csn=1;

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0
	rf_ce_high();
	DelayCnt = 2;Delay100US();// wait 100us
	rf_ce_low();// һҪע⣬У׼ʱCEǵ͵

	while(1)
	{

		rf_reg=HS6220_BANK0_RF_SETUP+HS6220_R_REGISTER; rf_data=0x00;rf_read_onebyte();
		if(rf_buf.5)  break;

		DelayCnt = 10;Delay100US();						//ʱ1MS
		temp00--;
		if(0 == temp00)
		{	//³ʼ
			goto reset_rf_int;
		}
	}
	rf_reg=HS6220_BANK0_RF_SETUP+HS6220_W_REGISTER; rf_data=0x40;rf_write_onebyte();

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1
    spi_csn=0;
	rf_buf=HS6220_BANK1_CAL_CTL+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x75;
	rf_data_buf[1]=0x98;
	rf_data_buf[0]=0x20;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;
	/* increase fitler agc threshold start (A2 don't need config this bit)*/
/*    spi_csn=0;
	rf_buf=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x05;
	rf_data_buf[1]=0xa0;
	rf_data_buf[0]=0x03;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK1_AGC_CTRL+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[1]=0xb2;
	rf_data_buf[0]=0xcf;
	rf_write_data_cnt=2;
	write_rf_data_buf();
    spi_csn=1;
*/	
	/* increase fitler agc threshold end (A2 don't need config this bit)*/
/*
    spi_csn=0;
	rf_buf=HS6220_BANK1_RF_IVGEN+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x11;
	rf_data_buf[1]=0x04;
	rf_data_buf[0]=0x1f;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;
*/

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0

    spi_csn=0;
	rf_buf=HS6220_BANK0_RX_ADDR_P0+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x46;
	rf_data_buf[1]=0x0b;
	rf_data_buf[2]=0xaf;
	rf_data_buf[3]=0x43;
	rf_data_buf[4]=0x98;
	rf_write_data_cnt=5;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK0_TX_ADDR+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x46;
	rf_data_buf[1]=0x0b;
	rf_data_buf[2]=0xaf;
	rf_data_buf[3]=0x43;
	rf_data_buf[4]=0x98;
	rf_write_data_cnt=5;
	write_rf_data_buf();
    spi_csn=1;

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x10;rf_write_onebyte();
	rf_reg=HS6220_BANK0_EN_AA+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0xfb;rf_write_onebyte();
	rf_reg=HS6220_BANK0_RX_PW_P0+HS6220_W_REGISTER; rf_data=rx_lenth;rf_write_onebyte();
	rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=60;rf_write_onebyte();
	rf_reg=HS6220_BANK0_EN_RXADDR+HS6220_W_REGISTER; rf_data=0x03;rf_write_onebyte();//scramble_en = 0
//	rf_reg=HS6220_BANK0_RF_SETUP+HS6220_W_REGISTER; rf_data=0x47;rf_write_onebyte();



	clear_rf_status();
	flush_rx_fifo();
	rf_rx_set();
	rf_ce_high();

}

//===============================================
//tx_rf_data
//===============================================
void rf_tx_data(void)
{
	byte repeat_send_cnt=10;

	rf_ce_low();
	flush_tx_fifo();
	clear_rf_status();
	 spi_csn=0;
	 rf_buf=HS6220_W_TX_PAYLOAD_NOACK;
     spi_Writeabyte();
     rf_write_data_cnt=16;
	 write_rf_data_buf();
	 spi_csn=1;
	.delay 200
	.delay 200
	 spi_csn=0;
	 rf_buf=HS6220_REUSE_TX_PL;
     spi_Writeabyte();
	 spi_csn=1;
	 rf_ce_high();
	.delay 200
	rf_ce_low();
	while(repeat_send_cnt)
	{
		rf_ce_high();
		.delay 200
		rf_ce_low();
		.delay 200	
		repeat_send_cnt--;
	}

	clear_rf_status();
	flush_tx_fifo();
//	rf_ce_high();

}
//===============================================
//data_verification
//===============================================
void data_verification(void)   //У
{
	if((rf_data_buf[1]==rf_data_buf[2])&&(rf_data_buf[3]==0xaa)&&(rf_data_buf[4]==0xaa)&&(rf_data_buf[5]==0xa5))
 //  if((rf_data_buf[4]==0xa5))
   {
	   data_code=rf_data_buf[1];
	   no_rf_delay=50;

   }
}
//===============================================
//rf_RecivePack
//===============================================
extern word rf_reset_cnt;

void rf_RecivePack(void)
{
//	rf_ce_low();
//	rf_reg=HS6220_BANK0_RF_CH+HS6220_R_REGISTER; rf_data=0x00;rf_read_onebyte();
	get_rf_status_flag();
	if(rf_buf.6) //rx_dr
	{
		rf_reset_cnt=rf_reset_time;
		rf_sleep_cnt=10;
	 rf_reg = HS6220_R_RX_PL_WID | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	 if(rf_buf==rx_lenth)  //16
	 {
		 rf_write_data_cnt=rf_buf;
		 spi_csn=0;
		 rf_buf=HS6220_R_RX_PAYLOAD;
		 spi_Writeabyte();
		 rf_write_data_cnt=rx_lenth;
		 read_rf_data_buf();
		 spi_csn=1;
		 data_verification();
	 }
	// յݲȡFIFO֮
	rf_ce_low();
	flush_rx_fifo();
	clear_rf_status();
	rf_ce_high(); // CEߵȴ´ݵ

	}

	if(!rf_reset_cnt) // 300msûյ1ݣλRF³ʼ
	{

		init_rf();
		rf_reset_cnt=rf_reset_time;

	}
	if(!rf_sleep_cnt)// 20msûյ1ݣRF˯߻һ
	{
		
		rf_ce_low();
		flush_rx_fifo();
		clear_rf_status();
		rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xae;rf_write_onebyte();
		DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС 
		rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xac;rf_write_onebyte();
		DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС
		rf_ce_high(); 
		rf_sleep_cnt=10;
	}



}

		/* ע⣺λΪزʹλزģʽ֮CEҪߣزŻ
		   ҪлƵ㣬ʵȣͲҪȥڲRFῴزźŵ*/
extern byte int_2ms;
extern byte test_mode_fg;
extern byte key_code;

void test_mode(void)
{
	byte key_temp=1;
	byte key_cnt=0;
	byte rc_ch;
		rf_ce_low();
		rf_tx_set();

		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0xc7;
	     spi_Writeabyte();  
		 spi_csn=1;
		rf_ce_high();	
		test_mode_fg=1;
/*
	rf_ce_low();
	if(test_mode_fg==1)//زģʽ
	{
		rf_tx_set();

		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0xc7;
	     spi_Writeabyte();  
		 spi_csn=1;
	}
	else
	if(test_mode_fg==2)//ģʽ
	{
		rf_tx_set();

		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0x47;
	     spi_Writeabyte();  
		 spi_csn=1;
	}
	else//ģʽ
	{
		 rf_rx_set();
	}
	rf_ce_high();
*/
//	io_led=1;
	while(1)
	{
		io_led_f=1;
		if((!PB.2)&&(key_temp))
		{
			key_temp=0;
///			if(key_code)
			{
			key_cnt++;
			if(key_cnt>9) key_cnt=1;
			}

			if(key_cnt==1)
			{
				init_rf();
				rf_ce_low();
				rf_tx_set();

				 spi_csn=0;
				 rf_buf=0x26;
			     spi_Writeabyte();
				 rf_buf=0xc7;
			     spi_Writeabyte();  
				 spi_csn=1;
				rf_ce_high();	
				test_mode_fg=1;

				rc_ch=0x05;
			}
			else
			if(key_cnt==2)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==3)
			{
				rc_ch=75;
			}
			else
			if(key_cnt==4)
			{
				init_rf();
				rf_ce_low();
				rf_tx_set();

				 spi_csn=0;
				 rf_buf=0x26;
			     spi_Writeabyte();
				 rf_buf=0x47;
			     spi_Writeabyte();  
				 spi_csn=1;
				rf_ce_high();	
				test_mode_fg=2;

				rc_ch=0x05;
			}
			else
			if(key_cnt==5)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==6)
			{
				rc_ch=75;
			}
			else
			if(key_cnt==7)
			{
				init_rf();
				rf_ce_low();
				rf_rx_set();
				rf_ce_high();	
				test_mode_fg=3;

				rc_ch=0x05;
			}
			else
			if(key_cnt==8)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==9)
			{
				rc_ch=75;
			}


			 rf_ce_low();
			 spi_csn=0;
			 rf_buf=0x25;
		     spi_Writeabyte();
			 rf_buf=rc_ch;
		     spi_Writeabyte();  
			 spi_csn=1;
			 rf_ce_high();
		}
		else
		{
			if(pb.2)
				key_temp=1;

		}

		if(!int_2ms )
		{
			int_2ms=2;

		//	key_deal();
			if(test_mode_fg==2)
			{
		 	 
			 rf_tx_data();

			}
		}
	}
}

void hs6200_carrier_mode(void)
{
	rf_ce_low();
/*	flush_tx_fifo();
	clear_rf_status();
	 spi_csn=0;
	 rf_buf=0x20;
     spi_Writeabyte();
	 rf_buf=0x0e;
     spi_Writeabyte();  
	 spi_csn=1;*/
//	 rf_ce_high();

	 spi_csn=0;
	 rf_buf=0x26;
     spi_Writeabyte();
	 rf_buf=0xc7;
     spi_Writeabyte();  
	 spi_csn=1;
	 spi_csn=0;
	 rf_buf=0x25;
     spi_Writeabyte();
	 rf_buf=0x02;
     spi_Writeabyte();  
	 spi_csn=1;
	 rf_ce_high();
	 while(1){

		 .delay 200
	 };


} 