#include <stdint.h>
#include "omw_iic.h"
#include "omw_clkcal.h"

#define IIC_PIN_NUM          2
#define CURR_TIMER_VAL      (*((volatile uint32_t*)0x42000104))
#define IIC_RX_EMPTY        (*((volatile uint32_t*)0x42000104))
//
#ifdef OMW_IIC


const struct gpio_cfg_tag iic_pin_cfg[] = {
    {OMW_IIC_PIN_SCL,  OMW_IIC_FUN_CFG_SCL},
    {OMW_IIC_PIN_SDA,  OMW_IIC_FUN_CFG_SDA}
};

void iic_init (iic_initypedef* IIC_Initstruct) 
{
	const struct gpio_cfg_tag  * pin_cfg = iic_pin_cfg;
	omw_gpio_set_func_ex(pin_cfg, IIC_PIN_NUM);
	uint8_t tmpreg;
	
	if(IIC_Initstruct->iic_mode == OMW_IIC_MODE_MASTER)
	{	
	    tmpreg = IIC_Initstruct->iic_mode |  IIC_Initstruct->iic_speed_mode |  IIC_Initstruct->iic_target_addr_mode | IIC_Initstruct->iic_slave_addr_mode | OMW_IIC_RESTART_EN;
	    IIC->IC_CON = tmpreg;
	    if(IIC_Initstruct->iic_speed_mode == OMW_IIC_SPEED_MODE_SS)
		{
	        IIC->IC_SS_SCL_HCNT = IIC_Initstruct->iic_clk_frequency;  // 50k:0x1d8  100kHz:0xe8  200k:70  400k:33
	        IIC->IC_SS_SCL_LCNT = IIC_Initstruct->iic_clk_frequency;  // 50k:0x1d8  100kHz:0xe8  200k:70  400k:33
        }
	    else
	    {
		    IIC->IC_FS_SCL_HCNT = IIC_Initstruct->iic_clk_frequency;  
	        IIC->IC_FS_SCL_LCNT = IIC_Initstruct->iic_clk_frequency;
   	    }
	    IIC->IC_TAR = (IIC_Initstruct->iic_target_addr & 0x07ff);
	    IIC->IC_TX_TL = IIC_Initstruct->iic_tx_threshold;
  	    IIC->IC_RX_TL = IIC_Initstruct->iic_rx_threshold;
	}
	else
	{
        tmpreg = IIC_Initstruct->iic_mode |  IIC_Initstruct->iic_speed_mode |  IIC_Initstruct->iic_slave_addr_mode ;
	    IIC->IC_CON = tmpreg;
	    IIC->IC_SAR = IIC_Initstruct->iic_slave_addr;
	    IIC->IC_TX_TL = IIC_Initstruct->iic_tx_threshold;
  	    IIC->IC_RX_TL = IIC_Initstruct->iic_rx_threshold;
	}
}




void iic_structinit(iic_initypedef* IIC_Initstruct)
{
	IIC_Initstruct -> iic_mode = OMW_IIC_MODE_MASTER;
	IIC_Initstruct -> iic_speed_mode = OMW_IIC_SPEED_MODE_SS;
	IIC_Initstruct->iic_target_addr_mode = OMW_IIC_TARGET_ADDR_MODE_7BIT;
	IIC_Initstruct->iic_slave_addr_mode = OMW_IIC_SLAVE_ADDR_MODE_7BIT;
	IIC_Initstruct->iic_clk_frequency = OMW_IIC_CLK_FREQUENCY_100K;
	IIC_Initstruct -> iic_tx_threshold = 0x07;
	IIC_Initstruct -> iic_rx_threshold = 0x07;
}





void iic_send_byte(uint8_t data)
{
	while(IIC->IC_TXFLR > 5); //txfifo为空将会发送stop信号
 	IIC->IC_DATA_CMD = data ;
}

uint8_t iic_receive_byte(void)
{
	IIC->IC_DATA_CMD_b.CMD = 1;
	while ((*(volatile int*)(0x41005070) & 0x08 )== 0){}
    return IIC->IC_DATA_CMD;
}
	
uint32_t iic_recv(uint8_t * buf, uint32_t len)
{ 
    uint32_t tc = 0, rc = 0;
    // write cmd and read data
    while(tc < len){
        // check tx fifo and send cmd
        if(IIC->IC_TXFLR <= 6){
            IIC->IC_DATA_CMD = OMW_IIC_CMD_READ;
            tc ++;
        }
        // read data
        if(IIC->IC_RXFLR >= 4){
            buf[rc] = IIC->IC_DATA_CMD;
            rc++;
        }
    }
    // read remaining data
    while(rc < len){
        if(IIC->IC_RXFLR > 0){
            buf[rc] = IIC->IC_DATA_CMD;
            rc++;
        }
    }
    return rc;
}	



void iic_cmd(FunctionalState NewState)
{
  if (NewState != DISABLE)
  {
    IIC->IC_ENABLE |=  ENABLE;
  }
  else
  {
   IIC->IC_ENABLE &= ~ENABLE;
  }
}

void iic_intr_cmd(uint16_t iic_intr,FunctionalState NewState)
{
  if (NewState != DISABLE)
  {
    IIC->IC_INTR_MASK |= iic_intr;
  }
  else
  {
    IIC->IC_INTR_MASK &= ~iic_intr;
  }
}


ITStatus iic_get_itstatus(uint16_t  iic_intr)
{
  ITStatus bitstatus = RESET;
  uint8_t itpos = 0;

  itpos = (IIC ->IC_INTR_STAT & iic_intr);

  if (itpos != (uint8_t)RESET)
  {

    bitstatus = SET;
  }
  else
  {

    bitstatus = RESET;
  }
  /* Return the IIC_IT status */
  return bitstatus;
}


void iic_it_clearflag(void)
{
	IIC->IC_CLR_INTR;
}

//void iic_master_send_data(uint8_t *buf,uint16_t len)
//{
//	int i = 0;
//	while(i<len)
//	{
//		if((IIC->IC_TXFLR < 5) && (IIC->IC_RXFLR < 5))
//		{
////			omw_printf("tx_fifo:%d , rxfifo:%d/n",IIC->IC_TXFLR,IIC->IC_RXFLR);
//
//			iic_send_byte(buf[i]);
//			i++;
//		}
//	}
//}
//
//void iic_master_receive_data(uint8_t *buf,uint16_t len)
//{
//	int i = 0;
//	while(i<len)
//	{   
//		if((IIC->IC_TXFLR < 5) && (IIC->IC_RXFLR < 5))
//	    { 	
//			IIC->IC_DATA_CMD_b.CMD = 1;
//			while ((IIC->IC_RAW_INTR_STAT & 0x100) == 0);
//			buf[i] = iic_receive_byte();
//			i++;
//			
////		}
////	    while(IIC->IC_RXFLR)
////	    {
////		buf[j] = iic_receive_byte();
////		j++;
////	    }
////		if(i == len)
////		{
////            *(volatile int*)(0x41005010) |=   0x200;
////		}
//		
//	}
//
////	omw_printf("接收数据：%d",j);
//}
//}
//
//
//void iic_slave_send_data(uint8_t *buf,uint16_t len)
//{
//	int i = 0;
//	while ((IIC->IC_RAW_INTR_STAT & 0x20) == 0);
//	
//	while(i<len)
//	{
//		if(IIC->IC_TXFLR < 5)
//		{
//			iic_send_byte(buf[i]);
//			i++;
//		}
//	}
//	IIC->IC_CLR_RD_REQ;	
//}
//
//void iic_slave_receive_data(uint8_t *buf,uint16_t len)
//{
//	int i = 0;
//	
//	while(i<len)
//	{
//		if(IIC->IC_TXFLR < 5)
//		{
//			buf[i] = iic_receive_byte() ;
//			i++;
//		}
//	}
//	IIC->IC_CLR_RD_REQ;	
//}
#endif


