#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "periph_gpio.h"
#include "periph_gpadc.h"

// 使用EV KIT LED和按键，具体连接为：
int main()
{
    int t, led_mode, key_bak, key_cur; // 0~3, control led blink frequency
    GPIO_InitTypeDef GPIO_InitStruct;

    // init
    key_bak = 1;
    key_cur = 1;
    led_mode = 0;
    omw_dbg_init();
    printf("GPIO test ...\n");
    printf("     NOTE: plese press key more than 3 seconds\n");
    
    // GPIO2/3 output, connect LED
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_2 | GPIO_PIN_3;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUT_PP;
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
    GPIO_Init(&GPIO_InitStruct);
    GPIO_SetBits(GPIO_PIN_2);
    GPIO_ResetBits(GPIO_PIN_3);
    // GPIO19 input pull up, connect KEY to ground
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_19;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPU;
    GPIO_Init(&GPIO_InitStruct);

    // loop
    while(1){
        // key detect, filter 10ms
        key_cur = GPIO_ReadInputDataBit(GPIO_PIN_19);
        if (key_bak == 1 && key_cur == 0) // down detect
        {
            DELAY_MS(10);
            key_cur = GPIO_ReadInputDataBit(GPIO_PIN_19);
            if (key_cur == 0) // update key status
            {
                key_bak = 0;
                key_cur = 0;
                printf("  -> key press detected   !      *** led mode: %d\n", led_mode);
            }
        }
        else if (key_bak == 0 && key_cur == 1) // up detect
        {
            DELAY_MS(10);
            key_cur = GPIO_ReadInputDataBit(GPIO_PIN_19);
            if (key_cur == 1) // update key status
            {
                key_bak = 1;
                key_cur = 1;
                if (led_mode >= 3)
                {
                    led_mode = 0;
                }
                else
                {
                    led_mode += 1;
                }
                printf("  <- key release detected !      *** led mode: %d\n", led_mode);
            }
        }
        // led delay mode
        DELAY_MS(300 + led_mode*300);
        // led: GPIO[2]
        t = GPIO_ReadOutputDataBit(GPIO_PIN_2);
        if (t != RESET)
        {
            GPIO_ResetBits(GPIO_PIN_2);
        }
        else
        {
            GPIO_SetBits(GPIO_PIN_2);
        }
        // led: GPIO[3]
        t = GPIO_ReadOutputDataBit(GPIO_PIN_3);
        if (t != RESET)
        {
            GPIO_ResetBits(GPIO_PIN_3);
        }
        else
        {
            GPIO_SetBits(GPIO_PIN_3);
        }
    }
    
    while(1);
    return 0;
}

