#include "omw_uart.h"
#include "t1001_it.h"
#include "omw_gpio.h"

#define GPADC_Handler   Interrupt7_Handler
#if defined(OMW_HAS_SCH) && (defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0))
#include "omw_rtos.h"
#endif

extern void calc_hp_offset_at_curr_temp();
extern void RF_BT_IRQHandler(void);
#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
extern void BT_TIMER_IRQHandler(void);
#endif
extern void VTIMER_IRQHandler(void);
#ifdef OMW_EN_DEEP_SLEEP
extern void Check_PwrOn_OnBbDmaIrq();
extern void  Check_PwrOn_OnBbDmaIrq_Before();

#ifndef OMW_OTP_ROM_USE_OTP_INIT
extern void otp_powup();
extern void otp_powdown();
#endif
#endif

#if defined(OMW_DEBUG_TIFS) || defined(OMW_DEBUG_RX_TIMING)
#include "t1001_bt.h"

extern volatile uint8_t  tifs_test_flag;
volatile uint32_t rxon_tick;
volatile uint32_t  rx_gap_ticks;
volatile uint16_t  min_rx_gap_ticks = 0xFFFF;
volatile uint16_t  max_rx_gap_ticks;
volatile uint32_t  avg_gap_ticks;

extern RfBtGlobalParameters_t rf_bt_mgr;
#endif

#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
ATTRIBUTE_ISR __RAM_CODE_SECTION void RADIO_TICK_Handler(void)
{
    #ifndef OMW_OTP_ROM_USE_OTP_INIT
    #ifdef OMW_EN_DEEP_SLEEP
    otp_powup();
    #endif
    #endif

    BT_TIMER_IRQHandler(); //rom api

    // uint16_t  bb_ctrl_val = 0xf700;
    // if (rf_bt_mgr.rx_ptr != NULL)
    // {
    //    bb_ctrl_val = 0xf708;
    // }
    // REG_WRT(0x42000008, bb_ctrl_val);

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq();
    #endif

    #if defined(OMW_HAS_SCH)
    omw_rtos_low_pri_free_cpu(OMW_CTRL_ARG_FLAG);
    #endif

    #ifndef OMW_OTP_ROM_USE_OTP_INIT
    #ifdef OMW_EN_DEEP_SLEEP
    otp_powdown();
    #endif
    #endif

    #ifdef OMW_BLE_V0
    calc_hp_offset_at_curr_temp();
    #endif
}
#endif


#if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER) || defined(OMW_CLTR_SLEEP_TEST)
ATTRIBUTE_ISR void RTC_Handler(void)
{
    omw_hw_set_in_irq_flag();

    VTIMER_IRQHandler();

    omw_hw_clr_in_irq_flag();
}
#endif

#if 0
ATTRIBUTE_ISR void GPADC_Handler(void)
{

}

ATTRIBUTE_ISR void WDT_Handler(void)
{

}

ATTRIBUTE_ISR void GPIO_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER0_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER1_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER2_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER3_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER4_Handler(void)
{
  omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
  omw_gpio_set_output(OMW_GPIO_PIN19, HIGH);
}

ATTRIBUTE_ISR void TIMER5_Handler(void)
{
  omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
  omw_gpio_set_output(OMW_GPIO_PIN19, HIGH);
}

ATTRIBUTE_ISR void TIMER6_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER7_Handler(void)
{

}
#endif
