#include <errno.h>
#include <stddef.h>
#include <string.h>

#include "omw_config.h"
#include "utils/byteorder.h"

#include <common/bt_buf.h>

#include "hci_driver.h"

#ifdef OMW_COMID_PATCH
static bt_hci_controller_send_cb_t bt_controller_send_cb_org;

void hci_driver_rcv_pactch(simple_buf_t *buf)
{
    if (BT_BUF_EVT == bt_buf_get_type(buf))
    {
        uint8_t * pbuf = buf->data + sizeof(struct bt_hci_evt_hdr);
        uint16_t op_code = sys_get_le16(pbuf + 1);
        if (BT_OGF(op_code) == BT_OGF_INFO && BT_OCF(op_code) == BT_OCF(BT_HCI_OP_READ_LOCAL_VERSION_INFO))
        {
            struct bt_hci_rp_read_local_version_info * rsp = (struct bt_hci_rp_read_local_version_info *)(pbuf + sizeof(struct bt_hci_evt_cmd_complete));
            rsp->manufacturer   = OMW_BT_CTRL_COMPANY_ID;
            rsp->lmp_subversion = OMW_BT_CTRL_SUBVERSION_NUMBER;
        }
    }

    if (bt_controller_send_cb_org != NULL)
        bt_controller_send_cb_org(buf);
}

int hci_driver_open_patch(void* cb)
{
    hci_driver_open(hci_driver_rcv_pactch);

    bt_controller_send_cb_org = cb;
    return 0;
}
#endif


#ifdef OMW_EN_DEEP_SLEEP
#include "hci_core.h"

extern struct bt_dev_set bt_dev;
__RAM_CODE_SECTION
uint8_t hci_core_sleep_check()
{
     return (NULL == sys_slist_peek_head(&bt_dev.rx_evt_queue)) && (NULL == sys_slist_peek_head(&bt_dev.rx_queue));
}

#endif