#include "port.h"

extern int btstack_main(int argc, const char *argv[]);
extern uint8_t ll_gap_time_array[];

void omw_app_init()
{
    ll_gap_time_array[5] += 1; // 调整timing时序
#ifdef OMW_HCI_RAM
    // must register callback here, can not in omw_host_init
    omw_ctrlr_hci_ram_reg_host_rx_cb(custom_process_data_from_ctrlr);
#endif
}

/* -------------------------------------------------------------------------- */
/*                               timer4 1ms init                              */
/* -------------------------------------------------------------------------- */
#ifdef OMW_INTR
#define NVIC_EnableIRQ(IRQn) csi_vic_enable_irq(IRQn)
#define NVIC_SetPriority(IRQn, priority) csi_vic_set_prio(IRQn, priority)
#endif

void t1001_time_init(void)
{
#ifdef OMW_TIMER
    // timer0 1ms
    NVIC_SetPriority(TIMER0_IRQn, IRQ_CRITICAL_PRIORITY);
    NVIC_EnableIRQ(TIMER0_IRQn);

    TIMER_InitTypeDef timer_struct_0;
    omw_timer_struct_init(&timer_struct_0);
    timer_struct_0.timer_mode = OMW_TIMER_MODE_USER_DEFINED;
    timer_struct_0.timer_clk_divide = OMW_TIMER_CLK_DIVIDE_2;
    timer_struct_0.timer_clk = OMW_TIMER_CLK_SEL_XTAL24M;
    timer_struct_0.timer_loadcount = 12000;
    timer_struct_0.timer_pwm_en = OMW_TIMER_PWM_DISABLE;
    omw_timer_en(TIMER0, DISABLE);
    omw_timer_init(TIMER0, &timer_struct_0);
    omw_timer_it_en(TIMER0, ENABLE);
    omw_timer_en(TIMER0, ENABLE);
#endif
}




/* -------------------------------------------------------------------------- */
/*                               platform_init                                */
/* -------------------------------------------------------------------------- */
void platform_init(void)
{
    platform_init_complete(false);
    t1001_time_init();
    platform_memory_init();
    platform_run_loop_init();
#ifdef ENABLE_PRINTF_HEXDUMP
    hci_dump_init(hci_dump_embedded_stdout_get_instance());
#endif
    platform_transport_get_instance_init();
    platform_flash_bank_init();
    platform_packet_handler();


    // 设置蓝牙地址
    set_ble_addr(OMW_BT_ADDR);

    /**
     * @brief app mian
     *
     */
    btstack_main(0, NULL);

    platform_init_complete(true);
}