#include "BL2102_pwmbase.h"

/****************************************************************************************************************************************** 
* :	PWMBASE_Common_Init()
* ˵:	PWMBASEʼ
*     : PWMBASE_TypeDef * PWMBASEx                              ָҪõPWMBASEЧֵPWMBASE0
*			PWMBASE_CommonInitTypeDef * PWMBASE_CommonInitStruct	PWMBASE趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_Common_Init(PWMBASE_TypeDef * PWMBASEx, PWMBASE_CommonInitTypeDef * PWMBASE_CommonInitStruct)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));                                //ĲPWMBASExǷϷ    
	
//	assert_param(IS_PWMBASE_CLKDIV(PWMBASE_CommonInitStruct->ClkDiv));     //ĲClkDivǷϷ     
//	
//	assert_param(IS_PWMBASE_PERIOD(PWMBASE_CommonInitStruct->Period));     //ĲPeriodǷϷ     
//	
//	assert_param(IS_PWMBASE_IE_OVF(PWMBASE_CommonInitStruct->OvfIE));      //ĲOvfIEǷϷ     
	
	switch((uint32_t)PWMBASEx)
	{
		case((uint32_t)PWMBASE0):
		
			SYS->CLKEN |= 0x01 << SYS_CLKEN_PWMBASE0_POS;           //PWMBASE0ʱ
		
		break;
	}
	
	PWMBASE_Stop(PWMBASEx);                                         //رPWMBASEֹͣPWM  

	PWMBASEx->DIV = PWMBASE_CommonInitStruct->ClkDiv;               //PWMBASEƵϵ   ʵʷƵΪֵ1
	
	if(PWMBASE_CommonInitStruct->Period == 0 || PWMBASE_CommonInitStruct->Period > 0xFFFF)
	{
		PWMBASE_CommonInitStruct->Period = 0xFFFF;
	}
	
	PWMBASEx->PERIOD = PWMBASE_CommonInitStruct->Period;                  //PWMBASE
	
	if(PWMBASE_CommonInitStruct->OvfIE == ENABLE)                         //PWMBASEжʹ
	{
		PWMBASEx->IE |= 0x01 << PWMBASE_IE_OVF_POS;
	}
	else
	{
		PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_OVF_POS);
	}
	
	switch((uint32_t)PWMBASEx)
	{
		case((uint32_t)PWMBASE0):
		
			if(PWMBASE_CommonInitStruct->OvfIE)
			{
				NVIC_EnableIRQ(PWMBASE0_IRQn);
			}
		
		break;
	}
	
	PWMBASEx->IF = 0x0F;       //жϱ־
}

/****************************************************************************************************************************************** 
* :	PWMBASE_Channel_Init()
* ˵:	PWMBASEͨʼ
*     : PWMBASE_TypeDef * PWMBASEx                  ָҪõPWMBASEЧֵPWMBASE0
*			PWMBASE_ChannelInitTypeDef * PWMBASE_ChannelInitStruct	PWMBASE趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_Channel_Init(PWMBASE_TypeDef * PWMBASEx, PWMBASE_ChannelInitTypeDef * PWMBASE_ChannelInitStruct)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));                                //ĲPWMBASExǷϷ    
//	
//	assert_param(IS_PWMBASE_COMP(PWMBASE_CommonInitStruct->Comp));          //ĲCompǷϷ    
//	
//	assert_param(IS_PWMBASE_INV(PWMBASE_CommonInitStruct->Inv));            //ĲInvǷϷ  
//	
//	assert_param(IS_PWMBASE_OUTEN(PWMBASE_CommonInitStruct->OutEn));        //ĲOutEnǷϷ  
//	
//	assert_param(IS_PWMBASE_IE_COMP(PWMBASE_CommonInitStruct->CompIE));     //ĲCompIEǷϷ  
	
	
	PWMBASE_Stop(PWMBASEx);                                                 //رPWMBASEֹͣPWM  

	if(PWMBASE_ChannelInitStruct->Comp > PWMBASE_GetPeriod(PWMBASEx))
	{
		PWMBASE_ChannelInitStruct->Comp = 0;
	}
	
	if((PWMBASE_ChannelInitStruct->Channel & PWMBASE_CH0) == PWMBASE_CH0)
	{
		PWMBASEx->CH0_COMP = PWMBASE_ChannelInitStruct->Comp;            //PWMBASEͨ0ת
		
		if(PWMBASE_ChannelInitStruct->Inv == ENABLE)                     //PWMBASEͨ0źת
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH0_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH0_INV_POS);
		}

		if(PWMBASE_ChannelInitStruct->OutEn == ENABLE)                   //PWMBASEͨ0źʹ
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH0_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH0_EN_POS);
		}
		
		if(PWMBASE_ChannelInitStruct->CompIE == ENABLE)                  //PWMBASEͨ0﷭תжʹ
		{
			PWMBASEx->IE |= 0x01 << PWMBASE_IE_CH0_COMP_POS;
		}
		else
		{
			PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH0_COMP_POS);
		}
	}
	
	if((PWMBASE_ChannelInitStruct->Channel & PWMBASE_CH1) == PWMBASE_CH1)
	{
		PWMBASEx->CH1_COMP = PWMBASE_ChannelInitStruct->Comp;            //PWMBASEͨ1ת
	
		if(PWMBASE_ChannelInitStruct->Inv == ENABLE)                     //PWMBASEͨ1źת
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH1_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH1_INV_POS);
		}
		
		if(PWMBASE_ChannelInitStruct->OutEn == ENABLE)                   //PWMBASEͨ1źʹ
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH1_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH1_EN_POS);
		}
		
		PWMBASEx->CH1_COMP = PWMBASE_ChannelInitStruct->Comp;            //PWMBASEͨ1ת
		
		if(PWMBASE_ChannelInitStruct->CompIE == ENABLE)                  //PWMBASEͨ1﷭תжʹ
		{
			PWMBASEx->IE |= 0x01 << PWMBASE_IE_CH1_COMP_POS;
		}
		else
		{
			PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH1_COMP_POS);
		}	
	}
	
	if((PWMBASE_ChannelInitStruct->Channel & PWMBASE_CH2) == PWMBASE_CH2)
	{
		PWMBASEx->CH2_COMP = PWMBASE_ChannelInitStruct->Comp;            //PWMBASEͨ2ת
	
		if(PWMBASE_ChannelInitStruct->Inv == ENABLE)                     //PWMBASEͨ2źת
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH2_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH2_INV_POS);
		}
		
		if(PWMBASE_ChannelInitStruct->OutEn == ENABLE)                   //PWMBASEͨ2źʹ
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH2_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH2_EN_POS);
		}
		
		if(PWMBASE_ChannelInitStruct->CompIE == ENABLE)                  //PWMBASEͨ2﷭תжʹ
		{
			PWMBASEx->IE |= 0x01 << PWMBASE_IE_CH2_COMP_POS;
		}
		else
		{
			PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH2_COMP_POS);
		}
	}
	
	switch((uint32_t)PWMBASEx)
	{
		case((uint32_t)PWMBASE0):
		
			if(PWMBASE_ChannelInitStruct->CompIE)
			{
				NVIC_EnableIRQ(PWMBASE0_IRQn);
			}
		
		break;
	}
	
	PWMBASEx->IF = 0x0F;       //жϱ־
}

/****************************************************************************************************************************************** 
* :	PWMBASE_Start()
* ˵:	PWMBASEʼPWM
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_Start(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));                                //ĲPWMBASExǷϷ    
	
	PWMBASEx->EN |= 0x01 << PWMBASE_EN_POS; 
}


/****************************************************************************************************************************************** 
* :	PWMBASE_Stop()
* ˵:	رPWMBASEֹͣPWM
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_Stop(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));                                //ĲPWMBASExǷϷ    
	
	PWMBASEx->EN &= ~(0x01 << PWMBASE_EN_POS);  
}


/****************************************************************************************************************************************** 
* :	PWMBASE_SetClkDiv()
* ˵:	ԤƵϵ   ʵʷƵΪֵ1
*     : uint8_t Clk_Div   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_SetClkDiv(PWMBASE_TypeDef * PWMBASEx,uint8_t Clk_Div)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ    
//	
//	assert_param(IS_PWMBASE_CLKDIV(Clk_Div));     //ĲClkDivǷϷ   
	
	PWMBASEx->DIV = Clk_Div;                      //PWMBASEƵϵ  ʵʷƵΪֵ1
}


/****************************************************************************************************************************************** 
* :	PWMBASE_SetOutInv()
* ˵:	PWMBASEźŷת
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMBASE_CH0 | PWMBASE_CH1 | PWMBASE_CH2
*           FunctionalState  OutEn         ЧֵENABLE  DISABLE
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_SetOutInv(PWMBASE_TypeDef * PWMBASEx,uint8_t CHx,FunctionalState  OutInv)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ    
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
//	
//	assert_param(IS_PWMBASE_INV(OutInv));         //ĲOutInvǷϷ 
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		if(OutInv == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH0_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH0_INV_POS);
		}	
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		if(OutInv == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH1_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH1_INV_POS);
		}
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		if(OutInv == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH2_INV_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH2_INV_POS);
		}
	}
}


/****************************************************************************************************************************************** 
* :	PWMBASE_SetOutEn()
* ˵:	PWMBASEʹ
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMBASE_CH0 | PWMBASE_CH1 | PWMBASE_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_SetOutEn(PWMBASE_TypeDef * PWMBASEx,uint8_t CHx,FunctionalState  OutEn)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ    
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
//	
//	assert_param(IS_PWMBASE_OUTEN(OutEn));        //ĲOutEnǷϷ 
	
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		if(OutEn == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH0_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH0_EN_POS);
		}	
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		if(OutEn == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH1_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH1_EN_POS);
		}
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		if(OutEn == ENABLE)
		{
			PWMBASEx->OUTCTR |= 0x01 << PWMBASE_OUTCTR_CH2_EN_POS;
		}
		else
		{
			PWMBASEx->OUTCTR &= ~(0x01 << PWMBASE_OUTCTR_CH2_EN_POS);
		}
	}
}

/****************************************************************************************************************************************** 
* :	PWMBASE_SetPeriod()
* ˵:	
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*			uint32_t Period			            Ҫ趨ֵ,16λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_SetPeriod(PWMBASE_TypeDef * PWMBASEx, uint32_t Period)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ    
//	
//	assert_param(IS_PWMBASE_PERIOD(Period));      //ĲPeriodǷϷ    
	
	if(Period == 0 || Period > 0xFFFF)
	{
		Period = 0xFFFF;
	}
	else
	{
		Period -= 1;
	}
	
	PWMBASEx->PERIOD = Period;
}

/****************************************************************************************************************************************** 
* :	PWMBASE_GetPeriod()
* ˵:	ȡ
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*     : ֵ
* ע: 
******************************************************************************************************************************************/
uint32_t PWMBASE_GetPeriod(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ    
	
	return PWMBASEx->PERIOD;
}

/****************************************************************************************************************************************** 
* :	PWMBASE_SetComp()
* ˵:	÷ת
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                         PWMBASE_CH0    PWMBASE_CH1   PWMBASE_CH2
*			uint32_t Comp			            Ҫ趨ķת,16λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_SetComp(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx,uint32_t Comp)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
//	
//	assert_param(IS_PWMBASE_COMP(Comp));          //ĲCompǷϷ    
	
	
	if(Comp > PWMBASE_GetPeriod(PWMBASEx))
	{
		Comp = 0;
	}
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		PWMBASEx->CH0_COMP  = Comp;
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		PWMBASEx->CH1_COMP  = Comp;
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		PWMBASEx->CH2_COMP  = Comp;
	}
}

/****************************************************************************************************************************************** 
* :	PWMBASE_GetComp()
* ˵:	ȡõķת
*     : PWMBASE_TypeDef * PWMBASEx			ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                         PWMBASE_CH0    PWMBASE_CH1   PWMBASE_CH2
*     : õķת
* ע: 
******************************************************************************************************************************************/
uint32_t PWMBASE_GetComp(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
	
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		return PWMBASEx->CH0_COMP;
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		return PWMBASEx->CH1_COMP;
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		return PWMBASEx->CH2_COMP;
	}
}

/****************************************************************************************************************************************** 
* :	PWMBASE_IntCompEn()
* ˵:	PWMBASEתжʹ
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMBASE_CH0 | PWMBASE_CH1 | PWMBASE_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntCompEn(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
	
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		PWMBASEx->IE |= (0x01 << PWMBASE_IE_CH0_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		PWMBASEx->IE |= (0x01 << PWMBASE_IE_CH1_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		PWMBASEx->IE |= (0x01 << PWMBASE_IE_CH2_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMBASE_IntCompDis()
* ˵:	PWMBASEתжϽ
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMBASE_CH0 | PWMBASE_CH1 | PWMBASE_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntCompDis(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH0_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH1_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_CH2_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMBASE_IntCompClr()
* ˵:	PWMBASEתжϱ־
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMBASE_CH0 | PWMBASE_CH1 | PWMBASE_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntCompClr(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		PWMBASEx->IF = (0x01 << PWMBASE_IF_CH0_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		PWMBASEx->IF = (0x01 << PWMBASE_IF_CH1_COMP_POS);
	}
	
	if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		PWMBASEx->IF = (0x01 << PWMBASE_IF_CH2_COMP_POS);
	}
}

/****************************************************************************************************************************************** 
* :	PWMBASE_IntCompState()
* ˵:	PWMBASEתж״̬
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*           uint8_t CHx                    ͨѡ ֻѡһͨ  PWMBASE_CH0   PWMBASE_CH1   PWMBASE_CH2
*     : 1 תжѾ    0  תжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMBASE_IntCompState(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx)
{
	uint8_t State = 0;
	
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
//	
//	assert_param(IS_PWMBASE_CHANNEL(CHx));        //ĲCHxǷϷ    
//	
	
	if((CHx & PWMBASE_CH0) == PWMBASE_CH0) 
	{
		if(PWMBASEx->IF & PWMBASE_IF_CH0_COMP_MSK)
		{
			State = 1;
		}
	}
	else if((CHx & PWMBASE_CH1) == PWMBASE_CH1) 
	{
		if(PWMBASEx->IF & PWMBASE_IF_CH1_COMP_MSK)
		{
			State = 1;
		}
	}
	else if((CHx & PWMBASE_CH2) == PWMBASE_CH2) 
	{
		if(PWMBASEx->IF & PWMBASE_IF_CH2_COMP_MSK)
		{
			State = 1;
		}
	}

	return State;
}



/****************************************************************************************************************************************** 
* :	PWMBASE_IntOvfEn()
* ˵:	PWMBASEжʹ
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntOvfEn(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
	
	PWMBASEx->IE |= (0x01 << PWMBASE_IE_OVF_POS);
}


/****************************************************************************************************************************************** 
* :	PWMBASE_IntOvfDis()
* ˵:	PWMBASEжϽ
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntOvfDis(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
	
	PWMBASEx->IE &= ~(0x01 << PWMBASE_IE_OVF_POS);
}


/****************************************************************************************************************************************** 
* :	PWMBASE_IntOvfClr()
* ˵:	PWMBASEжϱ־
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMBASE_IntOvfClr(PWMBASE_TypeDef * PWMBASEx)
{
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
	
	PWMBASEx->IF = (0x01 << PWMBASE_IF_OVF_POS);
}


/****************************************************************************************************************************************** 
* :	PWMBASE_IntOvfState()
* ˵:	PWMBASEж״̬
*     : PWMBASE_TypeDef * PWMBASEx     ָҪõPWMBASEЧֵPWMBASE0
*     : 
* ע: 
******************************************************************************************************************************************/
uint8_t PWMBASE_IntOvfState(PWMBASE_TypeDef * PWMBASEx)
{
	uint8_t State = 0;
	
//	assert_param(IS_PWMBASE_ALL(PWMBASEx));       //ĲPWMBASExǷϷ  
	
	if(PWMBASEx->IF & PWMBASE_IF_OVF_MSK)
	{
		State = 1;
	}
	
	return State;
}










