#include "BL210x_adc.h"


uint32_t TRIM_ADC_EXT_Addr = 0x3FFDC;
uint32_t TRIM_ADC_IN_Addr  = 0x3FFCC;

/****************************************************************************************************************************************** 
* : ADC_Init()
* ˵:	ADCģתʼ
*     : ADC_InitStructure * initStruct		ADCضֵĽṹ		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_Init(ADC_InitStructure * initStruct)
{
	uint32_t delay = 0;
	uint32_t ADC_TRIM_Data = 0;
	
	/*
	assert_param(IS_ADC_CLKDIV(initStruct->Clk_Div));           //ĲClk_DivǷϷ   
	
	assert_param(IS_ADC_CLKDIV(initStruct->Channels));          //ĲChannelsǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->SampAvg));           //ĲSampAvgǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Samp_Mode));         //ĲSamp_ModeǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->ExtSamp_ClkWin));    //ĲExtSamp_ClkWinǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Mode));              //ĲModeǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->SampClk));           //ĲSampClkǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->InSamp_ClkWin));     //ĲInSamp_ClkWinǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Adcvdd_Open));       //ĲAdcvdd_OpenǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Vref));              //ĲVrefǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Offset_En));         //ĲOffset_EnǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Kd_En));             //ĲKd_EnǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Eoc_IEn));           //ĲEoc_IEnǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Full_IEn));          //ĲFull_IEnǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->HalfFull_IEn));      //ĲHalfFull_IEnǷϷ  
	
	assert_param(IS_ADC_CLKDIV(initStruct->Ovf_IEn));           //ĲOvf_IEnǷϷ  
	*/
	
	SYS->CLKEN |= 0x01 << SYS_CLKEN_ADC_POS;        //ADCʱ

	ADC_Close();                                    //һЩؼĴֻADCرʱ
	
	if(initStruct->Vref == VREF_EXT)
	{
		ADC_TRIM_Data = FLASH_Read_Word_2(TRIM_ADC_EXT_Addr);     //ȡADCⲿοTRIMֵ
	}
	else if(initStruct->Vref == VREF_IN)
	{
		ADC_TRIM_Data = FLASH_Read_Word_2(TRIM_ADC_IN_Addr);      //ȡADCڲοTRIMֵ
	}
	
	ADC->CALIB_OFFSET = ADC_TRIM_Data & 0xFF;                     //дOFFSETĴ
	
	ADC->CALIB_KD = (ADC_TRIM_Data >> 16) & 0x3FF;                //дKDĴ
	
	for(delay = 0;delay < 10000;delay++);
	
	
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_ADC_POS);
	SYS->CLKSEL |= initStruct->Clk_Div << SYS_CLKSEL_ADC_POS;     //ADCתʱӷƵȡֵ1 2 4 8
	
	ADC->CFG &= ~(0x1FF << ADC_CFG_CH0_POS);
	ADC->CFG |= initStruct->Channels << ADC_CFG_CH0_POS;   //ADCתͨѡУADC_CH0ADC_CH1... ... ADC_CH8ϣλ㣩
	
	ADC->CFG &= ~(0x03 << ADC_CFG_AVG_POS);
	ADC->CFG |= initStruct->SampAvg << ADC_CFG_AVG_POS;    //ȡƽADCתADCһͨתΣǵƽֵΪͨת
	
	ADC->CFG &= ~(0x01 << ADC_CFG_CONT_POS);
	ADC->CFG |= initStruct->Samp_Mode << ADC_CFG_CONT_POS;  //ģʽ£1 תģʽһֱתֱSTARTλ
                                                            //                  0 תģʽתɺSTARTλԶֹͣת	 
	
	ADC->CFG &= ~(0x07 << ADC_CFG_SMPL_SETUP_POS);
	ADC->CFG |= initStruct->ExtSamp_ClkWin << ADC_CFG_SMPL_SETUP_POS;  //ⲿ
	
	ADC->CFG &= ~(0x01 << ADC_CFG_MEM_MODE_POS);
	ADC->CFG |= initStruct->Mode << ADC_CFG_MEM_MODE_POS;      //ݴ洢ΪFIFOģʽͨģʽ   0: FIFO  1:ͨ
	
	ADC->CFG &= ~(0x01 << ADC_CFG_SMPL_CLK_POS);
	ADC->CFG |= initStruct->SampClk << ADC_CFG_SMPL_CLK_POS;   //ADCʱѡ  1:ڲʱ   0:ⲿʱ
	
	ADC->CFG &= ~(0x07 << ADC_CFG_IN_SMPL_WIN_POS);
	ADC->CFG |= initStruct->InSamp_ClkWin << ADC_CFG_IN_SMPL_WIN_POS;  //ڲ
	
	ADC->CFG &= ~(0x01 << ADC_CFG_EN_AVDDSNS_POS);
	ADC->CFG |= initStruct->Adcvdd_Open << ADC_CFG_EN_AVDDSNS_POS;     //ADC VDDʹܳ   0:ֻͨ8Чʱ,ADC VDDʹܲŴ  1:ADC VDDʹܳ
	
	ADC->CFG &= ~(0x01 << ADC_CFG_TRIG_POS);
	ADC->CFG |= initStruct->Trig << ADC_CFG_TRIG_POS;
	
	ADC->EXTTRIG_SEL &= ~(0x3F << ADC_EXTTRIG_SEL_TRIG0_POS);
	ADC->EXTTRIG_SEL = (initStruct->ExtTrig_Sel << ADC_EXTTRIG_SEL_TRIG0_POS);
	
	ADC->CTRL &= ~(0x01 << ADC_CTRL_VREF_POS);
	ADC->CTRL |= initStruct->Vref << ADC_CTRL_VREF_POS;   //ADCοԴѡ  0:ⲿο  1:ڲο
	
	ADC->CALIB_OFFSET &= ~(0x01 << ADC_CALIB_OFFSET_VALID_POS);
	ADC->CALIB_OFFSET |= initStruct->Offset_En << ADC_CALIB_OFFSET_VALID_POS;  //offsetʹ   0:ʹ  1:ʹ
	
	ADC->CALIB_KD &= ~(0x01 << ADC_CALIB_KD_VALID_POS);
	ADC->CALIB_KD |= initStruct->Kd_En << ADC_CALIB_KD_VALID_POS;              //kdʹ       0:ʹ  1:ʹ
	
	ADC->IF = 0xFFFFFFFF;	//жϱ־
	
	ADC->IE &= ~(ADC_IE_CH0EOC_MSK | ADC_IE_CH1EOC_MSK | ADC_IE_CH2EOC_MSK | ADC_IE_CH3EOC_MSK |
				 ADC_IE_CH4EOC_MSK | ADC_IE_CH5EOC_MSK | ADC_IE_CH6EOC_MSK | ADC_IE_CH7EOC_MSK | ADC_IE_CH8EOC_MSK);
	ADC->IE |=  (((initStruct->Eoc_IEn & ADC_CH0) ? 1 : 0) << ADC_IE_CH0EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH1) ? 1 : 0) << ADC_IE_CH1EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH2) ? 1 : 0) << ADC_IE_CH2EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH3) ? 1 : 0) << ADC_IE_CH3EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH4) ? 1 : 0) << ADC_IE_CH4EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH5) ? 1 : 0) << ADC_IE_CH5EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH6) ? 1 : 0) << ADC_IE_CH6EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH7) ? 1 : 0) << ADC_IE_CH7EOC_POS) |
				(((initStruct->Eoc_IEn & ADC_CH8) ? 1 : 0) << ADC_IE_CH8EOC_POS);       //ͨתжʹ  ˶ͨתֻҪһͨжϼ
	
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_FULL_POS);
	ADC->IE |= initStruct->Full_IEn << ADC_IE_FIFO_FULL_POS;        //FIFOжʹ
	
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_HFULL_POS);
	ADC->IE |= initStruct->HalfFull_IEn << ADC_IE_FIFO_HFULL_POS;   //FIFOжʹ  
	
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_OVF_POS);
	ADC->IE |= initStruct->Ovf_IEn << ADC_IE_FIFO_OVF_POS;          //FIFO жʹ
	
	if(initStruct->Eoc_IEn | initStruct->Ovf_IEn | initStruct->HalfFull_IEn | initStruct->Full_IEn)
	{
		NVIC_EnableIRQ(ADC_IRQn);
	}
	else
	{
		NVIC_DisableIRQ(ADC_IRQn);
	}
}

/****************************************************************************************************************************************** 
* :	ADC_Open()
* ˵:	ADC
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_Open(void)
{
	ADC->CFG |= (0x01 << ADC_CFG_EN_POS);
}

/****************************************************************************************************************************************** 
* :	ADC_Close()
* ˵:	ADCر
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_Close(void)
{
	ADC->CFG &= ~(0x01 << ADC_CFG_EN_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_Start()
* ˵:	ADCת
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_Start(void)
{
	ADC->START |= (0x01 << ADC_START_START_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_Stop()
* ˵:	ADCֹͣת
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_Stop(void)
{
	ADC->START &= ~(0x01 << ADC_START_START_POS);
}

/****************************************************************************************************************************************** 
* :	ADC_SoftReset()
* ˵:	ADCλ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_SoftReset(void)
{
	ADC->START &= ~(0x01 << ADC_START_SOFT_RESET_POS);
	ADC->START |= (0x01 << ADC_START_SOFT_RESET_POS);
}

/****************************************************************************************************************************************** 
* :	chn2idx()
* ˵:	ͨת
*     : chn   ADC_CH0  ---  ADC_CH8 
*     : ͨ
* ע: 
******************************************************************************************************************************************/
static uint8_t chn2idx(uint32_t chn)
{
	uint32_t idx = 0;
	
//	assert_param(IS_ADC_CH(chn));           //ĲchnǷϷ   
	
	switch(chn)
	{
		case 0x01:  idx = 0; break;
		case 0x02:  idx = 1; break;
		case 0x04:  idx = 2; break;
		case 0x08:  idx = 3; break;
		case 0x10:  idx = 4; break;
		case 0x20:  idx = 5; break;
		case 0x40:  idx = 6; break;
		case 0x80:  idx = 7; break;
		case 0x100: idx = 8; break;
	}
	
	return idx;
}

/****************************************************************************************************************************************** 
* :	ADC_Read()
* ˵:	ָͨȡת
*     : uint32_t chn			ҪȡתͨЧֵADC_CH0ADC_CH1... ... ADC_CH8				
*     : uint16_t				ȡת
* ע: 
******************************************************************************************************************************************/
uint16_t ADC_Read(uint32_t chn)
{
	uint16_t data = 0;
	
	uint8_t idx = chn2idx(chn);

	data = ADC->CH[idx].DATA & 0xFFF;
		
	ADC->IF = (0x01 << idx);   //EOC־
	
	return data;
}

/****************************************************************************************************************************************** 
* :	ADC_Read_FIFO()
* ˵:	FIFOĴжȡת
*     : uint8_t num			    Ҫȡݸ			
*     : uint16_t * buffer	    ȡnum   аͨźͨת
* ע: 
******************************************************************************************************************************************/
void ADC_Read_FIFO(uint16_t * buffer,uint8_t num)
{
	uint8_t k = 0;
	
	for(k = 0;k < num;k++)
	{
		buffer[k] = ADC->FIFO_DATA &0xFFFF;
	}
}


/****************************************************************************************************************************************** 
* :	ADC_IsEOC()
* ˵:	ָͨǷת
*     : uint32_t chn			Ҫѯ״̬ͨЧֵADC_CH0ADC_CH1... ... ADC_CH8				
*     : uint8_t				    1 ͨת    0 ͨδת
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_IsEOC(uint32_t chn)
{
	uint8_t idx = chn2idx(chn);
	
	return (ADC->CH[idx].STAT & ADC_STAT_EOC_MSK) ? 1 : 0;
}

/****************************************************************************************************************************************** 
* :	ADC_IntEOCEn()
* ˵:	תжʹ
*     : uint32_t chn			ҪõͨЧֵADC_CH0ADC_CH1... ... ADC_CH8				
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntEOCEn(uint32_t chn)
{
	uint8_t idx = chn2idx(chn);
	
	ADC->IE |= (0x01 << idx);
}


/****************************************************************************************************************************************** 
* :	ADC_IntEOCEn()
* ˵:	תжϽֹ
*     : uint32_t chn			ҪõͨЧֵADC_CH0ADC_CH1... ... ADC_CH8				
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntEOCDis(uint32_t chn)
{
	uint8_t idx = chn2idx(chn);
	
	ADC->IE &= ~(0x01 << idx);
}


/****************************************************************************************************************************************** 
* :	ADC_IntEOCStat()
* ˵:	תж״̬
*     : uint32_t chn			ҪѯͨЧֵADC_CH0ADC_CH1... ... ADC_CH8					
*     : uint8_t				    1 ͨת    0 ͨδת
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_IntEOCStat(uint32_t chn)
{
	uint8_t idx = chn2idx(chn);
	
	return (ADC->IF & (0x01 << idx)) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	ADC_IntEOCEn()
* ˵:	תжϱ־
*     : uint32_t chn			ҪõͨЧֵADC_CH0ADC_CH1... ... ADC_CH8				
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntEOCClr(uint32_t chn)
{
	uint8_t idx = chn2idx(chn);
	
	ADC->IF = (0x01 << idx);
}

/****************************************************************************************************************************************** 
* :	ADC_FIFO_Level()
* ˵:	ȡFIFOˮλ
*     : 		
*     : uint8_t	  FIFOˮλ  ʾFIFOжݿԶȡ			    
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_FIFO_Level(void)
{
	uint8_t Level = 0;
	
	Level = (ADC->FIFO_STAT & ADC_FIFO_STAT_LEVEL_MSK) >> ADC_FIFO_STAT_LEVEL_POS;

	return Level;
}

/****************************************************************************************************************************************** 
* :	ADC_FULLStat()
* ˵:	FIFO״̬
*     : 		
*     : uint8_t				1 FIFO   0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_FULLStat(void)
{
	return (ADC->FIFO_STAT & ADC_FIFO_STAT_FULL_MSK) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	ADC_HALFFULLStat()
* ˵:	FIFO״̬
*     : 		
*     : uint8_t				1 FIFO   0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_HALFFULLStat(void)
{
	return (ADC->FIFO_STAT & ADC_FIFO_STAT_HFULL_MSK) ? 1 : 0;
}

/****************************************************************************************************************************************** 
* :	ADC_EMPTYStat()
* ˵:	FIFO״̬
*     : 		
*     : uint8_t				1 FIFO  0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_EMPTYStat(void)
{
	return (ADC->FIFO_STAT & ADC_FIFO_STAT_EMPTY_MSK) ? 1 : 0;
}

/****************************************************************************************************************************************** 
* :	ADC_OVFStat()
* ˵:	FIFO״̬
*     : 		
*     : uint8_t				1 FIFO 0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_OVFStat(void)
{
	return (ADC->FIFO_STAT & ADC_FIFO_STAT_OVF_MSK) ? 1 : 0;
}

/****************************************************************************************************************************************** 
* :	ADC_IntFULLEn()
* ˵:	FIFOжʹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntFULLEn(void)
{
	ADC->IE |= (0x01 << ADC_IE_FIFO_FULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntFULLDis()
* ˵:	FIFOжϽֹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntFULLDis(void)
{
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_FULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntFULLStat()
* ˵:	FIFOж״̬
*     : 		
*     : uint8_t				1 FIFO   0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_IntFULLStat(void)
{
	return (ADC->IF & ADC_IF_FIFO_FULL_MSK) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	ADC_IntFULLClr()
* ˵:	FIFOж״̬
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntFULLClr(void)
{
	ADC->IF = (0x01 << ADC_IF_FIFO_FULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntHALFFULLEn()
* ˵:	FIFOжʹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntHALFFULLEn(void)
{
	ADC->IE |= (0x01 << ADC_IE_FIFO_HFULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntHALFFULLDis()
* ˵:	FIFOжϽֹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntHALFFULLDis(void)
{
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_HFULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntHALFFULLStat()
* ˵:	FIFOж״̬
*     : 		
*     : uint8_t				1 FIFO   0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_IntHALFFULLStat(void)
{
	return (ADC->IF & ADC_IF_FIFO_HFULL_MSK) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	ADC_IntHALFFULLClr()
* ˵:	FIFOж״̬
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntHALFFULLClr(void)
{
	ADC->IF = (0x01 << ADC_IF_FIFO_HFULL_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntOVFEn()
* ˵:	FIFOжʹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntOVFEn(void)
{
	ADC->IE |= (0x01 << ADC_IE_FIFO_OVF_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntOVFDis()
* ˵:	FIFOжϽֹ
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntOVFDis(void)
{
	ADC->IE &= ~(0x01 << ADC_IE_FIFO_OVF_POS);
}


/****************************************************************************************************************************************** 
* :	ADC_IntOVFStat()
* ˵:	FIFOж״̬
*     : 		
*     : uint8_t				1 FIFO  0 FIFOδ
* ע: 
******************************************************************************************************************************************/
uint8_t ADC_IntOVFStat(void)
{
	return (ADC->IF & ADC_IF_FIFO_OVF_MSK) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	ADC_IntOVFClr()
* ˵:	FIFOж״̬
*     : 		
*     : 
* ע: 
******************************************************************************************************************************************/
void ADC_IntOVFClr(void)
{
	ADC->IF = (0x01 << ADC_IF_FIFO_OVF_POS);
}












