/***********************************************************************
 * Copyright (c)  2017 - 2020, Unicmicro Co.,Ltd .
 * All rights reserved.
 * Filename    : common.c
 * Description : conmmon source file
 * Author(s)   : Dan
 * version     : V1.0
 * Modify date : 2020-07-16
 ***********************************************************************/
#include  "common.h"
#include  "config.h"

/************************************************************************
 * function   : delay1ms
 * Description: delay 1ms
 * input : uint32_t n: n ms
 *		  
 * return: none
 ************************************************************************/

void delay1ms(uint32_t n)		//@16M Hz
{
	uint32_t x;
	uint8_t i;
	uint8_t j;
	for(x = 0; x<=n; x++)
	{
		_nop_();
		i = 21;
		j = 146;
		do
		{
			while (--j);
		} while (--i);
	}
}

void delay(uint32_t i)
{
		while(i--);
}

#ifdef DEBUG
/************************************************************************
 * function   : printf_buff_byte
 * Description: printf data block by byte
 * input :
 *         uint8_t* buff: buff
 *         uint32_t length: byte length
 * return: none
 ************************************************************************/
void printf_buff_byte(uint8_t* buff, uint32_t length)
{
	uint32_t i;

	for(i=0; i<length; i++)
	{
		printf("%.2bx ",buff[i]);	
	}
	printf("\n");
}

/************************************************************************
 * function   : printf_buff_word
 * Description: printf data block by word
 * input :
 *         uint8_t* buff: buff
 *         uint32_t length: word length
 * return: none
 ************************************************************************/
void printf_buff_word(uint32_t* buff, uint32_t length)
{
	uint32_t i;

	for(i=0; i<length; i++)
	{
		printf("%.8lx ",buff[i]);	
	}
	printf("\n");
}

#endif
