/***********************************************************************
 * Copyright (c)  2017 - 2021, Radioway Co.,Ltd .
 * All rights reserved.
 * Filename    : un800x_test.c
 * Description : app driver source file for test
 * version     : V1.0
 * Modify date : 2021-04-26
 ***********************************************************************/
#include  "system_um800x.h"
#include  "um800x_test.h"
#include  "config.h"
#include  "common.h"
#include  "uart0.h"
#include  "adc.h"
#include  "beeper.h"
#include  "eflash.h"
#include  "gpio.h"
#include  "i2c.h"
#include  "timer.h"
#include  "lptimer.h"
#include  "pwm.h"
#include  "spi.h"




volatile uint8_t rx_flag ;
volatile uint8_t uart0_rx_buf[32];
//volatile uint8_t uart0_tx_buf[32];
volatile uint16_t rx_count = 0;
volatile uint16_t tx_count = 0;

volatile uint8_t adc_rx_flag = 0;
volatile uint8_t adc_rx_count = 0;
volatile uint16_t adc_data = 0;
//volatile uint16_t adc_converte_val[40];
/************************************************************************
 * function   : uart0_rec_pro
 * Description: uart0_rec_pro ڽմص
 * input : none
 * return: none
 ************************************************************************/
void uart0_rec_pro(void)
{
	uart0_rx_buf[rx_count++]= uart0_recv_byte();
	rx_flag = 1;	
}
/************************************************************************
 * function   : uart0_send_pro
 * Description: uart0_send_pro ڷʹص
 * input : none
 * return: none
 ************************************************************************/
void uart0_send_pro(void)
{
	tx_flag = 1;
}


/************************************************************************
 * function   : uart1_rec_pro
 * Description: uart1_rec_pro ڽմص
 * input : none
 * return: none
 ************************************************************************/
//void uart1_rec_pro(void)
//{
//	uart0_rx_buf[rx_count++]= uart1_recv_byte();
//	rx_flag = 1;
//}
/************************************************************************
 * function   : uart1_send_pro
 * Description: uart1_send_pro ڷʹص
 * input : none
 * return: none
 ************************************************************************/
//void uart1_send_pro(void)
//{
//	tx_flag = 1;
//}

/************************************************************************
 * function   : uart_init
 * Description: uart_init ڳʼ
 * input : none
 * return: none
 ************************************************************************/
void uart_init(void)
{
	rx_flag = 0;
	uart0_init(UART0_BAUD_RATE);
    uart0_irq_init(UART0_IRQ_ENABLE,uart0_rec_pro,uart0_send_pro);
}

// =================  LOWPOWER TEST DEMO  ===========================================

void gpio_enable_interrupt(void)
{
	EA = 0x1;				//EAжϿ
    EX0 = 0x1;             //ⲿжʹ
    P0IEN |= (0x1<<4);     //ʹP04˿ж

}

// function   : lowpower_test
// Description: lowpower ͹Ĳ
// input : none
// return: none
//
void lowpower_test(void)
{
	
	uint8_t chs = 2;
	
	switch(chs)
	{ 
	
	case 0:             //SLEEP mode,wake up by GPIO inerrupt
		//printfS("SLEEP  MODE------Enter SLEEP mode------Wake up by P04!\n");
	
		POREN |= (1<<0);				//رLVR
	  LVDCON |= (1<<4);				//رLVD
		
		CLKCON &= ~(0x1<<3);				//RCLʱӹر
		
		PCLK0 = 0x00;					//رģʱ
		PCLK1 = 0x01;					//رճѹܽIO֮ģʱ
		PRESET0 = 0x00;					//λģ(GPIO0)
		PRESET1 = 0x01;					//λģ(GPIO0)
	
		P0IE = 0x14; 					//ֹ(P04NRST)
		P1IE = 0x00;					//ֹ	
		P2IE = 0x00;					//ֹ		
		
		P0PU &= ~(1<<4);  				//ʹP04ڲ
	
		gpio_enable_interrupt();		//P04жʹ
		
		sys_entersleep();               //enter SLEEP mode
		
		uart_init();	                //´UART0ͨӡϢжǷ
		//printfS("SLEEP MODE------Exit SLEEP mode------Pass!\n");	
		break;
	case 1:             //Deepsleep  modewake up by GPIO(rising edge or falling edge ) inerrupt or Timer
		//printfS("Deepsleep MODE------Enter Deepsleep mode------Wake up by P04!\n");
		
		POREN |= (1<<0);				//رLVR
	  LVDCON |= (1<<4);				//رLVD
				
		PCLK0 = 0x00;					//رģʱ
		PCLK1 = 0x01;					//رճѹܽIO֮ģʱ
		PRESET0 = 0x00;					//λģ(GPIO0)
		PRESET1 = 0x01;					//λģ(GPIO0)
	
		P0IE = 0x14; 					//ֹ(P04NRST)
		P1IE = 0x00;					//ֹ	
		P2IE = 0x00;					//ֹ		
		
		P0PU &= ~(1<<4);  				//ʹP04ڲ
			
		gpio_enable_interrupt();		//P04жʹ
	
		sys_enterdeepsleep();  			//enter deepsleep mode
	
		uart_init();	                //´UART0ͨӡϢжǷ
		//printfS("Deepsleep MODE------Exit Deepsleep mode------Pass!\n");
	
		break;
	case 2:             //stop modewake up by GPIO(rising edge or falling edge ) inerrupt
		//printfS("STOP MODE------Enter STOP mode------Wake up by P04!\n");
		
		POREN |= (1<<0);				//رLVR
	    LVDCON |= (1<<4);				//رLVD
				
		PCLK0 = 0x00;					//رģʱ
		PCLK1 = 0x01;					//رճѹܽIO֮ģʱ
		PRESET0 = 0x00;					//λģ(GPIO0)
		PRESET1 = 0x01;					//λģ(GPIO0)
	
		P0IE = 0x14; 					//ֹ(P04NRST)
		P1IE = 0x00;					//ֹ	
		P2IE = 0x00;					//ֹ		
		
		P0PU &= ~(1<<4);  				//ʹP04ڲ	
		
		gpio_enable_interrupt();		//P04жʹ
	
		sys_enterstop();            	//enter stop mode

		uart_init();	                //´UART0ͨӡϢжǷ
		//printfS("STOP MODE------Exit STOP mode------Pass!\n");
		break;
	default:
			break;
	
    }        
    
}

// function   : active_test
// Description: active ģʽĲ
// input : none
// return: none
//
void active_test(void)
{
    //printfS("Թйģ鶼رգֻⲿλ!\n");
    CLKCON &= ~(1<<3);				//رRC32K
    POREN |= (1<<0);				//رLVR
    LVDCON |= (1<<4);				//رLVD

    PCLK0 = 0x00;					//رģʱ
    PCLK1 = 0x00;					//رģʱ
    PRESET0 = 0x00;					//λģ
    PRESET1 = 0x00;					//λģ

    P0IE = 0x04;  					//ֹ(P02)
    P1IE = 0x00;					//ֹ	
    P2IE = 0x00;					//ֹ		
        
    while(1)
    {
        
    }

}
// =================  END OF LOWPOWER TEST DEMO  ===========================================

// =================  ADC TEST DEMO  ===========================================
#if 0
void adc_single_mode_func(void)
{
	adc_data = get_adc_value();
	adc_rx_flag = 1;
}
	
void adc_single_mode_test(void)
{
	uint8_t i;
	uint16_t adc_converte_data;
	
	/* ADC1MspsADC = f(ADCCLK) / (ʱ+תʱ) = 16MHz/(4clk+12clk) = 1Msps */
	adc_init(ADC_VREFSEL_VDDH,ADC_CLKSRC_SYSCLK,1,ADC_SINGLE_MODE);		//ADCʼVREFѡVDDHιģʽʱԴѡϵͳʱӷʱʱADCCDRƵЧ
	adc_io_config(ADC_CH4);												//ADCͨ

#ifdef ADCIRQ_ENABLE											//ADCжģʽ
	adc_irq_config(ADC_IRQ_ENABLE,adc_single_mode_func);		//ʹж
	while(1)
	{
		adc_convert_start(ADC_CH4);
		while(!adc_rx_flag);
		printfS("adc single mode irq test,adc_data = %d, adc_vol = %.3fV\r\n",adc_data,((float)adc_data/4096*(float)3.3));
		adc_rx_flag = 0;
		
		delay1ms(1000);
	}

#else	
	//ʮεβ
	for(i=0; i<10; i++)
	{
		
		adc_converte_data = get_adc(ADC_CH4);
		printfS("adc single mode normal test,adc_converte_data = %d,adc_vol = %.3fV\r\n",adc_converte_data,((float)adc_converte_data/4096*(float)3.3));	
		delay1ms(5);
	
	}
#endif

}

void adc_continous_mode_func(void)
{
	adc_converte_val[adc_rx_count] = get_adc_value();
	adc_rx_count++;
	if(adc_rx_count == 10)
	{
		adc_convert_stop();						//ADCֹͣת
	}

}
	
void adc_continous_mode_test(void)
{
	uint8_t i;
	
	/* ADC1MspsADC = f(ADCCLK) / (ʱ+תʱ) = 16MHz/(4clk+12clk) = 1Msps */
	adc_init(ADC_VREFSEL_VDDH,ADC_CLKSRC_SYSCLK,1,ADC_CONTINOUS_MODE);	//ADCʼVREFѡVDDHģʽʱԴѡϵͳʱӷʱʱADCCDRƵЧ
	adc_io_config(ADC_CH4);												//ADCͨ
	
	adc_irq_config(ADC_IRQ_ENABLE,adc_continous_mode_func);		//ʹж
	adc_convert_start(ADC_CH4);
	
	while(adc_rx_count != 10);
	for(i=0; i<adc_rx_count; i++)
	{
		printfS("adc continous mode irq test,adc_converte_val = %d\r\n",adc_converte_val[i]);
	}


}
	
void adc_test(void)
{
	printfS("UM800x run at %ldHz\n",SystemCoreClock);	
	
	adc_single_mode_test();

//	adc_continous_mode_test();
	
}
#endif	
// =================  END OF ADC TEST DEMO  ===========================================

// =================  BEEPER TEST DEMO  ===============================================
#if 0
void beeper_test(void)
{
	//printfS("System run at %ldHz\n\r", SystemCoreClock);
	//printfS("beep test start! \n");
	beeper_init();
	beeper_level_set(HIGH,SEL_4KHz);
	
	while(1)
	{			
    
	}    
	
}
#endif
// =================  END OF BEEPER TEST DEMO  ========================================

// =================  eFLASH TEST DEMO  ===============================================
#if 0
void eflash_page_check_8bits(uint16_t base_addr,uint8_t w_val, uint8_t page)
{
    uint16_t i;
    
    for(i = 0; i < PAGE_SIZE; i++)
    {
        eflash_write_byte(base_addr+page*PAGE_SIZE+i,w_val);
    }
    
    for(i = 0; i < PAGE_SIZE; i++)
    {
        if(eflash_read_byte(base_addr+page*PAGE_SIZE+i) != w_val)
        {
            printf("Error: 8bit Read not equal write![0x%x]\n",(base_addr+page*PAGE_SIZE+i));
            break;
        }
    }

}
void eflash_page_check_bytes(uint16_t base_addr,uint8_t w_val, uint32_t length)
{
    uint32_t i;
 
    uint8_t  write_data[DATA_SIZE]={0};
    uint8_t  read_data[DATA_SIZE]={0};
    
    //ֽڶд
    eflash_erase_page(base_addr);								//ҳ

    for(i = 0; i < length; i++)
    {
        if(eflash_read_byte(base_addr+i) != 0xff)
        {
                printf("Error: erase fail![0x%lx]\n",(base_addr+i));
                break;
        }
    }	
    
    for(i=0;i<length;i++)
    {
        write_data[i] = w_val;                          
    }
    
    eflash_write_bytes(base_addr, write_data, length);                       //ֽд
        
        
   if(length == eflash_read_bytes(base_addr, read_data, length))             //ֽڶ    
   {
        for(i=0;i<length;i++)
        {
            if(read_data[i] != w_val)
            {
                printf("Error: multibyte Read not equal Write![0x%x]\n",(base_addr+i));
                break;
            } 
//            printf("read_data:[0x%bx]\n",read_data[i]);
        }          
   }
        
    
}

void eflash_page_check_byte(uint16_t base_addr, uint8_t start_page, uint8_t num_page)
{
    uint16_t i;
    uint8_t page;

    //ֽڶд

    for(page = start_page; page < num_page; page++)
    {
        eflash_erase_page(base_addr + page * PAGE_SIZE);								//ҳ
        for(i = 0; i < PAGE_SIZE; i++)
        {
            if(eflash_read_byte(base_addr+page*PAGE_SIZE+i) != 0xff)
            {
                    printf("Error: erase fail![0x%lx]\n",(base_addr+page*PAGE_SIZE+i));
                    break;
            }
        }	
        eflash_page_check_8bits(base_addr,0x55,page);                                   //ֽڶд
    }


}
void eflash_test(void)
{
	eflash_init(SystemCoreClock);

	/********MAINд*********/
    //ֽڶд
	//printfS("0x1000- 0x1200 write and read by byte test start\r\n");
	eflash_page_check_byte(0x1000,0,1);
   	//printfS("0x1000- 0x1200 write and read by byte test end\r\n"); 
    
    //ֽڶд
    //printfS("0x1000 write and read by multi bytes test start\r\n");
    eflash_page_check_bytes(0x1000,0xa5,DATA_SIZE);                                          //ֽڶд
	//printfS("0x1000 write and read by multi bytes test end\r\n");


}		
#endif
// =================  END OF BEEPER TEST DEMO  ========================================


// =================  GPIO TEST DEMO  ===============================================
#if 1
void gpio_in_test(void)
{
	uint8_t temp; 
    
    //printfS("GPIO in test.\n\r");
    //ⲿP1.2ţͣӡƽ仯
	gpio_init(P12);                       //P1.2ʱӳʼģ
	gpio_dir_set(P12, GPIO_DIR_IN);       //P1.2Ϊ
	gpio_pu_set(P12, GPIO_PU_ENABLE);     //P1.2ʹڲ
    gpio_in_enable(P12, IN_ENABLE);       //P1.2 ʹ 

	while (1) 
	{
        temp = gpio_io_get(P12);
        printfS("gpio_in_test:P1.2 =  %bd\n\r",temp);
	}
}

void gpio_out_test(void)
{ 
    //printfS("GPIO out test.\n\r");
    //GPIOD5˸
	gpio_init(P11);                      //P1.1ʱӳʼģ
	gpio_dir_set(P11, GPIO_DIR_OUT);     //P1.1Ϊ
    
    while (1) 
	{
        gpio_io_set(P11, GPIO_HIGH); 
        delay1ms(1000);
        gpio_io_set(P11, GPIO_LOW); 
        delay1ms(1000);
	}                
}

void gpio_int_pro(void)
{
    //printfS("gpio_P2.3 interrupt test \n\r");
}

void gpio_irq_test(void)
{
    //printfS("GPIO interrupt test.\n\r");
    
	gpio_init(P23);                          //P2.3ʱӳʼģ
	gpio_dir_set(P23, GPIO_DIR_IN);          //P2.3Ϊ
	gpio_pu_set(P23, GPIO_PU_ENABLE);        //ʹP2.3ڲ
    gpio_in_enable(P23, IN_ENABLE);          //P2.3ʹ 
	gpio_irq_set(P23, GPIO_IRQ_ENABLE, gpio_int_pro);		//ʹP2.3ж
    
}

void gpio_test(void)
{	
	//printfS("UM800x run at %ldHz\n\r", SystemCoreClock);

//	gpio_in_test();       //P1.2жϲ
	gpio_out_test();      //P1.1
	//gpio_irq_test();      //P2.3жϲ
	
	while (1) 
	{
    
	}
}
#endif
// =================  END OF GPIO TEST DEMO  ===============================================


// =================  I2C TEST DEMO  ===============================================
#if 0
void i2c_test(void)
{
	i2c_master_test();
  i2c_slave_test();
}
	

void i2c_master_test(void)
{	
	i2c_master_send_test();
//	i2c_master_recv_test();
}

void i2c_master_send_test(void)
{
	uint8_t xdata status;
	uint8_t xdata i;
	uint8_t xdata i2c_send_data[10];
	for(i=0 ; i<8; i++)
	{
		i2c_send_data[i] = i+0x10;
	
	}
	//printfS("i2c master send start\r\n");
	
	i2c_master_init(MASTER_I2C_SPEED_100K);			
	status = i2c_master_write(I2C_SLAVE_ADDR,0x00,i2c_send_data,8);

	//printfS("status = 0x%bx\r\n",status);
	//printfS("i2c master send end\r\n");

}

void i2c_master_recv_test(void)
{
	uint8_t xdata status;
	uint8_t xdata i2c_recv_data[10];
	//printfS("i2c master recv start\r\n");
	
	i2c_master_init(MASTER_I2C_SPEED_100K);			
	status = i2c_master_read(I2C_SLAVE_ADDR,0x00,i2c_recv_data,8);
		
	//printfS("status = 0x%bx\r\n",status);
	//printfS("i2c master recv end\r\n");
	//printfB8(i2c_recv_data,8);

}

// ====================   slave test ==================
void i2c_slave_test(void)
{
	i2c_slave_read_test();
//	i2c_slave_write_test();
}

void i2c_slave_write_test(void)
{
	uint8_t xdata i;
	uint8_t xdata len;
	uint8_t xdata i2c_slave_send_data[20];
	for(i=0 ; i<8; i++)
	{
		i2c_slave_send_data[i] = i+0xa0;
	
	}
	
	//printfS("i2c slave write test start\r\n");
	i2c_slave_init();						//ӻʼ
	i2c_set_slave_addr1(I2C_SLAVE_ADDR);	//ôӻַ
	
	while(1)
	{	
		if((REG_I2C_SR0 & MAAS1) == MAAS1) //maas1ƥ
		{				
				REG_I2C_SR0 = MAAS1;		//յַƥ״̬			
				if((REG_I2C_SR0 & SRW)) 	//Ϊӷ
				{
					len = i2c_slave_write(i2c_slave_send_data);
					//printfS("write len:%bd\n", len);
					//printfS("match addr1,i2c slave send\n");
					
				}
		
		}
		if((REG_I2C_SR0 & MAAS2) == MAAS2) //maas2ƥ
		{				
				REG_I2C_SR0 = MAAS2;	   //յַƥ״̬			
				if((REG_I2C_SR0 & SRW))    //Ϊӷ
				{
					len = i2c_slave_write(i2c_slave_send_data);
					//printfS("write len:%bd\n", len);
					//printfS("match addr2,i2c slave send\n");
				}
		}
	}


}


void i2c_slave_read_test(void)
{
	uint8_t xdata len;
	uint8_t xdata i2c_slave_recv_data[20];
	
	//printfS("i2c slave read test start\r\n");
	
	i2c_slave_init();							//ӻʼ
	i2c_set_slave_addr1(I2C_SLAVE_ADDR);		//ôӻַ
	i2c_ack();									//ʹӦACK
	while(1)
	{	
		if((REG_I2C_SR0 & MAAS1) == MAAS1) 		//maas1ƥ
		{				
				REG_I2C_SR0 = MAAS1;			//յַƥ״̬
				if(!(REG_I2C_SR0 & SRW)) 		//Ϊӽ
				{
					len = i2c_slave_read(i2c_slave_recv_data);
					//printfB8(i2c_slave_recv_data,len);
					//printfS("match addr1,i2c slave receive\n");
				}
		}
		if((REG_I2C_SR0 & MAAS2) == MAAS2) 		//maas2ƥ
		{				
				REG_I2C_SR0 = MAAS2;			//յַƥ״̬
				if(!(REG_I2C_SR0 & SRW)) 		//Ϊӽ
				{
					len = i2c_slave_read(i2c_slave_recv_data);
					//printfB8(i2c_slave_recv_data,len);
					//printfS("match addr2,i2c slave receive\n");
				}
		}
	}

}

#endif
// =================  END OF I2C TEST DEMO  ===============================================

// =================  TIMER TEST DEMO  ===============================================

// Function		: timer0_irq_func
// Description	: timer0_irq_func TIMER0жϻص
// Input			: none
// Return		: none
//
void timer0_irq_func(void)
{
	static uint32_t a=0;
	
	printfS("timer0 irq cnt = %ld\r\n",a++);
}

// Function		: timer1_irq_func
// Description	: timer1_irq_func TIMER1жϻص
// Input			: none
// Return		: none
//
void timer1_irq_func(void)
{
	static uint32_t b=0;
	
	printfS("timer1 irq cnt = %ld\r\n",b++);
}

// Function		: timer0_test
// Description	: timer0_test
// Input			: none
// Return		: none
//
void timer0_test()
{   
    uint16_t num = 0;
	//printfS("Timer0 test start\r\n");
	
	timer0_init(TIMER_CLKSRC_SYSCLK,TIMER_CLKPSC_256,62500);		//1sʱ
	
#ifdef	TIMER0_IRQ_ENABLE											//TIMER0жϷʽ
	timer0_irq_config(TIMER_IRQ_ENABLE,timer0_irq_func);
	timer0_start();
#else																//TIMER0ѯʽ
	timer0_start();
	while(1)          
	{
        if(TF0 == 1)												//TIMER0־
		{								
            TF0 = 0;												//TIMER0־			
			printfS("num = %d\r\n",num++);			
		}
		
	}
#endif
}

// Function		: timer1_test
// Description	: timer1_test
// Input			: none
// Return		: none
//
void timer1_test()
{
    uint16_t num = 0;
	//printfS("Timer1 test start\r\n");
	
	timer1_init(TIMER_CLKSRC_RC32K,TIMER_CLKPSC_256,640);		//1sʱ
	
#ifdef	TIMER1_IRQ_ENABLE										//TIMER1жϷʽ
	timer1_irq_config(TIMER_IRQ_ENABLE,timer1_irq_func);
	timer1_start();
#else															//TIMER1ѯʽ
	timer1_start();
	while(1)          
	{
        if(TF1 == 1)											//TIMER1־
		{
            TF1 = 0;											//TIMER1־			
			printfS("num = %d\r\n",num++);			
		}
		
	}
#endif
}

// Function		: timer_test
// Description	: timer_test
// Input			: none
// Output		: none
// Return		: none
//
void timer_test(void)
{
    //printfS("System run at %ldHz\n\r", SystemCoreClock);
		timer0_test();
//		timer1_test();

}

volatile uint8_t flag_ov_int = 0;
volatile uint8_t flag_trig_int = 0;
volatile uint8_t flag_comp_int = 0;
volatile uint8_t count = 0;
// Function		: lptim_comp_pro
// Description	: Ƚƥжϻص
// Input			: none
// Output		: none
// Return		: none
//
void lptim_comp_pro(void)
{
    flag_comp_int = 1;	
    //printfS("Lptim comp irq!!\r\n",count);  
    
}

// Function		: lptim_ov_pro
// Description	: ʱжϻص
// Input			: none
// Output		: none
// Return		: none
//
void lptim_ov_pro(void)
{ 
    flag_ov_int = 1;
    count++;
    //printfS("Timing %bds.\r\n",count);   	        
}


// Function		: lptim_trig_pro
// Description	: ⲿжϻص
// Input			: none
// Output		: none
// Return		: none
//
void lptim_trig_pro(void)
{
    flag_trig_int = 1;	
    //printfS("Lptim trig irq!!\r\n",count);  
}


// Function		: lptim_timer
// Description	: lptim ͨʱģʽ
// Input			: none
// Output		: none
// Return		: none
//
void lptim_timer_test(void)
{
    lptimer_init(TIMER_TMODE);                                               /*ͨʱģʽ*/
    lptimer_irq_init(LPTIMER_IRQ_ENABLE,LPTIE_OV,lptim_ov_pro);              /*ж*/      
    lptimer_set_ms(1000);                                                    /*ʱ1s*/     
    lptimer_outio();                                                         /*P0_3ΪLPOUT*/   
    lptimer_on();                                                            /*ʱ*/ 
    //printfS("lptimer timing start !!\r\n");                                
    
    
	while(1)
	{
       if(count==20)                                                        /*ʱ20sر*/
       {
            lptimer_off();                                                  /*ʱر*/
            //printfS("lptimer timing finish!!\r\n");
            count = 0;
       }
    }
}


// Function		: lptim_pwm_test
// Description	: lptim pwm 
// Input			: none
// Output		: none
// Return		: none
//
void lptim_pwm_test(void)
{
    lptimer_pwm_init();                                                      /*pwmʼ*/
    lptimer_irq_init(LPTIMER_IRQ_ENABLE,LPTIE_COMP,lptim_comp_pro);          /*ƥж*/  
    lptimer_pwm_set(10, 50);                                                 /*Ϊ10msռձΪ50%PWM*/       
    lptimer_outio();                                                         /*P0_3ΪLPOUT*/
    lptimer_on();                                                            /*ʱ*/ 
}

// =================  END OF TIMER TEST DEMO  ===============================================

// =================  PWM TEST DEMO  ===============================================

// function   : pwm0_test
// Description: pwm0_test
// input : none
// return: none
//
void pwm0_test(void)
{
    //printfS("start test pwm0! \n");   
    pwm0_init(1000000, 50, HIGH);    //ƵΪ1MHzռձΪ50%PWM(Ƶ÷ΧΪ245hz~8Mhz)
    
    while(1)
    {
        pwm0_start();   
        delay1ms(2000);
        pwm0_stop();
        delay1ms(2000);
    }

}

// function   : pwm1_test
// Description: pwm1_test
// input : none
// return: none
//
void pwm1_test(void)
{
    //printfS("start test pwm1! \n");
    
	  pwm1_init(500000, 25, HIGH);      //ƵΪ500KHzռձΪ25%PWM(Ƶ÷ΧΪ245hz~8Mhz)
    pwm1_start();    
}


// function   : pwm2_test
// Description: pwm2_test
// input : none
// return: none
//
void pwm2_test(void)
{
    //printfS("start test pwm2! \n");
    
	  pwm2_init(2000000, 75, HIGH);      //ƵΪ2MHzռձΪ75%PWM(Ƶ÷ΧΪ245hz~8Mhz) 
    pwm2_start();   
}
// =================  END OF PWM TEST DEMO  ===============================================

// =================  SPI TEST DEMO  ===============================================

#define LEN		8
//#define SPI_IRQ_ENABLE 	1

volatile uint8_t spi_rx_data;
volatile uint8_t spi_rx_flag = 0;

uint8_t xdata rx_buf[256];
uint8_t xdata tx_buf[256];

void spi_irq_func(void)
{
	spi_rx_data = spi_receive_byte();
	spi_rx_flag = 1;
}

void spi_test(void)
{
		uint16_t xdata i;
	
		for(i=0;i<LEN;i++)
		{
			tx_buf[i]= i;      // master mode
			//tx_buf[i]= i+0xA0; // slave  mode, use this
		}
		
		//printfS("SPI Master test start!! \r\n");
		//printfS("SPI Slave test start!! \r\n");
		spi_master_init(WORK_MODE_0,SPI_CLK_DIV_4);	//SPIʼѡģʽSPIͨ=fSYSCLK/ʷƵ
    //spi_slave_init(WORK_MODE_0);
		
#ifdef SPI_IRQ_ENABLE								//жϷʽapp.hп
		//printfS("SPI Master RXNE irq test start!! \r\n");
		//printfS("SPI Slave RXNE irq test start!! \r\n");
		
		spi_irq_enable(SPI_RXNE_IE,spi_irq_func);
		
		while(1)
		{
				for(i=0;i<LEN;i++)
				{
						spi_cs_enable();	// master mode,  slave  mode DONT need this function
						spi_send_byte(tx_buf[i]);	
						while(!spi_rx_flag);
						rx_buf[i] = spi_rx_data;
						spi_rx_flag = 0;
						spi_cs_disable(); // master mode,  slave  mode DONT need this function
				
				}		

				//printfB8(rx_buf,LEN);
				
				delay1ms(1000);
		
		
		}
			
		
#else												//ѯʽ	
		while(1)
		{

				spi_cs_enable();	  // master mode,  slave  mode DONT need this function
				for(i=0;i<LEN;i++)
				{				
					spi_send_byte(tx_buf[i]);						 
					rx_buf[i] = spi_receive_byte();			
				}		
				spi_cs_disable();   // master mode,  slave  mode DONT need this function
				
				printfB8(rx_buf,LEN);
				
				delay1ms(1000);
					
		}
#endif
					
}

// =================  END OF SPI TEST DEMO  ===============================================
