#ifndef __BL2101_AES_H__
#define __BL2101_AES_H__

#include "BL2101.h"

typedef enum
{ 
	ECB =  0x00,             //ECBģʽ                       
	CBC =  0x01,             //CBCģʽ
    CTR =  0x02,             //CTRģʽ
} AESConnectMode_TypeDef;

typedef enum
{ 
	Encrypt    =  0x00,      //     
	Key        =  0x01,      //Կ
    Decrypt    =  0x02,      //
	KeyDecrypt =  0x03       //Կӽ
} AESMode_TypeDef;

typedef enum
{ 
	BIT32    =  0x00,        //32λݲ    
	BIT16    =  0x01,        //16λݽ       
    BIT08    =  0x02,        //8λݽ
	BIT01    =  0x03         //1λݽ
} AESDataType_TypeDef;

typedef struct {
	
	AESConnectMode_TypeDef  AESConnectMode;	    //ģʽ		
	AESMode_TypeDef         AESMode;	        //ģʽ
	AESDataType_TypeDef     AESDataType;	    //
} AES_InitTypeDef;

void AES_Init(AES_InitTypeDef * AES_InitStruct);         //AESʼ

void AES_Set_Key(uint32_t *key);                         //AESKEY
void AES_Set_Key_IV(uint32_t *key,uint32_t *iv);         //AESKEYIV

void AES_Get_KeyDerived(uint32_t *key_derived);          //AESȡԿ

void AES_Data_WriteRead(uint32_t *din,uint32_t*dout);    //AESд
void AES_Data_Write(uint32_t *din);                      //AESд
void AES_Data_Read(uint32_t*dout);                       //AESݶ

#endif //__BL2101_AES_H__
