#include "bl210x_test.h"
#include "bl210x_uart.h"
//#include "bl2101_timer.h"
#include "bl210x_gpio.h"
#include "bl210x_port.h"
#include "bl210x_adc.h"

#include "BL210x_iic.h"
#include "BL210x_spi.h"
#include "BL210x_wdt.h"

#include "BL210x_exti.h"

#include "common.h"
//#include "BL2102_pwmplus.h"

#include "stdio.h"
#include "uti.h"

#ifdef IC_BL2102
#include "BL2102.h"
#include "BL210x_pwmbase.h"
#include "BL210x_flash.h"
#else
#include "BL2101.h"
#include "BL2101_timer.h"
#include "BL2101_pwm.h"
#include "BL2101_rtc.h"
#include "BL210x_power.h"
#include "HS6220_RF.h"
#endif

uint16_t time_1ms = 0;              //1ms 
uint16_t time_10ms = 0;             //10ms
uint16_t time_100ms = 0;            //100ms

uint16_t Serial_timeout_1ms = 0;    //ڳʱֵ

uint8_t Rec_Data[100] = {1,2};      //յݴ
uint8_t Rec_Num = 0;                //յݸ

uint8_t * UART_TXBuffer = 0;        //
uint32_t UART_TXCount = 0;          //ݸ
uint32_t UART_TXIndex = 0;          //

uint8_t Uart_Rec_flag=0;

// =================== UART  TEST DEMO ===================================================

///
/// ڳʼ
///
void uart_init(void)
{
	UART_InitTypeDef UART_InitStruct;
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_UART0_TX;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTA1Ϊ0ķ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN1;
	PORT_InitStruct.Func = PORTA_PIN1_UART0_RX;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);     //PORTA2Ϊ0Ľ
	
	
	UART_InitStruct.Baudrate = 115200;            //115200
	UART_InitStruct.DataBits = UART_DATA_8BIT;    //λ8λ
	UART_InitStruct.Parity = UART_PARITY_NONE;    //У
	UART_InitStruct.StopBits = UART_STOP_1BIT;    //ֹͣλ1λ
	
	UART_InitStruct.RXIEn = DISABLE;                    //жʹ
	
	UART_Init(UART0,&UART_InitStruct);            //ڳʼ
}

///
/// 0жϷ
///
void UART0_Handler(void)
{
	if(UART0->LSR & UART_LSR_REC_MSK)             //Ч
	{
		Serial_timeout_1ms = 0;                   //ڳʱ0
		//time_1ms=0;
		Rec_Data[Rec_Num++] = UART0->RDR;         //ȡյ
	  //Uart_Rec_flag = 1;
		printf("Rec_Num: %d\r\n", Rec_Num); 
	}
	
	if(UART0->LSR & UART_LSR_TEMT_MSK)            //
	{
		if(UART_TXIndex < UART_TXCount)
		{
			UART_SendData(UART0, UART_TXBuffer[UART_TXIndex]);
			UART_TXIndex++;
		}
		else
		{
			UART0->IE &= ~(0x01 << UART_IE_TXE_POS);    //رշж
		}
	}
}

///
/// жϷʽ
///
void UART_SendChars(uint8_t data[], uint32_t len)
{
	UART_TXBuffer = data;
	UART_TXCount = len;
	UART_TXIndex = 0;
	
	UART0->IE |= 0x01 << UART_IE_TXE_POS;
	NVIC_EnableIRQ(UART0_IRQn);
}



///
/// ڲԳ    
///
void uart_test_tx_rx(uint8_t senddata)
{
//	uint8_t k = 0;
	
	if(Serial_timeout_1ms > 10)                        //ڳʱ10ms
	{
		
		if(Rec_Num == 0)                               //ûյ0
		{
			Serial_timeout_1ms = 0;
		}
		else                                           //յ
		{
			printf("hell33o\r\n");
			Serial_timeout_1ms = 0;                    //ʱ0
			
			//for(k = 0; k < Rec_Num;k++)
			//{
			//	UART_SendData(UART0, Rec_Data[k]);     //ѯʽ 
			//}
			
			UART_SendChars(Rec_Data,Rec_Num);          //жϷʽ 
			
			Rec_Num = 0;	
		}
	}
}


/******************************************************************************************************************************************
* : fputc()
* ˵: printf()ʹô˺ʵʵĴڴӡ
*     : int ch		Ҫӡַ
*			FILE *f		ļ
*     : 
* ע: 
******************************************************************************************************************************************/
int fputc(int ch, FILE *f)
{
	UART_SendData(UART0,ch);
    return ch;
}
// =================== END OF UART  TEST DEMO ===================================================


// =================== TIMER  TEST DEMO ===================================================
#if TIMER_TEST

void timer_1ms_init(void)
{
#ifdef IC_BL2101
	  // 16λʱʼ
    TIMER_Init(TIMER_LOW16BIT,1000,1);      //16λʱ   ʱʱ1ms     TIMER_Start(TIMER_LOW16BIT);            //16λʱ
		 TIMER_Start(TIMER_LOW16BIT);
	#else
	TIMPLUS_CommonInitTypeDef  TIMPLUS_CommonInitStruct = {0};

	TIMPLUS_CommonInitStruct.ClkDiv = SystemCoreClock/1000000 - 1;    //õ1usļʱʱ
	TIMPLUS_CommonInitStruct.Mode = TIMER_MODE;                       //ʱģʽ
	TIMPLUS_CommonInitStruct.ClkSel = SYSCLK_DIV;                     //ʱԴѡϵͳʱӷƵ
	TIMPLUS_CommonInitStruct.Period = 1000;                           //Ϊ1000ҲǶʱ1ms
	TIMPLUS_CommonInitStruct.OutEn = DISABLE;                         //
	TIMPLUS_CommonInitStruct.Ovf_IE = ENABLE;                         //жʹ
	
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_LOW,&TIMPLUS_CommonInitStruct);
	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW);                              //ʱ
	
#endif
}
#ifdef IC_BL2102
void TIMPLUS0_Handler(void)
{

	if(TIMPLUS0->IF & TIMPLUS_IF_LOW_OVF_MSK)
	{
		TIMPLUS0->IF = (0x01 << TIMPLUS_IF_LOW_OVF_POS);              //ʱж״̬
		
		time_1ms++;
		if(time_1ms>1000)
		{
			time_1ms=0;
		}
	}
}

#endif
#ifdef IC_BL2101
//16λʱʼ
void TIMER_L16_Init(void)
{
   TIMER_Init(TIMER_LOW16BIT,100,ENABLE);      //16λʱ   ʱʱ1ms   ж
   TIMER_Start(TIMER_LOW16BIT);                 //16λʱ
}
///
/// 16λʱʼ
///
void TIMER_H16_Init(void)
{
   TIMER_Init(TIMER_HIGH16BIT,10000,1);    //16λʱ   ʱʱ10ms   ж
   TIMER_Start(TIMER_HIGH16BIT);           //16λʱ
	
}

///
/// 32λʱʼ
///
void TIMER_HL32_Init(void)
{
	TIMER_Init(TIMER_32BIT,100000,1);      //32λʱ   ʱʱ100ms   ж
   TIMER_Start(TIMER_32BIT);              //32λʱ
}

///
/// ʱжϷ
///
void TIMER_Handler(void)
{
	if(TIMER_INTStat(TIMER_LOW16BIT))          //жϵ16λʱжϱ־ǷΪ1
	{
		TIMER_INTClr(TIMER_LOW16BIT);          //16λʱжϱ־
		LED3_ON;
		time_1ms++;                            //1ms1
	//	LED1_TOGGLE;
		LED3_OFF;
	}

	if(TIMER_INTStat(TIMER_HIGH16BIT))         //жϸ16λʱжϱ־ǷΪ1  
	{
		TIMER_INTClr(TIMER_HIGH16BIT);         //16λʱжϱ־
		
		time_10ms++;                           //10ms1
	}

	if(TIMER_INTStat(TIMER_32BIT))             //ж32λʱжϱ־ǷΪ1          
	{
		TIMER_INTClr(TIMER_32BIT);             //32λʱжϱ־
		
		time_100ms++;                          //100ms1
	}
}
#endif
void timer_test(void)
{
	timer_1ms_init();
}
#endif
// =================== END OF TIMER  TEST DEMO ===================================================

#if ADC_TEST
// =================== ADC  TEST DEMO ===================================================

#define adc_data_size  100

uint16_t Adc_Data[adc_data_size] = {0};     //ADCջ
uint16_t Adc_Num = 0;              //ADCֽڼ
uint8_t Flag_ADC_Over = 0;         //ADCɼɱ־

uint8_t Flag_Int = 0;              //жϲű־

uint16_t Fifo_Cnt0 = 0;            //ͨ0
uint16_t Fifo_Cnt1 = 0;            //ͨ1


///
/// ADC_VDDβѯģʽʼ
///
void ADC_VDD_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH8;                     //ADCתͨѡCH8
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_64;     //ⲿ
	ADC_initStruct.Vref = VREF_IN;                         //ADCοԴѡڲο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 1;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 1;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

///
/// ADC_VDDβѯģʽ
///
void ADC_VDD_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH8) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH8);                              //ȡת
	
	data = (data*3*1400)>>12;                              //תΪʵʵĵѹֵ λΪmV   ڲ1/3ѹвɼ
	
	printf("%d,",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת
}
   

///
/// ͨβѯģʽʼ
///
void SingleChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

#ifdef IC_BL2102	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH6;                     //ADCתͨѡCH7 CH6
	
//	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
//	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;    //ⲿ
	ADC_initStruct.Vref = VREF_IN;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 1;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
#else
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTB5ΪADCͨ0
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;      //ⲿ
	ADC_initStruct.Vref = VREF_IN;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 1;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
#endif	
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}



///
/// ͨβѯģʽ
///
void SingleChn_Single_Check_Devote(void)
{
	uint16_t data = 0;
	while(ADC_IsEOC(ADC_CH0) == 0);                        //ȴת
	data = ADC_Read(ADC_CH0);                              //ȡת
	printf("%d,",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת
}


///
/// ͨѯģʽʼ
///
void SingleChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTB5ΪADCͨ0
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}


///
/// ͨѯģʽ
///
void SingleChn_Continue_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH0) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH0);                              //ȡת
	
	printf("%d,",data);                                    //ӡת   
}


///
/// ͨβжģʽʼ
///
void SingleChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH0;                      //ͨ0תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 1;
	
	ADC_Start();                                           //ADCת
}

///
/// ͨβжģʽ
///
void SingleChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                        //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< adc_data_size; i++)
        {
            printf("%d,",Adc_Data[i]);            //ӡ
        }
		
		    ADC_Start();                              //ת
    }
}

///
/// ͨжģʽʼ
///
void SingleChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH0;                      //ͨ0תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 2;
	
	ADC_Start();                                           //ADCת
}


///
/// ͨжģʽ
///
void SingleChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                           //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< adc_data_size; i++)
        {
            printf("%d,",Adc_Data[i]);               //ӡ
        }
		
		    ADC_Start();                                 //ת
    }
}

///
/// ͨβѯģʽʼ
///
void MultiChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת     
}

///
/// ͨβѯģʽ
///
void MultiChn_Single_check_Devote(void)
{
	uint16_t data = 0;
	

	while(ADC_IsEOC(ADC_CH1) == 0);                        //ȴͨ1ת   
	
	data = ADC_Read(ADC_CH0);                              //ȡͨ0ת
	
	printf("CH0:%d\r\n",data);                             //ӡͨ0ת 
	
	data = ADC_Read(ADC_CH1);                              //ȡͨ1ת
	
	printf("CH1:%d\r\n",data);                             //ӡͨ1ת 
	
	ADC_Start();                                           //ADCת
}

///
/// ͨѯģʽʼ
///
void MultiChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;
#ifdef IC_BL2102
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH6 | ADC_CH7 ;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
#else
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1 ;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_IN;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 1;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
		
#endif	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

///
/// ͨѯģʽ
///
void MultiChn_Continue_check_Devote(void)
{
	uint16_t data = 0;
	printf("CH68:%d\r\n",data); 
	while(ADC_IsEOC(ADC_CH7) == 0);                        //ȴͨ1ת   

	data = ADC_Read(ADC_CH6);                              //ȡͨ0ת
	
	printf("CH6:%d\r\n",data);                             //ӡͨ0ת 
	
	data = ADC_Read(ADC_CH7);                              //ȡͨ1ת
	
	printf("CH7:%d\r\n",data);                             //ӡͨ1ת 
}


///
/// ͨβжģʽʼ
///
void MultiChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH1;                      //ͨ1תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 3;
	
	ADC_Start();                                           //ADCת    
}

///
/// ͨβжģʽ
///
void MultiChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i]);             //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i+adc_data_size/2]);        //ӡͨ1ת 
        }
		    printf("\r\n");
		
		ADC_Start();                              //ADCת 
    }
}

///
/// ͨжģʽʼ
///
void MultiChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH1;                      //ͨ1תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 4;
	
	ADC_Start();                                           //ADCת    
}

///
/// ͨжģʽ
///
void MultiChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i]);            //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i+adc_data_size/2]);       //ӡͨ1ת 
        }
		    printf("\r\n");
		
		    ADC_Start();                             //ADCת 
    }
}

///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_Full_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = ENABLE;                      //FIFOжʹ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 5;
	
	ADC_Start();                                           //ADCת   
}


///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_HalfFull_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = ENABLE;                  //FIFOжʹ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 6;
	
	ADC_Start();                                           //ADCת 
}


///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_Ovf_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = ENABLE;                       //FIFOжʹ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 7;
	
	ADC_Start();                                           //ADCת 
}


///
/// ͨFIFOжģʽ
///
void MultiChn_Continue_FIFO_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< 49; i++)
        {
			      printf("%d,",Adc_Data[i]);              //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< 49; i++)
        {
			      printf("%d,",Adc_Data[i+50]);         //ӡͨ1ת 
        }
		    printf("\r\n");
		
		    ADC_Start();                               //ADCת 
    }
}

///
/// ADCжϴ
///
void ADC_Handler(void)
{
	uint16_t Fifo_Data[9] = {0};
	uint8_t j = 0;
	
	if(Flag_Int == 1 || Flag_Int == 2)                 //ADCͨж  ͨж
	{
		   Adc_Data[Adc_Num++] = ADC_Read(ADC_CH0);
		
		   if(Adc_Num >= adc_data_size)
		   {
			     Adc_Num = 0;
			
			     Flag_ADC_Over = 1;
		   }
	}
	else if(Flag_Int == 3 || Flag_Int == 4)           //ADCͨж  ͨж
	{
		  Adc_Data[Adc_Num] = ADC_Read(ADC_CH0);
		  Adc_Data[Adc_Num + adc_data_size/2] = ADC_Read(ADC_CH1);
		
		  Adc_Num++;
		
		  if(Adc_Num >= adc_data_size/2)
		  {
			    Adc_Num = 0;
			
			    Flag_ADC_Over = 1;
		  }
	}
	else if(Flag_Int == 5)                            //ADCͨFIFOж
	{
		if(ADC_IntFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntFULLClr();
		}
	}
	else if(Flag_Int == 6)                     //ADCͨFIFOж
	{
		if(ADC_IntHALFFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,5);
			
			for(j = 0;j < 5;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntHALFFULLClr();
		}
	}
	else if(Flag_Int == 7)                  //ADCͨFIFOж
	{
		if(ADC_IntOVFStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntOVFClr();
		}
	}
	
	if(Flag_Int == 1 || Flag_Int == 3)          //ADCͨж  ͨж
	{
		if(Flag_ADC_Over == 0)
		{
			ADC_Start();	
		}
	}
	else if(Flag_Int == 2 || Flag_Int == 4)    //ADCͨж   ͨж
	{
		if(Flag_ADC_Over == 1)
		{
			ADC_Stop();	
		}
	}
}


void adc_test(void)
{

	//ADC_VDD_Check_Init();                                     //ADC_VDDβѯģʽʼ
	SingleChn_Single_Check_Init();                          //ͨβѯģʽʼ
	//SingleChn_Continue_Check_Init();                        //ͨѯģʽʼ
	//SingleChn_Single_Interrupt_Init();                      //ͨβжģʽʼ
	//SingleChn_Continue_Interrupt_Init();                    //ͨжģʽʼ
	//MultiChn_Single_Check_Init();                           //ͨβѯģʽʼ
	//MultiChn_Continue_Check_Init();                         //ͨѯģʽʼ
	//MultiChn_Single_Interrupt_Init();                       //ͨβжģʽʼ
	//MultiChn_Continue_Interrupt_Init();                     //ͨжģʽʼ
	//MultiChn_Continue_Full_Interrupt_Init();                //ͨFIFOжģʽʼ
	//MultiChn_Continue_HalfFull_Interrupt_Init();            //ͨFIFOжģʽʼ
	//MultiChn_Continue_Ovf_Interrupt_Init();                 //ͨFIFOжģʽʼ

	while(1)
	{
		 
		//ADC_VDD_Check_Devote();                               //ADC_VDDβѯģʽ
		SingleChn_Single_Check_Devote();                    //ͨβѯģʽ
		//SingleChn_Continue_Check_Devote();                  //ͨѯģʽ
		//SingleChn_Single_Interrupt_Devote();                //ͨβжģʽ
		//SingleChn_Continue_Interrupt_Devote();              //ͨжģʽ		
		//MultiChn_Single_check_Devote();                     //ͨβѯģʽ
	
		//MultiChn_Continue_check_Devote();	                  //ͨѯģʽ
		//MultiChn_Single_Interrupt_Devote();                 //ͨβжģʽ
		//MultiChn_Continue_Interrupt_Devote();               //ͨжģʽ
		//MultiChn_Continue_FIFO_Interrupt_Devote();          //ͨFIFOжģʽ
		Delay1ms(100);
	}	
}

// =================== END OF ADC  TEST DEMO ===================================================
#endif

//LED IOʼ
void led_init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = LED1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/

	
	GPIO_InitStruct.Pin = LED2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = LED3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/


	GPIO_InitStruct.Pin = LED4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
			
	LED1_OFF;       
	LED2_OFF;
	LED3_OFF;
	LED4_OFF;		
}

// =================== start of flash ReadWrite TEST DEMO =====================================
#if FLASH_TEST
#define CODE_ADDR   0x3000    

uint32_t wdata[64] = {0};
/****************************************************************************************************************************************** 
* : FLASH_SingleRead()
* ˵:	FLASH߶ݲӡ   ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_SingleRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_SingleReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_DualRead()
* ˵:	FLASH˫߶ݲӡ    ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_DualRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_DualReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_QuadRead()
* ˵:	FLASH߶ݲӡ    ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_QuadRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_QuadReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_SingleReadWrite()
* ˵:	FLASH߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_SingleReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_SingleReadData,FLASH_CLKDIV_1);   //FLASHʼ  ߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);    //ҳ
	
	FLASH_SingleRead();                                //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_SinglePageProgram,CODE_ADDR + k*4,k);   //д
	}
	
	FLASH_SingleRead();                                 //߶ӡ
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);   //
	
	FLASH_SingleRead();                                 //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;             
	}
	
	FLASH_Write_Words(FLASH_SinglePageProgram,CODE_ADDR,wdata,64);   //д
	
	FLASH_SingleRead();                                              //߶ӡ
}

/****************************************************************************************************************************************** 
* : FLASH_DualReadWrite()
* ˵:	FLASH˫߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_DualReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_DualReadData,FLASH_CLKDIV_1);               //FLASHʼ  ˫߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);              //ҳ
	
	FLASH_DualRead();                                            //˫߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_DualPageProgram,CODE_ADDR + k*4,k);     //˫д
	}
	
	FLASH_DualRead();                                                  //˫߶ӡ
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);                  //
	
	FLASH_DualRead();                                                  //˫߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;
	}
	
	FLASH_Write_Words(FLASH_DualPageProgram,CODE_ADDR,wdata,64);  //˫д
	
	FLASH_DualRead();                               //˫߶ӡ
}

/****************************************************************************************************************************************** 
* : FLASH_QuadReadWrite()
* ˵:	FLASH߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_QuadReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_QuadReadData,FLASH_CLKDIV_1);                      //FLASHʼ  ߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);                     //ҳ
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_QuadPageProgram,CODE_ADDR + k*4,k);      //д
	}
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);                   //
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;
	}
	
	FLASH_Write_Words(FLASH_QuadPageProgram,CODE_ADDR,wdata,64);        //д
	
	FLASH_QuadRead();                                                   //߶ӡ
}

void eflash_test(void)
{
	
	printf("SingleReadWrite\r\n");
	printf("\r\n");
	
	FLASH_SingleReadWrite();            //߶дFLASH
	
	printf("\r\n");
	printf("DualReadWrite\r\n");
	printf("\r\n");
	
	FLASH_DualReadWrite();             //˫߶дFLASH
	
	printf("\r\n");
	printf("QuadReadWrite\r\n");
	printf("\r\n");
	
	FLASH_QuadReadWrite();            //߶дFLASH
	
    while(1)
    {
			
	
    }
}
#endif
// =================== start of flash ReadWrite TEST DEMO =====================================
// =================== start of lowpower TEST DEMO =====================================
#if LOWPOWER_TEST

#define WAKEUP_GPIO_PORT    GPIOB		                
#define WAKEUP_GPIO_PIN		GPIO_PIN0			     

void Wakeup_IO_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStruct = {0};          /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = WAKEUP_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;               //   
	
	GPIO_InitStruct.WakeUp_En = WAKEUP_ENABLE;       //ѹʹ
	
	GPIO_Init(WAKEUP_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
    
	PORT->PORT_CFG &= ~(0x01 << PORT_CFG_WKRF_POS);  //½ػ	
}
uint8_t Flag_Second = 0;         //жϱ־
uint8_t Flag_Alarm = 0;          //жϱ־
uint8_t Flag_OverFlow = 0;       //жϱ־

//RTCʼ
void RTC_Test(void)
{
	RTC_InitTypeDef RTC_InitStruct;

	RTC_InitStruct.Second = 320000;           //Ĵֵ
	RTC_InitStruct.Alarm  = 640000;          //ӼĴֵ
	RTC_InitStruct.Second_IE = ENABLE;        //жʹ
	RTC_InitStruct.Alarm_IE = ENABLE;         //жʹ
	RTC_InitStruct.OverFlow_IE = ENABLE;      //жʹ
	
	RTC_Init(&RTC_InitStruct);                //RTCʼ
	
	RTC_Start();                              //RTC
}

//RTCжϷ
void RTC_Handler(void)
{
	if(RTC_IntSecondStat())             //ж״̬Ϊ1
	{
		RTC_IntSecondClr();             //ж״̬
		
		Flag_Second = 1;                //жϱ־1
	}

	if(RTC_IntAlarmStat())              //ж״̬Ϊ1
	{
		RTC_IntAlarmClr();              //ж״̬
		
		Flag_Alarm = 1;                 //жϱ־1
	}

	if(RTC_IntOverFlowStat())           //ж״̬Ϊ1
	{
		RTC_IntOverFlowClr();           //ж״̬
		
		Flag_OverFlow = 1;              //жϱ־1
	}
}

uint8_t Flag_Wakeup = 0;
volatile uint8_t Wakeup_state = 0;
void lowpower_test(void)
{
	uint8_t Delay_Cnt = 0;	
		led_init();  
	Flag_Wakeup = 5;    //޸ͿԲԲͬĻģʽ  0---9
	printf("Test_RAM:%d\r\n",Wakeup_state);
    while(1)
    {
		Delay1ms(300);
		Delay1ms(200);
		
        Delay_Cnt++;

        if(Delay_Cnt >= 5)
        {
            Delay_Cnt = 0;
			
			Wakeup_state = *((volatile unsigned int *)(0x20000b00));
			
			printf("Test_RAM1:%d\r\n",Wakeup_state);
        }

        switch(Delay_Cnt)
        {
            case 0:
                LED1_OFF;
                LED2_OFF;
                LED3_OFF;
                LED4_OFF;
            break;
            
            case 1:
                LED1_ON;
                LED2_OFF;
                LED3_OFF;
                LED4_OFF;
            break;
            
            case 2:
                LED1_OFF;
                LED2_ON;
                LED3_OFF;
                LED4_OFF;
            break;
            
            case 3:
                LED1_OFF;
                LED2_OFF;
                LED3_ON;
                LED4_OFF;
            break;
            
            case 4:
                LED1_OFF;
                LED2_OFF;
                LED3_OFF;
                LED4_ON;
            break;
        }
		
		if(Flag_Wakeup == 0)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_ALARM);                     //RTCӻʹ
				
				Enter_LowPower_Mode(MODE_STANDBY);                         //ϵͳSTANDBYģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_ALARM))                       //жǷRTCӻѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_ALARM);                      //RTCӻѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 1)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_SECOND);                    //RTC뻽ʹ
				
				Enter_LowPower_Mode(MODE_STANDBY);                         //ϵͳSTANDBYģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_SECOND))                      //жǷRTC뻽ѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_SECOND);                     //RTC뻽ѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 2)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_ALARM);                     //RTCӻʹ
				
				Enter_LowPower_Mode(MODE_SLEEP);                           //ϵͳSLEEPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_ALARM))                       //жǷRTCӻѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_ALARM);                      //RTCӻѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 3)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_SECOND);                    //RTC뻽ʹ
				
				Enter_LowPower_Mode(MODE_SLEEP);                           //ϵͳSLEEPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_SECOND))                      //жǷRTC뻽ѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_SECOND);                     //RTC뻽ѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 4)
		{
			if(Delay_Cnt == 0)
			{
				Wakeup_IO_Init();                                          //IOųʼ
				
				WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
				
				Enter_LowPower_Mode(MODE_STANDBY);                         //ϵͳSTANDBYģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
			{
				WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
				
				LED1_OFF;                                
                LED2_ON;
                LED3_ON;
                LED4_OFF;
			}
		}
		else if(Flag_Wakeup == 5)
		{
			if(Delay_Cnt == 0)
			{
				Wakeup_IO_Init();                                          //IOųʼ
				printf("sleep io\r\n");
				WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
				
				Enter_LowPower_Mode(MODE_SLEEP);                           //ϵͳSLEEPģʽ
				printf("sleep11 io\r\n");
			}
			
			if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
			{
				WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
				
				LED1_ON;
                LED2_OFF;
                LED3_OFF;
                LED4_ON;
			}
		}
		else if(Flag_Wakeup == 6)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_ALARM);                     //RTCӻʹ

				Wakeup_state++;
				*((volatile unsigned int *)(0x20000b00)) = Wakeup_state;
				
				Enter_LowPower_Mode(MODE_DEEPSLEEP);                       //ϵͳDEEPSLEEPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_ALARM))                       //жǷRTCӻѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_ALARM);                      //RTCӻѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 7)
		{
			if(Delay_Cnt == 0)
			{
				RTC_Test();                                                //RTCʼ
				
				WakeUp_Style_Enable(WAKEUP_RTC_SECOND);                    //RTC뻽ʹ
				
				Enter_LowPower_Mode(MODE_DEEPSLEEP);                       //ϵͳDEEPSLEEPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_RTC_SECOND))                      //жǷRTC뻽ѱ־
			{
				WakeUp_State_Clear(WAKEUP_RTC_SECOND);                     //RTC뻽ѱ־
				
				RTC_Stop();                                                //RTCر
			}
		}
		else if(Flag_Wakeup == 8)
		{
			if(Delay_Cnt == 0)
			{
				Wakeup_IO_Init();                                          //IOųʼ
				
				WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
				
				Enter_LowPower_Mode(MODE_DEEPSLEEP);                       //ϵͳDEEPSLEEPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
			{
				WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
				
				LED1_ON;
                LED2_OFF;
                LED3_OFF;
                LED4_ON;
			}
		}
		else if(Flag_Wakeup == 9)
		{
			if(Delay_Cnt == 0)
			{
				Wakeup_IO_Init();                                          //IOųʼ
				
				WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
				
				Enter_LowPower_Mode(MODE_STOP);                            //ϵͳSTOPģʽ
			}
			
			if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
			{
				WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
				
				LED1_ON;
                LED2_OFF;
                LED3_OFF;
                LED4_ON;
			}
		}
    }

}
#endif

// =================== END of lowpower TEST DEMO =====================================
// =================== start of IIC TEST DEMO =====================================
#if IIC_TEST

#ifdef IC_BL2101
/*
*********************************************************************************************************
*	  : AT24CXX_Init
*	˵: AT24CXXʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void AT24CXX_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
#ifdef IC_BL2102	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTA_PIN4_IIC_SCL;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA4ΪIICʱ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_IIC_SDA;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA3ΪIIC
#else
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN14;
	PORT_InitStruct.Func = PORTA_PIN14_IIC_SCL;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA14ΪIICʱ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Func = PORTA_PIN15_IIC_SDA;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA15ΪIIC
	
#endif	

	IIC_Init(IIC0,400,DISABLE);           //IICʱΪ400K  ѯʽ
	
	IIC_Open(IIC0);                       //IIC
}

/*
*********************************************************************************************************
*	  : AT24CXX_WaitNACK
*	˵: ȴACKźţNACKֹͣź  ACKִ
*	    Σuint8_t nack    0 ʾNACK    1ʾACK
*	  ֵ: 0 ִ  1ʾִֹͣУ
*********************************************************************************************************
*/
uint8_t AT24CXX_WaitNACK(uint8_t nack)
{
	if(nack == 0)
	{
		IIC_Stop(IIC0);
		Delay1ms(1);
		
		return 1;
	}
	
	return 0;
}


/*
*********************************************************************************************************
*	  : AT24CXX_ReadBytes
*	˵: ӴEEPROMַָʼȡ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  ReadBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_ReadBytes(uint16_t Address,uint8_t *ReadBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint8_t Rec = 0;
	
    /* ôEEPROMȡָУȡֽ */

    /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
   
	if(EE_TYPE > AT24C16)
    {
        Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Rec = IIC_Write(IIC0,Address>>8);
    }
    else
    {
        Rec = IIC_Start(IIC0,(EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Address>>8)<<1));
    }

    /* 2ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */

	Rec = IIC_Write(IIC0,Address%256);
	
    /* 4ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    /* 5I2CߡǰĴĿEEPROM͵ַ濪ʼȡ
    ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ*/
    
	Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_RD);

    /* 6ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 7ѭȡ */
    
	for (i = 0; i < Size; i++)
    {
        /* ÿ1ֽںҪAck һֽڲҪAckNack */
        if (i != Size - 1)
        {
            ReadBuf[i] = IIC_Read(IIC0,ACK);     /* мֽڶCPUACKź(SDA = 0) */	
        }
        else
        {
            ReadBuf[i] = IIC_Read(IIC0,NACK);
        }
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop(IIC0);
    Delay1ms(1);
    return 1;	/* ִгɹ */
}

/*
*********************************************************************************************************
*	  : AT24CXX_WriteBytes
*	˵: EEPROMַָдݣҳддЧ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  WriteBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_WriteBytes(uint16_t Address,uint8_t *WriteBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint16_t Addr;
	uint8_t Rec = 0;
	
    /*
    	дEEPROMȡֽܶڣÿдֻͬһpage
    	24c02page size = 8
    	򵥵ĴΪֽдģʽÿд1ֽڣ͵ַ
    	ΪдЧ: page write
    */

    Addr = Address;
	
    for (i = 0; i < Size; i++)
    {
        /* ͵1ֽڻҳ׵ַʱҪ·źź͵ַ */
        if ((i == 0) || (Addr & (EEPROM_PAGE_SIZE - 1)) == 0)
        {
            /*ڣֹͣźţڲд*/
            IIC_Stop(IIC0);
            Delay1ms(10);

            /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
            if(EE_TYPE > AT24C16)
            {
                Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
				if(AT24CXX_WaitNACK(Rec))
				{
					return 0;
				}
				
				Rec = IIC_Write(IIC0,Addr>>8);
            }
            else
            {
                Rec = IIC_Start(IIC0,(EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Addr>>8)<<1));
            }

            /* 2ȴACK */
			
            if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}

            /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */
            Rec = IIC_Write(IIC0,Addr%256);
	
			/* 4ȴACK */
			
			if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}
        }

        /* 5ʼд */ 
		
		Rec = IIC_Write(IIC0,WriteBuf[i]);

        /* 6ȴACK */
        
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Addr++;	/* ַ1 */
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop(IIC0);
    Delay1ms(10);

    return 1;
}

/*
*********************************************************************************************************
*	  : IIC_CheckDevice
*	˵: I2C豸CPU豸ַȻȡ豸Ӧжϸ豸Ƿ
*	  ֵ: ֵ 1 ʾȷ 0ʾδ̽⵽
*********************************************************************************************************
*/
uint8_t IIC_CheckDevice(void)
{
    uint8_t Rec = 0;
	
	Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    IIC_Stop(IIC0);
    Delay1ms(1);

    return 1;
}


uint8_t buf[EEPROM_SIZE];

/******AT24CXXȫ******/
void AT24CXX_FullErase(void)
{
    uint16_t i;

    /* 仺 */
    for (i = 0; i < EEPROM_SIZE; i++)
    {
        buf[i] = 0xFF;
    }

    /* дEEPROM, ʼַ = 0ݳΪ 256 */
    if (AT24CXX_WriteBytes(0, buf, EEPROM_SIZE) == 0)
    {
        printf("eeprom\r\n");
    }
    else
    {
        printf("eepromɹ\r\n");
    }
}


#else
/*
*********************************************************************************************************
*	  : AT24CXX_Init
*	˵: AT24CXXʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void AT24CXX_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN14;
	PORT_InitStruct.Func = PORTA_PIN14_IIC_SCL;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA14ΪIICʱ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Func = PORTA_PIN15_IIC_SDA;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA15ΪIIC

//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN0;
//	PORT_InitStruct.Func = PORTB_PIN0_IIC_SCL;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN1;
//	PORT_InitStruct.Func = PORTB_PIN1_IIC_SDA;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);

	IIC_Init(400,DISABLE);                  //IICʱΪ400K  ѯʽ
	
	IIC_Open();                       //IIC
}

/*
*********************************************************************************************************
*	  : AT24CXX_WaitNACK
*	˵: ȴACKźţNACKֹͣź  ACKִ
*	    Σuint8_t nack    0 ʾNACK    1ʾACK
*	  ֵ: 0 ִ  1ʾִֹͣУ
*********************************************************************************************************
*/
uint8_t AT24CXX_WaitNACK(uint8_t nack)
{
	if(nack == 0)
	{
		IIC_Stop();
		delay_ms(1);
		
		return 1;
	}
	
	return 0;
}


/*
*********************************************************************************************************
*	  : AT24CXX_ReadBytes
*	˵: ӴEEPROMַָʼȡ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  ReadBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_ReadBytes(uint16_t Address,uint8_t *ReadBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint8_t Rec = 0;
	
    /* ôEEPROMȡָУȡֽ */

    /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
   
	if(EE_TYPE > AT24C16)
    {
        Rec = IIC_Start(EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Rec = IIC_Write(Address>>8);
    }
    else
    {
        Rec = IIC_Start((EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Address>>8)<<1));
    }

    /* 2ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */

	Rec = IIC_Write(Address%256);
	
    /* 4ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    /* 5I2CߡǰĴĿEEPROM͵ַ濪ʼȡ
    ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ*/
    
	Rec = IIC_Start(EEPROM_DEV_ADDR | EEPROM_I2C_RD);

    /* 6ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 7ѭȡ */
    
	for (i = 0; i < Size; i++)
    {
        /* ÿ1ֽںҪAck һֽڲҪAckNack */
        if (i != Size - 1)
        {
            ReadBuf[i] = IIC_Read(ACK);     /* мֽڶCPUACKź(SDA = 0) */	
        }
        else
        {
            ReadBuf[i] = IIC_Read(NACK);
        }
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop();
    delay_ms(1);
    return 1;	/* ִгɹ */
}

/*
*********************************************************************************************************
*	  : AT24CXX_WriteBytes
*	˵: EEPROMַָдݣҳддЧ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  WriteBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_WriteBytes(uint16_t Address,uint8_t *WriteBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint16_t Addr;
	uint8_t Rec = 0;
	
    /*
    	дEEPROMȡֽܶڣÿдֻͬһpage
    	24c02page size = 8
    	򵥵ĴΪֽдģʽÿд1ֽڣ͵ַ
    	ΪдЧ: page write
    */

    Addr = Address;
	
    for (i = 0; i < Size; i++)
    {
        /* ͵1ֽڻҳ׵ַʱҪ·źź͵ַ */
        if ((i == 0) || (Addr & (EEPROM_PAGE_SIZE - 1)) == 0)
        {
            /*ڣֹͣźţڲд*/
            IIC_Stop();
            delay_ms(10);

            /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
            if(EE_TYPE > AT24C16)
            {
                Rec = IIC_Start(EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
				if(AT24CXX_WaitNACK(Rec))
				{
					return 0;
				}
				
				Rec = IIC_Write(Addr>>8);
            }
            else
            {
                Rec = IIC_Start((EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Addr>>8)<<1));
            }

            /* 2ȴACK */
			
            if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}

            /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */
            Rec = IIC_Write(Addr%256);
	
			/* 4ȴACK */
			
			if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}
        }

        /* 5ʼд */ 
		
		Rec = IIC_Write(WriteBuf[i]);

        /* 6ȴACK */
        
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Addr++;	/* ַ1 */
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop();
    delay_ms(10);

    return 1;
}

/*
*********************************************************************************************************
*	  : IIC_CheckDevice
*	˵: I2C豸CPU豸ַȻȡ豸Ӧжϸ豸Ƿ
*	  ֵ: ֵ 1 ʾȷ 0ʾδ̽⵽
*********************************************************************************************************
*/
uint8_t IIC_CheckDevice(void)
{
    uint8_t Rec = 0;
	
	Rec = IIC_Start(EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    IIC_Stop();
    delay_ms(1);

    return 1;
}


uint8_t buf[EEPROM_SIZE];

/******AT24CXXȫ******/
void AT24CXX_FullErase(void)
{
    uint16_t i;

    /* 仺 */
    for (i = 0; i < EEPROM_SIZE; i++)
    {
        buf[i] = 0xFF;
    }

    /* дEEPROM, ʼַ = 0ݳΪ 256 */
    if (AT24CXX_WriteBytes(0, buf, EEPROM_SIZE) == 0)
    {
        printf("eeprom\r\n");
    }
    else
    {
        printf("eepromɹ\r\n");
    }
}


#endif 
//Ҫд뵽24c02ַ
uint8_t Send_Buffer[]={" Welcome to beijing!Welcome to CHINA!"};
#define SIZE sizeof(Send_Buffer)

uint8_t datatemp[SIZE];
uint8_t Flag_AT24CXX_OK = 0;
void i2c_test(void)
{
	AT24CXX_Init();        //AT24CXXʼ
	
    Flag_AT24CXX_OK = IIC_CheckDevice();  //I2C豸CPU豸ַȻȡ豸Ӧжϸ豸Ƿ
	
	if(Flag_AT24CXX_OK == 0x01)
	{
		printf("AT24CXX IS OK!\r\n");
	}
	else
	{
		printf("AT24CXX IS ERROR!\r\n");
	}
	
	printf("\r\n");
	
	while(1)
	{
		Delay1ms(200);
		Delay1ms(300);
		
		if(Flag_AT24CXX_OK == 1)
		{
			AT24CXX_WriteBytes(0,(uint8_t*)Send_Buffer,SIZE);      //AT24CXXд     
			AT24CXX_ReadBytes(0,datatemp,SIZE);                    //AT24CXX
			
			printf("the data is %s\r\n",datatemp);
			printf("\r\n");
			
			AT24CXX_FullErase();                                   //AT24CXXȫ
			AT24CXX_ReadBytes(0,datatemp,SIZE);                    //AT24CXX
			
			printf("data[0] is %x\r\n",datatemp[0]);
			printf("data[1] is %x\r\n",datatemp[1]);
			printf("data[2] is %x\r\n",datatemp[2]);
			printf("data[%d] is %x\r\n",SIZE-1,datatemp[SIZE - 1]);
			printf("\r\n");
		}	
	}
}

#endif
// =================== end of IIC TEST DEMO =====================================
// =================== start of IIC INT TEST DEMO ===============================
#if IIC_INT_TEST

uint8_t Flag_IIC_INT = 0;                //IICжϱ־λ

volatile uint8_t Read_Cnt = 0;           //е               
volatile uint8_t ReadBuf = 0;            //еĽ

volatile uint8_t Write_Cnt = 0;          //де   
volatile uint8_t WriteBuf = 0;           //деķ

uint8_t AT24CXX_Sel = 0;                 //AT24CXX

uint8_t data = 0;                        //д뵽AT24CXXе

uint8_t addr = 0;                        //д뵽AT24CXXеĵַ

uint8_t error = 0;                       //
/****************************************************************************************************************************************** 
* : AT24CXX_Init()
* ˵:	AT24CXXʼ
*     : 	   
*     : 
* ע: 
******************************************************************************************************************************************/
void AT24CXX_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN14;
	PORT_InitStruct.Func = PORTA_PIN14_IIC_SCL;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);     //PORTA14ΪIICʱ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Func = PORTA_PIN15_IIC_SDA;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);    //PORTA15ΪIIC

//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN0;
//	PORT_InitStruct.Func = PORTB_PIN0_IIC_SCL;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN1;
//	PORT_InitStruct.Func = PORTB_PIN1_IIC_SDA;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);
	
	

	IIC_Init(IIC0,400,ENABLE); //IICʱΪ400K  жϷʽ
	
	IIC_IntClr(IIC0);                 //жϱ־
	
	IIC_Open(IIC0);                   //IIC
}

/*
*********************************************************************************************************
*	  : AT24CXX_WaitNACK
*	˵: ȴACKźţNACKֹͣź  ACKִ
*	    Σuint8_t nack    0 ʾNACK    1ʾACK
*	  ֵ: 0 ִ  1ʾִֹͣУ
*********************************************************************************************************
*/
uint8_t AT24CXX_WaitNACK(void)
{
	if(IIC0->SR & IIC_SR_RACK_MSK)
	{
		IIC_Stop(IIC0);
		Delay1ms(1);
		
		return 1;
	}
	
	return 0;
}


///IICжϷ
void IIC_Handler(void)
{
	if(IIC_IntStat(IIC0))
	{
		IIC_IntClr(IIC0);
		
		Flag_IIC_INT = 1;
	}
}


/*
*********************************************************************************************************
*	  : AT24CXX_ReadBytes
*	˵: ӴEEPROMַָʼȡ
*	    ΣAddress : ʼַ
*			  ReadBuf : Ŷ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_ReadByte(uint16_t Address)
{
    if(Read_Cnt == 0)
	{
		/* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
		IIC_Start_NoWait(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		Read_Cnt = 1;
		Delay1ms(1);
	}
	else if(Read_Cnt == 1)
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 2ȴACK */
			if(AT24CXX_WaitNACK())
			{
				Read_Cnt = 0;
				return 0;
			}
			else
			{
				/* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */

				IIC_Write_NoWait(IIC0,Address);
				Read_Cnt = 2;
			}	
		}	
	}
	else if(Read_Cnt == 2)
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 4ȴACK */ 
			if(AT24CXX_WaitNACK())
			{
				Read_Cnt = 0;
				return 0;
			}
			else
			{
				/* 5I2CߡǰĴĿEEPROM͵ַ濪ʼȡ
			   ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ*/

				IIC_Start_NoWait(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_RD);
				Read_Cnt = 3;
			}	
		}	
	}
	else if(Read_Cnt == 3)			
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 6ȴACK */
			if(AT24CXX_WaitNACK())
			{
				Read_Cnt = 0;
				return 0;
			}
			else
			{
				/* 7ȡ */

				IIC_Read_NoWait(IIC0,NACK); 
				Read_Cnt = 4;
			}	
		}	
	}
	else if(Read_Cnt == 4)	
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 9ȡ */

			ReadBuf = IIC0->RXR; 
			
			/* ִгɹI2Cֹͣź */
			IIC_Stop(IIC0);
			Delay1ms(10);
			
			Read_Cnt = 0;
			
			return 1;	/* ִгɹ */
		}
	}

	return 0;
}

/*
*********************************************************************************************************
*	  : AT24CXX_WriteBytes
*	˵: EEPROMַָдݣҳддЧ
*	    ΣAddress : ʼַ
*			  WriteBuf : Ŷ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_WriteByte(uint16_t Address)
{
	if(Write_Cnt == 0)
	{
		/* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
		IIC_Start_NoWait(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		Write_Cnt = 1;
		Delay1ms(1);
	}
	else if(Write_Cnt == 1)
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
	
			/* 2ȴACK */
			if(AT24CXX_WaitNACK())
			{
				Write_Cnt = 0;
				
				return 0;
			}
			else
			{
				/* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */

				IIC_Write_NoWait(IIC0,Address);
				Write_Cnt = 2;
			}
		}	
	}
	else if(Write_Cnt == 2)
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 4ȴACK */
			if(AT24CXX_WaitNACK())
			{
				Write_Cnt = 0;
				return 0;
			}
			else
			{
				/* 5ʼд */ 

				IIC_Write_NoWait(IIC0,WriteBuf);
				Write_Cnt = 3;
			}	
		}	
	}
	else if(Write_Cnt == 3)
	{
		if(Flag_IIC_INT == 1)
		{
			Flag_IIC_INT = 0;
			
			/* 6ȴACK */
			if(AT24CXX_WaitNACK())
			{
				Write_Cnt = 0;
				return 0;
			}
			else
			{
				/* ִгɹI2Cֹͣź */
				IIC_Stop(IIC0);
				Delay1ms(10);

				Write_Cnt = 0;
				return 1; 
			}	
		}	  
	}

	return 0;
}

void i2c_int_test(void)
{
	uint8_t rec = 0;
	AT24CXX_Init();        //AT24CXXʼ
	
	while(1)
	{
	
	
	if(AT24CXX_Sel == 0)
	{
		Delay1ms(200);
		
		WriteBuf = data;
		
		printf("Write Addr is 0x%02X\r\n",addr);
		printf("Write Data is 0x%02X\r\n",WriteBuf);
		
		AT24CXX_Sel = 1;
	}
	else if(AT24CXX_Sel == 1)
	{
			
		rec = AT24CXX_WriteByte(addr);     //addrַдWriteBufɹ1 ʧܷ0
	
		if(rec == 1)
		{
			AT24CXX_Sel = 2;
		}
	}
	else if(AT24CXX_Sel == 2)
	{
		rec = AT24CXX_ReadByte(addr);     //ȡַaddrеݵReadBufɹ1 ʧܷ0
		
		if(rec == 1)
		{
			printf("Read  Data is 0x%02X\r\n",ReadBuf);
			
			if(ReadBuf != WriteBuf)        //дݺͶȡݱȶ
			{
				error++;
				
				printf("error\r\n");
			}
			else
			{
				printf("ok\r\n");
			}
			printf("\r\n");
			
			addr++;                //ַ1
			data++;                //ݼ1
			ReadBuf = 0;
			AT24CXX_Sel = 0;	
		}
	}
	}
}
#endif

// =================== end of IIC INT TEST DEMO =================================
// =================== start of spi TEST DEMO ===================================
#if SPI_TEST
//SPIӲʼ
void SPI_Hard_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	SPI_InitTypeDef  SPI_InitStruct;
#ifdef IC_BL2102	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Func = PORTA_PIN15_SPI_SSN;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN10;
	PORT_InitStruct.Func = PORTA_PIN10_SPI_CLK;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN11;
	PORT_InitStruct.Func = PORTA_PIN11_SPI_MOSI;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN12;
	PORT_InitStruct.Func = PORTA_PIN12_SPI_MISO;
	PORT_InitStruct.Input_En = ENABLE;
#else
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN2;
	PORT_InitStruct.Func = PORTA_PIN2_SPI_SSN;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_SPI_SCLK;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTA_PIN4_SPI_MOSI;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_SPI_MISO;
	PORT_InitStruct.Input_En = ENABLE;
#endif
	PORT_Init(&PORT_InitStruct);
	
	SPI_InitStruct.Master     = SPI_MASTER_MODE;        //ģʽ
	SPI_InitStruct.ClkDiv     = SPI_CLKDIV_8;           //ʱ4Ƶ
	SPI_InitStruct.SampleEdge = SPI_FIRST_EDGE;         //һزɼ
	SPI_InitStruct.IdleLevel  = SPI_LOW_LEVEL;          //Ϊ͵ƽ
	SPI_InitStruct.LsbFirst   = SPI_MSB_FISRT;          //MSBȷ
	
	SPI_Init(&SPI_InitStruct);    
}

uint32_t rxdata, txdata = 0x01;    //ͽ

uint8_t SPI_Sel = 1;               //SPIģʽѡ

uint8_t Flag_spi_irq = 0;          //SPIжϱ־
uint8_t spi_irq_cnt = 0;           //SPIжģʽ

void spi_test(void)
{
	SPI_Hard_Init();          //SPIʼ 
	
    SPI_Sel = 0;              //ģʽѡ  0  ѯģʽ   1  жģʽ
	
	if(SPI_Sel == 0)          //ѯģʽ 
	{
		SPI_Open();       //SPI0  
		
		printf("SPI0 Check Mode\r\n");
		printf("\r\n");
	}
	else                      //жģʽ
	{
		SPI->IE = 0x01 << SPI_SPIF_IE_POS;   //SPI0ж
	
		NVIC_EnableIRQ(SPI_IRQn);
		
		SPI_Open();       //SPI0 
		
		printf("SPI Int Mode\r\n");
		printf("\r\n");
	}
	
	while(1)
	{
		if(SPI_Sel == 0)                          //ѯģʽ 
		{
			rxdata = SPI_ReadWrite(txdata);  //SPI0ͽ
			printf("rxdata: 0x%X\r\n", rxdata);
			printf("txdata: 0x%X\r\n", txdata);
			txdata = rxdata + 1;		          //SPI_MOSISPI_MISO̽ӣɿӡֵһ

			printf("\r\n");
			Delay1ms(400);	
		}
		else                                      //жģʽ                                   
		{
			if(spi_irq_cnt == 0)                     
			{
				SPI_Master_SSN_Out(0);
				
				SPI_Write(txdata);           //SPI0
				spi_irq_cnt = 1;
			}
			else if(spi_irq_cnt == 1)
			{
				if(Flag_spi_irq == 1)             //жϱ־Ϊ1ʾSPI0
				{
					Flag_spi_irq = 0;
					
					rxdata = SPI->RDATA;         //ȡ
					
					printf("txdata: 0x%02X\r\n", txdata);
					printf("rxdata: 0x%02X\r\n", rxdata);
					txdata = rxdata + 1;		  //SPI_MOSISPI_MISO̽ӣɿӡֵһ 
					
					SPI_Master_SSN_Out(1);
					
					spi_irq_cnt = 2;
					
					printf("\r\n");
					printf("\r\n");
				}
			}
			else if(spi_irq_cnt == 2)
			{
				delay_ms(400);
				spi_irq_cnt = 0;
			}
		}		
	}
}
#endif

// =================== end of spi TEST DEMO =====================================
// =================== start of iwdt TEST DEMO ==================================
#if WDT_TEST
uint8_t IWDT_Sel = 0;         
uint8_t Flag_IWDT = 0;

#ifdef IC_BL2102	
//IWDT   32Kʱ  ܸλ
void IWDT_32K_Test(uint32_t load)
{
	IWDT_InitTypeDef IWDT_InitStruct;
	
	IWDT_InitStruct.RstEn = RstEn_DISABLE;     //ܸλ
	IWDT_InitStruct.Load = load;               //ʼֵ
	
	IWDT_Init(&IWDT_InitStruct);               //IWDTʼ

	IWDT_Start();                              //IWDT
}

//IWDT   32Kʱ  ʹܸλ
void IWDT_32K_Rst_Test(uint32_t load)
{
	IWDT_InitTypeDef IWDT_InitStruct;
	
	IWDT_InitStruct.RstEn = RstEn_ENABLE;      //ʹܸλ
	IWDT_InitStruct.Load = load;               //ʼֵ
	
	IWDT_Init(&IWDT_InitStruct);               //IWDTʼ

	IWDT_Start();                              //IWDT
}


void IWDT_Test(void)
{
	switch(IWDT_Sel)
	{
		case IWDT_32K_TEST:                //32Kʱ  ܸλ  ʱι
		case IWDT_32K_INT_TEST:            //32Kʱ  ܸλ  жϴ
			IWDT_32K_Test(32000);
			break;
		case IWDT_32K_RST_TEST:            //32Kʱ  ʹܸλ
			IWDT_32K_Rst_Test(32000);
			break;
	}
}

//IWDTжϷ
void IWDT_Handler(void)
{
	if(IWDT_Sel == IWDT_32K_INT_TEST)   //ǲжϹ
	{
		IWDT->IF = 0;              //жϱ־0
	}
	
	Flag_IWDT = 1;        
}


void iwdt_test(void)
{
	
	IWDT_Sel = IWDT_32K_RST_TEST;
	
	if(SYS->IWDTRST_ST & SYS_IWDTRST_ST_MSK)       //IWDTλ  ӡIWDT RESET!  λ־
	{
		printf("IWDT RESET!\r\n");
		
		SYS->IWDTRST_ST = 0x01 << SYS_IWDTRST_ST_POS;
	}
	else                                          //ϵ縴λӡPOWER ON RESET!
	{
		printf("POWER ON RESET!\r\n");
	}
	
	if(IWDT_Sel == IWDT_32K_TEST)                              
	{
		printf("IWDT_32K_TEST!\r\n");
	}
	else if(IWDT_Sel == IWDT_32K_INT_TEST)
	{
		printf("IWDT_32K_INT_TEST!\r\n");
	}
	else if(IWDT_Sel == IWDT_32K_RST_TEST)
	{
		printf("IWDT_32K_RST_TEST!\r\n");
	}
	
	IWDT_Test();
	
    while(1)
    {
        if(IWDT_Sel == IWDT_32K_TEST)
		{
			delay_ms(200);
			
			IWDT_FEED();                 //IWDTι
			
			printf("IWDT FEED!\r\n");
		}
		
		if(Flag_IWDT == 1)
		{
			Flag_IWDT = 0;
			
			printf("IWDT INTERRUPT!\r\n");
		}
    }	
}
#else
uint8_t Wdt_Sel = 0;         
uint8_t Flag_Wdt = 0;


//WDT   32Kʱ  ܸλ
void Wdt_32K_Test(uint32_t load)
{
	WDT_InitTypeDef WDT_InitStruct;
	
	WDT_InitStruct.ClkSel = ClkSel_32K;       //ʱԴѡ32Kʱ
	WDT_InitStruct.RstEn = RstEn_DISABLE;     //ܸλ
	WDT_InitStruct.Load = load;               //ʼֵ
	
	WDT_Init(&WDT_InitStruct);                //WDTʼ

	WDT_Start();                              //WDT
}

//WDT   32Kʱ  ʹܸλ
void Wdt_32K_Rst_Test(uint32_t load)
{
	WDT_InitTypeDef WDT_InitStruct;
	
	WDT_InitStruct.ClkSel = ClkSel_32K;       //ʱԴѡ32Kʱ
	WDT_InitStruct.RstEn = RstEn_ENABLE;      //ʹܸλ
	WDT_InitStruct.Load = load;               //ʼֵ
	
	WDT_Init(&WDT_InitStruct);                //WDTʼ

	WDT_Start();                              //WDT
}

//WDT   ϵͳʱ  ܸλ
void Wdt_Sys_Test(uint32_t load)
{
	WDT_InitTypeDef WDT_InitStruct;
	
	WDT_InitStruct.ClkSel = ClkSel_SYS;       //ʱԴѡϵͳʱ
	WDT_InitStruct.RstEn = RstEn_DISABLE;     //ܸλ
	WDT_InitStruct.Load = load;               //ʼֵ
	
	WDT_Init(&WDT_InitStruct);                //WDTʼ

	WDT_Start();                              //WDT
}

//WDT   ϵͳʱ  ʹܸλ
void Wdt_Sys_Rst_Test(uint32_t load)
{
	WDT_InitTypeDef WDT_InitStruct;
	
	WDT_InitStruct.ClkSel = ClkSel_SYS;       //ʱԴѡϵͳʱ
	WDT_InitStruct.RstEn = RstEn_ENABLE;      //ʹܸλ
	WDT_InitStruct.Load = load;               //ʼֵ
	 
	WDT_Init(&WDT_InitStruct);                //WDTʼ

	WDT_Start();                              //WDT
}



void Wdt_Test(void)
{
	switch(Wdt_Sel)
	{
		case WDT_32K_TEST:                //32Kʱ  ܸλ  ʱι
		case WDT_32K_INT_TEST:            //32Kʱ  ܸλ  жϴ
			Wdt_32K_Test(32000);
			break;
		case WDT_32K_RST_TEST:            //32Kʱ  ʹܸλ
			Wdt_32K_Rst_Test(32000);
			break;
		case WDT_SYS_TEST:                //ϵͳʱ  ܸλ  ʱι
		case WDT_SYS_INT_TEST:            //ϵͳʱ  ܸλ  жϴ
			Wdt_Sys_Test(64000000);
			break;
		case WDT_SYS_RST_TEST:            //ϵͳʱ  ʹܸλ
			Wdt_Sys_Rst_Test(64000000);
			break;
	}
}

//WDTжϷ
void WDT_Handler(void)
{
	if(Wdt_Sel == WDT_32K_INT_TEST || Wdt_Sel == WDT_SYS_INT_TEST)   //ǲжϹ
	{
		WDT->IF = 0;              //жϱ־0
	}
	
	Flag_Wdt = 1;        
}
void iwdt_test(void)
{
	Wdt_Sel = WDT_SYS_INT_TEST;                      //ѡ
	
	if(SYS->WDTRST_ST & SYS_WDTRST_ST_MSK)       //WDTλ  ӡWDT RESET!  λ־
	{
		printf("WDT RESET!\r\n");
		
		SYS->WDTRST_ST = 0x01 << SYS_WDTRST_ST_POS;
	}
	else                                         //ϵ縴λӡPOWER ON RESET!
	{
		printf("POWER ON RESET!\r\n");
	}
	
	if(Wdt_Sel == WDT_32K_TEST)                              
	{
		printf("WDT_32K_TEST!\r\n");
	}
	else if(Wdt_Sel == WDT_32K_INT_TEST)
	{
		printf("WDT_32K_INT_TEST!\r\n");
	}
	else if(Wdt_Sel == WDT_32K_RST_TEST)
	{
		printf("WDT_32K_RST_TEST!\r\n");
	}
	else if(Wdt_Sel == WDT_SYS_TEST)
	{
		printf("WDT_SYS_TEST!\r\n");
	}
	else if(Wdt_Sel == WDT_SYS_INT_TEST)
	{
		printf("WDT_SYS_INT_TEST!\r\n");
	}
	else if(Wdt_Sel == WDT_SYS_RST_TEST)
	{
		printf("WDT_SYS_RST_TEST!\r\n");
	}
	
	Wdt_Test();            //WDTԳ
	
	while(1)
	{
		if(Wdt_Sel == WDT_32K_TEST || Wdt_Sel == WDT_SYS_TEST)
		{
			delay_ms(200);
			delay_ms(300);
			WDT_FEED();                 //WDTι
			
			printf("WDT FEED!\r\n");
		}
		
		if(Flag_Wdt == 1)
		{
			Flag_Wdt = 0;
			
			printf("WDT INTERRUPT!\r\n");
		}
	}
}
#endif
#endif
// =================== end of iwdt TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if UART_TEST
void uart_test(void)
{
		uart_init();
		while(1)
		{
			if(time_1ms >= 1)
			{
				time_1ms = 0;
				Serial_timeout_1ms++;
			}
			
			uart_test_tx_rx(time_1ms);      //ڲԳ 	
		}
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if PWM_BASE_TEST
void PWMBASE_Test(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	PWMBASE_CommonInitTypeDef PWMBASE_CommonInitStruct;
	PWMBASE_ChannelInitTypeDef PWMBASE_ChannelInitStruct;
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_PWMB0_CH0;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_PWMB0_CH1;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN9;
	PORT_InitStruct.Func = PORTA_PIN9_PWMB0_CH2;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN10;
//	PORT_InitStruct.Func = PORTA_PIN10_PWMB0_CH0;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN15;
//	PORT_InitStruct.Func = PORTA_PIN15_PWMB0_CH2;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);

	PWMBASE_CommonInitStruct.ClkDiv = 63;         //ʱ64Ƶ
	PWMBASE_CommonInitStruct.Period = 1000;       //Ϊ1000
	PWMBASE_CommonInitStruct.OvfIE = ENABLE;      //жʹ
	
	PWMBASE_Common_Init(PWMBASE0,&PWMBASE_CommonInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH0;    //ѡͨ0
	PWMBASE_ChannelInitStruct.Inv = DISABLE;            //ת
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;           //ʹ
	PWMBASE_ChannelInitStruct.Comp = 500;               //ȽϵΪ500
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;          //Ƚϵжʹ
	
	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH1;
	PWMBASE_ChannelInitStruct.Inv = DISABLE;
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;
	PWMBASE_ChannelInitStruct.Comp = 300;
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;
	
	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH2;
	PWMBASE_ChannelInitStruct.Inv = DISABLE;
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;
	PWMBASE_ChannelInitStruct.Comp = 800;
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;

	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	PWMBASE_Start(PWMBASE0);        //PWMBASE0
}


void PWMBASE_IO_Indicate(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;                     /*һGPIO_InitTypeDef͵Ľṹ*/
	
	
	GPIO_InitStruct.Pin = PWMBASE_IO0_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMBASE_IO0_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMBASE_IO1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMBASE_IO1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMBASE_IO2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/

	GPIO_Init(PWMBASE_IO2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_ClrBit(PWMBASE_IO0_GPIO_PORT,PWMBASE_IO0_GPIO_PIN);
	GPIO_ClrBit(PWMBASE_IO1_GPIO_PORT,PWMBASE_IO1_GPIO_PIN);
	GPIO_ClrBit(PWMBASE_IO2_GPIO_PORT,PWMBASE_IO2_GPIO_PIN);
}


//PWMBASE0жϷ
void PWMBASE0_Handler(void)
{
	if(PWMBASE0->IF & PWMBASE_IF_OVF_MSK)                 //жжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_OVF_POS);      //жϱ־
		
		PWMBASE_IO0_TOGGLE;
		PWMBASE_IO1_TOGGLE;
		PWMBASE_IO2_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH0_COMP_MSK)              //жͨ0Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH0_COMP_POS);   //ͨ0Ƚϵжϱ־
		
		PWMBASE_IO0_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH1_COMP_MSK)              //жͨ1Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH1_COMP_POS);   //ͨ1Ƚϵжϱ־
	
		PWMBASE_IO1_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH2_COMP_MSK)              //жͨ2Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH2_COMP_POS);   //ͨ2Ƚϵжϱ־
		
		PWMBASE_IO2_TOGGLE;
	}
}

void pwm_base_test(void)
{
  PWMBASE_Test();            //PWMBASEʼ
	PWMBASE_IO_Indicate();     //ָʾIOʼ
	
    while(1)
    {
    PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH0,DISABLE);    //ת
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH1,DISABLE);
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH2,DISABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH0,ENABLE);     //ת
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH1,ENABLE);
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH2,ENABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH0,DISABLE);     //
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH1,DISABLE);
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH2,DISABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH0,ENABLE);      //ʹ
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH1,ENABLE);
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH2,ENABLE);
		
		delay_ms(100);
    }
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if PWM_PLUS_TEST
void PWMPLUS_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	PWMPLUS_CommonInitTypeDef PWMPLUS_CommonInitStruct;
	PWMPLUS_ChannelInitTypeDef PWMPLUS_ChannelInitStruct;
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_PWMP0_CH0N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);

	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN1;
	PORT_InitStruct.Func = PORTA_PIN1_PWMP0_CH1N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN2;
	PORT_InitStruct.Func = PORTA_PIN2_PWMP0_CH2N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_PWMP0_CH0;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTA_PIN4_PWMP0_CH1;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_PWMP0_CH2;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN8;
//	PORT_InitStruct.Func = PORTA_PIN8_PWMP0_CH2;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN8;
//	PORT_InitStruct.Func = PORTA_PIN8_PWMP0_CH0N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN9;
//	PORT_InitStruct.Func = PORTA_PIN9_PWMP0_CH1N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN10;
//	PORT_InitStruct.Func = PORTA_PIN10_PWMP0_CH2N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN11;
//	PORT_InitStruct.Func = PORTA_PIN11_PWMP0_CH0;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN12;
//	PORT_InitStruct.Func = PORTA_PIN12_PWMP0_CH1;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN6;
//	PORT_InitStruct.Func = PORTA_PIN6_BREAK_IN0;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);

//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN7;
//	PORT_InitStruct.Func = PORTA_PIN7_BREAK_IN1;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);
	
	PWMPLUS_CommonInitStruct.Clk_Src = CLKSRC_DIV;                         //ڲԤƵʱΪʱ           
	PWMPLUS_CommonInitStruct.ClkDiv = 0;                                  //ʱ16Ƶ
	PWMPLUS_CommonInitStruct.Mode = CYCLE_EDGE_ALIGN;                      //ض
	PWMPLUS_CommonInitStruct.Dir = DIR_UP;                                 //ϼ
	PWMPLUS_CommonInitStruct.Reload_Cnt = 0;                               //װشΪ1
	PWMPLUS_CommonInitStruct.Period = 10000;                               //Ϊ10000
	PWMPLUS_CommonInitStruct.Brake_Filter = BRAKE_FILTER_1;                //ɲ˲ϵΪ1
	PWMPLUS_CommonInitStruct.Brake_InputLevel = BRAKE0_HIGH_BRAKE1_HIGH;   //ɲ0Ϊߵƽ  ɲ1Ϊߵƽ
	PWMPLUS_CommonInitStruct.Trig_Comp = 2000;                             //ڲΪ2000
	PWMPLUS_CommonInitStruct.Trig_Sel = NOSIGNAL_TRIG;                     //޴ź
	PWMPLUS_CommonInitStruct.Reload_IE = DISABLE;                          //װжϽ
	PWMPLUS_CommonInitStruct.Brake0_IE = DISABLE;                          //ɲ0жϽ
	PWMPLUS_CommonInitStruct.Brake1_IE = DISABLE;                          //ɲ1жϽ
	PWMPLUS_CommonInitStruct.Up_OvfIE  = ENABLE;                           //ϼжʹ
	PWMPLUS_CommonInitStruct.Up_TrigCompIE  = DISABLE;                     //ϼڲжϽ
	PWMPLUS_CommonInitStruct.Down_OvfIE  = DISABLE;                        //¼жϽ
	PWMPLUS_CommonInitStruct.Down_TrigCompIE  = DISABLE;                   //¼ڲжϽ
	
	PWMPLUS_CommonInit(PWMPLUS0,&PWMPLUS_CommonInitStruct);
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH0;                   //Ϊͨ0
	PWMPLUS_ChannelInitStruct.Comp = 2500;                             //ȽϵΪ4000
	PWMPLUS_ChannelInitStruct.DeadZone = 100;                          //Ϊ100
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_LOW;                  //ʼƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_HIGH;               //ͨ0еƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_HIGH;              //ͨ0NеƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;                        //ͨ0ת
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;                       //ͨ0Nת
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;                       //ͨ0ʹ
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;                      //ͨ0Nʹ
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;           //ͨ0ɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;          //ͨ0NɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;    //ɲ0 ɲ1
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;              //ͨ0εƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;             //ͨ0NεƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;               //ͨ0ιܽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;              //ͨ0Nιܽ
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;                     //ͨ0ϼȽϵжʹ
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;                  //ͨ0¼ȽϵжϽ
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH1;
	PWMPLUS_ChannelInitStruct.Comp = 3000;
	PWMPLUS_ChannelInitStruct.DeadZone = 100;
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH2;
	PWMPLUS_ChannelInitStruct.Comp = 7000;
	PWMPLUS_ChannelInitStruct.DeadZone = 100;
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	PWMPLUS_Start(PWMPLUS0);
//	PWMPLUS_SoftLoad(PWMPLUS0); 
}


void PWMPLUS_IO_Indicate(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;                     /*һGPIO_InitTypeDef͵Ľṹ*/
	
	
	GPIO_InitStruct.Pin = PWMPLUS_IO0_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMPLUS_IO0_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMPLUS_IO1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMPLUS_IO1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMPLUS_IO2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/

	GPIO_Init(PWMPLUS_IO2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_ClrBit(PWMPLUS_IO0_GPIO_PORT,PWMPLUS_IO0_GPIO_PIN);
	GPIO_ClrBit(PWMPLUS_IO1_GPIO_PORT,PWMPLUS_IO1_GPIO_PIN);
	GPIO_ClrBit(PWMPLUS_IO2_GPIO_PORT,PWMPLUS_IO2_GPIO_PIN);
//	PWMPLUS_SetPeriod(PWMPLUS_CH0,5000);
//	PWMPLUS_SetPeriod(PWMPLUS_CH1,5000);	
}


//PWMBASE0жϷ
void PWMPLUS0_Handler(void)
{
//	if(PWMPLUS0->IF & PWMPLUS_IF_RELOAD_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_RELOAD_POS);
//		
//		PWMPLUS_IO0_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_BRK0_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_BRK0_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_BRK1_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_BRK1_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
//	if(PWMPLUS0->IF & PWMPLUS_IF_UP_TRIG_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_UP_TRIG_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_DOWN_TRIG_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_DOWN_TRIG_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
	if(PWMPLUS0->IF & PWMPLUS_IF_UP_OVF_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_UP_OVF_POS);
		
//		PWMPLUS_IO0_TOGGLE;
		PWMPLUS_IO1_TOGGLE;
		PWMPLUS_IO2_TOGGLE;
	}
	
//	if(PWMPLUS0->IF & PWMPLUS_IF_DOWN_OVF_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_DOWN_OVF_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH0_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH0_UP_COMP_POS);
		
//		PWMPLUS_IO0_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH0_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH0_DOWN_COMP_POS);
//		
//		PWMPLUS_IO0_TOGGLE;
//	}
//	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH1_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH1_UP_COMP_POS);
		
		PWMPLUS_IO1_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH1_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH1_DOWN_COMP_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH2_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH2_UP_COMP_POS);
		
		PWMPLUS_IO2_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH2_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH2_DOWN_COMP_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
}
void PWMPLUS0_user_handle(void)
{
			static  uint16_t pwm_data;
	    if(time_1ms >= 1000)
		    {
			    time_1ms = 0;
			//    PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH0;
					pwm_data+=2500;
					if(pwm_data>7500) pwm_data=0;
					PWMPLUS_SetComp(PWMPLUS0,1,pwm_data);
					PWMPLUS_SetComp(PWMPLUS0,2,pwm_data);
					PWMPLUS_SetComp(PWMPLUS0,4,pwm_data);			
					
					PWMPLUS_SoftLoad(PWMPLUS0); 
					
		    }

}	

void pwm_plus_test(void)
{
	PWMPLUS_Init();
	PWMPLUS_IO_Indicate();
	
    while(1)
    {
   
    }	
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of exti TEST DEMO ================================
#if EXTI_TEST
uint8_t Flag_Key1 = 0;      //1жϱ־λ
uint8_t Flag_Key2 = 0;      //2жϱ־λ
uint8_t Flag_Key3 = 0;      //3жϱ־λ
uint8_t Flag_Key4 = 0;      //4жϱ־λ
//ⲿжϳʼ
void Exti_Init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
   
	GPIO_InitStruct.Pin = KEY1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	EXTI_Init(KEY1_GPIO_PORT,KEY1_GPIO_PIN,EXTI_RISE_EDGE);   //ж
	EXTI_Init(KEY2_GPIO_PORT,KEY2_GPIO_PIN,EXTI_FALL_EDGE);   //½ж
	EXTI_Init(KEY3_GPIO_PORT,KEY3_GPIO_PIN,EXTI_BOTH_EDGE);   //˫ж
	EXTI_Init(KEY4_GPIO_PORT,KEY4_GPIO_PIN,EXTI_LOW_LEVEL);   //͵ƽж
	
	NVIC_EnableIRQ(KEY1_IRQn);                    //ʹܰ1ж     
	NVIC_EnableIRQ(KEY2_IRQn);                    //ʹܰ2ж    
	NVIC_EnableIRQ(KEY3_IRQn);                    //ʹܰ3ж    
	NVIC_EnableIRQ(KEY4_IRQn);                    //ʹܰ4ж    
	
	EXTI_Open(KEY1_GPIO_PORT,KEY1_GPIO_PIN);      //򿪰1ⲿж  
	EXTI_Open(KEY2_GPIO_PORT,KEY2_GPIO_PIN);      //򿪰2ⲿж  
	EXTI_Open(KEY3_GPIO_PORT,KEY3_GPIO_PIN);      //򿪰3ⲿж  
	EXTI_Open(KEY4_GPIO_PORT,KEY4_GPIO_PIN);      //򿪰4ⲿж  
}

//1жϷ
void KEY1_Handler(void)
{
	if(EXTI_State(KEY1_GPIO_PORT,KEY1_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY1_GPIO_PORT,KEY1_GPIO_PIN);   //жϱ־
		
		Flag_Key1 = 1;                              //1ı־λ1
	}
}

//2жϷ
void KEY2_Handler(void)
{
	if(EXTI_State(KEY2_GPIO_PORT,KEY2_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY2_GPIO_PORT,KEY2_GPIO_PIN);   //жϱ־ 
		
		Flag_Key2 = 1;                              //2ı־λ1
	}
}

//3жϷ
void KEY3_Handler(void)
{
	if(EXTI_State(KEY3_GPIO_PORT,KEY3_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY3_GPIO_PORT,KEY3_GPIO_PIN);   //жϱ־ 
		
		Flag_Key3 = 1;                              //3ı־λ1
	}
}

//4жϷ
void KEY4_Handler(void)
{
	if(EXTI_State(KEY4_GPIO_PORT,KEY4_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY4_GPIO_PORT,KEY4_GPIO_PIN);   //жϱ־ 
		
		Flag_Key4 = 1;                              //4ı־λ1
	}
}

void exti_test(void)
{
    Exti_Init();           //extiʼ
	
    while(1)
    {
        if(Flag_Key1 == 1)  //1ı־λΪ1ʱ  LED1ת
		{
			Flag_Key1 = 0;
			printf("key1 int\r\n");
			LED1_TOGGLE;
		}
		
		if(Flag_Key2 == 1)  //2ı־λΪ1ʱ  LED2ת
		{
			Flag_Key2 = 0;
			printf("key2 int\r\n");
			LED2_TOGGLE;
		}
		
		if(Flag_Key3 == 1)  //3ı־λΪ1ʱ  LED3ת
		{
			Flag_Key3 = 0;
			printf("key3 int\r\n");
			LED3_TOGGLE;
		}
		
		if(Flag_Key4 == 1)  //4ı־λΪ1ʱ  LED4ת
		{
			Flag_Key4 = 0;
			printf("key4 int\r\n");
			LED4_TOGGLE;
		}
    }

}
#endif
// =================== START PWM TEST DEMO ==================================
#ifdef PWM_TEST

//LED IOʼ
void Led_Init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = LED1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/

	
	GPIO_InitStruct.Pin = LED2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = LED3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/


	GPIO_InitStruct.Pin = LED4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
			
	LED1_OFF;       
	LED2_OFF;
	LED3_OFF;
	LED4_OFF;		
}
uint8_t Flag_Pwm_Hend = 0;             //PWMߵƽжϱ־
uint8_t Flag_Pwm_Ovf = 0;              //PWMжϱ־
uint8_t  Dir = 0;           //   0     1  ݼ
uint16_t High = 0;          //ߵƽʱ

void PWM_Test(void)
{
	PWM_InitTypeDef  PWM_InitStruct;
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN11;
	PORT_InitStruct.Input_En = DISABLE;
	PORT_InitStruct.Func = PORTA_PIN11_PWM0;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN12;
	PORT_InitStruct.Input_En = DISABLE;
	PORT_InitStruct.Func = PORTA_PIN12_PWM1;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN13;
	PORT_InitStruct.Input_En = DISABLE;
	PORT_InitStruct.Func = PORTA_PIN13_PWM2;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN14;
	PORT_InitStruct.Input_En = DISABLE;
	PORT_InitStruct.Func = PORTA_PIN14_PWM3;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Input_En = DISABLE;
	PORT_InitStruct.Func = PORTA_PIN15_PWM4;
	
	PORT_Init(&PORT_InitStruct);
	
	
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN6;
//	PORT_InitStruct.Input_En = DISABLE;
//	PORT_InitStruct.Func = PORTA_PIN6_PWM0;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN7;
//	PORT_InitStruct.Input_En = DISABLE;
//	PORT_InitStruct.Func = PORTA_PIN7_PWM1;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN8;
//	PORT_InitStruct.Input_En = DISABLE;
//	PORT_InitStruct.Func = PORTA_PIN8_PWM4;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN6;
//	PORT_InitStruct.Input_En = DISABLE;
//	PORT_InitStruct.Func = PORTB_PIN6_PWM2;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTB;
//	PORT_InitStruct.Pin = GPIO_PIN7;
//	PORT_InitStruct.Input_En = DISABLE;
//	PORT_InitStruct.Func = PORTB_PIN7_PWM3;
//	
//	PORT_Init(&PORT_InitStruct);
	
	
	PWM_InitStruct.clkdiv = PWM_CLKDIV_4;    //ƵֵΪ512
	
	PWM_InitStruct.period = 4000;              //Ϊ4000
	PWM_InitStruct.high = 1500;                //ߵƽΪ1500
	PWM_InitStruct.Inv = DISABLE;              //źŲת
	PWM_InitStruct.HEndIE = ENABLE;            //ߵƽжʹ
	PWM_InitStruct.OvfIE = ENABLE;             //жʹ
	
	PWM_Init(PWM0,&PWM_InitStruct);            //PWM0ʼ
	
	
	PWM_InitStruct.period = 2000;
	PWM_InitStruct.high = 0;
	PWM_InitStruct.Inv = DISABLE;
	PWM_InitStruct.HEndIE = DISABLE;
	PWM_InitStruct.OvfIE = DISABLE;
	
	PWM_Init(PWM1,&PWM_InitStruct);
	
	
	PWM_InitStruct.period = 3000;
	PWM_InitStruct.high = 1000;
	PWM_InitStruct.Inv = DISABLE;
	PWM_InitStruct.HEndIE = DISABLE;
	PWM_InitStruct.OvfIE = DISABLE;
	
	PWM_Init(PWM2,&PWM_InitStruct);
	
	
	PWM_InitStruct.period = 4000;
	PWM_InitStruct.high = 3000;
	PWM_InitStruct.Inv = DISABLE;
	PWM_InitStruct.HEndIE = DISABLE;
	PWM_InitStruct.OvfIE = DISABLE;
	
	PWM_Init(PWM3,&PWM_InitStruct);
	
	
	PWM_InitStruct.period = 4000;
	PWM_InitStruct.high = 3000;
	PWM_InitStruct.Inv = ENABLE;
	PWM_InitStruct.HEndIE = DISABLE;
	PWM_InitStruct.OvfIE = DISABLE;
	
	PWM_Init(PWM4,&PWM_InitStruct);
	
	PWM_Start(PWM0);            //PWM0
	PWM_Start(PWM1);
	PWM_Start(PWM2);
	PWM_Start(PWM3);
	PWM_Start(PWM4);
}

//PWMжϷ
void PWM_Handler(void)
{
	if(PWMG->IF & PWMG_PWM0_HEND_IF_MSK)         //PWM0ߵƽжǷ
	{
		PWMG->IF = PWMG_PWM0_HEND_IF_MSK;        //PWM0ߵƽж״̬
		Flag_Pwm_Hend = 1;                       //ߵƽжϱ־1
	}
	
	if(PWMG->IF & PWMG_PWM0_OVF_IF_MSK)          //PWM0жǷ
	{
		PWMG->IF = PWMG_PWM0_OVF_IF_MSK;         //PWM0ж״̬
		Flag_Pwm_Ovf = 1;                        //жϱ־1
	}
}

void pwm_test(void)
{
		Led_Init();             //LEDʼ
	PWM_Test();             //PWMʼ
	TIMER_L16_Init();       //16λʱʼ    
	
    while(1)
    {
       if(Flag_Pwm_Hend == 1)      
	   {
			Flag_Pwm_Hend = 0;
		    LED1_TOGGLE;           //IOתָʾжϷλ  
	   }
	   
	   if(Flag_Pwm_Ovf == 1)
	   {
	        Flag_Pwm_Ovf = 0;
		    LED2_TOGGLE;           //IOתָʾжϷλ  
	   }
	   
	   if(time_1ms >= 100)
	   {
		   time_1ms = 0;
		   
		   if(Dir == 0)
		   {
			   High++;
			   
			   if(High >= 2000)
			   {
				  Dir = 1;
			   }
		   }
		   else
		   {
			   High--;
			   
			   if(High <= 0)
			   {
				  Dir = 0;
			   }
		   }

		   PWM_SetHigh(PWM1,High);    //޸ռձ
	   } 
    }


}
#endif
// =================== end of PWM TEST DEMO ==================================
// =================== START RTC TEST DEMO ==================================
#ifdef RTC_TEST

uint8_t Flag_Second = 0;         //жϱ־
uint8_t Flag_Alarm = 0;          //жϱ־
uint8_t Flag_OverFlow = 0;       //жϱ־

//RTCʼ
void RTC_Test(void)
{
	RTC_InitTypeDef RTC_InitStruct;

	RTC_InitStruct.Second = 320000;           //Ĵֵ
	RTC_InitStruct.Alarm  = 640000;          //ӼĴֵ
	RTC_InitStruct.Second_IE = ENABLE;        //жʹ
	RTC_InitStruct.Alarm_IE = ENABLE;         //жʹ
	RTC_InitStruct.OverFlow_IE = ENABLE;      //жʹ
	
	RTC_Init(&RTC_InitStruct);                //RTCʼ
	
	RTC_Start();                              //RTC
}

//RTCжϷ
void RTC_Handler(void)
{
	if(RTC_IntSecondStat())             //ж״̬Ϊ1
	{
		RTC_IntSecondClr();             //ж״̬
		
		Flag_Second = 1;                //жϱ־1
	}

	if(RTC_IntAlarmStat())              //ж״̬Ϊ1
	{
		RTC_IntAlarmClr();              //ж״̬
		
		Flag_Alarm = 1;                 //жϱ־1
	}

	if(RTC_IntOverFlowStat())           //ж״̬Ϊ1
	{
		RTC_IntOverFlowClr();           //ж״̬
		
		Flag_OverFlow = 1;              //жϱ־1
	}
}
uint32_t time = 0;

void rtc_test(void)
{
	RTC_Test();        //RTCʼ
	
	while(1)
	{
		if(Flag_Second == 1)                    //жϱ־Ϊ1
		{
			Flag_Second = 0;                    //жϱ־0
			time = RTC_Get_Time();              //ȡRTCǰʱ
			printf("\r\n");   
			printf("time:0x%08x\r\n",time);     //ӡRTCǰʱ
			printf("Second\r\n");               //ӡSecond
			printf("\r\n");               
		}
		
		if(Flag_Alarm == 1)                     //жϱ־Ϊ1
		{
			Flag_Alarm = 0;                     //жϱ־0
			printf("\r\n");   
			printf("Alarm\r\n");                //ӡAlarm
			printf("\r\n");   
		}
		
		if(Flag_OverFlow == 1)                  //жϱ־Ϊ1
		{
			Flag_OverFlow = 0;                  //жϱ־0
			
			printf("OverFlow\r\n");             //ӡOverFlow
		}
	}	
}
#endif
// =================== end of RTC TEST DEMO ==================================
// =================== start of rf TEST DEMO ==================================
#if RF_TEST
void rf_test(void)
{
			unsigned char rf_mode=HS6220_Carrier_Mode;//ģʽ
			unsigned char rf_buf[32];	
			unsigned char len;	
		  HS6220_Init();


			if(rf_mode==HS6220_PTX_Mode)
			{
				printf("HS6220_PTX_Mode\r\n");
				while(1)
				{				
					Delay1ms(2);
					rf_buf[0]=0x00;
					rf_buf[1]=0x01;
					rf_buf[2]=0x02;
					rf_buf[3]=0x03;
					rf_buf[4]=0x04;
					rf_buf[5]=0x05;
					rf_buf[6]=0x06;		
					rf_buf[7]=0x07;
					rf_buf[8]=0x08;	
					rf_buf[9]=0x09;		
					HS6220_Clear_All_Irq();
					HS6220_Flush_Tx();
					HS6220_Flush_Rx();					
					HS6220_SendPack(HS6220_W_TX_PAYLOAD_NOACK,rf_buf,rx_lenth);				
				}

			}
			else
			if(rf_mode==HS6220_PRX_Mode)
			{
				printf("HS6220_PRX_Mode\r\n");
				HS6220_CE_Low();				
				HS6220_Clear_All_Irq();
				HS6220_Flush_Tx();
				HS6220_Flush_Rx();
				HS6220_ModeSwitch(HS6220_PRX_Mode);
				HS6220_CE_High();		
				while(1)
				{				
					Delay1ms(2);
					
					len=HS6220_ReceivePack(rf_buf);
					if(len==rx_lenth)
					{
						printf("rf_buf is %x %x %x %x %x %x \r\n",rf_buf[0],rf_buf[1],rf_buf[2],rf_buf[3],rf_buf[4],rf_buf[5]);

					}	
				}
			}
			else
			if(rf_mode==HS6220_Carrier_Mode)
			{
			HS6220_CE_Low();
			HS6220_ModeSwitch(HS6220_Carrier_Mode);
			HS6220_CE_High();		
			printf("HS6220_Carrier_Mode\r\n");

			 while(1);
			}	
				
		 while(1)
		 {	 
		 }	


}
#endif
// =================== end of rf TEST DEMO ==================================
















