#ifndef __BL2102_PWMPLUS_H__
#define __BL2102_PWMPLUS_H__

#include "BL2102.h"


typedef enum
{ 
	CLKSRC_DIV    =  0x00,              // ڲԤƵʱΪʱ
	CLKSRC_LOW16  =  0x03,              // 16λʱΪʱ
	CLKSRC_HIGH16 =  0x04,              // 16λʱΪʱ
} PWMPLUS_Clk_Src_TypeDef;


typedef enum
{ 
	SINGLE_EDGE_ALIGN   =  0x00,       // αض
	CYCLE_EDGE_ALIGN    =  0x01,       // ѭض
	SINGLE_CENTER_ALIGN =  0x02,       // Ķ 
	CYCLE_CENTER_ALIGN  =  0x03,       // ѭĶ 
} PWMPLUS_Mode_TypeDef;

typedef enum
{ 
	DIR_UP   =  0x00,                  // ϼ
	DIR_DOWN =  0x01,                  // ¼
} PWMPLUS_Dir_TypeDef;

typedef enum
{ 
	PWMPLUS_CH0   =  0x01,             //ͨCH0     
	PWMPLUS_CH1   =  0x02,             //ͨCH1   
	PWMPLUS_CH2   =  0x04,             //ͨCH2   
	PWMPLUS_CH0N  =  0x08,             //ͨCH0N   
	PWMPLUS_CH1N  =  0x10,             //ͨCH1N   
	PWMPLUS_CH2N  =  0x20,             //ͨCH2N   
} PWMPLUS_Channel_TypeDef;

typedef enum
{ 
	LEVEL_LOW   =  0x00,               //͵ƽ
	LEVEL_HIGH  =  0x01,               //ߵƽ
} PWMPLUS_Level_TypeDef;

typedef enum
{ 
	BRAKE_FILTER_1   =  0x00,          //ɲ˲1ʱ                
	BRAKE_FILTER_2   =  0x01,          //ɲ˲2ʱ 
	BRAKE_FILTER_4   =  0x02,          //ɲ˲4ʱ 
	BRAKE_FILTER_8   =  0x03,          //ɲ˲8ʱ 
} PWMPLUS_BrakeFilter_TypeDef;

typedef enum
{ 
	BRAKE0_LOW_BRAKE1_LOW    = 0x00,   //ɲ0͵ƽɲ1͵ƽ
	BRAKE0_HIGH_BRAKE1_LOW   = 0x01,   //ɲ0ߵƽɲ1͵ƽ
	BRAKE0_LOW_BRAKE1_HIGH   = 0x02,   //ɲ0͵ƽɲ1ߵƽ
	BRAKE0_HIGH_BRAKE1_HIGH  = 0x03,   //ɲ0ߵƽɲ1ߵƽ
} PWMPLUS_BrakeLevel_TypeDef;

typedef enum
{ 
	BRAKE0_DIS_BRAKE1_DIS    =  0x00,  //ɲ0ɲ1
	BRAKE0_EN_BRAKE1_DIS     =  0x01,  //ɲ0ʹɲ1
	BRAKE0_DIS_BRAKE1_EN     =  0x02,  //ɲ0ɲ1ʹ
	BRAKE0_EN_BRAKE1_EN      =  0x03,  //ɲ0ʹɲ1ʹ
} PWMPLUS_BrakeEnable_TypeDef;


typedef enum
{ 
	NOSIGNAL_TRIG         =  0x00,     //޴ź
	UP_OVF_TRIG           =  0x01,     //ϼ
	DOWN_OVF_TRIG         =  0x02,     //¼
	UPDOWN_OVF_TRIG       =  0x03,     //¼
	CH0_UP_COMP_TRIG      =  0x04,     //ͨ0Ϸת㴥
	CH0_DOWN_COMP_TRIG    =  0x05,     //ͨ0·ת㴥
	CH0_UPDOWN_COMP_TRIG  =  0x06,     //ͨ0·ת㴥
	CH1_UP_COMP_TRIG      =  0x07,     //ͨ1Ϸת㴥 
	CH1_DOWN_COMP_TRIG    =  0x08,     //ͨ1·ת㴥
	CH1_UPDOWN_COMP_TRIG  =  0x09,     //ͨ1·ת㴥
	CH2_UP_COMP_TRIG      =  0x0A,     //ͨ2Ϸת㴥 
	CH2_DOWN_COMP_TRIG    =  0x0B,     //ͨ2·ת㴥
	CH2_UPDOWN_COMP_TRIG  =  0x0C,     //ͨ2·ת㴥
	UP_INCOMP_TRIG        =  0x0D,     //ϼڲ㴥
	DOWN_INCOMP_TRIG      =  0x0E,     //¼ڲ㴥   
	UPDOWN_INCOMP_TRIG    =  0x0F,     //¼ڲ㴥
} PWMPLUS_TrigSel_TypeDef;



typedef struct {
	
	PWMPLUS_Clk_Src_TypeDef Clk_Src;          //ʱѡ     
	
	uint8_t ClkDiv;		                      //1---256Ƶ
	
	PWMPLUS_Mode_TypeDef Mode;                //ģʽ   
	
	PWMPLUS_Dir_TypeDef Dir;                  //   0 ϼ  1 ¼
	
	uint8_t Reload_Cnt;                       //Զװش
	
	uint32_t Period;		                  //,16λ
	
	PWMPLUS_BrakeFilter_TypeDef Brake_Filter;      //ɲź˲  00 ˲   01  2ʱ˲  10 4ʱ˲  11  8ʱ˲
	
	PWMPLUS_BrakeLevel_TypeDef Brake_InputLevel;   //ɲЧƽѡ   0  ͵ƽЧ  1  ߵƽЧ
	
	uint32_t Trig_Comp;                       //ڲ
	
	PWMPLUS_TrigSel_TypeDef Trig_Sel;         //trigźŹѡ
	
	FunctionalState Reload_IE;                //Զװжʹ
	
	FunctionalState Brake0_IE;                //ɲ0жʹ
	
	FunctionalState Brake1_IE;                //ɲ1жʹ
	
	FunctionalState Up_OvfIE;		          //ϼжʹ
	
	FunctionalState Up_TrigCompIE;		      //ϼڲжʹ
	
	FunctionalState Down_OvfIE;		          //¼жʹ
	
	FunctionalState Down_TrigCompIE;          //¼ڲжʹ
} PWMPLUS_CommonInitTypeDef;

typedef struct {
	PWMPLUS_Channel_TypeDef Channel;          //ͨѡ
	
	uint32_t Comp;                            //ת
	
	uint16_t DeadZone;                        //
	
	PWMPLUS_Level_TypeDef StartLevel;         //ʼƽ
	
	PWMPLUS_Level_TypeDef CHxIdleLevel;       //ͨxƽ
	
	PWMPLUS_Level_TypeDef CHxNIdleLevel;      //ͨxNƽ
	
	FunctionalState  CHxInv;                  //ͨxźŵƽת
	
	FunctionalState  CHxNInv;                 //ͨxNźŵƽת
	
	FunctionalState  CHxOutEn;                //ͨxʹ
	
	FunctionalState  CHxNOutEn;               //ͨxNʹ
	
	PWMPLUS_BrakeEnable_TypeDef Brake_Enable; //ɲʹ
	
	PWMPLUS_Level_TypeDef Brake_CHxOutLevel;  //ɲͨCHxƽ
	
	PWMPLUS_Level_TypeDef Brake_CHxNOutLevel; //ɲͨCHxNƽ
	
	FunctionalState Mask_CHx_Enable;          //ͨCHxʹ
	
	FunctionalState Mask_CHxN_Enable;         //ͨCHxNʹ
	
	PWMPLUS_Level_TypeDef Mask_CHx_Level;     //ͨCHxƽ
	
	PWMPLUS_Level_TypeDef Mask_CHxN_Level;    //ͨCHxNƽ
	
	FunctionalState Up_CompIE;		          //ϼתжʹ
	
	FunctionalState Down_CompIE;		      //¼תжʹ	
} PWMPLUS_ChannelInitTypeDef;


//  PWMPLUS
#define IS_PWMPLUS_ALL(PWMPLUS)  ((PWMPLUS) == PWMPLUS0)

//  PWMPLUSʱѡ
#define IS_PWMPLUS_CLKSRC(PWMPLUS_CLKSRC)    ((PWMPLUS_CLKSRC) == CLKSRC_DIV || (PWMPLUS_CLKSRC) == CLKSRC_LOW16 || (PWMPLUS_CLKSRC) == CLKSRC_HIGH16)                

//  PWMPLUSԤƵϵ  
#define IS_PWMPLUS_CLKDIV(PWMPLUS_CLKDIV)    ((PWMPLUS_CLKDIV) <= 255)

//  PWMPLUSģʽ
#define IS_PWMPLUS_MODE(PWMPLUS_MODE)  ((PWMPLUS_MODE == SINGLE_EDGE_ALIGN)   || (PWMPLUS_MODE == CYCLE_EDGE_ALIGN) || \
                                        (PWMPLUS_MODE == SINGLE_CENTER_ALIGN) || (PWMPLUS_MODE == CYCLE_CENTER_ALIGN) )
//  PWMPLUS
#define IS_PWMPLUS_DIR(PWMPLUS_DIR)    ((PWMPLUS_DIR == DIR_UP) || (PWMPLUS_DIR == DIR_DOWN))
                                        
//  PWMPLUSͨ
#define IS_PWMPLUS_CHANNEL_ALL(PWMPLUS_CHANNEL_ALL)  ((PWMPLUS_CHANNEL_ALL == PWMPLUS_CH0) || (PWMPLUS_CHANNEL_ALL == PWMPLUS_CH0N) || \
                                                      (PWMPLUS_CHANNEL_ALL == PWMPLUS_CH1) || (PWMPLUS_CHANNEL_ALL == PWMPLUS_CH1N) || \
                                                      (PWMPLUS_CHANNEL_ALL == PWMPLUS_CH2) || (PWMPLUS_CHANNEL_ALL == PWMPLUS_CH2N))

//  PWMPLUSͨ
#define IS_PWMPLUS_CHANNEL_HALF(PWMPLUS_CHANNEL_HALF)  ((PWMPLUS_CHANNEL_HALF == PWMPLUS_CH0) || (PWMPLUS_CHANNEL_HALF == PWMPLUS_CH1) || \
                                                        (PWMPLUS_CHANNEL_HALF == PWMPLUS_CH2) ) 
                                                      
//  PWMPLUSԶװش
#define IS_PWMPLUS_RELOAD_CNT(PWMPLUS_RELOAD_CNT)    ((PWMPLUS_RELOAD_CNT) <= 255)

//  PWMPLUS
#define IS_PWMPLUS_PERIOD(PWMPLUS_PERIOD)    (((PWMPLUS_PERIOD) > 0) && ((PWMPLUS_PERIOD) < 4096))

//  PWMPLUSת
#define IS_PWMPLUS_COMP(PWMPLUS_COMP)    (((PWMPLUS_COMP) > 0) && ((PWMPLUS_COMP) < 4096))

//  PWMPLUS
#define IS_PWMPLUS_DEADZONE(PWMPLUS_DEADZONE)    (((PWMPLUS_DEADZONE) > 0) && ((PWMPLUS_DEADZONE) < 1024))

//  PWMPLUSɲź˲
#define IS_PWMPLUS_BRAKE_FILTER(PWMPLUS_BRAKE_FILTER)    ((PWMPLUS_BRAKE_FILTER == BRAKE_FILTER_1) || (PWMPLUS_BRAKE_FILTER == BRAKE_FILTER_2) || \
                                                          (PWMPLUS_BRAKE_FILTER == BRAKE_FILTER_4) || (PWMPLUS_BRAKE_FILTER == BRAKE_FILTER_8) )
//  PWMPLUSɲźЧƽ
#define IS_PWMPLUS_BRAKE_LEVEL(PWMPLUS_BRAKE_LEVEL)    ((PWMPLUS_BRAKE_LEVEL == BRAKE0_LOW_BRAKE1_LOW)  || (PWMPLUS_BRAKE_LEVEL == BRAKE0_HIGH_BRAKE1_LOW) || \
                                                        (PWMPLUS_BRAKE_LEVEL == BRAKE0_LOW_BRAKE1_HIGH) || (PWMPLUS_BRAKE_LEVEL == BRAKE0_HIGH_BRAKE1_HIGH) )
//  PWMPLUSɲźʹ
#define IS_PWMPLUS_BRAKE_ENABLE(PWMPLUS_BRAKE_ENABLE)    ((PWMPLUS_BRAKE_ENABLE == BRAKE0_DIS_BRAKE1_DIS)  || (PWMPLUS_BRAKE_ENABLE == BRAKE0_EN_BRAKE1_DIS) || \
                                                          (PWMPLUS_BRAKE_ENABLE == BRAKE0_DIS_BRAKE1_EN)   || (PWMPLUS_BRAKE_ENABLE == BRAKE0_EN_BRAKE1_EN) )
//  PWMPLUStrigźŹѡ
#define IS_PWMPLUS_TRIG_SEL(PWMPLUS_TRIG_SEL)    (((PWMPLUS_TRIG_SEL) >= NOSIGNAL_TRIG) && ((PWMPLUS_TRIG_SEL) <= UPDOWN_INCOMP_TRIG))

//  PWMPLUSڲ
#define IS_PWMPLUS_TRIG_COMP(PWMPLUS_TRIG_COMP)    (((PWMPLUS_TRIG_COMP) > 0) && ((PWMPLUS_TRIG_COMP) < 4096))

//  PWMPLUSʼƽ
#define IS_PWMPLUS_START_LEVEL(PWMPLUS_START_LEVEL)    (((PWMPLUS_START_LEVEL) == LEVEL_LOW) && ((PWMPLUS_START_LEVEL) == LEVEL_HIGH))

//  PWMPLUSͨƽ
#define IS_PWMPLUS_IDLE_LEVEL(PWMPLUS_IDLE_LEVEL)    (((PWMPLUS_IDLE_LEVEL) == LEVEL_LOW) && ((PWMPLUS_IDLE_LEVEL) == LEVEL_HIGH))

//  PWMPLUSͨźŵƽת
#define IS_PWMPLUS_OUTINV(PWMPLUS_OUTINV)            (((PWMPLUS_OUTINV) == ENABLE) && ((PWMPLUS_OUTINV) == DISABLE))

//  PWMPLUSͨʹ
#define IS_PWMPLUS_OUTEN(PWMPLUS_OUTEN)        (((PWMPLUS_OUTEN) == ENABLE) && ((PWMPLUS_OUTEN) == DISABLE))

//  PWMPLUSɲʹ
#define IS_PWMPLUS_BRAKEEN(PWMPLUS_BRAKEEN)    (((PWMPLUS_BRAKEEN) == ENABLE) && ((PWMPLUS_BRAKEEN) == DISABLE))

//  PWMPLUSɲͨƽ
#define IS_PWMPLUS_BRAKE_OUTLEVEL(PWMPLUS_BRAKE_OUTLEVEL)    (((PWMPLUS_BRAKE_OUTLEVEL) == LEVEL_LOW) && ((PWMPLUS_BRAKE_OUTLEVEL) == LEVEL_HIGH))

//  PWMPLUSͨʹ
#define IS_PWMPLUS_MASK_EN(PWMPLUS_MASK_EN)    (((PWMPLUS_MASK_EN) == ENABLE) && ((PWMPLUS_MASK_EN) == DISABLE))

//  PWMPLUSͨƽ
#define IS_PWMPLUS_MASK_LEVEL(PWMPLUS_MASK_LEVEL)    (((PWMPLUS_MASK_LEVEL) == LEVEL_LOW) && ((PWMPLUS_MASK_LEVEL) == LEVEL_HIGH))

//  PWMPLUSԶװжʹ
#define IS_PWMPLUS_RELOAD_IE(PWMPLUS_RELOAD_IE)    (((PWMPLUS_RELOAD_IE) == ENABLE) && ((PWMPLUS_RELOAD_IE) == DISABLE))

//  PWMPLUSɲ0жʹ
#define IS_PWMPLUS_BRAKE0_IE(PWMPLUS_BRAKE0_IE)    (((PWMPLUS_BRAKE0_IE) == ENABLE) && ((PWMPLUS_BRAKE0_IE) == DISABLE))

//  PWMPLUSɲ1жʹ
#define IS_PWMPLUS_BRAKE1_IE(PWMPLUS_BRAKE1_IE)    (((PWMPLUS_BRAKE1_IE) == ENABLE) && ((PWMPLUS_BRAKE1_IE) == DISABLE))

//  PWMPLUSϼжʹ
#define IS_PWMPLUS_UP_OVF_IE(PWMPLUS_UP_OVF_IE)    (((PWMPLUS_UP_OVF_IE) == ENABLE) && ((PWMPLUS_UP_OVF_IE) == DISABLE))

//  PWMPLUS¼жʹ
#define IS_PWMPLUS_DOWN_OVF_IE(PWMPLUS_DOWN_OVF_IE)    (((PWMPLUS_DOWN_OVF_IE) == ENABLE) && ((PWMPLUS_DOWN_OVF_IE) == DISABLE))

//  PWMPLUSϼڲжʹ
#define IS_PWMPLUS_UP_TRIGCOMP_IE(PWMPLUS_UP_TRIGCOMP_IE)    (((PWMPLUS_UP_TRIGCOMP_IE) == ENABLE) && ((PWMPLUS_UP_TRIGCOMP_IE) == DISABLE))

//  PWMPLUS¼ڲжʹ
#define IS_PWMPLUS_DOWN_TRIGCOMP_IE(PWMPLUS_DOWN_TRIGCOMP_IE)    (((PWMPLUS_DOWN_TRIGCOMP_IE) == ENABLE) && ((PWMPLUS_DOWN_TRIGCOMP_IE) == DISABLE))

//  PWMPLUSϼתжʹ
#define IS_PWMPLUS_UP_COMP_IE(PWMPLUS_UP_COMP_IE)    (((PWMPLUS_UP_COMP_IE) == ENABLE) && ((PWMPLUS_UP_COMP_IE) == DISABLE))

//  PWMPLUS¼תжʹ
#define IS_PWMPLUS_DOWN_COMP_IE(PWMPLUS_DOWN_COMP_IE)    (((PWMPLUS_DOWN_COMP_IE) == ENABLE) && ((PWMPLUS_DOWN_COMP_IE) == DISABLE))



void PWMPLUS_CommonInit(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_CommonInitTypeDef * PWMPLUS_CommonInitStruct);        //PWMPLUSʼ

void PWMPLUS_ChannelInit(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_ChannelInitTypeDef * PWMPLUS_ChannelInitStruct);     //PWMPLUSͨʼ

void PWMPLUS_Start(PWMPLUS_TypeDef * PWMPLUSx);                                                                   //PWMPLUSʼPWM

void PWMPLUS_Stop(PWMPLUS_TypeDef * PWMPLUSx);                                                                    //رPWMPLUSֹͣPWM

void PWMPLUS_SetClk_Src(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Clk_Src_TypeDef Clk_Src);                              //PWMPLUSʱѡ

void PWMPLUS_SetClkDiv(PWMPLUS_TypeDef * PWMPLUSx,uint8_t ClkDiv);                                                //ԤƵϵ   ʵʷƵΪֵ1

void PWMPLUS_SetMode(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Mode_TypeDef Mode);                                       //ùģʽ

void PWMPLUS_SetDir(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Dir_TypeDef Dir);                                          //ü

void PWMPLUS_SetReload_Cnt(PWMPLUS_TypeDef * PWMPLUSx,uint8_t Reload_Cnt);                                        //Զװش   ʵװشΪֵ1

void PWMPLUS_SetBrake_Filter(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_BrakeFilter_TypeDef Brake_Filter);                //ɲ˲

void PWMPLUS_SetBrake_InputLevel(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_BrakeLevel_TypeDef Brake_InputLevel);         //ɲЧƽѡ 

void PWMPLUS_SetBrake_Enable(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_BrakeEnable_TypeDef Brake_Enable);    //ɲʹ

void PWMPLUS_SetBrake_OutLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef Brake_OutLevel);      //ɲʱͨƽ

void PWMPLUS_SetMask_Enable(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState Mask_Enable);                  //ιǷʹ

void PWMPLUS_SetMask_Level(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef Mask_Level);              //ƽ

void PWMPLUS_SetStartLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef StartLevel);              //PWMPLUSʼƽ

void PWMPLUS_SetIdleLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef  IdleLevel);               //PWMPLUSƽ

void PWMPLUS_SetOutEn(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState  OutEn);                             //PWMPLUSʹ

void PWMPLUS_SetOutInv(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState  OutInv);                           //PWMPLUSźŷת

void PWMPLUS_SetPeriod(PWMPLUS_TypeDef * PWMPLUSx, uint32_t Period);                                              //

uint32_t PWMPLUS_GetPeriod(PWMPLUS_TypeDef * PWMPLUSx);                                                           //ȡ

void PWMPLUS_SetComp(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx,uint32_t Comp);                                      //÷ת

uint32_t PWMPLUS_GetComp(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                                //ȡõķת

void PWMPLUS_SetDeadZone(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx,uint16_t DeadZone);                              //ͨ

uint16_t PWMPLUS_GetDeadZone(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                            //ȡͨ

void PWMPLUS_SetTrig_Comp(PWMPLUS_TypeDef * PWMPLUSx, uint32_t Trig_Comp);                                        //ڲ

uint32_t PWMPLUS_GetTrig_Comp(PWMPLUS_TypeDef * PWMPLUSx);                                                        //ȡڲ

void PWMPLUS_SetTrig_Sel(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_TrigSel_TypeDef Trig_Sel);                           //ôźŹѡ

uint8_t PWMPLUS_GetTrig_Sel(PWMPLUS_TypeDef * PWMPLUSx);                                                          //ȡźŹѡ

void PWMPLUS_IntReloadEn(PWMPLUS_TypeDef * PWMPLUSx);                                                             //Զװжʹ

void PWMPLUS_IntReloadDis(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ԶװжϽ

uint8_t PWMPLUS_IntReloadState(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡԶװж״̬

void PWMPLUS_IntReloadClr(PWMPLUS_TypeDef * PWMPLUSx);                                                            //Զװж״̬

void PWMPLUS_IntBrake0En(PWMPLUS_TypeDef * PWMPLUSx);                                                             //ɲ0жʹ
 
void PWMPLUS_IntBrake0Dis(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ɲ0жϽ

uint8_t PWMPLUS_IntBrake0State(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡɲ0ж״̬

void PWMPLUS_IntBrake0Clr(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ɲ0ж״̬

void PWMPLUS_IntBrake1En(PWMPLUS_TypeDef * PWMPLUSx);                                                             //ɲ1жʹ

void PWMPLUS_IntBrake1Dis(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ɲ1жϽ

uint8_t PWMPLUS_IntBrake1State(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡɲ1ж״̬

void PWMPLUS_IntBrake1Clr(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ɲ1ж״̬

void PWMPLUS_IntUp_OvfEn(PWMPLUS_TypeDef * PWMPLUSx);                                                             //ϼжʹ

void PWMPLUS_IntUp_OvfDis(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ϼжϽ

uint8_t PWMPLUS_IntUp_OvfState(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡϼж״̬

void PWMPLUS_IntUp_OvfClr(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ϼж״̬

void PWMPLUS_IntUp_TrigCompEn(PWMPLUS_TypeDef * PWMPLUSx);                                                        //ϼﴥжʹ

void PWMPLUS_IntUp_TrigCompDis(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ϼﴥжϽ

uint8_t PWMPLUS_IntUp_TrigCompState(PWMPLUS_TypeDef * PWMPLUSx);                                                  //ȡϼﴥж״̬

void PWMPLUS_IntUp_TrigCompClr(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ϼﴥж״̬

void PWMPLUS_IntDown_OvfEn(PWMPLUS_TypeDef * PWMPLUSx);                                                           //¼жʹ

void PWMPLUS_IntDown_OvfDis(PWMPLUS_TypeDef * PWMPLUSx);                                                          //¼жϽ

uint8_t PWMPLUS_IntDown_OvfState(PWMPLUS_TypeDef * PWMPLUSx);                                                     //ȡ¼ж״̬

void PWMPLUS_IntDown_OvfClr(PWMPLUS_TypeDef * PWMPLUSx);                                                          //¼ж״̬

void PWMPLUS_IntDown_TrigCompEn(PWMPLUS_TypeDef * PWMPLUSx);                                                      //¼ﴥжʹ

void PWMPLUS_IntDown_TrigCompDis(PWMPLUS_TypeDef * PWMPLUSx);                                                     //¼ﴥжϽ

uint8_t PWMPLUS_IntDown_TrigCompState(PWMPLUS_TypeDef * PWMPLUSx);                                                //ȡ¼ﴥж״̬

void PWMPLUS_IntDown_TrigCompClr(PWMPLUS_TypeDef * PWMPLUSx);                                                     //¼ﴥж״̬

void PWMPLUS_IntUp_CompEn(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                               //ϼ﷭תжʹ

void PWMPLUS_IntUp_CompDis(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                              //ϼ﷭תжϽ

uint8_t PWMPLUS_IntUp_CompState(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                         //ȡϼ﷭תж״̬

void PWMPLUS_IntUp_CompClr(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                              //ϼ﷭תж״̬

void PWMPLUS_IntDown_CompEn(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                             //¼﷭תжʹ

void PWMPLUS_IntDown_CompDis(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                            //¼﷭תжϽ

uint8_t PWMPLUS_IntDown_CompState(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                       //ȡ¼﷭תж״̬

void PWMPLUS_IntDown_CompClr(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx);                                            //¼﷭תж״̬

void PWMPLUS_SoftLoad(PWMPLUS_TypeDef * PWMPLUSx);                                                                //PWMPLUSLOAD

uint8_t PWMPLUS_GetCntState(PWMPLUS_TypeDef * PWMPLUSx);                                                          //ȡPWMPLUS״̬

uint8_t PWMPLUS_GetCntDir(PWMPLUS_TypeDef * PWMPLUSx);                                                            //ȡPWMPLUSǰ

uint16_t PWMPLUS_GetCurrentCnt(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡPWMPLUSǰֵ

uint8_t PWMPLUS_GetBrake0State(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡPWMPLUSɲ0ĵǰ״̬

uint8_t PWMPLUS_GetBrake1State(PWMPLUS_TypeDef * PWMPLUSx);                                                       //ȡPWMPLUSɲ1ĵǰ״̬
	

#endif //__BL2102_PWMPLUS_H__
