#include "BL2102_timerplus.h"


/****************************************************************************************************************************************** 
* :	TIMPLUS_Common_Init()
* ˵:	TIMPLUSʼ
*     : TIMPLUS_TypeDef * TIMPLUSx                              ָҪõTIMPLUSЧֵTIMPLUS0
*			TIMPLUS_CommonInitTypeDef * TIMPLUS_CommonInitStruct	TIMPLUS趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_Common_Init(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_CommonInitTypeDef * TIMPLUS_CommonInitStruct)
{
	switch((uint32_t)TIMPLUSx)
	{
		case((uint32_t)TIMPLUS0):
		
			SYS->CLKEN |= 0x01 << SYS_CLKEN_TIMPLUS0_POS;           //TIMPLUS0ʱ
		
		break;
	}
	
	TIMPLUS_Stop(TIMPLUSx,type);                                    //رնʱ
	
	TIMPLUSx->DIV = TIMPLUS_CommonInitStruct->ClkDiv;               //TIMPLUSƵϵ,ʵʷƵΪֵ1
	
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_MODE_POS);       //ģʽѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->Mode << TIMPLUS_CTR_LOW_MODE_POS);
		
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_CLKSEL_POS);     //ʱԴѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ClkSel << TIMPLUS_CTR_LOW_CLKSEL_POS);
		
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_LOW_EXTSEL_POS);     //ģʽ벶ģʽźѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ExtSel << TIMPLUS_CTR_LOW_EXTSEL_POS);
		
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_EXTLEVEL_POS);   //ģʽ벶ģʽźЧѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ExtLevel << TIMPLUS_CTR_LOW_EXTLEVEL_POS);
		
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_LOW_OUTEN_POS);      //ʱģʽ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->OutEn << TIMPLUS_CTR_LOW_OUTEN_POS);
		
		TIMPLUSx->LOW_PERIOD = TIMPLUS_CommonInitStruct->Period;    //ʱֵ
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_OVF_POS);          //ʱжʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->Ovf_IE << TIMPLUS_IE_LOW_OVF_POS);
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_RISE_POS);         //ʱжʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->RIse_IE << TIMPLUS_IE_LOW_RISE_POS);
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_FALL_POS);         //ʱ½жʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->Fall_IE << TIMPLUS_IE_LOW_FALL_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		if(TIMPLUS_CommonInitStruct->Mode >= HALL_MODE)
		{
			TIMPLUS_CommonInitStruct->Mode = TIMER_MODE;
		}
		
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_MODE_POS);       //ģʽѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->Mode << TIMPLUS_CTR_HIGH_MODE_POS);
		
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_CLKSEL_POS);     //ʱԴѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ClkSel << TIMPLUS_CTR_HIGH_CLKSEL_POS);
		
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_HIGH_EXTSEL_POS);     //ģʽ벶ģʽźѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ExtSel << TIMPLUS_CTR_HIGH_EXTSEL_POS);
		
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_EXTLEVEL_POS);   //ģʽ벶ģʽźЧѡ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->ExtLevel << TIMPLUS_CTR_HIGH_EXTLEVEL_POS);
		
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_HIGH_OUTEN_POS);      //ʱģʽ
		TIMPLUSx->CTR |=  (TIMPLUS_CommonInitStruct->OutEn << TIMPLUS_CTR_HIGH_OUTEN_POS);
		
		TIMPLUSx->HIGH_PERIOD = TIMPLUS_CommonInitStruct->Period;    //ʱֵ
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_OVF_POS);          //ʱжʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->Ovf_IE << TIMPLUS_IE_HIGH_OVF_POS);
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_RISE_POS);         //ʱжʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->RIse_IE << TIMPLUS_IE_HIGH_RISE_POS);
		
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_FALL_POS);         //ʱ½жʹ
		TIMPLUSx->IE |= (TIMPLUS_CommonInitStruct->Fall_IE << TIMPLUS_IE_HIGH_FALL_POS);
	}
	
	if(TIMPLUS_CommonInitStruct->Ovf_IE || TIMPLUS_CommonInitStruct->RIse_IE || TIMPLUS_CommonInitStruct->Fall_IE)
	{
		NVIC_EnableIRQ(TIMPLUS0_IRQn);
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_Hall_Init()
* ˵:	TIMPLUSͨʼ
*     : TIMPLUS_TypeDef * TIMPLUSx                  ָҪõTIMPLUSЧֵTIMPLUS0
*			TIMPLUS_HallInitTypeDef * TIMPLUS_HallInitStruct	TIMPLUS HALL趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_Hall_Init(TIMPLUS_TypeDef * TIMPLUSx, TIMPLUS_HallInitTypeDef * TIMPLUS_HallInitStruct)
{
	TIMPLUS_Stop(TIMPLUSx,TIMPLUS_LOW);                          //رնʱ
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL0_RISE_POS);          //HALL0жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall0_Rise_IE << TIMPLUS_IE_HALL0_RISE_POS);
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL0_FALL_POS);          //HALL0½жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall0_Fall_IE << TIMPLUS_IE_HALL0_FALL_POS);
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL1_RISE_POS);          //HALL1жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall1_Rise_IE << TIMPLUS_IE_HALL1_RISE_POS);
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL1_FALL_POS);          //HALL1½жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall1_Fall_IE << TIMPLUS_IE_HALL1_FALL_POS);
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL2_RISE_POS);          //HALL2жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall2_Rise_IE << TIMPLUS_IE_HALL2_RISE_POS);
	
	TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL2_FALL_POS);          //HALL2½жʹ
	TIMPLUSx->IE |= (TIMPLUS_HallInitStruct->Hall2_Fall_IE << TIMPLUS_IE_HALL2_FALL_POS);
	
	if(TIMPLUS_HallInitStruct->Hall0_Rise_IE || TIMPLUS_HallInitStruct->Hall0_Fall_IE || TIMPLUS_HallInitStruct->Hall1_Rise_IE || \
	   TIMPLUS_HallInitStruct->Hall1_Fall_IE || TIMPLUS_HallInitStruct->Hall2_Rise_IE || TIMPLUS_HallInitStruct->Hall2_Fall_IE  )
	{
		NVIC_EnableIRQ(TIMPLUS0_IRQn);
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_Start()
* ˵:	ʱӳʼֵʼʱ/
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
*           uint8_t type	ʱѡ   116λʱ  216λʱ 
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_Start(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->EN |= (0x01 << TIMPLUS_EN_LOW_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->EN |= (0x01 << TIMPLUS_EN_HIGH_POS);
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_Stop()
* ˵:	ֹͣʱ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
*           uint8_t type	ʱѡ   116λʱ  216λʱ 
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_Stop(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->EN &= ~(0x01 << TIMPLUS_EN_LOW_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->EN &= ~(0x01 << TIMPLUS_EN_HIGH_POS);
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_SetClkDiv()
* ˵:	ԤƵϵ   ʵʷƵΪֵ1
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            uint8_t Clk_Div   ԤƵϵ   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetClkDiv(TIMPLUS_TypeDef * TIMPLUSx,uint8_t Clk_Div)
{
	TIMPLUSx->DIV = Clk_Div;          //TIMPLUSƵϵ  ʵʷƵΪֵ1
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_SetMode()
* ˵:	ùģʽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type     ʱѡ   116λʱ  216λʱ 
*	        TIMPLUS_ModeTypeDef Mode	 ģʽѡ	
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetMode(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ModeTypeDef Mode)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_MODE_POS);       //ģʽѡ
		TIMPLUSx->CTR |=  (Mode << TIMPLUS_CTR_LOW_MODE_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_MODE_POS);      //ģʽѡ
		TIMPLUSx->CTR |=  (Mode << TIMPLUS_CTR_HIGH_MODE_POS);
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_SetClkSel()
* ˵:	üʱԴ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ 
*	        TIMPLUS_ClkSelTypeDef ClkSel	 ʱԴѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetClkSel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ClkSelTypeDef ClkSel)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_CLKSEL_POS);       //ʱԴѡ
		TIMPLUSx->CTR |=  (ClkSel << TIMPLUS_CTR_LOW_CLKSEL_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_CLKSEL_POS);      //ʱԴѡ
		TIMPLUSx->CTR |=  (ClkSel << TIMPLUS_CTR_HIGH_CLKSEL_POS);
	}	
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_SetExtSel()
* ˵:	üģʽ벶ģʽź
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ 
*	        TIMPLUS_ExtSelTypeDef ExtSel	 ģʽ벶ģʽźѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetExtSel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ExtSelTypeDef ExtSel)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_LOW_EXTSEL_POS);       //ģʽ벶ģʽźѡ
		TIMPLUSx->CTR |=  (ExtSel << TIMPLUS_CTR_LOW_EXTSEL_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_HIGH_EXTSEL_POS);      //ģʽ벶ģʽźѡ
		TIMPLUSx->CTR |=  (ExtSel << TIMPLUS_CTR_HIGH_EXTSEL_POS);
	}	
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_SetExtLevel()
* ˵:	üģʽ벶ģʽźЧ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type             ʱѡ   116λʱ  216λʱ 
*	        TIMPLUS_ExtLevelTypeDef ExtLevel	 ģʽ벶ģʽźЧѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetExtLevel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ExtLevelTypeDef ExtLevel)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_LOW_EXTLEVEL_POS);       //ģʽ벶ģʽźЧѡ
		TIMPLUSx->CTR |=  (ExtLevel << TIMPLUS_CTR_LOW_EXTLEVEL_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->CTR &= ~(0x03 << TIMPLUS_CTR_HIGH_EXTLEVEL_POS);      //ģʽ벶ģʽźЧѡ
		TIMPLUSx->CTR |=  (ExtLevel << TIMPLUS_CTR_HIGH_EXTLEVEL_POS);
	}	
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_SetOutEn()
* ˵:	öʱģʽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ 
*	        TIMPLUS_OutEnTypeDef OutEn	     ʱģʽ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetOutEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,FunctionalState OutEn)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_LOW_OUTEN_POS);      //ʱģʽ
		TIMPLUSx->CTR |=  (OutEn << TIMPLUS_CTR_LOW_OUTEN_POS);
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->CTR &= ~(0x01 << TIMPLUS_CTR_HIGH_OUTEN_POS);      //ʱģʽ
		TIMPLUSx->CTR |=  (OutEn << TIMPLUS_CTR_HIGH_OUTEN_POS);
	}	
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_SetPeriod()
* ˵:	öʱֵ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ 
*	        uint16_t Period          	     ʱֵ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_SetPeriod(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,uint16_t Period)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->LOW_PERIOD = Period;     //ʱֵ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->HIGH_PERIOD = Period;    //ʱֵ
	}	
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_SetPeriod()
* ˵:	ȡʱֵ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : ʱֵ
* ע: 
******************************************************************************************************************************************/
uint16_t TIMPLUS_GetPeriod(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		return TIMPLUSx->LOW_PERIOD;     //ضʱֵ
	}
	
	if(type == TIMPLUS_HIGH)
	{
		return TIMPLUSx->HIGH_PERIOD;    //ضʱֵ
	}

	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_GetCurrentCnt()
* ˵:	ȡʱǰֵ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : ʱǰֵ
* ע: 
******************************************************************************************************************************************/
uint16_t TIMPLUS_GetCurrentValue(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		return TIMPLUSx->LOW_CNT;     //ضʱǰֵ
	}
	
	if(type == TIMPLUS_HIGH)
	{
		return TIMPLUSx->HIGH_CNT;    //ضʱǰֵ
	}
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_GetCaptureCnt()
* ˵:	ȡʱֵ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : ʱֵ
* ע: 
******************************************************************************************************************************************/
uint16_t TIMPLUS_GetCaptureValue(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		return TIMPLUSx->LOW_CVAL;     //ضʱֵ
	}
	
	if(type == TIMPLUS_HIGH)
	{
		return TIMPLUSx->HIGH_CVAL;    //ضʱֵ
	}
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_GetHallLevel()
* ˵:	ȡHALLʼƽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2     	     
*     : HALLʼƽ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_GetHallLevel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if(HallLevel == HALL_0)
	{
		return (TIMPLUSx->HALL_VAL & TIMPLUS_HALL_VAL_HALL0_MSK);
	}
	
	if(HallLevel == HALL_1)
	{
		return (TIMPLUSx->HALL_VAL & TIMPLUS_HALL_VAL_HALL1_MSK);
	}
	
	if(HallLevel == HALL_2)
	{
		return (TIMPLUSx->HALL_VAL & TIMPLUS_HALL_VAL_HALL2_MSK);
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntOvfEn()
* ˵:	öʱжʹ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntOvfEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_LOW_OVF_POS);         //ʱжʹ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HIGH_OVF_POS);        //ʱжʹ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntOvfDis()
* ˵:	öʱжϽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntOvfDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_OVF_POS);         //ʱжϽ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_OVF_POS);        //ʱжϽ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntOvfClr()
* ˵:	ʱж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntOvfClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_LOW_OVF_POS);         //ʱж״̬
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HIGH_OVF_POS);        //ʱж״̬
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntOvfState()
* ˵:	ȡʱж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 1 жѾ    0  жδ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_IntOvfState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_LOW_OVF_MSK)
		{
			return 1;
		}
	}
	
	if(type == TIMPLUS_HIGH)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_HIGH_OVF_MSK)
		{
			return 1;
		}
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntRiseEn()
* ˵:	öʱжʹ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntRiseEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_LOW_RISE_POS);         //ʱжʹ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HIGH_RISE_POS);        //ʱжʹ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntRiseDis()
* ˵:	öʱжϽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntRiseDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_RISE_POS);         //ʱжϽ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_RISE_POS);        //ʱжϽ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntRiseClr()
* ˵:	ʱж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntRiseClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_LOW_RISE_POS);         //ʱж״̬
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HIGH_RISE_POS);        //ʱж״̬
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntRiseState()
* ˵:	ȡʱж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 1 жѾ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_IntRiseState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_LOW_RISE_MSK)
		{
			return 1;
		}
	}
	
	if(type == TIMPLUS_HIGH)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_HIGH_RISE_MSK)
		{
			return 1;
		}
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntFallEn()
* ˵:	öʱ½жʹ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntFallEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_LOW_FALL_POS);         //ʱ½жʹ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HIGH_FALL_POS);        //ʱ½жʹ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntFallDis()
* ˵:	öʱ½жϽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntFallDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_LOW_FALL_POS);         //ʱ½жϽ
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HIGH_FALL_POS);        //ʱ½жϽ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntFallClr()
* ˵:	ʱ½ж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntFallClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if((type & TIMPLUS_LOW) == TIMPLUS_LOW)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_LOW_FALL_POS);         //ʱ½ж״̬
	}
	
	if((type & TIMPLUS_HIGH) == TIMPLUS_HIGH)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HIGH_FALL_POS);        //ʱ½ж״̬
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntFallState()
* ˵:	ȡʱ½ж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_TypeTypeDef type         ʱѡ   116λʱ  216λʱ        	     
*     : 1 ½жѾ    0 ½жδ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_IntFallState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type)
{
	if(type == TIMPLUS_LOW)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_LOW_FALL_MSK)
		{
			return 1;
		}
	}
	
	if(type == TIMPLUS_HIGH)
	{
		if(TIMPLUSx->IF & TIMPLUS_IF_HIGH_FALL_MSK)
		{
			return 1;
		}
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallRiseEn()
* ˵:	öʱHALLжʹ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallRiseEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL0_RISE_POS);      //ʱHALL0жʹ
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL1_RISE_POS);     //ʱHALL1жʹ
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL2_RISE_POS);     //ʱHALL2жʹ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallRiseDis()
* ˵:	öʱHALLжϽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2     	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallRiseDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL0_RISE_POS);    //ʱHALL0жϽ
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL1_RISE_POS);    //ʱHALL1жϽ
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL2_RISE_POS);    //ʱHALL2жϽ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallRiseClr()
* ˵:	ʱHALLж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2        	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallRiseClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL0_RISE_POS);    //ʱHALL0ж״̬
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL1_RISE_POS);    //ʱHALL1ж״̬
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL2_RISE_POS);    //ʱHALL2ж״̬
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallRiseState()
* ˵:	ȡʱHALLж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0  	     
*     : 1 жѾ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_IntHallRiseState(TIMPLUS_TypeDef * TIMPLUSx)
{
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL0_RISE_MSK)
	{
		return 1;
	}
	
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL1_RISE_MSK)
	{
		return 1;
	}
	
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL2_RISE_MSK)
	{
		return 1;
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallFallEn()
* ˵:	öʱHALL½жʹ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2         	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallFallEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL0_FALL_POS);      //ʱHALL0½жʹ
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL1_FALL_POS);     //ʱHALL1½жʹ
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IE |= (0x01 << TIMPLUS_IE_HALL2_FALL_POS);     //ʱHALL2½жʹ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallFallDis()
* ˵:	öʱHALL½жϽ
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2       	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallFallDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL0_FALL_POS);    //ʱHALL0½жϽ
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL1_FALL_POS);    //ʱHALL1½жϽ
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IE &= ~(0x01 << TIMPLUS_IE_HALL2_FALL_POS);    //ʱHALL2½жϽ
	}
}

/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallFallClr()
* ˵:	ʱHALL½ж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0
            TIMPLUS_HallTypeDef HallLevel    ѡ  HALL0  HALL1  HALL2         	     
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMPLUS_IntHallFallClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel)
{
	if((HallLevel & HALL_0) == HALL_0)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL0_FALL_POS);    //ʱHALL0½ж״̬
	}
	
	if((HallLevel & HALL_1) == HALL_1)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL1_FALL_POS);    //ʱHALL1½ж״̬
	}
	
	if((HallLevel & HALL_2) == HALL_2)
	{
		TIMPLUSx->IF = (0x01 << TIMPLUS_IF_HALL2_FALL_POS);    //ʱHALL2½ж״̬
	}
}


/****************************************************************************************************************************************** 
* :	TIMPLUS_IntHallFallState()
* ˵:	ȡʱHALL½ж״̬
*     : TIMPLUS_TypeDef * TIMPLUSx       ЧֵTIMPLUS0     	     
*     : 1 ½жѾ    0 ½жδ
* ע: 
******************************************************************************************************************************************/
uint8_t TIMPLUS_IntHallFallState(TIMPLUS_TypeDef * TIMPLUSx)
{
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL0_FALL_MSK)
	{
		return 1;
	}
	
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL1_FALL_MSK)
	{
		return 1;
	}
	
	if(TIMPLUSx->IF & TIMPLUS_IF_HALL2_FALL_MSK)
	{
		return 1;
	}
	
	return 0;
}

