#include "BL210x_exti.h"

/****************************************************************************************************************************************** 
* : EXTI_Init()
* ˵:	ָⲿжϳʼ
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 		ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*			uint32_t mode	        ЧֵEXTI_FALL_EDGEEXTI_RISE_EDGEEXTI_BOTH_EDGEEXTI_LOW_LEVELEXTI_HIGH_LEVEL
*     : 
* ע: 
******************************************************************************************************************************************/
void EXTI_Init(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin, uint32_t mode)
{
	EXTI_Close(GPIOx, GPIO_Pin);			               //ùؼĴǰȹر
	
	if(mode & 0x10)
	{
		GPIOx->INTLVLTRG |= (0x01 << GPIO_Pin);			   //ƽ
		
		if(mode & 0x01)
			GPIOx->INTRISEEN |= (0x01 << GPIO_Pin);		   //ߵƽ
		else
			GPIOx->INTRISEEN &= ~(0x01 << GPIO_Pin);	   //͵ƽ
	}		
	else
	{
		GPIOx->INTLVLTRG &= ~(0x01 << GPIO_Pin);		   //ش
		
		if(mode & 0x02)
		{
			GPIOx->INTBE |= (0x01 << GPIO_Pin);			   //˫ش	
		}
		else
		{
			GPIOx->INTBE &= ~(0x01 << GPIO_Pin);		   //ش
			
			if(mode & 0x01)
				GPIOx->INTRISEEN |= (0x01 << GPIO_Pin);	   //ش
			else
				GPIOx->INTRISEEN &= ~(0x01 << GPIO_Pin);   //½ش
		}
	}
	
	GPIOx->INTCLR = (1 << GPIO_Pin);		//Ϊģʽÿܲж
}

/****************************************************************************************************************************************** 
* :	EXTI_Open()
* ˵:	ָⲿжϴ򿪣ʹܣ
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 		ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: 
******************************************************************************************************************************************/
void EXTI_Open(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->INTEN |= (0x01 << GPIO_Pin);
}

/****************************************************************************************************************************************** 
* :	EXTI_Close()
* ˵:	ָⲿжϹرգܣ
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 		ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: 
******************************************************************************************************************************************/
void EXTI_Close(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->INTEN &= ~(0x01 << GPIO_Pin);
}

/****************************************************************************************************************************************** 
* :	EXTI_State()
* ˵:	ָǷ񴥷ж
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 		ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : uint32_t	1 Ŵж    0 δж
* ע: 
******************************************************************************************************************************************/
uint32_t EXTI_State(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	return (GPIOx->INTSTAT >> GPIO_Pin) & 0x01;
}

/****************************************************************************************************************************************** 
* :	EXTI_RawState()
* ˵:	ָǷ/жϴжϹرʱͨô˺ԲѯķʽǷ/жϴ
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 	    ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : uint32_t	1 /жϴ    0 δ/жϴ
* ע: 
******************************************************************************************************************************************/
uint32_t EXTI_RawState(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	return (GPIOx->INTRAWSTAT >> GPIO_Pin) & 0x01;
}

/****************************************************************************************************************************************** 
* :	EXTI_Clear()
* ˵:	ָⲿжжϱ־ٴνжϣ
*     : GPIO_TypeDef * GPIOx	ָⲿжϵGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin 	    ָⲿжϵGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: ֻشжϵı־ƽжϵı־޷ֻŵƽжϴӲԶ
******************************************************************************************************************************************/
void EXTI_Clear(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->INTCLR = (0x01 << GPIO_Pin);
}


