#include "BL210x_spi.h"

/****************************************************************************************************************************************** 
* :	SPI_Init()
* ˵:	SPIʼ
*     : SPI_InitTypeDef * SPI_InitStruct    
*     : 
* ע: 
******************************************************************************************************************************************/
#ifdef IC_BL2102
void SPI_Init(SPI_TypeDef * SPIx,SPI_InitTypeDef * SPI_InitStruct)
{
//	assert_param(IS_SPI_MODE(SPI_InitStruct->Master));               //ĲMasterǷϷ     
//	
//	assert_param(IS_SPI_CLKDIV(SPI_InitStruct->ClkDiv));             //ĲClkDivǷϷ 
//	
//	assert_param(IS_SPI_SAMPLE_EDGE(SPI_InitStruct->SampleEdge));    //ĲSampleEdgeǷϷ 
//	
//	assert_param(IS_SPI_IDLE_LEVEL(SPI_InitStruct->IdleLevel));      //ĲIdleLevelǷϷ 
//	
//	assert_param(IS_SPI_LSBFIRST(SPI_InitStruct->LsbFirst));         //ĲLsbFirstǷϷ 
	
	switch((uint32_t)SPIx)
	{
		case ((uint32_t)SPI0):
			
			SYS->CLKEN |= 0x01 << SYS_CLKEN_SPI0_POS;    //SPI0ʱ
		
			break;
	}
	
	SPI_Close(SPIx);     //SPIرʱüĴ
	
	SPIx->CTRL &= ~(SPI_CTRL_CLKDIV_MSK | SPI_CTRL_CPHA_MSK | SPI_CTRL_CPOL_MSK | SPI_CTRL_MSTR_MSK | SPI_CTRL_LSBF_MSK);
	
	SPIx->CTRL |= (SPI_InitStruct->ClkDiv     << SPI_CTRL_CLKDIV_POS) |
	             (SPI_InitStruct->SampleEdge << SPI_CTRL_CPHA_POS)   |
	             (SPI_InitStruct->IdleLevel  << SPI_CTRL_CPOL_POS)   |
	             (SPI_InitStruct->Master     << SPI_CTRL_MSTR_POS)   |
	             (SPI_InitStruct->LsbFirst   << SPI_CTRL_LSBF_POS);
}
/****************************************************************************************************************************************** 
* :	SPI_Open()
* ˵:	SPI򿪣շ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Open(SPI_TypeDef * SPIx)
{
	SPIx->CTRL |= (0x01 << SPI_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* :	SPI_Close()
* ˵:	SPIرգֹշ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Close(SPI_TypeDef * SPIx)
{
	SPIx->CTRL &= ~(0x01 << SPI_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* : SPI_Write()
* ˵: һ
*     : uint8_t data 			Ҫ͵		
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Write(SPI_TypeDef * SPIx,uint8_t data)
{
	SPIx->WDATA = data;	
}

/****************************************************************************************************************************************** 
* : SPI_Write_Wait()
* ˵: һݣȴ
*     : uint8_t data 			Ҫ͵		
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Write_Wait(SPI_TypeDef * SPIx,uint8_t data)
{
	SPIx->WDATA = data;
	while(!(SPIx->IF & SPI_SPIF_IF_MSK));
	SPIx->IF = 0x01 << SPI_SPIF_IF_POS;
}


/****************************************************************************************************************************************** 
* : SPI_ReadWrite()
* ˵: һݣط͹нյ
*     : uint8_t data 			Ҫ͵		
*     : uint8_t				    յ
* ע: 
******************************************************************************************************************************************/
uint8_t SPI_ReadWrite(SPI_TypeDef * SPIx,uint8_t data)
{
	uint8_t temp;
	
	SPIx->WDATA = data;
	while(!(SPIx->IF & SPI_SPIF_IF_MSK));
	
	temp = SPIx->RDATA;
	SPIx->IF = 0x01 << SPI_SPIF_IF_POS;
	
	return temp;
}

/****************************************************************************************************************************************** 
* : SPI_ReadBytes()
* ˵: Ϊnum
*     : uint8_t num 			Ҫȡݸ	
*     : uint8_t	*data			յ
* ע: 
******************************************************************************************************************************************/
void SPI_ReadBytes(SPI_TypeDef * SPIx,uint8_t* data,uint8_t num)
{
	uint8_t i;
	
	SPI_Write_Wait(SPIx,0xFF);
	
	for(i = 0; i < num; i++)
	{
		SPIx->WDATA = 0xFF;
		while(!(SPIx->IF & SPI_SPIF_IF_MSK));
		data[i] = SPIx->RDATA;
		SPIx->IF = 0x01 << SPI_SPIF_IF_POS;
	}
}

/****************************************************************************************************************************************** 
* : SPI_Master_SSN_Out()
* ˵: ģʽ£SSNߵ͵ƽƴӻƬѡ
*     : uint8_t out 			SSNҪĵƽ    0 ͵ƽ   1 ߵƽ		
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Master_SSN_Out(SPI_TypeDef * SPIx,uint8_t out)
{
	if(out == 0)
	{
		SPIx->CTRL &= ~(0x01 << SPI_CTRL_MST_SSN_POS);
	}
	else
	{
		SPIx->CTRL |= (0x01 << SPI_CTRL_MST_SSN_POS);
	}	
}
#else
void SPI_Init(SPI_InitTypeDef * SPI_InitStruct)
{
	SYS->CLKEN |= 0x01 << SYS_CLKEN_SPI_POS;    //SPIʱ
	
	SPI_Close();     //SPIرʱüĴ
	
	SPI->CTRL &= ~(SPI_CTRL_CLKDIV_MSK | SPI_CTRL_CPHA_MSK | SPI_CTRL_CPOL_MSK | SPI_CTRL_MSTR_MSK | SPI_CTRL_LSBF_MSK);
	
	SPI->CTRL |= (SPI_InitStruct->ClkDiv     << SPI_CTRL_CLKDIV_POS) |
	             (SPI_InitStruct->SampleEdge << SPI_CTRL_CPHA_POS)   |
	             (SPI_InitStruct->IdleLevel  << SPI_CTRL_CPOL_POS)   |
	             (SPI_InitStruct->Master     << SPI_CTRL_MSTR_POS)   |
	             (SPI_InitStruct->LsbFirst   << SPI_CTRL_LSBF_POS);
}

/****************************************************************************************************************************************** 
* :	SPI_Open()
* ˵:	SPI򿪣շ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Open(void)
{
	SPI->CTRL |= (0x01 << SPI_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* :	SPI_Close()
* ˵:	SPIرգֹշ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Close(void)
{
	SPI->CTRL &= ~(0x01 << SPI_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* : SPI_Write()
* ˵: һ
*     : uint8_t data 			Ҫ͵		
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Write(uint8_t data)
{
	SPI->WDATA = data;
}

void SPI_Write_Wait(uint8_t data)
{
	SPI->WDATA = data;
	while(!(SPI->IF & SPI_SPIF_IF_MSK));
	SPI->IF = SPI_SPIF_IF_MSK;
}


/****************************************************************************************************************************************** 
* : SPI_ReadWrite()
* ˵: һݣط͹нյ
*     : uint8_t data 			Ҫ͵		
*     : uint8_t				    յ
* ע: 
******************************************************************************************************************************************/
uint8_t SPI_ReadWrite(uint8_t data)
{
	uint8_t temp;
	
	SPI->WDATA = data;
	while(!(SPI->IF & SPI_SPIF_IF_MSK));
	
	temp = SPI->RDATA;
	SPI->IF = SPI_SPIF_IF_MSK;
	
	return temp;
}

/****************************************************************************************************************************************** 
* : SPI_ReadBytes()
* ˵: Ϊnum
*     : uint8_t num 			Ҫȡݸ	
*     : uint8_t	*data			յ
* ע: 
******************************************************************************************************************************************/
void SPI_ReadBytes(uint8_t* data,uint8_t num)
{
	uint8_t i;
	
	SPI_Write_Wait(0xff);
	
	for(i = 0; i < num; i++)
	{
		SPI->WDATA = 0xff;
		while(!(SPI->IF & SPI_SPIF_IF_MSK));
		data[i] = SPI->RDATA;
		SPI->IF = SPI_SPIF_IF_MSK;
	}
}

/****************************************************************************************************************************************** 
* : SPI_Master_SSN_Out()
* ˵: ģʽ£SSNߵ͵ƽƴӻƬѡ
*     : uint8_t out 			SSNҪĵƽ    0 ͵ƽ   1 ߵƽ		
*     : 
* ע: 
******************************************************************************************************************************************/
void SPI_Master_SSN_Out(uint8_t out)
{
	if(out == 0)
	{
		SPI->CTRL &= ~(0x01 << SPI_CTRL_MST_SSN_POS);
	}
	else
	{
		SPI->CTRL |= (0x01 << SPI_CTRL_MST_SSN_POS);
	}	
}

#endif






