/************************************************************************************************/
/**
* @file               ciu32f003_std_irtim.h
* @author             MCU Ecosystem Development Team
* @brief              IRTIM STDͷļ
*                     ṩIRTIMصSTDԼĶ塣                         
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_IRTIM_H
#define CIU32F003_STD_IRTIM_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup IRTIM IRTIM
* @brief ģSTD
* @{
*/
/************************************************************************************************/

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"

/*--------------------------------------------define--------------------------------------------*/
/************************************************************************************************/
/**
* @defgroup IRTIM_Constants  IRTIM Constants
* @brief    IRTIM弰궨
* @{
*
*/
/************************************************************************************************/

/* IRTIM źԴѡ  */    
#define ITRIM_SIGNAL_SOURCE_TIM3_OC1                       IRTIM_CR_IR_MODE_TIM3_OC1                /**< źԴTIM3_OC1  */
#define ITRIM_SIGNAL_SOURCE_UART1_TX                       IRTIM_CR_IR_MODE_UART1_TX                /**< źԴUART1_TX  */
#define ITRIM_SIGNAL_SOURCE_UART2_TX                       IRTIM_CR_IR_MODE_UART2_TX                /**< źԴUART2_TX  */
                    
/* IRTIM źżѡ */
#define IRTIM_POLARITY_DIRECT                              (0x00000000U)                            /**< IRTIM źδ  */
#define IRTIM_POLARITY_INVERSE                             IRTIM_CR_IR_POL                          /**< IRTIM źŷ    */
     
     
/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup IRTIM_External_Functions IRTIM External Functions
* @brief    IRTIM⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  IRTIMźԴ
* @param  source źԴѡ
*             @arg ITRIM_SIGNAL_SOURCE_TIM3_OC1 źԴΪTIM3OC1
*             @arg ITRIM_SIGNAL_SOURCE_UART1_TX źԴΪUART1
*             @arg ITRIM_SIGNAL_SOURCE_UART2_TX źԴΪUART2
* @retval 
*/
__STATIC_INLINE void std_irtim_set_signal_source(uint32_t source)
{
    MODIFY_REG(IRTIM->CR, IRTIM_CR_IR_MODE, source);
}

/**
* @brief  ȡIRTIMźԴ
* @retval uint32_t źԴ
*             @arg ITRIM_SIGNAL_SOURCE_TIM3_OC1 źԴΪTIM3OC1
*             @arg ITRIM_SIGNAL_SOURCE_UART1_TX źԴΪUART1
*             @arg ITRIM_SIGNAL_SOURCE_UART2_TX źԴΪUART2
*/
__STATIC_INLINE uint32_t std_irtim_get_signal_source(void)
{
    return(IRTIM->CR & IRTIM_CR_IR_MODE);
}

/**
* @brief  IR_OUTźżѡ
* @param  polarity źż
*             @arg IRTIM_POLARITY_DIRECT:  źδ
*             @arg IRTIM_POLARITY_INVERSE: źŷ
* @retval 
*/
__STATIC_INLINE void std_irtim_set_polarity(uint32_t polarity)
{
    MODIFY_REG(IRTIM->CR, IRTIM_CR_IR_POL, polarity);
}

/**
* @brief  ȡIR_OUTźż״̬
* @retval uint32_t ߼ʽжϽ
*             @arg 0 ʾIRTIMźŷ
*             @arg  0  ʾIRTIMźδ෴
*/
__STATIC_INLINE uint32_t std_irtim_get_polarity(void)
{
    return(IRTIM->CR & IRTIM_CR_IR_POL);
}



/**
* @}
*/

#ifdef __cplusplus
}
#endif

/**
* @}
*/

/**
* @}
*/

#endif /* CIU32F003_STD_IRTIM_H */
