/************************************************************************************************/
/**
* @file               ciu32f003_std.c
* @author             MCU Ecosystem Development Team
* @brief              STD
*                     ʵSTDļʱȹAPI
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/************************************************************************************************/
/**
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @addtogroup STD 
* @{
*
*/
/************************************************************************************************/  

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std.h"




/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @addtogroup STD_External_Functions 
* @{
*
*/
/************************************************************************************************/

/**
* @brief  Systickʼ
* @note   úΪweakûѡʱ¶ʵָú
* @retval 
*/
__weak void std_delay_init(void)
{
    SysTick->CTRL |= SysTick_CTRL_CLKSOURCE_Msk;
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;
}

/**
* @brief  usʱģʽ
* @param  count 
* @note   ʱֵSysTickֵĴֵ0xFFFFFF16777216
* @note   úΪweakûѡʱ¶ʵָú
* @retval 
*/
__weak void std_delayus(uint32_t count)
{
    count = STD_DELAY_US * count;
    count = count > 16777216 ? 16777216 : count;
    SysTick->LOAD = count - 1;
    SysTick->VAL = 0;
    while(!((SysTick->CTRL >> 16) & 0x1));
}

/**
* @brief  msʱģʽ
* @param  count 
* @note   úΪweakûѡʱ¶ʵָú
* @retval 
*/
__weak void std_delayms(uint32_t count)
{
    while(count--)
    {
        std_delayus(1000);
    }
}

/**
* @brief  usʱģʽ
* @param  count 
* @note   ʱֵSysTickֵĴֵ0xFFFFFF16777216
* @note   úΪweakûѡʱ¶ʵָú
* @retval 
*/
__weak void std_delayus_start(uint32_t count)
{
    count = STD_DELAY_US * count;
    count = count > 16777216 ? 16777216 : count;
    SysTick->LOAD = count - 1;
    SysTick->VAL = 0;
}

/**
* @brief  msʱģʽ
* @param  count 
* @note   ʱֵSysTickֵĴֵ0xFFFFFF16777216
* @note   úΪweakûѡʱ¶ʵָú
* @retval 
*/
__weak void std_delayms_start(uint32_t count)
{
    std_delayus_start(1000 * count);
}


/**
* @brief  ȡ״̬ģʽ
* @note   úΪweakûѡʱ¶ʵָú
* @note   ústd_delayus_startstd_delayms_startʹãжϼ״̬
* @retval bool ߼ʽжϽ
*             @arg true ʾѽ
*             @arg falseʾڽ
*/
__weak bool std_delay_end(void)
{
    return (((SysTick->CTRL >> 16) & 0x1) == 0x1);
}



/** 
* @} 
*/


/** 
* @} 
*/

/** 
* @} 
*/
