/************************************************************************************************/
/**
* @file               ciu32f003_std_rcc.c
* @author             MCU Ecosystem Development Team
* @brief              RCC STD
*                     ʵRCCʱƵʻȡAPI
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/************************************************************************************************/
/**
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @addtogroup RCC 
* @{
*
*/
/************************************************************************************************/


/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std.h"

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @addtogroup RCC_External_Functions 
* @{
*
*/
/************************************************************************************************/ 

/**
* @brief  ȡǰϵͳʱƵʣSYSCLK
* @retval ϵͳʱƵʣHz
*/
uint32_t std_rcc_get_sysclkfreq(void)
{
    uint32_t frequency = 0;
    
    /* ȡǰϵͳʱԴ */
    switch(std_rcc_get_sysclk_source())
    {
        /* ϵͳʱΪEXTCLKĬΪ8MHz */
        case RCC_SYSCLK_SRC_STATUS_EXTCLK:
        {
            frequency = EXTCLK_VALUE;
        }break;
        
        /* ϵͳʱΪRCHDIV3 */
        case RCC_SYSCLK_SRC_STATUS_RCHDIV3:
        {
            frequency = RCH_VALUE/3;
        }break;
        
        /* ϵͳʱΪRCH */
        case RCC_SYSCLK_SRC_STATUS_RCH:
        {
            frequency = RCH_VALUE;
        }break;
        
        /* ϵͳʱΪRCL */
        case RCC_SYSCLK_SRC_STATUS_RCL:
        {
            frequency = RCL_VALUE;
        }break;       
        
        /* ϵͳʱΪRCHDIV6 */
        case RCC_SYSCLK_SRC_STATUS_RCHDIV6:
        default:
        {
            frequency = RCH_VALUE/6;
        }break;
    }
    return frequency;
}


/**
* @brief  ȡAHBʱƵʣHCLK
* @retval HCLKʱƵʣHz
*/
uint32_t std_rcc_get_hclkfreq(void)
{
    uint32_t frequency = 0;
    uint32_t tmp, hclk_div;
    
    tmp = std_rcc_get_sysclkfreq();
    
    /* ȡAHBƵ */
    hclk_div = std_rcc_get_ahbdiv()>>RCC_CFG_HPRE_POS;
    frequency = tmp >> hclk_div;    

    return frequency;
}

/**
* @brief  ȡAPBʱƵʣPCLK
* @retval PCLK1ʱƵʣHz
*/
uint32_t std_rcc_get_pclkfreq(void)
{
    uint32_t frequency = 0;
    uint32_t tmp, pclk_div;
    
    tmp = std_rcc_get_hclkfreq();
    
    /* ȡAPBƵ */
    pclk_div = std_rcc_get_apbdiv()>>RCC_CFG_PPRE_POS;
    
    if (pclk_div < 3)
    {
        frequency = tmp;
    }
    else
    {
        pclk_div -= 3;
        frequency = tmp >> pclk_div;
    }
    
    return frequency;
}


/** 
* @} 
*/



/** 
* @} 
*/

/** 
* @} 
*/
