/************************************************************************************************/
/**
* @file               ciu32f003_std_comp.c
* @author             MCU Ecosystem Development Team
* @brief              COMP STD
*                     ʵCOMPʼõȹAPI
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/************************************************************************************************/
/**
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @addtogroup COMP 
* @{
*
*/
/************************************************************************************************/

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std.h"

#ifdef STD_COMP_PERIPHERAL_USED
/*------------------------------------------functions-------------------------------------------*/

/************************************************************************************************/
/**
* @addtogroup COMP_External_Functions 
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  COMPȥʼ
* @param  compx COMP
* @retval 
*/
void std_comp_deinit(COMP_t *compx)
{
    /* λCOMP */
    compx->CSR = 0x00000000U;
    
    /*COMP1COMP2λʱλCRĴ*/
    if((COMP1->CSR == 0) && (COMP2->CSR == 0))
    {
        COMP_COMMON->CR = 0x00000000U;
    }
    
}

/** 
* @} 
*/

#endif /* STD_COMP_PERIPHERAL_USED */

/** 
* @} 
*/

/** 
* @} 
*/
