/************************************************************************************************/
/**
* @file               main.c
* @author             MCU Ecosystem Development Team
* @brief              ʾչʾUARTжϷʽշݵĹܡ
*                     
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/*------------------------------------------includes--------------------------------------------*/
#include "main.h"


/*--------------------------------------------variables-----------------------------------------*/
/* UARTշɱ־ */
__IO uint8_t g_uart_ready = 0;    

/*------------------------------------------functions-------------------------------------------*/
RF_FRAME	rf;

int main(void)
{      
    /* ϵͳʱ */
    system_clock_config(); 
	
	std_delay_init();

    /* GPIOʼ */
    gpio_init();
    
    /* UARTʼ */
    uart_init();

	tim1_init();
	
    /* NVICʼ */
    nvic_init(); 
	
	printf("start\n");
	
	HS6220_Init();
    
//	زģʽ
//	HS6220_CE_Low();
//	HS6220_ModeSwitch(HS6220_Carrier_Mode);	 
//	HS6220_CE_High();	
//	while(1);

#if	TX
	HS6220_CE_Low();
	HS6220_ModeSwitch(HS6220_PTX_Mode);	
	HS6220_CE_High();
	for(rf.len=0; rf.len < D_RF_DATA_LENTH; rf.len++)
	{
		rf.buf[rf.len] = 0;
	}
    while(1)
    {  
		
		if(u8_cnt_2_int >= 2)	
		{	
			u8_cnt_2_int = 0;
			rf.cnt = 0;
			
			rf.mark++;
			rf.buf[0] = 0x55;
			rf.buf[1] = 0xaa;
			rf.buf[2] = rf.mark;
			rf.buf[3] = 0;
			rf.buf[4] = 0x02;
			HS6220_CE_Low();
			HS6220_Clear_All_Irq();
			HS6220_Flush_Tx();
			HS6220_SendPack(HS6220_W_TX_PAYLOAD_NOACK,rf.buf,D_RF_DATA_LENTH);
		//	HS6220_SendPack(HS6220_W_ACK_PAYLOAD,rf.buf,D_RF_DATA_LENTH);
		}     
    }
#else

	HS6220_CE_Low();
	HS6220_Clear_All_Irq();
	HS6220_Flush_Rx();	
	HS6220_ModeSwitch(HS6220_PRX_Mode);		
	HS6220_CE_High();
	for(rf.cnt=0; rf.cnt < D_RF_DATA_LENTH; rf.cnt++)
	{
		rf.buf[rf.cnt] = 0;
	}
	
	
	while(1)
	{
		
		if(rf.cnt >= 2)
		{
			u8_cnt_2_int = 0;
			rf.cnt = 0;

			rf.len = HS6220_ReceivePack(rf.buf);
			if(D_RF_DATA_LENTH == rf.len)
			{
				if((0x55 == rf.buf[0]) && (0xaa == rf.buf[1]))
				{
					if(rf.mark != rf.buf[2])
					{
						rf.mark = rf.buf[2];
						
						if(0x01 == rf.buf[4])
						{	
							
						}
						else if(0x02 == rf.buf[4])
						{
							
						}
					}
				}
			}
		}
	}
#endif
}











