;-------------------------------------------------------------------------------
;	Crt0 For Chip SN8F27E62
;-------------------------------------------------------------------------------

CHIP		SN8F27E62


GOTO_THE_END EQU 0



Extern CODE _main
Public exit

public _tmpA
public _tmpB
public _tmpC
public T

public __ClearWatchDogTimer
public __ClrRAM

crt0@data segment data at 0x00 inbank
; 29 bytes
_tmpA ds 1
_tmpB ds 1
_tmpC ds 1
T	ds 1


;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------

crt0@code segment code at 0x0
	ORG	0					;Code section start
	jmp		_sgv_init_entry		;Reset vector
								;Address 4 to 7 are reserved



_SGV_INIT_CODE_BEGIN segment CODE 
PUBLIC _sgv_init_entry
_sgv_init_entry:

;------------------------------------------------------------------------------- 
; Initialize STKP 
    MOV A,# 0x7F 
    B0MOV STKP, A 
;------------------------------------------------------------------------------- 

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV A, #0x5A
	B0MOV WDTR, A
		
;-------------------------------------------------------------------------------
; Call Clear RAM : Use index @YZ to clear RAM 
;-------------------------------------------------------------------------------
	CALL __ClrRAM;
;-------------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_SGV_INIT_CODE SEGMENT CODE BANK 0x0 INBANK
;Define a null segment

_SGV_INIT_CODE_END segment CODE  bank 0 inbank

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
		MOV A, #0x5A
		B0MOV WDTR, A

if (GOTO_THE_END != 0)
    CALL _main
	B0MOV	R, A
    JMP THE_END
else
    JMP _main
endif	


;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
__ClearWatchDogTimer:
	MOV A, #0x5A
	B0MOV WDTR, A
	RET
	
;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM  (00h~7Fh)
;-------------------------------------------------------------------------------

__ClrRAM:
	B0MOV RBANK,#0
; RAM Bank 0
	clr 		Y	    		
	b0mov		Z,#0x7F		

ClrRAM10:
	clr 		@YZ				
	decms		Z   			
	jmp 		ClrRAM10
	clr 		@YZ				

; RAM Bank 1
	b0mov		Y,#1			
	b0mov		Z,#0xFF			

ClrRAM20:
	clr 		@YZ				
	decms		Z   			
	jmp 		ClrRAM20
	clr 		@YZ				

; RAM Bank 2
	b0mov		Y,#2			
	b0mov		Z,#0x7F			

ClrRAM30:
	clr 		@YZ				
	decms		Z   			
	jmp 		ClrRAM30
	clr 		@YZ					


	ret