;*******************************************************************************
; FILENAME	: 1937Ev.asm
; AUTHOR	: SONiX Kai Chen
; PURPOSE	: SN8P1937 EV Kit interface subroutine.
;                 User must include this file to communication with Ev. Kit 
; REVISION	: 09/18/2009 V1.0 	First issue
;*******************************************************************************
;*  (c) Copyright 2009, SONiX TECHNOLOGY CO., LTD.
;*******************************************************************************
;
;-------------------------------------------------------------------------------
; ICE SIO function for Link emulation board
; SIO Master Rising edge TX/RX 
;     ICE	EV-IC
;     P40 <==>	P10
;     P41 <==>	P11
;     P42 <==>	P12
;     P43 <==>	P13
;
;     P34 <==>	P00  	Clock Pin
;-------------------------------------------------------------------------------
include chip.h
If	ICE_Mode == 1

public R_Temp3, R_Temp2, R_Temp1, R_Temp0;
public R_Temp3_isr, R_Temp2_isr, R_Temp1_isr, R_Temp0_isr;


XMOV_DATA_SEG segment DATA bank 0
R_Temp3		DS	1
R_Temp2		DS	1				
R_Temp1		DS	1
R_Temp0		DS	1	
R_Temp3_isr 	DS	1
R_Temp2_isr		DS	1				
R_Temp1_isr		DS	1
R_Temp0_isr		DS	1


public Parallel_Write;
public Parallel_Read;
public Delay_20us;
public Delay_10us;
public @@delayTime;

_x_c__Parallel_Write segment CODE INBANK
Parallel_Write:
	mov	a,#0FFh		; P4 as output mode
	b0mov	P4M,a		
	b0mov	a,R_Temp0
	b0mov	P4,a		; Data output to P4
	;==== High Nible send =========================
	SWAPM	P4		; High nible
	nop	
	b0bclr	ICE_CLK		; CLK pull low
	Call	Delay_10us	
	b0bset	ICE_CLK		; CLK pull high	
	nop		
	nop		
	;==== Low Nible send =========================
	SWAPM	P4		; High nible
	b0bclr	ICE_CLK		; CLK pull low
	nop
	nop
	nop
	nop
	nop
	nop
	clr	P4M		; input mode 
	b0bset	ICE_CLK		; CLK pull high	
ret


_x_c__Parallel_Read segment CODE INBANK
Parallel_Read:	
	clr	P4M		; P4 as input mode
	mov	a,#0FFH
	b0mov	P4ur,a
	Call	Delay_10us	
	;====== Read High Nible =====================
	b0bclr	ICE_CLK		; start to receive data
	Call	Delay_10us
	b0mov	a,P4
	b0bset	ICE_CLK		; end of communication
	and	a,#00001111b
	b0mov	R_Temp2,a
	swapm	R_Temp2		; high nible in R_Temp_2[7:4]
;	Call	Delay_10us
	;====== Read High Nible =====================
	b0bclr	ICE_CLK		; start to receive data
	Call	Delay_10us
	b0mov	a,P4
	and	a,#00001111b
	or	a,R_Temp2
	b0bset	ICE_CLK		; end of communication

ret
;-------------------------------------------------------------------------------
; delay loop for waiting emulation board process time
;-------------------------------------------------------------------------------
Delay_20us:
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
ret
Delay_10us:
	nop
	nop
	nop
ret

@@delayTime:
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	ret
ELSE
ENDIF

//------------------------------------------------------------------------------
// For XMOV_isr usage	
// 2009.12.24  jinbo_nie

public Parallel_Write_isr;
public Parallel_Read_isr;
public Delay_20us_isr;
public Delay_10us_isr;
public @@delayTime_isr;



If	ICE_Mode == 1
_x_c__Parallel_Write_isr segment CODE INBANK
Parallel_Write_isr:
	mov	a,#0FFh		; P4 as output mode
	b0mov	P4M,a		
	b0mov	a,R_Temp0_isr
	b0mov	P4,a		; Data output to P4
	;==== High Nible send =========================
	SWAPM	P4		; High nible
	nop	
	b0bclr	ICE_CLK		; CLK pull low
	Call	Delay_10us_isr	
	b0bset	ICE_CLK		; CLK pull high	
	nop		
	nop		
	;==== Low Nible send =========================
	SWAPM	P4		; High nible
	b0bclr	ICE_CLK		; CLK pull low
	nop
	nop
	nop
	nop
	nop
	nop
	clr	P4M		; input mode 
	b0bset	ICE_CLK		; CLK pull high	
ret


_x_c__Parallel_Read_isr segment CODE INBANK

Parallel_Read_isr:	
	clr	P4M		; P4 as input mode
	mov	a,#0FFH
	b0mov	P4ur,a
	Call	Delay_10us_isr	
	;====== Read High Nible =====================
	b0bclr	ICE_CLK		; start to receive data
	Call	Delay_10us_isr
	b0mov	a,P4
	b0bset	ICE_CLK		; end of communication
	and	a,#00001111b
	b0mov	R_Temp2_isr,a
	swapm	R_Temp2_isr		; high nible in R_Temp_2[7:4]
;	Call	Delay_10us_isr
	;====== Read High Nible =====================
	b0bclr	ICE_CLK		; start to receive data
	Call	Delay_10us_isr
	b0mov	a,P4
	and	a,#00001111b
	or	a,R_Temp2_isr
	b0bset	ICE_CLK		; end of communication

ret
;-------------------------------------------------------------------------------
; delay loop for waiting emulation board process time
;-------------------------------------------------------------------------------
Delay_20us_isr:
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
ret
Delay_10us_isr:
	nop
	nop
	nop
ret

@@delayTime_isr:
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	ret
ELSE
ENDIF

