#ifndef __SN8P1917__H
#define __SN8P1917__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#if ICE_Mode == 1
#define	LCDM1	(*((__RAM unsigned int*)0XCB))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0XCB)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	Dummy	(*((__RAM unsigned int*)0X8F))
#define	FLCDDATA	((*((__RAM struct specialRegister *)0X8F)).bit4)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0X8F)).bit2)
#define	FLCDRATE	((*((__RAM struct specialRegister *)0X8F)).bit1)
#define	FLCDCLK	((*((__RAM struct specialRegister *)0X8F)).bit0)
#else
#define	LCDM1	(*((__RAM unsigned int*)0x89))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	FLCDDATA	((*((__RAM struct specialRegister *)0x89)).bit4)
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FLCDRATE	((*((__RAM struct specialRegister *)0x89)).bit1)
#define	FLCDCLK	((*((__RAM struct specialRegister *)0x89)).bit0)
#endif
#define	AMPM	(*((__RAM unsigned int*)0x90))
#define	FBGRENB	((*((__RAM struct specialRegister *)0x90)).bit6)
#define	FFDS1	((*((__RAM struct specialRegister *)0x90)).bit5)
#define	FFDS0	((*((__RAM struct specialRegister *)0x90)).bit4)
#define	FGS2	((*((__RAM struct specialRegister *)0x90)).bit3)
#define	FGS1	((*((__RAM struct specialRegister *)0x90)).bit2)
#define	FGS0	((*((__RAM struct specialRegister *)0x90)).bit1)
#define	FAMPENB	((*((__RAM struct specialRegister *)0x90)).bit0)
#define	AMPCHS	(*((__RAM unsigned int*)0x91))
#define	FCHS2	((*((__RAM struct specialRegister *)0x91)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0x91)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0x91)).bit0)
#define	AMPCKS	(*((__RAM unsigned int*)0x92))
#define	FAMPCKS2	((*((__RAM struct specialRegister *)0x92)).bit2)
#define	FAMPCKS1	((*((__RAM struct specialRegister *)0x92)).bit1)
#define	FAMPCKS0	((*((__RAM struct specialRegister *)0x92)).bit0)
#define	ADCM	(*((__RAM unsigned int*)0x93))
#define	FIRVS	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FRVS1	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FRVS0	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FADCENB	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	ADCKS	(*((__RAM unsigned int*)0X94))
#define	CPM	(*((__RAM unsigned int*)0x95))
#define	FACMENB	((*((__RAM struct specialRegister *)0x95)).bit7)
#define	FAVDDRENB	((*((__RAM struct specialRegister *)0x95)).bit6)
#define	FAVESEL	((*((__RAM struct specialRegister *)0x95)).bit5)
#define	FAVENB	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FCPSTS	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FCPAUTO	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FCPON	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	FCPRENB	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	CPCKS	(*((__RAM unsigned int*)0x96))
#define	FCPCKS3	((*((__RAM struct specialRegister *)0x96)).bit3)
#define	FCPCKS2	((*((__RAM struct specialRegister *)0x96)).bit2)
#define	FCPCKS1	((*((__RAM struct specialRegister *)0x96)).bit1)
#define	FCPCKS0	((*((__RAM struct specialRegister *)0x96)).bit0)
#define	DFM	(*((__RAM unsigned int*)0x97))
#define	FWRS0	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FDRDY	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	ADCDL	(*((__RAM unsigned int*)0x98))
#define	ADCDH	(*((__RAM unsigned int*)0x99))
#define	LBTM	(*((__RAM unsigned int*)0x9A))
#define	FLBTO	((*((__RAM struct specialRegister *)0x9A)).bit2)
#define	FP41IO	((*((__RAM struct specialRegister *)0x9A)).bit1)
#define	FLBTENB	((*((__RAM struct specialRegister *)0x9A)).bit0)
#define	CPMTEST	(*((__RAM unsigned int*)0x9B))
#define	FCPSAVE	((*((__RAM struct specialRegister *)0x9B)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FPEDGEN	((*((__RAM struct specialRegister *)0xBF)).bit7)
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	P1M	(*((__RAM unsigned int*)0xC1))
#define	FP13M	((*((__RAM struct specialRegister *)0xC1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xC1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xC1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xC1)).bit0)
#define	P2M	(*((__RAM unsigned int*)0xC2))
#define	FP21M	((*((__RAM struct specialRegister *)0xC2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xC2)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FWTCKS	((*((__RAM struct specialRegister *)0xCA)).bit7)
#define	FWDRST	((*((__RAM struct specialRegister *)0xCA)).bit6)
#define	FWDRATE	((*((__RAM struct specialRegister *)0xCA)).bit5)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xD1))
#define	FP13	((*((__RAM struct specialRegister *)0xD1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xD1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xD1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xD1)).bit0)
#define	P2	(*((__RAM unsigned int*)0xD2))
#define	FP21	((*((__RAM struct specialRegister *)0xD2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xD2)).bit0)
#define	P4	(*((__RAM unsigned int*)0xD4))
#define	FP42	((*((__RAM struct specialRegister *)0xD4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xD4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xD4)).bit0)
#define	P5	(*((__RAM unsigned int*)0xD5))
#define	FP52	((*((__RAM struct specialRegister *)0xD5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xD5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xD5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xDF)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xE1))
#define	FP13R	((*((__RAM struct specialRegister *)0xE1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xE1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xE1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xE1)).bit0)
#define	P2UR	(*((__RAM unsigned int*)0xE2))
#define	FP21R	((*((__RAM struct specialRegister *)0xE2)).bit1)
#define	FP20R	((*((__RAM struct specialRegister *)0xE2)).bit0)
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	DP1X	(*((__RAM unsigned int*)0xE7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#if ICE_Mode == 1
#define	P3M	(*((__RAM unsigned int*)0xC3))
#define	FP37M	((*((__RAM struct specialRegister *)0xC3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xC3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xC3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xC3)).bit4)
#define	FP33M	((*((__RAM struct specialRegister *)0xC3)).bit3)
#define	FP32M	((*((__RAM struct specialRegister *)0xC3)).bit2)
#define	FP31M	((*((__RAM struct specialRegister *)0xC3)).bit1)
#define	FP30M	((*((__RAM struct specialRegister *)0xC3)).bit0)
#define	P3	(*((__RAM unsigned int*)0xD3))
#define	FP37	((*((__RAM struct specialRegister *)0xD3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xD3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xD3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xD3)).bit4)
#define	FP33	((*((__RAM struct specialRegister *)0xD3)).bit3)
#define	FP32	((*((__RAM struct specialRegister *)0xD3)).bit2)
#define	FP31	((*((__RAM struct specialRegister *)0xD3)).bit1)
#define	FP30	((*((__RAM struct specialRegister *)0xD3)).bit0)
#define	P3UR	(*((__RAM unsigned int*)0xE3))
#define	FP37R	((*((__RAM struct specialRegister *)0xE3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xE3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xE3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xE3)).bit4)
#define	FP33R	((*((__RAM struct specialRegister *)0xE3)).bit3)
#define	FP32R	((*((__RAM struct specialRegister *)0xE3)).bit2)
#define	FP31R	((*((__RAM struct specialRegister *)0xE3)).bit1)
#define	FP30R	((*((__RAM struct specialRegister *)0xE3)).bit0)
#endif
#endif
