#ifndef __SN8P2522__H
#define __SN8P2522__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	CMP0M	(*((__RAM unsigned int*)0x9c))
#define	FCMCH0	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	FCMCH1	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FCMCH2	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FCM0S0	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	FCM0S1	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	CMP0M1	(*((__RAM unsigned int*)0x9d))
#define	FCM0G0	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	FCM0G1	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FCMDB0	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCMDB1	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FCMP0M17	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	FCMP0M16	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FCMP0M15	((*((__RAM struct specialRegister *)0x9d)).bit5)
#define	FCMP0M14	((*((__RAM struct specialRegister *)0x9d)).bit4)
#define	T1M	(*((__RAM unsigned int*)0xa0))
#define	FCPTG0	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	FCPTG1	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FCPTStart	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FCPTCKS	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FT1rate0	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FT1rate1	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FT1rate2	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FT1ENB	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	T1CL	(*((__RAM unsigned int*)0xa1))
#define	T1CH	(*((__RAM unsigned int*)0xa2))
#define	T1VCL	(*((__RAM unsigned int*)0xa3))
#define	T1VCH	(*((__RAM unsigned int*)0xa4))
#define	T1CKM	(*((__RAM unsigned int*)0xa5))
#define	FCPTVC	((*((__RAM struct specialRegister *)0xa5)).bit7)
#define	FT1CKM2	((*((__RAM struct specialRegister *)0xa5)).bit2)
#define	FT1CKM1	((*((__RAM struct specialRegister *)0xa5)).bit1)
#define	FT1CKM0	((*((__RAM struct specialRegister *)0xa5)).bit0)
#define	SIOM	(*((__RAM unsigned int*)0xb4))
#define	FSENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xb5))
#define	SIOB	(*((__RAM unsigned int*)0xb6))
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FCM0IEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	FTC0CKS0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FTC0rate0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0rate1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0rate2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	FTC1CKS0	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1rate0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1rate1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1rate2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	FP10R	((*((__RAM struct specialRegister *)0xe1)).bit0)
#define	FP11R	((*((__RAM struct specialRegister *)0xe1)).bit1)
#define	FP12R	((*((__RAM struct specialRegister *)0xe1)).bit2)
#define	FP13R	((*((__RAM struct specialRegister *)0xe1)).bit3)
#define	FP14R	((*((__RAM struct specialRegister *)0xe1)).bit4)
#define	FP15R	((*((__RAM struct specialRegister *)0xe1)).bit5)
#define	FP16R	((*((__RAM struct specialRegister *)0xe1)).bit6)
#define	FP17R	((*((__RAM struct specialRegister *)0xe1)).bit7)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	TC0D	(*((__RAM unsigned int*)0xe8))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	FP50OC	((*((__RAM struct specialRegister *)0xe9)).bit2)
#define	FP51OC	((*((__RAM struct specialRegister *)0xe9)).bit3)
#define	FP52OC	((*((__RAM struct specialRegister *)0xe9)).bit4)
#define	FP53OC	((*((__RAM struct specialRegister *)0xe9)).bit5)
#define	FP54OC	((*((__RAM struct specialRegister *)0xe9)).bit6)
#define	TC1D	(*((__RAM unsigned int*)0xea))
#define	TOUCH0	(*((__RAM unsigned int*)0xed))
#define	TOUCH1	(*((__RAM unsigned int*)0xee))
#define	TOUCH2	(*((__RAM unsigned int*)0xef))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
