#ifndef __SN8P2715__H
#define __SN8P2715__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	P4CON	(*((__RAM unsigned int*)0xAE))
#define	FP4CON7	((*((__RAM struct specialRegister *)0xAE)).bit7)
#define	FP4CON6	((*((__RAM struct specialRegister *)0xAE)).bit6)
#define	FP4CON5	((*((__RAM struct specialRegister *)0xAE)).bit5)
#define	FP4CON4	((*((__RAM struct specialRegister *)0xAE)).bit4)
#define	FP4CON3	((*((__RAM struct specialRegister *)0xAE)).bit3)
#define	FP4CON2	((*((__RAM struct specialRegister *)0xAE)).bit2)
#define	FP4CON1	((*((__RAM struct specialRegister *)0xAE)).bit1)
#define	FP4CON0	((*((__RAM struct specialRegister *)0xAE)).bit0)
#define	DAM	(*((__RAM unsigned int*)0xB0))
#define	FDAENB	((*((__RAM struct specialRegister *)0xB0)).bit7)
#define	FDAB6	((*((__RAM struct specialRegister *)0xB0)).bit6)
#define	FDAB5	((*((__RAM struct specialRegister *)0xB0)).bit5)
#define	FDAB4	((*((__RAM struct specialRegister *)0xB0)).bit4)
#define	FDAB3	((*((__RAM struct specialRegister *)0xB0)).bit3)
#define	FDAB2	((*((__RAM struct specialRegister *)0xB0)).bit2)
#define	FDAB1	((*((__RAM struct specialRegister *)0xB0)).bit1)
#define	FDAB0	((*((__RAM struct specialRegister *)0xB0)).bit0)
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P2M	(*((__RAM unsigned int*)0xc2))
#define	FP27M	((*((__RAM struct specialRegister *)0xc2)).bit7)
#define	FP26M	((*((__RAM struct specialRegister *)0xc2)).bit6)
#define	FP25M	((*((__RAM struct specialRegister *)0xc2)).bit5)
#define	FP24M	((*((__RAM struct specialRegister *)0xc2)).bit4)
#define	FP23M	((*((__RAM struct specialRegister *)0xc2)).bit3)
#define	FP22M	((*((__RAM struct specialRegister *)0xc2)).bit2)
#define	FP21M	((*((__RAM struct specialRegister *)0xc2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xc2)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP47M	((*((__RAM struct specialRegister *)0xc4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P2	(*((__RAM unsigned int*)0xd2))
#define	FP27	((*((__RAM struct specialRegister *)0xd2)).bit7)
#define	FP26	((*((__RAM struct specialRegister *)0xd2)).bit6)
#define	FP25	((*((__RAM struct specialRegister *)0xd2)).bit5)
#define	FP24	((*((__RAM struct specialRegister *)0xd2)).bit4)
#define	FP23	((*((__RAM struct specialRegister *)0xd2)).bit3)
#define	FP22	((*((__RAM struct specialRegister *)0xd2)).bit2)
#define	FP21	((*((__RAM struct specialRegister *)0xd2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xd2)).bit0)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP47	((*((__RAM struct specialRegister *)0xd4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FTC1X8	((*((__RAM struct specialRegister *)0xd8)).bit3)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xd8)).bit2)
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP03R	((*((__RAM struct specialRegister *)0xe0)).bit3)
#define	FP02R	((*((__RAM struct specialRegister *)0xe0)).bit2)
#define	FP01R	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	P2UR	(*((__RAM unsigned int*)0xe2))
#define	FP27R	((*((__RAM struct specialRegister *)0xe2)).bit7)
#define	FP26R	((*((__RAM struct specialRegister *)0xe2)).bit6)
#define	FP25R	((*((__RAM struct specialRegister *)0xe2)).bit5)
#define	FP24R	((*((__RAM struct specialRegister *)0xe2)).bit4)
#define	FP23R	((*((__RAM struct specialRegister *)0xe2)).bit3)
#define	FP22R	((*((__RAM struct specialRegister *)0xe2)).bit2)
#define	FP21R	((*((__RAM struct specialRegister *)0xe2)).bit1)
#define	FP20R	((*((__RAM struct specialRegister *)0xe2)).bit0)
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	FP47R	((*((__RAM struct specialRegister *)0xe4)).bit7)
#define	FP46R	((*((__RAM struct specialRegister *)0xe4)).bit6)
#define	FP45R	((*((__RAM struct specialRegister *)0xe4)).bit5)
#define	FP44R	((*((__RAM struct specialRegister *)0xe4)).bit4)
#define	FP43R	((*((__RAM struct specialRegister *)0xe4)).bit3)
#define	FP42R	((*((__RAM struct specialRegister *)0xe4)).bit2)
#define	FP41R	((*((__RAM struct specialRegister *)0xe4)).bit1)
#define	FP40R	((*((__RAM struct specialRegister *)0xe4)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP56R	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	DP1X	(*((__RAM unsigned int*)0xe7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
