
;------------------------------------------------------------------------------
;  CHIP: SN8P2708A, OTP Only
;  Revision History:
;  V1.0  1/29/2004  1. First issue, emulate SN8P2708A in S8KD-2 ICE
;                   2. Disable "Low power" code option to avoid Hi/Low clock switching fail
;
;  V2.0  02/03/2004 1. Change P1OC register as write only
;
;  V3.0  02/05/2004 1. SMOV Table:
;                      In "87 00 DF 7F BF 80 CB 03 -1", change 80 to 88
;                      To Set P0.0 interrupt and wakeup as falling edge trigger after reset
;                   2. Code Option: On-line help in Watch_Dog "Enable"
;
;  V4.0  03/11/2004  1. Align the timing of built-in macro between ICE and real chip
;                    2. Force users to define ICE_MODE before compiler, in ICE_MODE = 1
;                       the user's ROM size is 4K+512 words
;                    3. Disable B0XCH A, M and B0MOV M, I (use 1.99K assembler)
;                    4. SMOV table:
;                       In "87 00...", add CA 80 to set WDT clock as internal RC
;
;  V5.0  03/23/2004  1. Remove B0MOV M, I 
;                    2. B0XCH A, M, the M can't be 0x80~0xFF
;
;  V6.0  04/09/2004  1. Replace NO_B0MOV_MI bt B0MOV_MI_LIMIT
;                       to limint the instance value of I can't be 0xE6, 0xE7
;                    2. Change WDTR to Write Only register
;                    3. SMOV table:
;                       In "FF -1 -1...", change FF to 00: Change P1W to write only
;
;  V7.0  04/30/2004  1. Modify the P3UR address from 0xE2 to 0xE3
;
;  V20   05/10/2004  1. For S8KE ICE, emulate all function of SN8P2708A
;                       So no SMOV table is necessary.
;                    2. It's no necessary to define ICE_MODE = 0 or 1
;                    3. Keep following Macro definition for backword compatibility.
;                       @RST_WDT, @P00_MODE, @P01_MODE, @P02_MODE, 
;                       @P00_OUT, @P01_OUT, @P02_OUT, @P00_EDGE
;                       @PWM0_MAX_DUTY, @PWM1_MAX_DUTY, @PWM01_MAX_DUTY
;                    4. Remove B0_MOV_MI_LIMIT and B0XCH_LIMIT limit
;                    5. Remove following S8KD-2 emulation register definition:
;                       S8KDP6M(0C6H), FS8KDWTCKS(OSCM.7), FS8KDWDRST(OSCM.6,
;                       FWDRATE(OSCM.5), S8KDP6(0D6H),
;        
;  V21   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs.
;               
;------------------------------------------------------------------------------

.Assembly	INC_VER		21
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	100h

.Assembly	INSTRUMENT	S8KE_TEST
.Assembly	BIT_FILE	S8KE_TEST

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	3, 8, 8, 1, 8, 8
.Assembly	COMMAND		MUL, PUSH, ORG8_LIMIT, PCL_LIMIT, Enable_ORG4_7, SWAP_B0BTS_BTS, RBANK_LIMIT, GREEN_NOP_LIMIT
.Assembly	CHIP_ID		0x6701

; Code Option 0x3FF
.Assembly	OPTION_Hide	0		Watch_Dog0	Enable	Disable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION_Hide	8		Int_16K_RC	Always_ON	By_CPUM
;.Assembly	OPTION		9		High_Clk/2	Enable	Disable
.Assembly	OPTION		9		Fix_High
;.Assembly	OPTION		10		RST_Debounce	No	16_Fcpu		128_Fcpu	1024_Fcpu
.Assembly	OPTION		10 : 11		Fix_High
.Assembly	OPTION		12		Fix_High
;.Assembly	OPTION		13		Low_Power   Lowest Lower Middle Disable
;.Assembly	OPTION		13		Low_Power   x Enable x Disable
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_High
; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High
; Code Option 0x3FD
;.Assembly	OPTION		32		Fosc_Div	/1	/2
.Assembly	OPTION		32 : 63		Fix_High

.Assembly	OPTION_VIRTUAL			Watch_Dog	Always_ON	Enable	Disable
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen mode : Enable Watchdog\nSleep mode : Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION_VIRTUAL			Noise_Filter	Enable		Disable

.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85

	PFLAG			EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU			0x87
		FRBNKS0	EQU		RBANK.0

	;P4CON is ADC analog gating control register
	P4CON			EQU		0xAE
		FP4CON7	EQU		P4CON.7
		FP4CON6	EQU		P4CON.6
		FP4CON5	EQU		P4CON.5
		FP4CON4	EQU		P4CON.4
		FP4CON3	EQU		P4CON.3
		FP4CON2	EQU		P4CON.2
		FP4CON1	EQU		P4CON.1
		FP4CON0	EQU		P4CON.0

	DAM			EQU		0xB0
		FDAENB	EQU		DAM.7
		FDAB6	EQU		DAM.6
		FDAB5	EQU		DAM.5
		FDAB4	EQU		DAM.4
		FDAB3	EQU		DAM.3
		FDAB2	EQU		DAM.2
		FDAB1	EQU		DAM.1
		FDAB0	EQU		DAM.0

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
	
		FADCKS2	EQU		ADR.7
		FADCKS	EQU		ADR.6
		FADCKS1	EQU		ADR.6
		FADLEN	EQU		ADR.5
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R		ADR.3
		FADB2	EQU_R		ADR.2
		FADB1	EQU_R		ADR.1
		FADB0	EQU_R		ADR.0		

	SIOM			EQU		0B4H
		FSENB	EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX	EQU		SIOM.0

	SIOR			EQU_W		0B5H
	SIOB			EQU		0B6H
	
	P0M			EQU		0B8H
		FP07M	EQU		P0M.7
		FP06M	EQU		P0M.6
		FP05M	EQU		P0M.5
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0
	
	
		PEDGE		EQU		0BFH
;		.W_LIMIT        0x80,0x00	;Force bit 7 = high 
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H
		FP17W	EQU_W		P1W.7
		FP16W	EQU_W		P1W.6
		FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0
		
	P3M		EQU			0C3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0		

	P4M			EQU		0C4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP57M	EQU		P5M.7
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0	
		
	P6M			EQU		0C6H
		FP67M	EQU		P6M.7
		FP66M	EQU		P6M.6
		FP65M	EQU		P6M.5
		FP64M	EQU		P6M.4
		FP63M	EQU		P6M.3
		FP62M	EQU		P6M.2
		FP61M	EQU		P6M.1
		FP60M	EQU		P6M.0		

	INTRQ			EQU		0C8H
		FADCIRQ	EQU		INTRQ.7
		FTC1IRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FSIOIRQ	EQU		INTRQ.3
		FP02IRQ	EQU		INTRQ.2
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN			EQU		0C9H
		FADCIEN	EQU		INTEN.7
		FTC1IEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FSIOIEN	EQU		INTEN.3
		FP02IEN	EQU		INTEN.2
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM			EQU		0CAH		
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
		
	WDTR		EQU_W		0CCH				

	TC0R			EQU_W		0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU		0D0H
		FP07	EQU		P0.7
		FP06	EQU		P0.6
		FP05	EQU		P0.5
		FP04	EQU		P0.4
		FP03	EQU		P0.3
		FP02	EQU		P0.2
		FP01	EQU		P0.1
		FP00	EQU		P0.0	

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0
		
	P3		EQU			0D3H
		FP37	EQU		P3.7
		FP36	EQU		P3.6
		FP35	EQU		P3.5
		FP34	EQU		P3.4
		FP33	EQU		P3.3
		FP32	EQU		P3.2
		FP31	EQU		P3.1
		FP30	EQU		P3.0

	P4			EQU		0D4H
		FP47	EQU		P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0	
		
	P6			EQU		0D6H
		FP67	EQU		P6.7
		FP66	EQU		P6.6
		FP65	EQU		P6.5
		FP64	EQU		P6.4
		FP63	EQU		P6.3
		FP62	EQU		P6.2
		FP61	EQU		P6.1
		FP60	EQU		P6.0	

	T0M			EQU		0D8H
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4

	T0C			EQU		0D9H

	TC0M			EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C			EQU		0DBH

	TC1M			EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C			EQU		0DDH
	TC1R			EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR			EQU_W		0E0H
		FP07R	EQU_W		P0UR.7
		FP06R	EQU_W		P0UR.6
		FP05R	EQU_W		P0UR.5
		FP04R	EQU_W		P0UR.4
		FP03R	EQU_W		P0UR.3
		FP02R	EQU_W		P0UR.2
		FP01R	EQU_W		P0UR.1
		FP00R	EQU_W		P0UR.0

	P1UR			EQU_W		0E1H
		FP17R	EQU_W		P1UR.7
		FP16R	EQU_W		P1UR.6
		FP15R	EQU_W		P1UR.5
		FP14R	EQU_W		P1UR.4
		FP13R	EQU_W		P1UR.3
		FP12R	EQU_W		P1UR.2
		FP11R	EQU_W		P1UR.1
		FP10R	EQU_W		P1UR.0

	P2UR			EQU_W		0E2H
		FP27R	EQU_W		P2UR.7
		FP26R	EQU_W		P2UR.6
		FP25R	EQU_W		P2UR.5
		FP24R	EQU_W		P2UR.4
		FP23R	EQU_W		P2UR.3
		FP22R	EQU_W		P2UR.2
		FP21R	EQU_W		P2UR.1
		FP20R	EQU_W		P2UR.0
		
	P3UR			EQU_W		0E3H
		FP37R	EQU_W		P3UR.7
		FP36R	EQU_W		P3UR.6
		FP35R	EQU_W		P3UR.5
		FP34R	EQU_W		P3UR.4
		FP33R	EQU_W		P3UR.3
		FP32R	EQU_W		P3UR.2
		FP31R	EQU_W		P3UR.1
		FP30R	EQU_W		P3UR.0

	P4UR			EQU_W		0E4H
		FP47R	EQU_W		P4UR.7
		FP46R	EQU_W		P4UR.6
		FP45R	EQU_W		P4UR.5
		FP44R	EQU_W		P4UR.4
		FP43R	EQU_W		P4UR.3
		FP42R	EQU_W		P4UR.2
		FP41R	EQU_W		P4UR.1
		FP40R	EQU_W		P4UR.0

	P5UR			EQU_W		0E5H
		FP57R	EQU_W		P5UR.7
		FP56R	EQU_W		P5UR.6
		FP55R	EQU_W		P5UR.5
		FP54R	EQU_W		P5UR.4
		FP53R	EQU_W		P5UR.3
		FP52R	EQU_W		P5UR.2
		FP51R	EQU_W		P5UR.1
		FP50R	EQU_W		P5UR.0

	@HL			EQU		0E6H
	DP0X			EQU		0E6H

	@YZ			EQU		0E7H
	DP1X			EQU		0E7H
	
	P1OC        		EQU_W     	0E9H
	    	FP10OC  EQU_W     	P1OC.0
            	FP11OC  EQU_W     	P1OC.1
            	FP52OC  EQU_W     	P1OC.2

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
	
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 4 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
		   NOP
		   NOP		
	endm
	
; -----------------------------------------------------	
; In S8KD-2 ICE P0.0 ~ P0.2 is input only, but SN8P2708A 
; real chip the P0.0 ~ P0.2 is I/O pin
; In ICE, 
; Connect the P6.0 and P0.0 to emulate P0.0 output pin
; Connect the P6.1 and P0.1 to emulate P0.1 output pin
; Connect the P6.2 and P0.2 to emulate P0.2 output pin

; Use @P00_Mode macro to set P0.0 output mode
;     @P00_Mode 0, Set P0.0 as input pin
;     @P00_Mode 1, Set P0.0 as output pin
;
; Use @P00_Out to set P0.0 output high or low
;     @P00_Out 0, Set P0.0 output low
;     @P00_Out 1, Set P0.0 output high

; Use @P01_Mode macro to set P0.1 output mode
;     @P01_Mode 0, Set P0.1 as input pin
;     @P01_Mode 1, Set P0.1 as output pin
;
; Use @P01_Out to set P0.1 output high or low
;     @P01_Out 0, Set P0.1 output low
;     @P01_Out 1, Set P0.1 output high

; Use @P02_Mode macro to set P0.2 output mode
;     @P02_Mode 0, Set P0.2 as input pin
;     @P02_Mode 1, Set P0.2 as output pin
;
; Use @P02_Out to set P0.2 output high or low
;     @P02_Out 0, Set P0.2 output low
;     @P02_Out 1, Set P0.2 output high
;
; P0X_Mode and P0X_Out Total Cycle: 1
; -----------------------------------------------------

	@P00_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
		IFNDEF  val
			ECHO	Error: @P00_MODE macro need one parameter
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode					
			   B0BCLR FP00M	
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP00M			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_MODE macro
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO				
		ENDIF		
	endm
;------------------------------------------------------------------------------	
	@P00_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P00_OUT macro need one parameter
			ECHO	Syntax: @P00_OUT  Level			
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 P0.0 output low
			B0BCLR FP00	
					
		ELSEIF val == 1		; val = 1 P0.0 output high			
			B0BSET FP00
			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_OUT macro
			ECHO	Syntax: @P00_OUT    Level
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO			
		ENDIF
	endm			

; -----------------------------------------------------------------------------	
	@P01_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
		IFNDEF  val
			ECHO	Error: @P01_MODE macro need one parameter
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode				
		   	B0BCLR FP01M		
			
		ELSEIF val == 1		; val = 1 output mode			
			B0BSET FP01M
			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_MODE macro
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P01_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P01_OUT macro need one parameter
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low			
			   B0BCLR FP01
			   			
		ELSEIF val == 1		; val = 1 output high			
			   B0BSET FP01			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_OUT macro
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------
	@P02_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
		IFNDEF  val
			ECHO	Error: @P02_MODE macro need one parameter
			ECHO	Syntax: @P02_MODE  Mode
			ECHO	Example:
			ECHO	@P02_MODE 0  Configure P0.2 as input mode
			ECHO	@P02_MODE 1  Configure P0.2 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode			
			B0BCLR FP02M			
			
		ELSEIF val == 1		; val = 1 output mode			
			B0BSET FP02M			
		ELSE
			ECHO	Error: val is invalid parameter of @P02_MODE macro
			ECHO	Syntax: @P02_MODE  Mode
			ECHO	Example:
			ECHO	@P02_MODE 0  Configure P0.2 as input mode
			ECHO	@P02_MODE 1  Configure P0.2 as output mode			
			ERROR
			ECHO				
		ENDIF		
	endm
	
;------------------------------------------------------------------------------
	@P02_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P02_OUT macro need one parameter
			ECHO	Syntax: @P02_OUT    Level
			ECHO	Example:
			ECHO	@P02_OUT 0  P0.2 output high
			ECHO	@P02_OUT 1  P0.2 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low			
			   B0BCLR FP02
			
		ELSEIF val == 1		; val = 1 output high			
			   B0BSET FP02			
		ELSE
			ECHO	Error: val is invalid parameter of @P02_OUT macro
			ECHO	Syntax: @P02_OUT    Level
			ECHO	Example:
			ECHO	@P02_OUT 0  P0.2 output high
			ECHO	@P02_OUT 1  P0.2 output low
			ERROR
			ECHO			
		ENDIF
	endm

; -----------------------------------------------------------------------------
; @PWM0_MAX_DUTY Macro to emulate 2708 Fast PWM0 in S8KD-2 ICE
; Total Cycle = 6

	@PWM0_MAX_DUTY	macro	Max_Duty
	
		;Max_Duty	TC0 Overflow Boundary	PWM Duty Range
		;	256	FFh to 00h		0/256 ~ 255/256
		;	64	3Fh to 40h		0/64 ~ 63/64
		;	32	1Fh to 20h		0/32 ~ 31/32
		;	16	0Fh to 10h		0/16 ~ 15/16
		
		IFNDEF  Max_Duty
			ECHO	Error: @PWM0_MAX_DUTY MACRO need Max-Duty parameter
			ECHO	Syntax: @PWM0_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM0_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO
		ENDIF		

		Duty_Temp = Max_Duty		
		IF	Duty_Temp == 256			
				;Set real chip PWM0 output
				B0BCLR	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP			

		ELSEIF	Duty_Temp == 64			
				;Set real chip PWM0 output
				B0BCLR	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP		

		ELSEIF	Duty_Temp == 32
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP		

		ELSEIF	Duty_Temp == 16
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP		
			
		ELSE
			ECHO	Error: Max_Duty is invalid Max-Duty parameter of @PWM0_MAX_DUTY MACRO
			ECHO	Syntax: @PWM0_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM0_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO			
		ENDIF		
	ENDM
	
; -----------------------------------------------------------------------------
; @PWM1_MAX_DUTY Macro to emulate 2708 Fast PWM1 in S8KD-2 ICE
; Total Cycle = 6

	@PWM1_MAX_DUTY	macro	Max_Duty
	
		;Max_Duty	TC1 Overflow Boundary	PWM Duty Range
		;	256	FFh to 00h		0/256 ~ 255/256
		;	64	3Fh to 40h		0/64 ~ 63/64
		;	32	1Fh to 20h		0/32 ~ 31/32
		;	16	0Fh to 10h		0/16 ~ 15/16
		
		IFNDEF  Max_Duty
			ECHO	Error: @PWM1_MAX_DUTY MACRO need Max-Duty parameter
			ECHO	Syntax: @PWM1_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM1_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO
		ENDIF		
		
		Duty_Temp = Max_Duty
		IF	Duty_Temp == 256
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP			

		ELSEIF	Duty_Temp == 64
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP			

		ELSEIF	Duty_Temp == 32
			
				;Set real chip PWM0 output
				B0BSET	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP		

		ELSEIF	Duty_Temp == 16
			
				;Set real chip PWM0 output
				B0BSET	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP
			
		ELSE
			ECHO	Error: Max_Duty is invalid Max-Duty parameter of @PWM1_MAX_DUTY MACRO
			ECHO	Syntax: @PWM1_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM1_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO		
		ENDIF	
				
	ENDM
	
; -----------------------------------------------------------------------------
; @PWM01_MAX_DUTY Macro to emulate 2708 Fast PWM0 and PWM1 in S8KD-2 ICE
; Total Cycle = 8

	@PWM01_MAX_DUTY	macro	Max_Duty
		
		;Max_Duty	TC0 Overflow Boundary	PWM0 Duty Range
		;       	TC1 Overflow Boundary	PWM1 Duty Range
		;	256	FFh to 00h		0/256 ~ 255/256
		;	64	3Fh to 40h		0/64 ~ 63/64
		;	32	1Fh to 20h		0/32 ~ 31/32
		;	16	0Fh to 10h		0/16 ~ 15/16
		
		IFNDEF  Max_Duty
			ECHO	Error: @PWM01_MAX_DUTY MACRO need Max-Duty parameter
			ECHO	Syntax: @PWM01_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM01_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO
		ENDIF	

		Duty_Temp = Max_Duty		
		IF	Duty_Temp == 256			
			
				;Set real chip PWM0/PWM1 output
				B0BCLR	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				B0BCLR	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 2 NOP to align timing in ICE mode
				NOP
				NOP			

		ELSEIF	Duty_Temp == 64
			
				;Set real chip PWM0/PWM1 output
				B0BCLR	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				B0BCLR	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 2 NOP to align timing in ICE mode
				NOP
				NOP		
			
		ELSEIF	Duty_Temp == 32
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				B0BSET	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 2 NOP to align timing in ICE mode
				NOP
				NOP

		ELSEIF	Duty_Temp == 16
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				B0BSET	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				; Add 2 NOP to align timing in ICE mode
				NOP
				NOP			
			
		ELSE
			ECHO	Error: Max_Duty is invalid Max-Duty parameter of @PWM01_MAX_DUTY MACRO
			ECHO	Syntax: @PWM01_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM01_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO			
		ENDIF	
				
	ENDM	

; -----------------------------------------------------	
; Set P0.0 interrupt edge MACRO
; The Falling and rising edge definition of SN8P2XXX are different to S8KD-2 ICE
; @P00_EDGE VAL
;           VAL = 1,  Rising edge  
;           VAL = 2,  Falling edge
;           VAL = 3,  Level Change (Bi-direction)
; Total Cycle = 2

	@P00_EDGE	MACRO       VAL
			
		IFNDEF  VAL
			ECHO	Error: @P00_EDGE macro need one parameter
			ECHO	Syntax: @P00_EDGE  EDGE
			ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
			ECHO    Example:
			ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
			ERROR
			ECHO
		ENDIF	
			
		IF VAL == 1
		   MOV		A,#00001000B
		   B0MOV	PEDGE,A
		ELSEIF VAL == 2
		   MOV		A,#00010000B
		   B0MOV	PEDGE,A
		ELSEIF VAL == 3
		   MOV		A,#00011000B
		   B0MOV	PEDGE,A
		ELSE
		   ECHO	Error: VAL is invalid parameter of @P00_EDGE macro
		   ECHO	Syntax: @P00_EDGE  EDGE
		   ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
		   ECHO	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
		   ECHO	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
		   ECHO	Example:
		   ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
		   ERROR
		   ECHO		        
		ENDIF	
				
	ENDM

; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	

;	   IF High_Clk == 32K_X'tal
;           {		
;           	Low_Power = Disable
;           };  	
;	   IF Low_Power == Enable
; 	   {  	
;  	      OPTION	     2	Fcpu	X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
;	   }
;	
;	   IF Low_Power == Disable
; 	   {		
;  	      OPTION	     2	Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
; 	   }


.TEXT
{
	//{{SONIX_OPTION_RULE		
	
	IF Noise_Filter == Enable
	{

	   OPTION    2 Fcpu	X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
	}
	
	IF Noise_Filter == Disable
	{

	   OPTION     2	Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
 	}   

	//{{SONIX_OPTION_RULE

	IF	Watch_Dog  == Always_ON
	{
		Int_16K_RC	= Always_ON
		Watch_Dog0	= Enable
	}
	ELSEIF	Watch_Dog  == Enable
	{
		Int_16K_RC	= By_CPUM
		Watch_Dog0	= Enable
	}
	ELSE
	{
		Int_16K_RC	= By_CPUM
		Watch_Dog0	= Disable
	}	
	
	ENDP
	//}}SONIX_OPTION_RULE
}
