;------------------------------------------------------------------------------
;  CHIP: SN8F27E23L
;  Revision History
;  
;  V01   2014/06/19
;  06/19/2013  1. First issue.
;  V02   2014/08/07
;  08/07/2014  1. Modify EB_ICE text note.
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		2
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8F27E23
.Assembly	BIT_FILE	SN8F27E23

.Assembly	OTP_BODY_SIZE				0x1000
.Assembly	USER_ROM_SIZE				0x0FF8

;.Assembly	LVD_Trim_ADR				0x100C
;.Assembly	IHRC_VALUE				0x01C2
;.Assembly	INFO_PROGRAM_LEN			0x4
;.Assembly	LVD_VALUE				0xFFFF
;.Assembly	LVD_VALUE_INVERSE			0x0000
;.Assembly	Regulator_VALUE				0xFFFC
;.Assembly	Regulator_VALUE_INVERSE			0x0003


.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x6200
.Assembly	command		Enable_ORG4_7, EB_ICE
;PGM_LVD_Regulator_trimmed_Data

.Assembly	Port_Pins	0, 8, 2, 0, 8, 0

; Code Option 0x0FFF
.Assembly	OPTION		0		Noise_Filter	Disable	Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		High_Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	High_Fcpu		: 	"Only Effective for HIGH Clock"
}
;.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_32M_RTC IHRC_32M Ext_CLK Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Assembly	OPTION		5		High_Clk	IHRC_16M x IHRC_32M Ext_CLK Ext_RC x 12M_X'tal 4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
;	IHRC_32M_RTC	:	"Internal 32M RC Oscillator with RTC.\n" \
;	                	"Connect 32.768K crystal to Xin/Xout"
	IHRC_32M	:	"Internal 32M RC Oscillator"
	Ext_CLK		:	"XIN pin connect external clock(1M ~32M)"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
;	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		8		Low_Fcpu	Flosc/1 Flosc/2 Flosc/4 Flosc/8
.Help
{
	Low_Fcpu		: 	"Only Effective for Low Clock"
}
.Assembly	OPTION		10		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_High

; Code Option 0x0FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x0FFD
.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_High
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41		LVD     	x	x	x	LVD_L
;.Assembly	OPTION		41		LVD     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"1.8V Reset"
;	LVD_M		:	"1.8V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
;	LVD_H		:	"2.4V Reset\nEnable LVD33 bit of PFLAG for\n3.3V Low Voltage Indicator"	
;	LVD_Max		:	"3.3V Reset"	
}
;.Assembly	OPTION		43 		Hold_CK_time	4ms 2ms
.Assembly	OPTION		43		Fix_Low

.Assembly	OPTION		44		Reset_Pin   P12 Reset
;.Assembly	OPTION		45		Rst_Length  	No 	128*ILRC
.Assembly	OPTION		45		Fix_High
.Assembly	OPTION		46 		WDT_CLK	Flosc/4 Flosc/8 Flosc/16 Flosc/32

; Code Option 0x0FFC

.Assembly	OPTION_Hide	48		ROM_EnTime	Full Half 60ns	x
;.Assembly	OPTION		50		REG_EXT_PATH	Disable Enable
.Assembly	OPTION		50		Fix_Low

;.Assembly	OPTION		51		REG_TRIM	1.5V 1.6V 1.7V 1.8V 1.9V 2.0V 2.1V 2.2V
.Assembly	OPTION		51		Fix_High
.Assembly	OPTION		52		Fix_High
.Assembly	OPTION		53		Fix_Low

.Assembly	OPTION_Hide	54		Hold_CK1	Disable	Enable
.Assembly	OPTION_Hide	55		Hold_CK2	Disable	Enable		
.Assembly	OPTION		56 : 63 	Fix_High

.Assembly	OPTION		2ffh
	L		EQU		80H
	H		EQU		81H
	R		EQU		82H
	Z		EQU		83H
	Y		EQU		84H
	X		EQU		85H
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FSTKOV		EQU_R		PFLAG.4
		FRST		EQU_R		PFLAG.5
		FWDT		EQU_R		PFLAG.6
		FPOR		EQU_R		PFLAG.7

	W0			EQU		088H
	W1			EQU		089H
	W2			EQU		08AH
	W3			EQU		08BH
	W4			EQU		08CH
	W5			EQU		08DH
	W6			EQU		08EH
	W7			EQU		08FH

	@HL			EQU		090H
	@YZ			EQU		091H
	PCL			EQU		093H
	PCH			EQU		094H

	OSCM		EQU		095H
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	096H

					
					
	INTRQ0		EQU		097H
		FP40IRQ		EQU		INTRQ0.0
		FP41IRQ		EQU		INTRQ0.1
		FP42IRQ		EQU		INTRQ0.2
		FT0IRQ		EQU		INTRQ0.3
		FTC0IRQ		EQU		INTRQ0.4
		FTC1IRQ		EQU		INTRQ0.5
		FTC2IRQ		EQU		INTRQ0.6
		FTC3IRQ		EQU		INTRQ0.7

      INTRQ1		EQU		098H
                FADCIRQ	EQU		INTRQ1.4
		FUTXIRQ EQU             INTRQ1.3
                FURXIRQ EQU             INTRQ1.2                
		FSIOIRQ	EQU		INTRQ1.1
		FWAKEIRQ EQU		INTRQ1.0

	P1W		EQU		099H
		FP17W	EQU		P1W.7
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

       INTEN0		EQU		09AH
		FP40IEN		EQU		INTEN0.0
		FP41IEN		EQU		INTEN0.1
		FP42IEN		EQU		INTEN0.2
		FT0IEN		EQU		INTEN0.3
		FTC0IEN		EQU		INTEN0.4
		FTC1IEN		EQU		INTEN0.5
		FTC2IEN		EQU		INTEN0.6
 		FTC3IEN		EQU		INTEN0.7

       INTEN1		EQU		09BH                 
                FADCIEN	EQU		INTEN1.4
		FUTXIEN EQU             INTEN1.3
                FURXIEN EQU             INTEN1.2
                FSIOIEN	EQU		INTEN1.1
		FWAKEIEN EQU		INTEN1.0

	PEDGE		EQU		09FH		
		FP40G0		EQU		PEDGE.0
		FP40G1		EQU		PEDGE.1
		FP41G0		EQU		PEDGE.2
		FP41G1		EQU		PEDGE.3
		FP42G0		EQU		PEDGE.4
		FP42G1		EQU		PEDGE.5

	P1M		EQU		0A1H
  		FP10M		EQU		P1M.0
  		FP11M		EQU		P1M.1
  		FP12M		EQU		P1M.2
  		FP13M		EQU		P1M.3
  		FP14M		EQU		P1M.4
  		FP15M		EQU		P1M.5
  		FP16M		EQU		P1M.6
  		FP17M		EQU		P1M.7
	P2M		EQU		0A2H
  		FP20M		EQU		P2M.0
  		FP21M		EQU		P2M.1
	P4M		EQU		0A4H
		FP40M		EQU		P4M.0
		FP41M		EQU		P4M.1
		FP42M		EQU		P4M.2
		FP43M		EQU		P4M.3
		FP44M		EQU		P4M.4
		FP45M		EQU		P4M.5
		FP46M		EQU		P4M.6
		FP47M		EQU		P4M.7

	P1		EQU		0A7H
		FP10		EQU		P1.0
		FP11		EQU		P1.1
		FP12		EQU		P1.2
		FP13		EQU		P1.3
		FP14		EQU		P1.4
		FP15		EQU		P1.5
		FP16		EQU		P1.6
		FP17		EQU		P1.7
	P2		EQU		0A8H
		FP20		EQU		P2.0
		FP21		EQU		P2.1		
	P4		EQU		0AAH
		FP40		EQU		P4.0
		FP41		EQU		P4.1
		FP42		EQU		P4.2
		FP43		EQU		P4.3
		FP44		EQU		P4.4
		FP45		EQU		P4.5
		FP46		EQU		P4.6		
		FP47		EQU		P4.7

	P1UR        EQU     0ADH
	    	FP10R   EQU  	P1UR.0
	    	FP11R   EQU  	P1UR.1
	    	FP12R   EQU  	P1UR.2		
	    	FP13R   EQU  	P1UR.3
	    	FP14R   EQU  	P1UR.4
	    	FP15R   EQU  	P1UR.5
	    	FP16R   EQU  	P1UR.6
	    	FP17R   EQU  	P1UR.7

    	P2UR        EQU     0AEH
	    	FP20R   EQU  	P2UR.0
	    	FP21R   EQU  	P2UR.1

	P4UR        EQU     0B0H
	    	FP40R   EQU  	P4UR.0
	    	FP41R   EQU  	P4UR.1
	    	FP42R   EQU  	P4UR.2		
	    	FP43R   EQU  	P4UR.3
	    	FP44R   EQU  	P4UR.4
	    	FP45R   EQU  	P4UR.5
	    	FP46R   EQU  	P4UR.6
	    	FP47R   EQU  	P4UR.7

	T0M			EQU	0B2H
		FT0ENB	 	EQU  	T0M.7
		FT0RATE2 	EQU  	T0M.6
		FT0RATE1 	EQU  	T0M.5
		FT0RATE0 	EQU  	T0M.4
		FT0TB	 	EQU  	T0M.0

	T0C			EQU	0B3H


	TC0M		EQU		0B4H
	       	FPWM0OUT   	EQU		TC0M.0 
       		FTC0PO    	EQU		TC0M.1
       		FTC0CKS0    	EQU		TC0M.2
       		FTC0CKS1    	EQU		TC0M.3
		FTC0RATE0	EQU		TC0M.4
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE2	EQU		TC0M.6
		FTC0ENB		EQU		TC0M.7

	TC0C		EQU		0B5H
	TC0R		EQU_W		0B6H
	TC0D		EQU		0B7H


	TC1M		EQU		0B8H
	       	FPWM1OUT   	EQU		TC1M.0 
       		FTC1PO    	EQU		TC1M.1
       		FTC1CKS0    	EQU		TC1M.2
		FTC1RATE0	EQU		TC1M.4
		FTC1RATE1	EQU		TC1M.5
		FTC1RATE2	EQU		TC1M.6
		FTC1ENB		EQU		TC1M.7

	TC1C		EQU		0B9H
	TC1R		EQU_W		0BAH
	TC1D		EQU		0BBH

	TC2M		EQU		0BCH
	       	FPWM2OUT   	EQU		TC2M.0 
       		FTC2PO    	EQU		TC2M.1
       		FTC2CKS0    	EQU		TC2M.2
		FTC2RATE0	EQU		TC2M.4
		FTC2RATE1	EQU		TC2M.5
		FTC2RATE2	EQU		TC2M.6
		FTC2ENB		EQU		TC2M.7

	TC2C		EQU		0BDH
	TC2R		EQU_W		0BEH
	TC2D		EQU		0BFH


	P4CON		EQU		0C6H
	P1CON		EQU		0C7H
		FP2CON0		EQU		P1CON.0
		FP2CON1		EQU		P1CON.1
		FP1CON6		EQU		P1CON.6
		FP1CON7		EQU		P1CON.7

	ADM 		EQU		0C8H
		FCHS0		EQU		ADM.0
		FCHS1		EQU		ADM.1
		FCHS2		EQU		ADM.2
		FCHS3		EQU		ADM.3
		FGCHS		EQU		ADM.4
		FEOC		EQU		ADM.5
		FADS		EQU		ADM.6
		FADENB		EQU		ADM.7

	ADB 		EQU_R		0C9H

	ADR 		EQU		0CAH
		FADB0		EQU_R		ADR.0
		FADB1		EQU_R		ADR.1
		FADB2		EQU_R		ADR.2
		FADB3		EQU_R		ADR.3
		FADCKS0		EQU		ADR.4
		FADLEN		EQU		ADR.5
		FADCKS1		EQU		ADR.6
		FTCHEN		EQU		ADR.7

	ADT 		EQU		0CBH
		FADT0		EQU		ADT.0
		FADT1		EQU		ADT.1
		FADT2		EQU		ADT.2
		FADT3		EQU		ADT.3
		FADT4		EQU		ADT.4
		FADTS0		EQU		ADT.6
		FADTS1		EQU		ADT.7

	VREFH 		EQU		0CCH
		FVHS0		EQU		VREFH.0
		FVHS1		EQU		VREFH.1
		FVHS2		EQU		VREFH.2
		FEVHENB		EQU		VREFH.7

	TC3M		EQU		0D0H
	       	FPWM3OUT   	EQU		TC3M.0 
       		FTC3PO    	EQU		TC3M.1
       		FTC3CKS0    	EQU		TC3M.2
		FTC3RATE0	EQU		TC3M.4
		FTC3RATE1	EQU		TC3M.5
		FTC3RATE2	EQU		TC3M.6
		FTC3ENB		EQU		TC3M.7

	TC3C		EQU		0D1H
	TC3R		EQU_W		0D2H
	TC3D		EQU		0D3H

	PWCH		EQU		0D4H
		FPWCH10		EQU		PWCH.0
		FPWCH11		EQU		PWCH.1
		FPWCH20		EQU		PWCH.2
		FPWCH21		EQU		PWCH.3
		FPWCH30		EQU		PWCH.4
		FPWCH31		EQU		PWCH.5

	PWES		EQU		0D5H
		FPW1ES0		EQU		PWES.0
		FPW1ES1		EQU		PWES.1
		FPW2ES0		EQU		PWES.2
		FPW2ES1		EQU		PWES.3
		FPW3ES0		EQU		PWES.4
		FPW3ES1		EQU		PWES.5

	P1DR		EQU		0D7H
		FP13DR		EQU		P1DR.0
		FP14DR		EQU		P1DR.1
		FP15DR		EQU		P1DR.2
		FP16DR		EQU		P1DR.3
		FP13SC		EQU		P1DR.4
		FP14SC		EQU		P1DR.5
		FP15SC		EQU		P1DR.6		
		FP16SC		EQU		P1DR.7


	PECMD			EQU_W		0DBH
	PEROML			EQU		0DCH	
	PEROMH			EQU		0DDH
	PERAML			EQU		0DEH
	PERAMCNT		EQU		0DFH

	SIOM			EQU		0E0H
		FSENB		EQU	SIOM.7
		FSTART		EQU	SIOM.6
		FSRATE1		EQU	SIOM.5
		FSRATE0		EQU	SIOM.4
		FMLSB		EQU	SIOM.3
		FSCKMD		EQU	SIOM.2
		FCPOL		EQU	SIOM.1
		FCPHA		EQU	SIOM.0

	SIOR			EQU_W		0E1H
	SIOB			EQU		0E2H	

        URTX	                EQU             0E4H  
                FUTXEN           EQU             URTX.7
                FUTXPEN          EQU             URTX.6
                FUTXPS           EQU             URTX.5
                FUTXBRK          EQU             URTX.4
                FURXBZ           EQU_R           URTX.3
                FUTXBZ           EQU_R           URTX.2
                FURMX            EQU           	 URTX.1
                FSIOMX           EQU           	 URTX.0


        URRX	                EQU             0E5H
                FURXEN           EQU             URRX.7
                FURXPEN          EQU             URRX.6
                FURXPS           EQU             URRX.5
                FURXPC           EQU             URRX.4
                FUFMER           EQU             URRX.3
                FURS2            EQU             URRX.2
                FURS1            EQU             URRX.1
                FURS0            EQU             URRX.0

        URCR                  EQU             0E6H
        UTXD                  EQU             0E7H
        URXD                  EQU             0E8H


	STKP		EQU		0EFH
		FGIE	EQU		STKP.7
		FLVD24	EQU_R		STKP.6
		FLVD33	EQU_R		STKP.5
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	STK7L		EQU		0xF0
	STK7H		EQU		0xF1
	STK6L		EQU		0xF2
	STK6H		EQU		0xF3
	STK5L		EQU		0xF4
	STK5H		EQU		0xF5
	STK4L		EQU		0xF6
	STK4H		EQU		0xF7
	STK3L		EQU		0xF8
	STK3H		EQU		0xF9
	STK2L		EQU		0xFA
	STK2H		EQU		0xFB
	STK1L		EQU		0xFC
	STK1H		EQU		0xFD
	STK0L		EQU		0xFE
	STK0H		EQU		0xFF
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
;
	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
;
	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
;
	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
	   IF High_Clk == IHRC_16M &&  High_Fcpu == Fosc/1
           {		
           	ROM_EnTime = Full
           }
	   ELSE
	   {
		ROM_EnTime = 60ns
	   } 

	   IF High_Clk == IHRC_32M &&  High_Fcpu == Fosc/1 || High_Clk == IHRC_32M &&  High_Fcpu == Fosc/2
           {		
           	ROM_EnTime = Full
           }

	   IF High_Clk == Ext_CLK || High_Clk == Ext_RC
           {		
           	ROM_EnTime = Full
           }

	   IF High_Clk == 12M_X'tal &&  High_Fcpu == Fosc/1
           {		
           	ROM_EnTime = Full
           } 	

	   IF Noise_Filter == Enable
	   {
	        Hold_CK1 = Enable
		Hold_CK2 = Enable
	   }
	   ELSE
	   {
	        Hold_CK1 = Disable
		Hold_CK2 = Disable
 	   }    
  
	ENDP
	//}}SONIX_OPTION_RULE
}