
;------------------------------------------------------------------------------
;  CHIP: SN8P1907, OTP Only
;  Revision History:
;  V1.0  03/01/2004  First issue
;        03/16/2004  1: Add AVE+ bit, 2: SMOV table: Addr=#73H, bit7=1
;	 03/19/2004  1: code option bit 1 : Fix High for Internal test only
;  V2.0  03/22/2004  1: Modified Low Power and LCD clock selection
;         	     2: Code option bit 15 Low Power Wrong only one bit not Two bits	
;  		     3: Release ROM size when ICE mode = 1 to 2.5K
;  	 	     4: Set P1W as FF in SMOV table	  
;  V3.0  07/22/2004  1: Modified code option : Add RC mode
;  V4.0  08/12/2005  1: Set CPCKS, AMPCKS, ADCKS as Write only register.
;  V5.0  04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V6.0  06/29/2010  1: Add Macro "@RST_WDT", "SleepMode", "SlowMode", "Slow2Normal" 
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P1907

;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x0800
  .Assembly	USER_ROM_SIZE	0x07FF
ELSE
  .Assembly	OTP_BODY_SIZE	0x0A00
  .Assembly	USER_ROM_SIZE	0x09FF
ENDIF
;.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN8P1907
.Assembly	PGM_TYPE	5
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	1, 4, 0, 0, 3, 3, 0
.Assembly	LCD_Size	12, 4
;.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x4C,0x4D

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Fix_High;LCD_clock	External_HCLK	Internal_LCLK
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	X	X	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8		Fix_High;Noise_Filter	Enable	Disable
.Assembly	OPTION		9 		Fix_High;TC1_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		10 		Fix_High
.Assembly	OPTION		11 		Fix_High;TC0_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		12 		Fix_High
.Assembly	OPTION		13 		Fix_High
.Assembly	OPTION		14 		Fix_Low		;LCD clock  Div_64 	Div_32
.Assembly	OPTION		15		Low_Power	Enable	Disable	;	8_Phase	1_Phase	4_Phase	6_Phase
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000


	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	
	PFLAG			EQU		0x86
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0
		
	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

IF	ICE_Mode==1

	LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3
ELSE	
	LCDM1		EQU		0x89	;SN8P1909 real chip address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3
ENDIF
	AMPM			EQU		0x90
		FGS2	EQU		AMPM.3
		FGS1	EQU		AMPM.2
		FGS0	EQU		AMPM.1
		FAMPENB	EQU		AMPM.0

	AMPCHS			EQU		0x91
		FCHS2	EQU		AMPCHS.2
		FCHS1	EQU		AMPCHS.1
		FCHS0	EQU		AMPCHS.0

	AMPCKS			EQU_W		0x92
		FAMPCKS1	EQU_W	AMPCKS.1
		FAMPCKS0	EQU_W	AMPCKS.0
		
	ADCM			EQU		0x93
		FRVS1	EQU		ADCM.2
		FRVS0	EQU		ADCM.1
		FADCENB	EQU		ADCM.0
				
	ADCKS			EQU_W		0X94

	CPM			EQU		0x95
		FEVENB	EQU		CPM.4
		FCPSTS	EQU_R		CPM.3
		FCPAUTO	EQU		CPM.2
		FCPON	EQU		CPM.1
		FCPRENB	EQU		CPM.0
	
	CPCKS			EQU_W		0x96
		FCPCKS1	EQU_W		CPCKS.1
		FCPCKS0	EQU_W		CPCKS.0
		
	DFM			EQU		0x97
		FWRS0	EQU		DFM.2
		FDRDY	EQU		DFM.0

	ADCDL			EQU_R		0x98
	ADCDH			EQU_R		0x99

	PEDGE		EQU			0xBF
		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4

	P1M			EQU		0xC1
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
	
	INTRQ		EQU		0C8H
		FT0IRQ	EQU	INTRQ.4
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FT0IEN	EQU	INTEN.4
		FP00IEN	EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0xCE
	PCH			EQU		0xCF

	P0			EQU_R	0D0H
		FP00	EQU_R	P0.0

	P1			EQU		0xD1
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P4			EQU_R		0xD4
		FP42	EQU_R		P4.2
		FP41	EQU_R		P4.1
		FP40	EQU_R		P4.0

	P5			EQU		0xD5
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4

	T0C			EQU		0xD9

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P1UR		EQU_W			0xE1
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh



; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1 

	@RST_WDT	macro		
 		B0BSET	FWDRST
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1

	SleepMode	macro	 
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-1 ICE
;  
; 		1907 No Green Mode
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm

;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1


		P3M			EQU		0xC3
			FP37M	EQU		P3M.7
			FP36M	EQU		P3M.6
			FP35M	EQU		P3M.5
			FP34M	EQU		P3M.4
			FP33M	EQU		P3M.3
			FP32M	EQU		P3M.2
			FP31M	EQU		P3M.1
			FP30M	EQU		P3M.0
		P3			EQU		0xD3
			FP37	EQU		P3.7
			FP36	EQU		P3.6
			FP35	EQU		P3.5
			FP34	EQU		P3.4
			FP33	EQU		P3.3
			FP32	EQU		P3.2
			FP31	EQU		P3.1
			FP30	EQU		P3.0

		P3UR		EQU_W			0xE3
			FP37R	EQU_W	P3UR.7
			FP36R	EQU_W	P3UR.6
			FP35R	EQU_W	P3UR.5
			FP34R	EQU_W	P3UR.4
			FP33R	EQU_W	P3UR.3
			FP32R	EQU_W	P3UR.2
			FP31R	EQU_W	P3UR.1
			FP30R	EQU_W	P3UR.0

ENDIF


.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 68 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 00 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 11 AD -1 -1 -1 -1 -1
	81 0F 00 FF 07 07 00 00   F0 -1 00 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F C0 FF E0 FF E4 FF D3 00 C3 EF E3 FF C4 00 C5 FF D5 00-1
	-1	
	0004 72 10 00
	0001 71 00 01 
	0002 71 10 00-1

	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	

	ENDP
	//}}SONIX_OPTION_RULE
}