
;------------------------------------------------------------------------------
;  CHIP: SN8P2522 
;  Revision History
;  
;  V01   12/19/2008  1. First issue and only for SN8ICE 2K.
;  V02   03/25/2009  1. Modify Fcpu code option.
;                    2. Fix FSTPHX bit of macros.   
;  V03   07/07/2009  1. Add 0xED register.
;  V04   05/04/2010  1. Modify FP56 EQU_R.
;  V05   06/24/2010  1. Add GREEN_NOP_LIMIT command and RedWrt_FORMAT.
;  V06   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V07   01/12/2011  1. Modify CHIP_ID.
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT   1
.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2522
.Assembly	BIT_FILE	SN8P2522

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FC

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
.Assembly	PGM_TYPE	13
.Assembly	CHIP_ID		0x3121
.Assembly	command		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	1, 8, 0, 0, 0, 7

; Code Option 0x07FF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		x Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
.Assembly	OPTION		5 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin   	P56 Reset
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14 : 15		Fix_High

; Code Option 0x07FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_Low

; Code Option 0x07FD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High

.Assembly	OPTION		2ffh

	L		EQU	80H
	H		EQU	81H
	R		EQU	82H
	Z		EQU	83H
	Y		EQU	84H
	
	PFLAG		EQU	86H
		FZ		EQU	PFLAG.0
		FDC		EQU	PFLAG.1
		FC		EQU	PFLAG.2
		FLVD24		EQU_R	PFLAG.4
		FLVD36		EQU_R	PFLAG.5
		FNPD		EQU	PFLAG.6
		FNT0		EQU	PFLAG.7

	CMP0M		EQU	9CH
		FCMCH0		EQU	CMP0M.0
		FCMCH1		EQU	CMP0M.1
		FCMCH2		EQU	CMP0M.2
		FCM0S0		EQU	CMP0M.3
		FCM0S1		EQU	CMP0M.4
		FCM0OUT		EQU_R	CMP0M.6
		FCM0EN		EQU	CMP0M.7

	CMP0M1		EQU	9DH
		FCM0G0		EQU	CMP0M1.0
		FCM0G1		EQU	CMP0M1.1
		FCMDB0		EQU	CMP0M1.2
		FCMDB1		EQU	CMP0M1.3
		FCMP0M17	EQU	CMP0M1.7
		FCMP0M16	EQU	CMP0M1.6
		FCMP0M15	EQU	CMP0M1.5
		FCMP0M14	EQU	CMP0M1.4

		
	T1M		EQU	0A0H
		FCPTG0		EQU	T1M.0
		FCPTG1		EQU	T1M.1
		FCPTStart	EQU	T1M.2
		FCPTCKS		EQU	T1M.3
		FT1rate0	EQU	T1M.4
		FT1rate1	EQU	T1M.5
		FT1rate2	EQU	T1M.6
		FT1ENB		EQU	T1M.7

	T1CL		EQU	0A1H
	T1CH		EQU	0A2H
	
	T1VCL    EQU 0A3H
	T1VCH    EQU 0A4H

	  
	T1CKM  EQU 0A5H
	  FCPTVC EQU T1CKM.7
	  FT1CKM2 EQU T1CKM.2
	  FT1CKM1 EQU T1CKM.1
	  FT1CKM0 EQU T1CKM.0
	  
	SIOM		EQU	0B4H
		FSENB		EQU	SIOM.7
		FSTART		EQU	SIOM.6
		FSRATE1		EQU	SIOM.5
		FSRATE0		EQU	SIOM.4
		FMLSB		EQU	SIOM.3
		FSCKMD		EQU	SIOM.2
		FCPOL		EQU	SIOM.1
		FCPHA		EQU	SIOM.0
	SIOR		EQU_W	0B5H
	SIOB		EQU	0B6H

	P0M		EQU	0B8H
		FP00M		EQU	P0M.0
	
	PEDGE		EQU	0BFH		
		FP00G1		EQU	PEDGE.4
		FP00G0		EQU	PEDGE.3

	P1W		EQU_W	0C0H

	P1M		EQU	0C1H
		FP10M		EQU	P1M.0
		FP11M		EQU	P1M.1
		FP12M		EQU	P1M.2
		FP13M		EQU	P1M.3
		FP14M		EQU	P1M.4
		FP15M		EQU	P1M.5
		FP16M		EQU	P1M.6
		FP17M		EQU	P1M.7

	P5M		EQU	0C5H
  		FP50M		EQU	P5M.0
  		FP51M		EQU	P5M.1
  		FP52M		EQU	P5M.2
  		FP53M		EQU	P5M.3
  		FP54M		EQU	P5M.4
  		FP55M		EQU	P5M.5

	INTRQ		EQU	0C8H
		FP00IRQ		EQU	INTRQ.0
		FT1IRQ		EQU	INTRQ.2
		FSIOIRQ		EQU	INTRQ.3
		FT0IRQ		EQU	INTRQ.4
		FTC0IRQ		EQU	INTRQ.5
		FTC1IRQ		EQU	INTRQ.6
		FCM0IRQ		EQU	INTRQ.7

	INTEN		EQU	0C9H
		FP00IEN		EQU	INTEN.0
		FT1IEN		EQU	INTEN.2
		FSIOIEN		EQU	INTEN.3
		FT0IEN		EQU	INTEN.4
		FTC0IEN		EQU	INTEN.5
		FTC1IEN		EQU	INTEN.6
		FCM0IEN		EQU	INTEN.7

	OSCM		EQU	0CAH
		FCPUM1		EQU	OSCM.4
		FCPUM0		EQU	OSCM.3
		FCLKMD		EQU	OSCM.2
		FSTPHX		EQU	OSCM.1

	WDTR		EQU_W	0CCH

    	TC0R		EQU_W	0CDH       

	PCL		EQU	0CEH
	PCH		EQU	0CFH

	P0		EQU 	0D0H
		FP00		EQU 	P0.0

	P1		EQU 	0D1H
		FP10		EQU 	P1.0
		FP11		EQU 	P1.1
		FP12		EQU 	P1.2
		FP13		EQU 	P1.3
		FP14		EQU 	P1.4
		FP15		EQU 	P1.5
		FP16		EQU 	P1.6
		FP17		EQU 	P1.7

	P5		EQU	0D5H
		FP50		EQU	P5.0
		FP51		EQU	P5.1
		FP52		EQU	P5.2
		FP53		EQU	P5.3
		FP54		EQU	P5.4
		FP55		EQU	P5.5
		FP56		EQU_R	P5.6
		
	T0M		EQU	0D8H
		FT0RATE0   	EQU	T0M.4
		FT0RATE1  	EQU	T0M.5
		FT0RATE2  	EQU	T0M.6
		FT0ENB    	EQU	T0M.7

	T0C		EQU	0D9H

	TC0M		EQU	0DAH
		FPWM0OUT	EQU	TC0M.0
		FTC0CKS0	EQU	TC0M.2
		FTC0CKS1	EQU	TC0M.3
		FTC0rate0	EQU	TC0M.4
		FTC0rate1	EQU	TC0M.5
		FTC0rate2	EQU	TC0M.6
		FTC0ENB		EQU	TC0M.7

	TC0C		EQU	0DBH

	TC1M		EQU	0DCH
		FPWM1OUT	EQU	TC1M.0
		FTC1CKS0	EQU	TC1M.2
		FTC1rate0	EQU	TC1M.4
		FTC1rate1	EQU	TC1M.5
		FTC1rate2	EQU	TC1M.6
		FTC1ENB		EQU	TC1M.7

	TC1C		EQU	0DDH
	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FSTKPB0		EQU	STKP.0
		FSTKPB1		EQU	STKP.1
		FSTKPB2		EQU	STKP.2
		FGIE		EQU	STKP.7

	P0UR		EQU_W     0E0H	
	    FP00R   EQU_W     P0UR.0
	P1UR       	EQU_W     0E1H
	    FP10R   EQU_W     P1UR.0
	    FP11R   EQU_W     P1UR.1
	    FP12R   EQU_W     P1UR.2
	    FP13R   EQU_W     P1UR.3
	    FP14R   EQU_W     P1UR.4
	    FP15R   EQU_W     P1UR.5
            FP16R   EQU_W     P1UR.6
	    FP17R   EQU_W     P1UR.7
	P5UR       	EQU_W     0E5H
	    FP50R   EQU_W     P5UR.0
	    FP51R   EQU_W     P5UR.1
	    FP52R   EQU_W     P5UR.2
	    FP53R   EQU_W     P5UR.3
	    FP54R   EQU_W     P5UR.4
	    FP55R   EQU_W     P5UR.5

	@HL		EQU	0E6H
	@YZ		EQU	0E7H

	TC0D		EQU	0E8H
	P1OC    	EQU_W   	0E9H
	    	FP50OC  	EQU_W 	P1OC.2
	    	FP51OC  	EQU_W  	P1OC.3
	    	FP52OC  	EQU_W   P1OC.4
	    	FP53OC  	EQU_W 	P1OC.5
	    	FP54OC  	EQU_W   P1OC.6

	TC1D		EQU	0EAH

	TOUCH0		EQU	0EDH
  	TOUCH1		EQU	0EEH
	TOUCH2		EQU	0EFH

	STK7L		EQU	0F0h
	STK7H		EQU	0F1h
	STK6L		EQU	0F2h
	STK6H		EQU	0F3h
	STK5L		EQU	0F4h
	STK5H		EQU	0F5h
	STK4L		EQU	0F6h
	STK4H		EQU	0F7h
	STK3L		EQU	0F8h
	STK3H		EQU	0F9h
	STK2L		EQU	0FAh
	STK2H		EQU	0FBh
	STK1L		EQU	0FCh
	STK1H		EQU	0FDh
	STK0L		EQU	0FEh
	STK0H		EQU	0FFh

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------		
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}