;*******************************************************************************
;  CHIP: SN8P2602C
;  Revision History
;  
;  V01   04/13/2010  1. First issue for FPGA Function Verification
;  V02   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V03   10/22/2010  1. modify Low_Power CodeOption limit : Low_Power enable, Fcpu < 4MIPS
;*******************************************************************************
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	48

.Assembly	INSTRUMENT	SN8P2602C
.Assembly	BIT_FILE	SN8P2602C

.Assembly	OTP_BODY_SIZE	0x0400
.Assembly	USER_ROM_SIZE	0x03FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x3240
.Assembly	command		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	1, 7, 0, 0, 0, 8

; Code Option 0x3FF
.Assembly	OPTION		0		Noise_Filter	Disable	Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
	Fosc/1		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/2		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/4		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/8		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/16		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/32		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/64		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/128	: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."

}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x Ext_RC  32K_X'tal  12M_X'tal  4M_X'tal
.Help
{
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal high RC(16MHz) free run. XIN/XOUT pins drive external 32KHz crystal."
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin   	P15 	Reset
;.Assembly	OPTION		13		Rst_Length  	No 128*ILRC
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Low_Power	Enable Disable
.Help
{
	Enable	:	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
}
;.Assembly	OPTION		15		Low_Power_Mode2 120ns	80ns
.Assembly	OPTION		15		Fix_High
; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31 	Fix_High

; Code Option 0x3FD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
;.Assembly	OPTION		43		LVDB		Disable	2*ILRC
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44		P5_SINK		40mA	15mA
.Help
{
	40mA		:	"P5.0~P5.3/P5.5 only"
}
.Assembly	OPTION		45 : 63		Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG			EQU		86H
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FLVD24	EQU_R		PFLAG.4
		FLVD36	EQU_R		PFLAG.5
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P0M			EQU		0B8H
		FP00M	EQU		P0M.0

	PEDGE			EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H

	P1M			EQU		0C1H
		FP10M	EQU		P1M.0
		FP11M	EQU		P1M.1
		FP12M	EQU		P1M.2
		FP13M	EQU		P1M.3
		FP14M	EQU		P1M.4
		FP16M	EQU		P1M.6

	P5M			EQU		0C5H
  		FP50M	EQU		P5M.0
  		FP51M	EQU		P5M.1
  		FP52M	EQU		P5M.2
  		FP53M	EQU		P5M.3
  		FP54M	EQU		P5M.4
  		FP55M	EQU		P5M.5
  		FP56M	EQU		P5M.6
  		FP57M	EQU		P5M.7

	INTRQ			EQU		0C8H
		FP00IRQ	EQU		INTRQ.0
		FT0IRQ	EQU		INTRQ.4
		FTC0IRQ	EQU		INTRQ.5

	INTEN			EQU		0C9H
		FP00IEN	EQU		INTEN.0
		FT0IEN	EQU		INTEN.4
		FTC0IEN	EQU		INTEN.5

	OSCM			EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR			EQU_W		0CCH

	TC0R  	   		EQU_W		0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 		0D0H
		FP00	EQU 		P0.0

	P1			EQU 		0D1H
		FP10	EQU 	P1.0
		FP11	EQU 	P1.1
		FP12	EQU 	P1.2
		FP13	EQU 	P1.3
		FP14	EQU 	P1.4
		FP15	EQU_R 	P1.5
		FP16	EQU 	P1.6

	P5			EQU		0D5H
		FP50	EQU		P5.0
		FP51	EQU		P5.1
		FP52	EQU		P5.2
		FP53	EQU		P5.3
		FP54	EQU		P5.4
		FP55	EQU		P5.5
		FP56	EQU		P5.6
		FP57	EQU		P5.7
		
	T0M			EQU		0D8H
		FT0TB	   EQU	T0M.0
		FT0RATE0   EQU	T0M.4
		FT0RATE1   EQU	T0M.5
		FT0RATE2   EQU	T0M.6
		FT0ENB     EQU	T0M.7

	T0C			EQU		0D9H

	TC0M		EQU			0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
        	FALOAD0     	EQU 	TC0M.2
        	FTC0OUT     	EQU 	TC0M.1
        	FPWM0OUT    	EQU 	TC0M.0 

	TC0C		EQU			0DBH

	BZM		EQU			0DCH
		FBZRATE0	EQU	BZM.5
		FBZRATE1	EQU	BZM.6
		FBZEN		EQU	BZM.7

	STKP		EQU			0DFH
		FGIE	EQU		STKP.7
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR        	EQU_W     		0E0H
	    	FP00R   EQU_W  P0UR.0
	
	P1UR        	EQU_W     		0E1H
	    FP10R   EQU_W     P1UR.0
	    FP11R   EQU_W     P1UR.1
	    FP12R   EQU_W     P1UR.2
	    FP13R   EQU_W     P1UR.3
	    FP14R   EQU_W     P1UR.4
            FP16R   EQU_W     P1UR.6

	P5UR        	EQU_W     		0E5H
	    FP50R   EQU_W     P5UR.0
	    FP51R   EQU_W     P5UR.1
	    FP52R   EQU_W     P5UR.2
	    FP53R   EQU_W     P5UR.3
	    FP54R   EQU_W     P5UR.4
	    FP55R   EQU_W     P5UR.5
	    FP56R   EQU_W     P5UR.6
	    FP57R   EQU_W     P5UR.7
	
	P5DR            EQU_W	     		0E6H
 		FP50DR   EQU_W     P5DR.0
		FP51DR   EQU_W     P5DR.1
		FP52DR   EQU_W     P5DR.2
		FP53DR   EQU_W     P5DR.3
	
	@YZ		EQU			0E7H

	P1OC		EQU_W			0E9H
		FP10OC   EQU_W  P1OC.0

	STK3L		EQU			0F8h
	STK3H		EQU			0F9h
	STK2L		EQU			0FAh
	STK2H		EQU			0FBh
	STK1L		EQU			0FCh
	STK1H		EQU			0FDh
	STK0L		EQU			0FEh
	STK0H		EQU			0FFh

;*******************************************************************************
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
;*******************************************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
;*******************************************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
;*******************************************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
;*******************************************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
;*******************************************************************************
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Low_Power == Enable
	{
		IF High_Clk == IHRC_16M
		{
		OPTION		2		Fcpu		x x x Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128  
		}
		ELSEIF High_Clk == IHRC_RTC
		{
		OPTION		2		Fcpu		x x x Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
		}
		ELSE
		{
			IF Noise_Filter == Enable
			{
				OPTION		2		Fcpu		x x Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  			}
			ELSE	
			{
				OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  			}      
		}
  	}
	ELSE	
	{
		IF Noise_Filter == Enable
		{
			OPTION		2		Fcpu		x x Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  		}
		ELSE	
		{
			OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  		}      
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}