;HS23P6610
;RAM:256
;ROM:2K
;------------------------------------------------------------------------------
;  CHIP: SN8P26L38 
;  Revision History
;  
;  V01   08/14/2007  1. First issue and only for SN8ICE 2K.
;  V02   12/27/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V04   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V05   05/25/2011  1. Add watchdog discription (.Help {XXXX})	
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		5
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	256;	384;192;880

.Assembly	INSTRUMENT	SN8P26L38
.Assembly	BIT_FILE	SN8P26L38

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	12
.Assembly	CHIP_ID		0x3720
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, GREEN_B0BSET_LIMIT
.Assembly	Port_Pins	8, 8, 8, 4, 8, 8

; Code Option 0x1FFF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	IHRC_8M IHRC_RTC x x Ext_RC  32K_X'tal  8M_X'tal  4M_X'tal
.Help
{
	IHRC_8M		:	"Internal 8M RC Oscillator"
	IHRC_RTC	:	"Internal 8M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	8M_X'tal	:	"Crystal/Resonator: 8Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~8Mhz"
}
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION		12		Reset_Pin   P02 	Reset
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_Low
.Assembly	OPTION		15		Fix_Low

; Code Option 0x1FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_Low

; Code Option 0x1FFD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVD     	x	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"1.8V Reset"
	LVD_M		:	"1.8V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD28 bit of PFLAG for\n2.8V Low Voltage Indicator"	
}
.Assembly	OPTION		43 : 63	Fix_High

.Assembly	OPTION		2ffh
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))
	L			EQU		80H
	H			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H

	reg_085h			EQU		85H
	
	PFLAG			EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD28		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	RBANK			EQU		087H
		FBANKS0		EQU		RBANK.0

	reg_088h			EQU		88H
	reg_089h			EQU		89H
	reg_08ah			EQU		8aH
	reg_08bh			EQU		8bH
	
	reg_08ch			EQU		8cH
	reg_08dh			EQU		8dH
	reg_08eh			EQU		8eH
	reg_08fh			EQU		8fH
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))

	reg_090h			EQU		090H
	reg_091h			EQU		091H
	reg_092h			EQU		092H
	reg_093h			EQU		093H
	
	reg_094h			EQU		094H
	reg_095h			EQU		095H
	reg_096h			EQU		096H
	reg_097h			EQU		097H
	
	reg_098h			EQU		098H
	reg_099h			EQU		099H
	reg_09ah			EQU		09aH
	reg_09bh			EQU		09bH
	reg_09ch			EQU		09cH
	reg_09dh			EQU		09dH
	reg_09eh			EQU		09eH
	reg_09fh			EQU		09fH
	
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))
	LDOOUT			EQU		0A0H
		FP53ANA		EQU		LDOOUT.0
		FP04ANA		EQU		LDOOUT.6
		FLDOOUTEN	EQU		LDOOUT.7

	AINET3			EQU		0A1H
		FAINET30	EQU		AINET3.0
		FAINET31	EQU		AINET3.1
		FAINET32	EQU		AINET3.2
		
		
	ADCLP			EQU		0A2H
		FADCLP0		EQU		ADCLP.0
		FADCLP1		EQU		ADCLP.1

	ADCCN3			EQU		0A3H
		FRDBH		EQU		ADCCN3.1
		
	ADCCN1			EQU		0A4H
		FADGN0		EQU		ADCCN1.0
		FADGN1		EQU		ADCCN1.1
		FADGN2		EQU		ADCCN1.2
		FNACM		EQU		ADCCN1.3
		FENTEMP		EQU		ADCCN1.4
		FENCHP		EQU		ADCCN1.5
		FADRST		EQU		ADCCN1.6
		FENADC		EQU		ADCCN1.7
	
	ADCCN2			EQU		0A5H
		FDCSET0		EQU		ADCCN2.0
		FDCSET1		EQU		ADCCN2.1
		FDCSET2		EQU		ADCCN2.2
		FVREGN		EQU		ADCCN2.3
		FOSR0		EQU		ADCCN2.4
		FOSR1		EQU		ADCCN2.5
		FOSR2		EQU		ADCCN2.6
		FOSR3		EQU		ADCCN2.7

	ADRESH			EQU		0A6H

	AINET1			EQU		0A7H
		FINIS		EQU		AINET1.1
		FINL0		EQU		AINET1.2
		FINL1		EQU		AINET1.3
		FINL2		EQU		AINET1.4
		FINH0		EQU		AINET1.5
		FINH1		EQU		AINET1.6
		FINH2		EQU		AINET1.7
			
	AINET2			EQU		0A8H
		FLVHSEN		EQU		AINET2.0
		FVRL0		EQU		AINET2.1
		FVRL1		EQU		AINET2.2
		FINX0		EQU		AINET2.3
		FINX1		EQU		AINET2.4
		FVRH0		EQU		AINET2.5
		FVRH1		EQU		AINET2.6
		ADPCON51		EQU		AINET2.7

	
	ADRESM			EQU		0A9H
	ADRESL			EQU		0AAH
	ADCPCON			EQU		0ABH
	PWRCN			EQU		0ACH
		FDRCON530	EQU		PWRCN.0
		FDRCON531	EQU		PWRCN.1
		FVDDAX0		EQU		PWRCN.4
		FVDDAX1		EQU		PWRCN.5
		FVDDAX2		EQU		PWRCN.6
		FLDOEN		EQU		PWRCN.7
	
	ADRBUF			EQU		0ADH
	ADCCK			EQU		0AEH
		FADCCKS		EQU		ADCCK.0
		FADCS0		EQU		ADCCK.3
		FADCS1		EQU		ADCCK.4
		FADCS2		EQU		ADCCK.5
		FDHS0		EQU		ADCCK.6
		FDHS1		EQU		ADCCK.7
	
	reg_0afh			EQU		0afH
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))
	P0W			EQU		0B0H
	P4W			EQU		0B1H
	P5W			EQU		0B2H

	I2CCON1			EQU		0B3H
		FRXAK		EQU		I2CCON1.0
	
	I2CCON			EQU		0B4H
		FI2CEN		EQU		I2CCON.0
		FI2CPU		EQU		I2CCON.1
		FCKP		EQU		I2CCON.2
		FTXAK		EQU		I2CCON.3
		FSRW		EQU		I2CCON.4
		FHBB		EQU		I2CCON.5
		FHAAS		EQU		I2CCON.6
		FHCF		EQU		I2CCON.7

	I2CADD			EQU		0B5H
	I2CBUF			EQU		0B6H

	I2CTOV			EQU		0B7H
		FTOS0		EQU		I2CTOV.0
		FTOS1		EQU		I2CTOV.1
		FTOS2		EQU		I2CTOV.2
		FTOVF		EQU		I2CTOV.6
		FTOVEN		EQU		I2CTOV.7
		

	P0M			EQU		0B8H
		FP03M		EQU		P0M.3
		FP04M		EQU		P0M.4

	reg_0b9h			EQU		0B9H
	reg_0bah			EQU		0BAH
	reg_0bbh			EQU		0BBH
	P4PD			EQU		0BCH
	reg_0bdh			EQU		0BDH
	
	reg_0beh			EQU		0beH

	PEDGE			EQU		0BFH		
		FP00G0		EQU		PEDGE.3
		FP00G1		EQU		PEDGE.4
		FINTSEL0		EQU		PEDGE.5
		FINTSEL1		EQU		PEDGE.6
		FINTSEL2		EQU		PEDGE.7

;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))
	reg_0c0h			EQU		0C0H
	reg_0c1h			EQU		0C1H
	reg_0c2h			EQU		0C2H
	reg_0c3h			EQU		0C3H

	P4M			EQU		0C4H
		FP40M		EQU		P4M.0
		FP41M		EQU		P4M.1

	P5M			EQU		0C5H
  		FP51M		EQU		P5M.1
  		FP53M		EQU		P5M.3


	reg_0c6h			EQU		0c6H
	reg_0c7h			EQU		0c7H
	
	INTRQ			EQU		0C8H
		FINT0IF		EQU		INTRQ.0
		FI2CIF		EQU		INTRQ.2
		FTC0IF		EQU		INTRQ.5
		FTC1IF	 	EQU		INTRQ.6
		FADCIF		EQU		INTRQ.7

	INTEN			EQU		0C9H
		FINT0IE		EQU		INTEN.0
		FI2CIE		EQU		INTEN.2
		FTC0IE		EQU		INTEN.5
		FTC1IE	 	EQU		INTEN.6
		FADCIE		EQU		INTEN.7

	OSCM			EQU		0CAH
		FSTPHX		EQU		OSCM.1
		FCLKMD		EQU		OSCM.2
		FCPUM0		EQU		OSCM.3
		FCPUM1		EQU		OSCM.4
		FLECS32K	EQU		OSCM.7
		
		

	WDTC			EQU		0CBH
		FWDTS0		EQU		WDTC.0
		FWDTS1		EQU		WDTC.1
		FWDTS2		EQU		WDTC.2
		FLFS0		EQU		WDTC.4
		FLFS1		EQU		WDTC.5
		FLFS2		EQU		WDTC.6
		FWDTEN		EQU		WDTC.7
		
	WDTR			EQU		0CCH

    TC0R        	EQU		0CDH 
	PCL			EQU		0CEH
	PCH			EQU		0CFH

;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))
	P0			EQU 		0D0H
		FP03		EQU 		P0.3
		FP04		EQU 		P0.4

	reg_0d1h			EQU 		0D1H
	reg_0d2h			EQU 		0D2H
	reg_0d3h			EQU 		0D3H

	P4			EQU		0D4H
		FP40		EQU		P4.0
		FP41		EQU		P4.1

	P5			EQU		0D5H
		FP51		EQU		P5.1
		FP53		EQU		P5.3
		
	reg_0d6h		EQU		0d6H
	reg_0d7h		EQU		0d7H
	
	T0M			EQU		0D8H
		FTC1GN	  	EQU		T0M.0
		FTC0GN  	EQU		T0M.1
		FTC0X8  	EQU		T0M.2
		FTC1X8  	EQU		T0M.3
		FTC0S16    	EQU		T0M.4
		FTC1S16    	EQU		T0M.5
		FLRCEN    	EQU		T0M.6

	PWMCON			EQU		0D9H
		FPWM1EN		EQU		PWMCON.0
		FPWM2EN		EQU		PWMCON.1
		FPWM1PSEL	EQU		PWMCON.2
		FPWM1OSEL		EQU		PWMCON.4
		FPWM2OSEL		EQU		PWMCON.5
		FPWM0OSEL		EQU		PWMCON.6

	TC0M			EQU		0DAH
		FPWM0EN		EQU		TC0M.0
		FTCOUT		EQU		TC0M.1
		FALOAD0		EQU		TC0M.2
		FT0CKS		EQU		TC0M.3
		FTPS0		EQU		TC0M.4
		FTPS1		EQU		TC0M.5
		FTPS2		EQU		TC0M.6
		FTR0		EQU		TC0M.7

	TC0C			EQU		0DBH

	TC1M			EQU		0DCH
		FALOAD1    	EQU		TC1M.2
		FTC1CKS		EQU		TC1M.3
		FTPS0		EQU		TC1M.4
		FTPS1		EQU		TC1M.5
		FTPS2		EQU		TC1M.6
		FTR1		EQU		TC1M.7
		

	TC1C			EQU		0DDH
	TC1R			EQU		0DEH

	STKP			EQU		0DFH	
		FSTKPB0		EQU		STKP.0
		FSTKPB1		EQU		STKP.1
		FSTKPB2		EQU		STKP.2
		FGIE		EQU		STKP.7
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))

	P0UR      	 	EQU		0E0H
	reg_0e1h      		EQU		0E1H
	reg_0e2h      		EQU		0E2H
	reg_0e3h     		EQU		0E3H
	
	P4UR      		EQU		0E4H
	P5UR       		EQU		0E5H
	reg_0e6h		EQU		0E6H
	@YZ			EQU		0E7H
	
	PWM2CON			EQU		0E8H
		FPWM2C0		EQU		PWM2CON.0
		FPWM2C1		EQU		PWM2CON.1
		FPWM2C2		EQU		PWM2CON.2
	
	
	TC0R0       		EQU		0E9H
	TC0R1       		EQU		0EAH
	TC0R2       		EQU		0EBH
	
	reg_0ech       		EQU		0EcH
	reg_0edh       		EQU		0EdH
	reg_0eeh       		EQU		0EeH
	reg_0efh       		EQU		0EfH
;((((((((((((((((((((((((((()))))))))))))))))))))))))))))))))

	STK7L			EQU		0F0h
	STK7H			EQU		0F1h
	STK6L			EQU		0F2h
	STK6H			EQU		0F3h
	
	STK5L			EQU		0F4h
	STK5H			EQU		0F5h
	STK4L			EQU		0F6h
	STK4H			EQU		0F7h
	
	STK3L			EQU		0F8h
	STK3H			EQU		0F9h
	STK2L			EQU		0FAh
	STK2H			EQU		0FBh
	
	STK1L			EQU		0FCh
	STK1H			EQU		0FDh
	STK0L			EQU		0FEh
	STK0H			EQU		0FFh
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		B0BSET	0XFF.7
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
